/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.AliHBaseAdminInterface;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseUEAdmin
extends HBaseAdmin
implements AliHBaseAdminInterface {
    private AliHBaseUEConnection connection;
    private int operationTimeout;
    private Configuration conf;
    private AliHBaseAPIProxy proxy;

    public AliHBaseUEAdmin(AliHBaseUEConnection connection) throws IOException {
        super((ClusterConnection)new AliHBaseUEClusterConnection(connection));
        this.connection = connection;
        this.conf = connection.getConfiguration();
        this.operationTimeout = connection.getOperationTimeout();
        this.proxy = connection.getAPIProxy(null);
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void abort(String why, Throwable e) {
    }

    public boolean isAborted() {
        return false;
    }

    public void close() throws IOException {
        this.proxy.close();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.proxy.tableExists(tableName);
    }

    public boolean tableExists(byte[] tableName) throws IOException {
        return this.tableExists(TableName.valueOf((byte[])tableName));
    }

    public boolean tableExists(String tableName) throws IOException {
        return this.tableExists(TableName.valueOf((String)tableName));
    }

    public HConnection getConnection() {
        return super.getConnection();
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.proxy.listTableDescriptors().toArray(new HTableDescriptor[0]);
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public TableName[] listTableNames() throws IOException {
        return this.proxy.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.proxy.getDescriptor(tableName);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        return this.proxy.listTableDescriptorsByNamespace(name).toArray(new HTableDescriptor[0]);
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        HTableDescriptor[] tableDescriptors = new HTableDescriptor[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tableDescriptors[i] = this.getTableDescriptor(tableNames.get(i));
        }
        return tableDescriptors;
    }

    public List<HTableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        ArrayList<HTableDescriptor> tableDescriptors = new ArrayList<HTableDescriptor>();
        for (TableName tableName : tableNames) {
            tableDescriptors.add(this.getTableDescriptor(tableName));
        }
        return tableDescriptors;
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>();
        for (String name : names) {
            tableNames.add(TableName.valueOf((String)name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.proxy.listTableNamesByNamespace(name);
    }

    public void createTable(HTableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        TableName.isLegalFullyQualifiedTableName((byte[])hTableDescriptor.getTableName().getName());
        this.proxy.createTable(hTableDescriptor, bytes);
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.proxy.deleteTable(tableName);
    }

    public void deleteTable(String tableName) throws IOException {
        this.deleteTable(TableName.valueOf((String)tableName));
    }

    public void deleteTable(byte[] tableName) throws IOException {
        this.deleteTable(TableName.valueOf((byte[])tableName));
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.proxy.truncateTable(tableName, preserveSplits);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.proxy.enableTable(tableName);
    }

    public void enableTable(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTable(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void disableTable(TableName tableName) throws IOException {
        this.proxy.disableTable(tableName);
    }

    public void disableTable(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTable(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.proxy.isTableEnabled(tableName);
    }

    public boolean isTableEnabled(byte[] tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableEnabled(String tableName) throws IOException {
        return this.isTableEnabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.proxy.isTableDisabled(tableName);
    }

    public boolean isTableDisabled(byte[] tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableDisabled(String tableName) throws IOException {
        return this.isTableDisabled(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.proxy.isTableAvailable(tableName);
    }

    public boolean isTableAvailable(byte[] tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName));
    }

    public boolean isTableAvailable(String tableName) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("isTableAvailable with split keys is not supported");
    }

    public void addColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.proxy.addColumnFamily(tableName, columnFamily);
    }

    public void addColumn(byte[] tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((byte[])tableName), column);
    }

    public void addColumn(String tableName, HColumnDescriptor column) throws IOException {
        this.addColumn(TableName.valueOf((String)tableName), column);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.proxy.deleteColumnFamily(tableName, columnFamily);
    }

    public void deleteColumn(byte[] tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((byte[])tableName), Bytes.toBytes((String)columnName));
    }

    public void deleteColumn(String tableName, String columnName) throws IOException {
        this.deleteColumn(TableName.valueOf((String)tableName), Bytes.toBytes((String)columnName));
    }

    public void modifyColumn(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        this.proxy.modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyColumn(String tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((String)tableName), descriptor);
    }

    public void modifyColumn(byte[] tableName, HColumnDescriptor descriptor) throws IOException {
        this.modifyColumn(TableName.valueOf((byte[])tableName), descriptor);
    }

    public void modifyTable(TableName tableName, HTableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((byte[])tableName), htd);
    }

    public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
        this.modifyTable(TableName.valueOf((String)tableName), htd);
    }

    public void modifyTable(HTableDescriptor td) throws IOException {
        this.proxy.modifyTable(td);
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
    }

    public void deleteNamespace(String name) throws IOException {
        this.proxy.deleteNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.proxy.getNamespaceDescriptor(name);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.proxy.listNamespaceDescriptors();
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        String namespace = descriptor.getName();
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)namespace));
        this.proxy.createNamespace(descriptor);
    }

    public void flush(TableName tableName) {
        this.proxy.flushTable(tableName);
    }

    public void flush(String tableNameOrRegionName) throws IOException, InterruptedException {
        this.flush(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void flush(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        try {
            this.flushRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.flush(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void flushRegion(byte[] regionName) {
        this.proxy.flushRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName) {
        this.proxy.compactTable(tableName);
    }

    public void compact(String tableNameOrRegionName) throws IOException {
        this.compact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void compactRegion(byte[] regionName) {
        this.proxy.compactRegion(Bytes.toString((byte[])regionName));
    }

    public void compact(TableName tableName, byte[] columnFamily) {
        this.compact(tableName);
    }

    public void compact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.compactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.compact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void compact(String tableOrRegionName, String columnFamily) throws IOException {
        this.compact(Bytes.toBytes((String)tableOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        this.compact(tableNameOrRegionName);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) {
        this.compactRegion(regionName);
    }

    public void majorCompact(TableName tableName) {
        this.proxy.majorCompactTable(tableName);
    }

    public void majorCompactRegion(byte[] regionName) {
        this.proxy.majorCompactRegion(Bytes.toString((byte[])regionName));
    }

    public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName), Bytes.toBytes((String)columnFamily));
    }

    public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName, columnFamily);
        }
        catch (IllegalArgumentException var4) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName), columnFamily);
        }
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) {
        this.majorCompact(tableName);
    }

    public void majorCompact(String tableNameOrRegionName) throws IOException {
        this.majorCompact(Bytes.toBytes((String)tableNameOrRegionName));
    }

    public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
        try {
            this.majorCompactRegion(tableNameOrRegionName);
        }
        catch (IllegalArgumentException var3) {
            this.majorCompact(TableName.valueOf((byte[])tableNameOrRegionName));
        }
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) {
        this.majorCompactRegion(regionName);
    }

    public boolean switchRpcThrottle(boolean enable) throws IOException {
        throw new UnsupportedOperationException("switchRpcThrottle is not supported");
    }

    public boolean isRpcThrottleEnabled() throws IOException {
        throw new UnsupportedOperationException("isRpcThrottleEnabled is not supported");
    }

    public boolean exceedThrottleQuotaSwitch(boolean enable) throws IOException {
        throw new UnsupportedOperationException("exceedThrottleQuotaSwitch is not supported");
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("disableTables is not supported");
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("disableTables by pattern not supported");
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported");
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("enableTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("deleteTables by pattern not supported");
    }

    public void closeRegion(String regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public void closeRegion(byte[] regionname, String serverName) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) {
        throw new UnsupportedOperationException("closeRegionWithEncodedRegionName not supported");
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) {
        throw new UnsupportedOperationException("closeRegion not supported");
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) {
        throw new UnsupportedOperationException("getOnlineRegions not supported");
    }

    public List<HRegionInfo> getRegions(ServerName serverName) {
        throw new UnsupportedOperationException("getRegions not supported");
    }

    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) {
        throw new UnsupportedOperationException("compactionSwitch not supported");
    }

    public void move(byte[] encodedRegionName) {
        throw new UnsupportedOperationException("move not supported");
    }

    public void move(byte[] encodedRegionName, ServerName destServerName) {
        throw new UnsupportedOperationException("move not supported");
    }

    public void assign(byte[] regionName) {
        throw new UnsupportedOperationException("assign not supported");
    }

    public void unassign(byte[] regionName, boolean force) {
        throw new UnsupportedOperationException("unassign not supported");
    }

    public void offline(byte[] regionName) {
        throw new UnsupportedOperationException("offline not supported");
    }

    public boolean isBalancerEnabled() {
        throw new UnsupportedOperationException("isBalancerEnabled not supported");
    }

    public boolean normalize() {
        throw new UnsupportedOperationException("normalize not supported");
    }

    public boolean isNormalizerEnabled() {
        throw new UnsupportedOperationException("isNormalizerEnabled not supported");
    }

    public boolean isCatalogJanitorEnabled() {
        throw new UnsupportedOperationException("isCatalogJanitorEnabled not supported");
    }

    public boolean runCleanerChore() {
        throw new UnsupportedOperationException("runCleanerChore not supported");
    }

    public boolean isCleanerChoreEnabled() {
        throw new UnsupportedOperationException("isCleanerChoreEnabled not supported");
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) {
        throw new UnsupportedOperationException("mergeRegions not supported");
    }

    public void split(TableName tableName) {
        throw new UnsupportedOperationException("split not supported");
    }

    public void splitRegion(byte[] regionName) {
        throw new UnsupportedOperationException("splitRegion not supported");
    }

    public void split(TableName tableName, byte[] splitPoint) {
        throw new UnsupportedOperationException("split not supported");
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) {
        throw new UnsupportedOperationException("splitRegion not supported");
    }

    public void shutdown() {
        throw new UnsupportedOperationException("shutdown not supported");
    }

    public void stopMaster() {
        throw new UnsupportedOperationException("stopMaster not supported");
    }

    public boolean isMasterInMaintenanceMode() {
        throw new UnsupportedOperationException("isMasterInMaintenanceMode not supported");
    }

    public void stopRegionServer(String hostnamePort) {
        throw new UnsupportedOperationException("stopRegionServer not supported");
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) {
        throw new UnsupportedOperationException("getTableRegions not supported");
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedure not supported");
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("abortProcedureAsync not supported");
    }

    public void rollWALWriter(ServerName serverName) {
        throw new UnsupportedOperationException("rollWALWriter not supported");
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestamp not supported");
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestampForRegion not supported");
    }

    public void snapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) {
        throw new UnsupportedOperationException("restoreSnapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("execProcedure not supported");
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) {
        throw new UnsupportedOperationException("isProcedureFinished not supported");
    }

    public void deleteSnapshot(byte[] snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshot(String snapshotName) {
        throw new UnsupportedOperationException("deleteSnapshot not supported");
    }

    public void deleteSnapshots(String regex) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteSnapshots(Pattern pattern) {
        throw new UnsupportedOperationException("deleteSnapshots not supported");
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) {
        throw new UnsupportedOperationException("deleteTableSnapshots not supported");
    }

    public void setQuota(QuotaSettings quota) {
        throw new UnsupportedOperationException("setQuota not supported");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) {
        throw new UnsupportedOperationException("getQuotaRetriever not supported");
    }

    public CoprocessorRpcChannel coprocessorService() {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    public void updateConfiguration(ServerName server) {
        throw new UnsupportedOperationException("updateConfiguration not supported");
    }

    public void updateConfiguration() {
        throw new UnsupportedOperationException("updateConfiguration not supported");
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) {
        throw new UnsupportedOperationException("clearDeadServers not supported");
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
        throw new UnsupportedOperationException("move not supported");
    }

    public void createTableAsync(HTableDescriptor hTableDescriptor, byte[][] bytes) throws IOException {
        throw new UnsupportedOperationException("createTableAsync not supported");
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("enableTableAsync not supported");
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("disableTableAsync not supported");
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] bytes) throws IOException {
        return new Pair((Object)0, (Object)1);
    }

    public void compactRegionServer(ServerName serverName, boolean b) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("compactRegionServer not supported");
    }

    public boolean setBalancerRunning(boolean b, boolean b1) throws IOException {
        throw new UnsupportedOperationException("setBalancerRunning not supported");
    }

    public boolean balancer() throws IOException {
        throw new UnsupportedOperationException("balancer not supported");
    }

    public boolean balancer(boolean b) throws IOException {
        throw new UnsupportedOperationException("balancer not supported");
    }

    public boolean setNormalizerRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setNormalizerRunning not supported");
    }

    public boolean enableCatalogJanitor(boolean b) throws IOException {
        throw new UnsupportedOperationException("enableCatalogJanitor not supported");
    }

    public int runCatalogScan() throws IOException {
        throw new UnsupportedOperationException("runCatalogScan not supported");
    }

    public boolean setCleanerChoreRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setCleanerChoreRunning not supported");
    }

    public ClusterStatus getClusterStatus() throws IOException {
        throw new UnsupportedOperationException("getClusterStatus not supported");
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        throw new UnsupportedOperationException("listProcedures not supported");
    }

    public String[] getMasterCoprocessors() {
        throw new UnsupportedOperationException("getMasterCoprocessors not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion not supported");
    }

    public void snapshot(String s, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, SnapshotCreationException {
        throw new UnsupportedOperationException("takeSnapshotAsync not supported");
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshotDescription) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished not supported");
    }

    public byte[] execProcedureWithRet(String s, String s1, Map<String, String> map) throws IOException {
        throw new UnsupportedOperationException("execProcedureWithRet not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String s) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        throw new UnsupportedOperationException("listSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String s, String s1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern pattern, Pattern pattern1) throws IOException {
        throw new UnsupportedOperationException("listTableSnapshots not supported");
    }

    public int getMasterInfoPort() throws IOException {
        throw new UnsupportedOperationException("getMasterInfoPort not supported");
    }

    public List<ServerName> listDeadServers() throws IOException {
        throw new UnsupportedOperationException("listDeadServers not supported");
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public String[] getTableNames() throws IOException {
        TableName[] tableNames = this.listTableNames();
        String[] tables = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            tables[i] = tableNames[i].toString();
        }
        return tables;
    }

    public String[] getTableNames(Pattern pattern) throws IOException {
        return this.getTableNames();
    }

    public String[] getTableNames(String regex) throws IOException {
        return this.getTableNames();
    }

    public HTableDescriptor getTableDescriptor(byte[] tableName) throws TableNotFoundException, IOException {
        return this.getTableDescriptor(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(byte[] tableName) throws IOException {
        this.enableTable(TableName.valueOf((byte[])tableName));
    }

    public void enableTableAsync(String tableName) throws IOException {
        this.enableTable(TableName.valueOf((String)tableName));
    }

    public void disableTableAsync(byte[] tableName) throws IOException {
        this.disableTable(TableName.valueOf((byte[])tableName));
    }

    public void disableTableAsync(String tableName) throws IOException {
        this.disableTable(TableName.valueOf((String)tableName));
    }

    public boolean isTableAvailable(byte[] tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((byte[])tableName), splitKeys);
    }

    public boolean isTableAvailable(String tableName, byte[][] splitKeys) throws IOException {
        return this.isTableAvailable(TableName.valueOf((String)tableName), splitKeys);
    }

    public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("split not supported");
    }

    public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("split not supported");
    }

    public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
        throw new UnsupportedOperationException("split not supported");
    }

    public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
        throw new UnsupportedOperationException("split not supported");
    }

    public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
        throw new UnsupportedOperationException("split not supported");
    }

    public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
        throw new UnsupportedOperationException("getTableRegions not supported");
    }

    public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
        throw new UnsupportedOperationException("rollHLogWriter not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("getCompactionState not supported");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
        throw new UnsupportedOperationException("getCompactionState not supported");
    }

    public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        throw new UnsupportedOperationException("snapshot not supported");
    }

    public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
        throw new UnsupportedOperationException("cloneSnapshot not supported");
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        return this.proxy.describeIndex(dataTableName);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        this.proxy.createIndex(indexDescriptor);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        this.proxy.createIndex(indexDescriptor, splitKeys);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor index, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        this.proxy.createIndex(index, startKey, endKey, numRegions);
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.deleteIndex(indexName, dataTable);
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        this.proxy.offlineIndex(indexName, dataTable);
    }
}

