/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.hbase.client;

import java.io.IOException;

import com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;

public abstract class AliHBaseImplFactory {

  public abstract AliHBaseAPIProxy getHBaseAPIProxyImpl(TableName tableName) throws IOException;

  public abstract void close() throws IOException;

  public abstract Configuration getConf();

  /**
   * Only meaningful in Thrift impl
   * @param cuLimit
   */
  void setCULimit(int cuLimit) {}

  public static AliHBaseImplFactory create(Configuration conf) throws IOException {
    boolean useThrift = AliHBaseConstants.ALIHBASE_USE_THRIFT_DEFAULT;
    if (conf.get(AliHBaseConstants.ALIHBASE_SERVER_NAME) == null || AliHBaseConstants
        .isHBaseUEConnectionString(conf, conf.get(HConstants.ZOOKEEPER_QUORUM))) {
      conf.set(AliHBaseConstants.ALIHBASE_SERVER_NAME, conf.get(HConstants.ZOOKEEPER_QUORUM));
    }
    String host = conf.get(AliHBaseConstants.ALIHBASE_SERVER_NAME).trim();
    if (host.startsWith("http://") || host.startsWith("https://")) {
      useThrift = true;
    }
    String serverlessStr =conf.get(AliHBaseConstants.SERVERLESS_IDENTIFIER, AliHBaseConstants.DEFAULT_SERVERLESS_IDENTIFIER);
    if (conf.get(AliHBaseConstants.ALIHBASE_USE_THRIFT) != null) {
      useThrift = conf.getBoolean(AliHBaseConstants.ALIHBASE_USE_THRIFT, AliHBaseConstants.ALIHBASE_USE_THRIFT_DEFAULT);
    }
    if (useThrift) {
      return new AliHBaseThriftImplFactory(conf);
    } else {
      return new AliHBaseDirectImplFactory(conf);
    }
  }


}
