package com.alibaba.hbase.haclient.dualservice;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.StrUtil;
import com.google.gson.JsonObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

public class DualTrace {

  private static Log LOG = LogFactory.getLog(DualTrace.class);

  public static String GET = "getMetrics";

  public static String PUT = "putMetrics";

  public static String DELETE = "deleteMetrics";

  public static String BATCHGET = "batchGetMetrics";

  public static String BATCHPUT = "batchPutMetrics";

  public static String BATCHDELETE = "batchDeleteMetrics";

  public static String SCAN = "scanMetrics";

  private ZooKeeperWatcher zooKeeperWatcher = null;

  private String name;

  private ConcurrentHashMap<String, DualMetrics> metricsMap = new ConcurrentHashMap<>();

  private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

  private DualTrace(final String endpoint, final Configuration clientConf){
    name = "dt-" + StrUtil.generateRandomString(7);
    metricsMap.put(GET, new DualMetrics("get"));
    metricsMap.put(PUT, new DualMetrics("put"));
    metricsMap.put(DELETE, new DualMetrics("delete"));
    metricsMap.put(BATCHGET, new DualMetrics("batchGet"));
    metricsMap.put(BATCHPUT, new DualMetrics("batchPut"));
    metricsMap.put(BATCHDELETE, new DualMetrics("batchDelete"));
    metricsMap.put(SCAN, new DualMetrics("scan"));
    long period = clientConf.getLong(AliHBaseConstants.DUALSERVICE_TRACE_PERIOD,
      AliHBaseConstants.DEFAULT_DUALSERVICE_TRACE_PERIOD);
    try {
      this.zooKeeperWatcher = DualUtil.getZookeeperWatcher(endpoint);
    }catch (Exception e){
      LOG.warn("get dual trace zk failed " + e);
    }
    scheduledExecutorService.scheduleAtFixedRate(new Runnable() {
      @Override
      public void run() {
        JsonObject snapshot = snapshot();
        try {
          if(zooKeeperWatcher != null) {
            DualUtil.setDualTraceToZK(zooKeeperWatcher, endpoint, clientConf, name,
              snapshot.toString());
          }
        }catch(Exception e){
          LOG.warn("set dual trace to zk failed " + e);
        }
      }
    }, period, period, TimeUnit.MILLISECONDS);
  }

  public static DualTrace getInstance(){
    return Singleton.INSTANCE.getInstance();
  }

  public static void init(String endpoint, Configuration clientConf){
    Singleton.INSTANCE.init(endpoint, clientConf);
  }

  private enum Singleton{
    INSTANCE;

    private DualTrace singleton;

    synchronized void init(String endpoint, Configuration clientConf) {
      if (singleton == null) {
        singleton = new DualTrace(endpoint, clientConf);
      }
    }

    public DualTrace getInstance(){
      return singleton;
    }
  }

  public DualMetrics getMetrics(String name){
    return this.metricsMap.get(name);
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonObject snapshot(){
    JsonObject result = new JsonObject();
    for(String metrics : this.metricsMap.keySet()){
      DualMetrics dm = this.metricsMap.get(metrics);
      result.add(dm.getName(), dm.shapshot());
    }
    return result;
  }

  public void close(){
    this.scheduledExecutorService.shutdown();
  }
}