package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.AdminUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;


public class AliHBaseMultiAdmin extends HBaseAdmin implements AliHBaseAdminInterface {
  private static final Log LOG = LogFactory.getLog(AliHBaseMultiAdmin.class);

  private volatile HBaseAdmin currentHBaseAdmin = null;
  //switch count decide switch or not
  private long switchCount = 0;
  private AliHBaseMultiClusterConnection connection;

  public AliHBaseMultiAdmin(AliHBaseMultiClusterConnection connection,
                            HBaseAdmin hbaseAdmin) throws IOException{
    super(connection);
    this.currentHBaseAdmin = hbaseAdmin;
    this.connection = connection;
    this.switchCount = connection.getSwitchCount();
  }

  private HBaseAdmin getCurrentHBaseAdmin() throws IOException {
    if(this.switchCount < connection.getSwitchCount()){
      AliHBaseConstants.ClusterType clusterType =
        AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
      //only HBase to HBase no need update BufferedMutator
      if(!(this.currentHBaseAdmin instanceof HBaseAdmin && clusterType == AliHBaseConstants.ClusterType.HBASE)) {
        HBaseAdmin newHBaseAdmin = connection.getHBaseAdmin();
        HBaseAdmin lastHBaseAdmin = this.currentHBaseAdmin;
        this.currentHBaseAdmin = newHBaseAdmin;
        if (lastHBaseAdmin != null) {
          try {
            lastHBaseAdmin.close();
          } catch (IOException e) {
            LOG.warn("last hbaseAdmin close failed" + e);
          }
        }
      }
      this.switchCount = connection.getSwitchCount();
    }
    return this.currentHBaseAdmin;
  }

  @Override
  public int getOperationTimeout() {
    return this.currentHBaseAdmin.getOperationTimeout();
  }

  @Override
  public void abort(String why, Throwable e) {
    this.currentHBaseAdmin.abort(why, e);
  }

  @Override
  public boolean isAborted() {
    return this.currentHBaseAdmin.isAborted();
  }


  @Override
  public Configuration getConfiguration() {
    return this.currentHBaseAdmin.getConfiguration();
  }

  @Override
  public boolean tableExists(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().tableExists(tableName);
  }

  @Override
  public HConnection getConnection() {
    return connection;
  }

  @Override
  public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
    try {
      return this.getCurrentHBaseAdmin().isMasterRunning();
    }catch(IOException e){
      LOG.error("isMasterRunning failed : " + e);
      return true;
    }
  }

  @Override
  public HTableDescriptor[] listTables() throws IOException {
    return this.getCurrentHBaseAdmin().listTables();
  }

  @Override
  public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
    return listTables();
  }

  @Override
  public HTableDescriptor[] listTables(String regex) throws IOException {
    return listTables();
  }

  @Override
  public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables)
    throws IOException {
    return listTables();
  }

  @Override
  public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
    return listTables();
  }

  @Override
  public TableName[] listTableNames() throws IOException {
    return this.getCurrentHBaseAdmin().listTableNames();
  }

  @Override
  public TableName[] listTableNames(Pattern pattern) throws IOException {
    return listTableNames();
  }

  @Override
  public TableName[] listTableNames(String regex) throws IOException {
    return listTableNames();
  }

  @Override
  public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
    return listTableNames();
  }

  @Override
  public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
    return listTableNames();
  }

  @Override
  public HTableDescriptor getTableDescriptor(TableName tableName)
    throws TableNotFoundException, IOException {
    return this.getCurrentHBaseAdmin().getTableDescriptor(tableName);
  }

  @Override
  public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
    return this.getCurrentHBaseAdmin().listTableDescriptorsByNamespace(name);
  }

  @Override
  public TableName[] listTableNamesByNamespace(String name) throws IOException {
    return this.getCurrentHBaseAdmin().listTableNamesByNamespace(name);
  }

  @Override
  public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames)
    throws IOException {
    return this.getCurrentHBaseAdmin().getTableDescriptorsByTableName(tableNames);
  }

  @Override
  public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
    return this.getCurrentHBaseAdmin().getTableDescriptors(names);
  }

  @Override
  public void createTable(HTableDescriptor desc) throws IOException {
    createTable(desc, null);
  }

  @Override
  public void createTable(HTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
    if(numRegions < 3) {
      throw new IllegalArgumentException("Must create at least three regions");
    } else if(Bytes.compareTo(startKey, endKey) >= 0) {
      throw new IllegalArgumentException("Start key must be smaller than end key");
    }
    if (numRegions == 3) {
      createTable(desc, new byte[][]{startKey, endKey});
      return;
    }
    byte [][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
    if(splitKeys == null || splitKeys.length != numRegions - 1) {
      throw new IllegalArgumentException("Unable to split key range into enough regions");
    }
    createTable(desc, splitKeys);
  }

  @Override
  public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
    this.getCurrentHBaseAdmin().createTable(desc, splitKeys);
    try{
      AdminUtil.setCreateInfoNode(this.connection.getOriginalConf(), desc, splitKeys);
    }catch(Exception e){
      throw new IOException(e);
    }
  }

  @Override
  public void createTableAsync(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
    this.getCurrentHBaseAdmin().createTableAsync(desc, splitKeys);
  }

  @Override
  public void deleteTable(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().deleteTable(tableName);
  }

  @Override
  public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
    this.getCurrentHBaseAdmin().truncateTable(tableName, preserveSplits);
  }

  @Override
  public void enableTable(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().enableTable(tableName);
  }

  @Override
  public void enableTableAsync(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().enableTableAsync(tableName);
  }

  @Override
  public void disableTable(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().disableTable(tableName);
  }

  @Override
  public void disableTableAsync(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().disableTableAsync(tableName);
  }

  @Override
  public boolean isTableEnabled(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().isTableEnabled(tableName);
  }

  @Override
  public boolean isTableDisabled(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().isTableDisabled(tableName);
  }

  @Override
  public boolean isTableAvailable(TableName tableName) throws IOException {
    return isTableEnabled(tableName);
  }

  @Override
  public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
    return this.getCurrentHBaseAdmin().isTableAvailable(tableName, splitKeys);
  }

  @Override
  public void addColumn(TableName tableName, HColumnDescriptor columnFamily)
    throws IOException {
    this.getCurrentHBaseAdmin().addColumn(tableName, columnFamily);
  }

  @Override
  public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().deleteColumn(tableName, columnFamily);
  }

  @Override
  public void modifyColumn(final TableName tableName, final HColumnDescriptor descriptor) throws IOException {
    this.getCurrentHBaseAdmin().modifyColumn(tableName, descriptor);
  }

  @Override
  public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
    this.getCurrentHBaseAdmin().modifyNamespace(descriptor);
  }

  @Override
  public void deleteNamespace(String name) throws IOException {
    this.getCurrentHBaseAdmin().deleteNamespace(name);
  }

  @Override
  public NamespaceDescriptor getNamespaceDescriptor(String name)
    throws NamespaceNotFoundException, IOException {
    return this.getCurrentHBaseAdmin().getNamespaceDescriptor(name);
  }

  @Override
  public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
    return this.getCurrentHBaseAdmin().listNamespaceDescriptors();
  }

  @Override
  public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
    this.getCurrentHBaseAdmin().createNamespace(descriptor);
  }

  @Override
  public void flush(TableName tableName) throws IOException{
    this.getCurrentHBaseAdmin().flush(tableName);
  }

  @Override
  public void flushRegion(byte[] regionName) throws IOException{
    this.getCurrentHBaseAdmin().flushRegion(regionName);
  }

  @Override
  public void compact(TableName tableName) throws IOException{
    this.getCurrentHBaseAdmin().compact(tableName);
  }

  @Override
  public void compactRegion(byte[] regionName) throws IOException {
    this.getCurrentHBaseAdmin().compactRegion(regionName);
  }

  @Override
  public void compact(TableName tableName, byte[] columnFamily) throws IOException{
    this.getCurrentHBaseAdmin().compact(tableName, columnFamily);
  }

  @Override
  public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException{
    this.getCurrentHBaseAdmin().compactRegion(regionName, columnFamily);
  }

  @Override
  public void compact(String tableNameOrRegionName) throws IOException {
    this.getCurrentHBaseAdmin().compact(tableNameOrRegionName);
  }

  @Override
  public void compact(byte[] tableNameOrRegionName) throws IOException {
      this.getCurrentHBaseAdmin().compact(tableNameOrRegionName);
  }

  @Override
  public void compact(String tableOrRegionName, String columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().compact(tableOrRegionName, columnFamily);
  }

  @Override
  public void compact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().compact(tableNameOrRegionName, columnFamily);
  }

  @Override
  public void compactRegionServer(ServerName sn, boolean major) throws IOException, InterruptedException {
    this.getCurrentHBaseAdmin().compactRegionServer(sn ,major);
  }

  @Override
  public void majorCompact(TableName tableName) throws IOException{
    this.getCurrentHBaseAdmin().majorCompact(tableName);
  }

  @Override
  public void majorCompactRegion(byte[] regionName) throws IOException{
    this.getCurrentHBaseAdmin().majorCompactRegion(regionName);
  }

  @Override
  public void majorCompact(TableName tableName, byte[] columnFamily)throws IOException {
    this.getCurrentHBaseAdmin().majorCompact(tableName, columnFamily);
  }

  @Override
  public void majorCompact(String tableNameOrRegionName) throws IOException {
    this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName);
  }

  @Override
  public void majorCompact(byte[] tableNameOrRegionName) throws IOException {
    this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName);
  }

  @Override
  public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().majorCompactRegion(regionName, columnFamily);
  }

  @Override
  public void majorCompact(String tableNameOrRegionName, String columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName, columnFamily);
  }

  @Override
  public void majorCompact(byte[] tableNameOrRegionName, byte[] columnFamily) throws IOException {
    this.getCurrentHBaseAdmin().majorCompact(tableNameOrRegionName, columnFamily);
  }

  @Override
  public HTableDescriptor[] disableTables(String regex) throws IOException {
    return this.getCurrentHBaseAdmin().disableTables(regex);
  }

  @Override
  public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
    return this.getCurrentHBaseAdmin().disableTables(pattern);
  }

  @Override
  public HTableDescriptor[] enableTables(String regex) throws IOException {
    return this.getCurrentHBaseAdmin().enableTables(regex);
  }

  @Override
  public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
    return this.getCurrentHBaseAdmin().enableTables(pattern);
  }

  @Override
  public HTableDescriptor[] deleteTables(String regex) throws IOException {
    return this.getCurrentHBaseAdmin().deleteTables(regex);
  }

  @Override
  public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
    return this.getCurrentHBaseAdmin().deleteTables(pattern);
  }


  @Override
  public void closeRegion(String regionname, String serverName) throws IOException {
    this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
  }

  @Override
  public void closeRegion(byte[] regionname, String serverName) throws IOException{
    this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
  }

  @Override
  public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException{
    return this.getCurrentHBaseAdmin().closeRegionWithEncodedRegionName(encodedRegionName, serverName);
  }

  @Override
  public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException{
    this.getCurrentHBaseAdmin().closeRegion(sn, hri);
  }

  @Override
  public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException{
    return this.getCurrentHBaseAdmin().getOnlineRegions(sn);
  }

  @Override
  public void move(final byte[] encodedRegionName, final byte[] destServerName) throws IOException {
    this.getCurrentHBaseAdmin().move(encodedRegionName, destServerName);
  }

  @Override
  public void assign(byte[] regionName) throws IOException {
    this.getCurrentHBaseAdmin().assign(regionName);
  }

  @Override
  public void unassign(byte[] regionName, boolean force) throws IOException {
    this.getCurrentHBaseAdmin().unassign(regionName, force);
  }

  @Override
  public void offline(byte[] regionName) throws IOException {
    this.getCurrentHBaseAdmin().offline(regionName);
  }

  @Override
  public boolean setBalancerRunning(final boolean on, final boolean synchronous) throws IOException {
    return this.getCurrentHBaseAdmin().setBalancerRunning(on, synchronous);
  }

  @Override
  public boolean balancer() throws IOException {
    return this.getCurrentHBaseAdmin().balancer();
  }

  @Override
  public boolean isBalancerEnabled() throws IOException {
    return this.getCurrentHBaseAdmin().isBalancerEnabled();
  }

  @Override
  public boolean enableCatalogJanitor(final boolean enable) throws IOException {
    return this.getCurrentHBaseAdmin().enableCatalogJanitor(enable);
  }

  @Override
  public int runCatalogScan() throws IOException {
    return this.getCurrentHBaseAdmin().runCatalogScan();
  }

  @Override
  public boolean isCatalogJanitorEnabled() throws IOException {
    return this.getCurrentHBaseAdmin().isCatalogJanitorEnabled();
  }

  @Override
  public void mergeRegions(final byte[] encodedNameOfRegionA, final byte[] encodedNameOfRegionB, final boolean forcible) throws IOException {
    this.getCurrentHBaseAdmin().mergeRegions(encodedNameOfRegionA, encodedNameOfRegionB, forcible);
  }

  @Override
  public void split(TableName tableName) throws IOException {
    this.getCurrentHBaseAdmin().split(tableName);
  }

  @Override
  public void splitRegion(byte[] regionName) throws IOException {
    this.getCurrentHBaseAdmin().splitRegion(regionName);
  }

  @Override
  public void split(String tableNameOrRegionName) throws IOException, InterruptedException {
    this.getCurrentHBaseAdmin().split(tableNameOrRegionName);
  }

  @Override
  public void split(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    this.getCurrentHBaseAdmin().split(tableNameOrRegionName);
  }

  @Override
  public void split(TableName tableName, byte[] splitPoint) throws IOException {
    this.getCurrentHBaseAdmin().split(tableName, splitPoint);
  }

  @Override
  public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
    this.getCurrentHBaseAdmin().splitRegion(regionName, splitPoint);
  }

  @Override
  public void split(String tableNameOrRegionName, String splitPoint) throws IOException {
    this.getCurrentHBaseAdmin().split(tableNameOrRegionName, splitPoint);
  }

  @Override
  public void split(byte[] tableNameOrRegionName, byte[] splitPoint) throws IOException {
    this.getCurrentHBaseAdmin().split(tableNameOrRegionName, splitPoint);
  }

  @Override
  public void split(ServerName sn, HRegionInfo hri, byte[] splitPoint) throws IOException {
    this.getCurrentHBaseAdmin().split(sn, hri, splitPoint);
  }

  @Override
  public void modifyTable(final TableName tableName, final HTableDescriptor htd) throws IOException {
    this.getCurrentHBaseAdmin().modifyTable(tableName, htd);
    try{
      AdminUtil.setModifyInfoNode(this.connection.getOriginalConf(), htd);
    }catch(Exception e){
      throw new IOException(e);
    }
  }

  @Override
  public void modifyTable(byte[] tableName, HTableDescriptor htd) throws IOException {
    modifyTable(TableName.valueOf(tableName), htd);
  }

  @Override
  public void modifyTable(String tableName, HTableDescriptor htd) throws IOException {
    modifyTable(TableName.valueOf(tableName), htd);
  }

  @Override
  public synchronized void shutdown() throws IOException {
    this.getCurrentHBaseAdmin().shutdown();
  }

  @Override
  public synchronized void stopMaster() throws IOException {
    this.getCurrentHBaseAdmin().stopMaster();
  }

  @Override
  public synchronized void stopRegionServer(String hostnamePort) throws IOException {
    this.getCurrentHBaseAdmin().stopRegionServer(hostnamePort);
  }

  @Override
  public ClusterStatus getClusterStatus() throws IOException {
    return this.getCurrentHBaseAdmin().getClusterStatus();
  }

  @Override
  public ProcedureInfo[] listProcedures() throws IOException {
    return this.getCurrentHBaseAdmin().listProcedures();
  }

  @Override
  public List<HRegionInfo> getTableRegions(byte[] tableName) throws IOException {
   return this.getCurrentHBaseAdmin().getTableRegions(tableName);
  }

  @Override
  public synchronized void close() throws IOException {
    this.getCurrentHBaseAdmin().close();
  }

  @Override
  public synchronized byte[][] rollHLogWriter(String serverName) throws IOException, FailedLogCloseException {
    return this.getCurrentHBaseAdmin().rollHLogWriter(serverName);
  }

  @Override
  public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
    this.getCurrentHBaseAdmin().rollWALWriter(serverName);
  }

  @Override
  public String[] getMasterCoprocessors() {
    try {
      return this.getCurrentHBaseAdmin().getMasterCoprocessors();
    }catch(IOException e){
      LOG.error("getMasterCoprocessors failed : " + e);
      return null;
    }
  }

  @Override
  public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().getCompactionState(tableName);
  }

  @Override
  public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
    return this.getCurrentHBaseAdmin().getCompactionStateForRegion(regionName);
  }

  @Override
  public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(String tableNameOrRegionName) throws IOException, InterruptedException {
    return this.getCurrentHBaseAdmin().getCompactionState(tableNameOrRegionName);
  }

  @Override
  public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(byte[] tableNameOrRegionName) throws IOException, InterruptedException {
    return this.getCurrentHBaseAdmin().getCompactionState(tableNameOrRegionName);
  }

  @Override
  public void snapshot(String snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
  }

  @Override
  public void snapshot(String snapshotName, String tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
  }

  @Override
  public void snapshot(byte[] snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type flushType) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, flushType);
  }

  @Override
  public void snapshot(byte[] snapshotName, TableName tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
  }

  @Override
  public void snapshot(byte[] snapshotName, byte[] tableName) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
  }

  @Override
  public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
  }

  @Override
  public void snapshot(String snapshotName, String tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
  }

  @Override
  public void snapshot(String snapshotName, byte[] tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
  }

  @Override
  public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
    this.getCurrentHBaseAdmin().snapshot(snapshot);
  }

  @Override
  public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
    return this.getCurrentHBaseAdmin().takeSnapshotAsync(snapshot);
  }

  @Override
  public boolean isSnapshotFinished(final HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
    return this.getCurrentHBaseAdmin().isSnapshotFinished(snapshot);
  }

  @Override
  public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
  }

  @Override
  public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
  }

  @Override
  public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
  }

  @Override
  public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
  }

  @Override
  public void cloneSnapshot(byte[] snapshotName, byte[] tableName) throws IOException, TableExistsException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
  }

  @Override
  public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
  }

  @Override
  public void cloneSnapshot(String snapshotName, String tableName) throws IOException, TableExistsException, RestoreSnapshotException, InterruptedException {
    this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
  }

  @Override
  public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException, TableExistsException, RestoreSnapshotException {
    this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
  }

  @Override
  public byte[] execProcedureWithRet(String signature, String instance, Map<String, String> props) throws IOException {
    return this.getCurrentHBaseAdmin().execProcedureWithRet(signature, instance, props);
  }

  @Override
  public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
    this.getCurrentHBaseAdmin().execProcedure(signature, instance, props);
  }

  @Override
  public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
   return this.getCurrentHBaseAdmin().isProcedureFinished(signature, instance, props);
  }

  @Override
  public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
    return this.getCurrentHBaseAdmin().listSnapshots();
  }

  @Override
  public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
    return this.getCurrentHBaseAdmin().listSnapshots(regex);
  }

  @Override
  public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
    return this.getCurrentHBaseAdmin().listSnapshots(pattern);
  }

  @Override
  public int getMasterInfoPort() throws IOException {
    return this.getCurrentHBaseAdmin().getMasterInfoPort();
  }

  @Override
  public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().getTableRegions(tableName);
  }

  @Override
  public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
    return this.getCurrentHBaseAdmin().abortProcedure(procId, mayInterruptIfRunning);
  }

  @Override
  public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
    return this.getCurrentHBaseAdmin().abortProcedureAsync(procId, mayInterruptIfRunning);
  }

  @Override
  public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
    return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestamp(tableName);
  }

  @Override
  public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
    return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestampForRegion(regionName);
  }

  @Override
  public void deleteSnapshot(byte[] snapshotName) throws IOException {
    this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
  }

  @Override
  public void deleteSnapshot(String snapshotName) throws IOException {
    this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
  }

  @Override
  public void deleteSnapshots(String regex) throws IOException {
    this.getCurrentHBaseAdmin().deleteSnapshots(regex);
  }

  @Override
  public void deleteSnapshots(Pattern pattern) throws IOException {
    this.getCurrentHBaseAdmin().deleteSnapshots(pattern);
  }

  @Override
  public void setQuota(QuotaSettings quota) throws IOException {
    this.getCurrentHBaseAdmin().setQuota(quota);
  }

  @Override
  public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
    return this.getCurrentHBaseAdmin().getQuotaRetriever(filter);
  }

  @Override
  public CoprocessorRpcChannel coprocessorService() {
    try {
      return this.getCurrentHBaseAdmin().coprocessorService();
    }catch(IOException e){
      LOG.error("coprocessorService failed : " + e);
      return null;
    }
  }

  @Override
  public CoprocessorRpcChannel coprocessorService(ServerName serverName)  {
    try {
      return this.getCurrentHBaseAdmin().coprocessorService(serverName);
    } catch(IOException e){
      LOG.error("coprocessorService failed : " + e);
      return null;
    }
  }

  @Override
  public void updateConfiguration(ServerName server) throws IOException {
    this.getCurrentHBaseAdmin().updateConfiguration(server);
  }

  @Override
  public void updateConfiguration() throws IOException {
    this.getCurrentHBaseAdmin().updateConfiguration();
  }

  @Override
  public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
    // return a fake pair
    return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
  }

  @Override
  public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
    // return a fake pair
    return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
  }

  @Override
  public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
    if (isHBaseUE()) {
      return ((AliHBaseUEAdmin) this.currentHBaseAdmin).describeIndex(dataTableName);
    } else {
      throw new UnsupportedOperationException("describeIndex not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
    if(isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).createIndex(indexDescriptor);
    } else {
      throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
    if(isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).createIndex(indexDescriptor, splitKeys);
    } else {
      throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[] startKey, byte[] endKey, int numRegions)
          throws IOException {
    if(isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).createIndex(indexDescriptor, startKey, endKey, numRegions);
    } else {
      throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void deleteIndex(String indexName, TableName dataTable) throws IOException {
    if(isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).deleteIndex(indexName, dataTable);
    } else {
      throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
    }
    throw new UnsupportedOperationException("createIndex not supported");
  }

  @Override
  public void offlineIndex(String indexName, TableName dataTable) throws IOException {
    if(isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).offlineIndex(indexName, dataTable);
    } else {
      throw new UnsupportedOperationException("offlineIndex not supported by HBase, please use HBaseUE instead.");
    }
  }


  @Override
  public void registerBDSCluster(String hbaseSourceName, String bdsClusterkey,
      String hbaseConnectionString, String username, String password) throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).registerBDSCluster(hbaseSourceName, bdsClusterkey, hbaseConnectionString, username, password);
    } else {
      throw new UnsupportedOperationException("registerBDSCluster not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void registerSolrCluster(String solrSourceName, String solrConnectionStr)
      throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).registerSolrCluster(solrSourceName, solrConnectionStr);
    } else {
      throw new UnsupportedOperationException("registerSolrCluster not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void registerESCluster(String esSourceName, String esConnectionStr, String userName,
      String password) throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).registerESCluster(esSourceName, esConnectionStr, userName, password);
    } else {
      throw new UnsupportedOperationException("registerESCluster not supported by HBase, please use HBaseUE instead.");
    }

  }

  @Override
  public void unregisterSolrCluster(boolean force) throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).unregisterSolrCluster(force);
    } else {
      throw new UnsupportedOperationException("unregisterSolrCluster not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void unregisterESCluster(boolean force) throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).unregisterESCluster(force);
    } else {
      throw new UnsupportedOperationException("unregisterESCluster not supported by HBase, please use HBaseUE instead.");
    }
  }

  @Override
  public void unregisterBDSCluster(boolean force) throws IOException {
    if (isHBaseUE()) {
      ((AliHBaseUEAdmin) this.currentHBaseAdmin).unregisterBDSCluster(force);
    } else {
      throw new UnsupportedOperationException("unregisterBDSCluster not supported by HBase, please use HBaseUE instead.");
    }
  }

  /**
   * Whether current connection is connected to an HBaseUE cluster.
   * @return true if connected to HBaseUE, false otherwise
   */
  private boolean isHBaseUE() {
    AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(
            this.connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
    return (this.currentHBaseAdmin instanceof AliHBaseUEAdmin && clusterType == AliHBaseConstants.ClusterType.HBASEUE);
  }
}