package org.apache.hadoop.hbase.client;

import java.io.IOException;

import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import com.alibaba.hbase.haclient.dualservice.DualScannerResult;
import org.apache.hadoop.hbase.HConstants;

public class AliHBaseResultScanner extends AbstractClientScanner {

  private HTable activeTable;
  private HTable standbyTable;
  private ResultScanner activeScanner = null;
  private ResultScanner standbyScanner = null;
  private volatile ResultScanner currentScanner = null;
  private DualExecutor dualExecutor;
  private Scan activeScan;
  private Scan standbyScan;
  private int glitchTimeout;
  private int scannerTimeout;

  public AliHBaseResultScanner(HTable activeTable, HTable standbyTable, DualExecutor dualExecutor
    , Scan scan, int glitchTimeout, int scannerTimeout) throws IOException{
    this.activeTable = activeTable;
    this.standbyTable = standbyTable;
    this.dualExecutor = dualExecutor;
    this.activeScan = new Scan(scan);
    this.standbyScan = new Scan(scan);
    this.activeScanner = this.activeTable.getScanner(this.activeScan);
    this.standbyScanner = this.standbyTable.getScanner(this.standbyScan);
    this.glitchTimeout = glitchTimeout;
    this.scannerTimeout = scannerTimeout;
  }

  @Override
  public Result next() throws IOException{
    if(currentScanner == null){
      DualScannerResult dualScannerResult = this.dualExecutor.dualNext(activeScanner,
        standbyScanner, activeTable.getName().getName(), glitchTimeout, scannerTimeout);
      this.currentScanner = dualScannerResult.getScanner();
      return dualScannerResult.getResult();
    }
    return currentScanner.next();
  }

  @Override
  public void close(){
    if(this.activeScanner != null ){
      this.activeScanner.close();
    }
    if(this.standbyScanner != null){
      this.standbyScanner.close();
    }
  }

  @Override
  public boolean renewLease(){
    return false;
  }
}