/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseThriftImplFactory;
import com.alibaba.hbase.client.Callable;
import com.alibaba.hbase.client.ThriftUtilities;
import com.alibaba.hbase.exception.BatchExceptions;
import com.alibaba.hbase.thrift2.generated.TAppend;
import com.alibaba.hbase.thrift2.generated.TColumnFamilyDescriptor;
import com.alibaba.hbase.thrift2.generated.TDelete;
import com.alibaba.hbase.thrift2.generated.TGet;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import com.alibaba.hbase.thrift2.generated.TIncrement;
import com.alibaba.hbase.thrift2.generated.TNamespaceDescriptor;
import com.alibaba.hbase.thrift2.generated.TPut;
import com.alibaba.hbase.thrift2.generated.TResult;
import com.alibaba.hbase.thrift2.generated.TRowMutations;
import com.alibaba.hbase.thrift2.generated.TScan;
import com.alibaba.hbase.thrift2.generated.TTableDescriptor;
import com.alibaba.hbase.thrift2.generated.TTableName;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;

public class AliHBaseAPIProxyThriftImpl
implements AliHBaseAPIProxy {
    private THBaseService.Client client;
    private TTransport transport;
    private ByteBuffer tableNameInBytes;
    private int defaultScannerCaching;
    private int operationTimeout;
    private int pause;
    private int numRetries;
    private AliHBaseThriftImplFactory factory;
    private int cUInBytes;
    private static Pair<byte[][], byte[][]> fakeKeys;

    public AliHBaseAPIProxyThriftImpl(Configuration conf, THBaseService.Client client, TTransport transport, TableName tableName, AliHBaseThriftImplFactory factory) {
        this.factory = factory;
        this.client = client;
        this.transport = transport;
        if (tableName != null) {
            this.tableNameInBytes = ByteBuffer.wrap(tableName.toBytes());
        }
        this.defaultScannerCaching = conf.getInt("hbase.client.scanner.caching", 100);
        if (this.defaultScannerCaching > 100) {
            this.defaultScannerCaching = 100;
        }
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.pause = (int)conf.getLong("hbase.client.pause", 100L);
        this.numRetries = conf.getInt("hbase.client.retries.number", 31);
        this.cUInBytes = conf.getInt("hbase.client.cu.in.bytes", 4096);
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.tableExists(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<HTableDescriptor> listTableDescriptors() throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByPattern(null, false);
            return ThriftUtilities.tableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByPattern(null, false);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HTableDescriptor getDescriptor(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            TTableDescriptor tTableDescriptor = this.client.getTableDescriptor(tTableName);
            return ThriftUtilities.tableDescriptorFromThrift(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByNamespace(name);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<HTableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByNamespace(name);
            return ThriftUtilities.tableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createTable(HTableDescriptor desc, byte[][] splitKeys) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(desc);
        List<ByteBuffer> splitKeyInBuffer = ThriftUtilities.splitKeyFromHBase(splitKeys);
        try {
            this.client.createTable(tTableDescriptor, splitKeyInBuffer);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.truncateTable(tTableName, preserveSplits);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.enableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.disableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableEnabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableDisabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableAvailable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addColumnFamily(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.addColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteColumnFamily(tTableName, ByteBuffer.wrap(columnFamily));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void modifyColumnFamily(TableName tableName, HColumnDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.modifyColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void modifyTable(HTableDescriptor td) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(td);
        try {
            this.client.modifyTable(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        try {
            this.client.deleteNamespace(name);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        try {
            TNamespaceDescriptor tNamespaceDescriptor = this.client.getNamespaceDescriptor(name);
            return ThriftUtilities.namespaceDescriptorFromThrift(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        try {
            List<TNamespaceDescriptor> tNamespaceDescriptors = this.client.listNamespaceDescriptors();
            return ThriftUtilities.namespaceDescriptorsFromThrift(tNamespaceDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        TNamespaceDescriptor tNamespaceDescriptor = ThriftUtilities.namespaceDescriptorFromHBase(descriptor);
        try {
            this.client.createNamespace(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flushRegion(String regionName) {
        throw new UnsupportedOperationException("flush is not supported");
    }

    @Override
    public void compactRegion(String regionName) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    @Override
    public void majorCompactRegion(String regionName) {
        throw new UnsupportedOperationException("majorCompact is not supported");
    }

    @Override
    public void flushTable(TableName tableName) {
        throw new UnsupportedOperationException("flush is not supported");
    }

    @Override
    public void compactTable(TableName tableName) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    @Override
    public void majorCompactTable(TableName tableName) {
        throw new UnsupportedOperationException("majorCompact is not supported");
    }

    @Override
    public void split(String tableNameOrRegionName, byte[] splitPoint) {
        throw new UnsupportedOperationException("split is not supported");
    }

    @Override
    public void mergeRegions(String tableNameA, String shortNameA, String shortNameB) {
        throw new UnsupportedOperationException("merge regions is not supported");
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        throw new UnsupportedOperationException("getRegionLocation is not supported");
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        HRegionLocation loc = this.createFakeRegionLocation(((byte[][])fakeKeys.getFirst())[0], ((byte[][])fakeKeys.getSecond())[0]);
        ArrayList<HRegionLocation> lists = new ArrayList<HRegionLocation>();
        lists.add(loc);
        return lists;
    }

    private HRegionLocation createFakeRegionLocation(byte[] startKey, byte[] endKey) {
        HRegionInfo regionInfo = new HRegionInfo(TableName.valueOf((byte[])this.tableNameInBytes.array()), startKey, endKey);
        return new HRegionLocation(regionInfo, ServerName.valueOf((String)"localhost", (int)0, (long)0L));
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return fakeKeys;
    }

    @Override
    public boolean exists(Get get2) throws IOException {
        final TGet tGet = ThriftUtilities.getFromHBase(get2);
        this.factory.acquirePermitInCU(1);
        RetryingCaller<Boolean> retryingCaller = new RetryingCaller<Boolean>();
        return retryingCaller.withRetries(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.exists(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tGet);
            }
        });
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        final ArrayList<TGet> tGets = new ArrayList<TGet>();
        for (Get get2 : gets) {
            tGets.add(ThriftUtilities.getFromHBase(get2));
        }
        this.factory.acquirePermitInCU(gets.size());
        RetryingCaller<List<Boolean>> retryingCaller = new RetryingCaller<List<Boolean>>();
        List<Boolean> results = retryingCaller.withRetries(new Callable<List<Boolean>>(){

            @Override
            public List<Boolean> call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.existsAll(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tGets);
            }
        });
        boolean[] booleans = new boolean[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            booleans[i] = results.get(i);
        }
        return booleans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        ArrayList<Object> tactions = new ArrayList<Object>(actions.size());
        int writeSize = 0;
        int readSize = 0;
        boolean hasGet = false;
        for (Row row : actions) {
            if (row instanceof Get) {
                tactions.add(ThriftUtilities.getFromHBase((Get)row));
                hasGet = true;
                continue;
            }
            if (row instanceof Put) {
                Put put2 = (Put)row;
                writeSize += AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)put2);
                tactions.add(ThriftUtilities.putFromHBase(put2));
                continue;
            }
            if (row instanceof Delete) {
                Delete delete = (Delete)row;
                tactions.add(ThriftUtilities.deleteFromHBase(delete));
                writeSize += AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)delete);
                continue;
            }
            if (row instanceof Append) {
                Append append2 = (Append)row;
                tactions.add(ThriftUtilities.appendFromHBase(append2));
                writeSize += AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)append2);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type " + row.getClass().getName() + " in batch operation.");
        }
        this.factory.acquirePermitInCU(this.convertToCU(writeSize));
        if (hasGet) {
            this.factory.acquirePermitInCU(1);
        }
        Object[] hbaseResults = null;
        BatchExceptions batchExceptions = new BatchExceptions();
        try {
            hbaseResults = this.batch(tactions);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < hbaseResults.length; ++i) {
                if (results != null) {
                    if (hbaseResults[i] == null) {
                        results[i] = null;
                        continue;
                    }
                    if (hbaseResults[i] instanceof TResult) {
                        Result result = ThriftUtilities.resultFromThrift((TResult)hbaseResults[i]);
                        results[i] = result;
                        readSize += AliHBaseAPIProxyThriftImpl.calculateResultSize(result);
                        continue;
                    }
                    if (hbaseResults[i] instanceof Result) {
                        results[i] = hbaseResults[i];
                        continue;
                    }
                    if (hbaseResults[i] instanceof Throwable) {
                        results[i] = hbaseResults[i];
                        batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                        continue;
                    }
                    throw new IOException("Not unsupported result type " + hbaseResults[i]);
                }
                if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
                batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
            }
            if (batchExceptions.hasErrors()) {
                throw batchExceptions.makeException();
            }
            this.factory.acquirePermitInCU(this.convertToCU(readSize, 1));
            throw throwable;
        }
        for (int i = 0; i < hbaseResults.length; ++i) {
            if (results != null) {
                if (hbaseResults[i] == null) {
                    results[i] = null;
                    continue;
                }
                if (hbaseResults[i] instanceof TResult) {
                    Result result = ThriftUtilities.resultFromThrift((TResult)hbaseResults[i]);
                    results[i] = result;
                    readSize += AliHBaseAPIProxyThriftImpl.calculateResultSize(result);
                    continue;
                }
                if (hbaseResults[i] instanceof Result) {
                    results[i] = hbaseResults[i];
                    continue;
                }
                if (hbaseResults[i] instanceof Throwable) {
                    results[i] = hbaseResults[i];
                    batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                    continue;
                }
                throw new IOException("Not unsupported result type " + hbaseResults[i]);
            }
            if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
            batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
        }
        if (batchExceptions.hasErrors()) {
            throw batchExceptions.makeException();
        }
        this.factory.acquirePermitInCU(this.convertToCU(readSize, 1));
    }

    private Object[] batch(List<Object> actions) throws IOException {
        int i;
        Object[] results = new Object[actions.size()];
        final ArrayList<TGet> getActions = new ArrayList<TGet>();
        ArrayList<Integer> getActionsIndex = new ArrayList<Integer>();
        final ArrayList<TPut> putActions = new ArrayList<TPut>();
        ArrayList<Integer> putActionsIndex = new ArrayList<Integer>();
        final ArrayList<TDelete> delActions = new ArrayList<TDelete>();
        ArrayList<Integer> delActionsIndex = new ArrayList<Integer>();
        ArrayList<TAppend> appendActions = new ArrayList<TAppend>();
        ArrayList<Integer> appendActionsIndex = new ArrayList<Integer>();
        for (i = 0; i < actions.size(); ++i) {
            if (actions.get(i) instanceof TGet) {
                getActions.add((TGet)actions.get(i));
                getActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TPut) {
                putActions.add((TPut)actions.get(i));
                putActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TDelete) {
                delActions.add((TDelete)actions.get(i));
                delActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TAppend) {
                appendActions.add((TAppend)actions.get(i));
                appendActionsIndex.add(i);
                continue;
            }
            throw new UnsupportedOperationException("Not supported action " + actions.get(i).getClass().getName());
        }
        if (!getActions.isEmpty()) {
            try {
                RetryingCaller<List<TResult>> retryingCaller = new RetryingCaller<List<TResult>>();
                Iterator getResult = retryingCaller.withRetries(new Callable<List<TResult>>(){

                    @Override
                    public List<TResult> call() throws Exception {
                        return AliHBaseAPIProxyThriftImpl.this.client.getMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, getActions);
                    }
                });
                for (int i2 = 0; i2 < getActions.size(); ++i2) {
                    int index = (Integer)getActionsIndex.get(i2);
                    results[index] = getResult.get(i2);
                }
            }
            catch (Throwable e) {
                for (Integer index : getActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!putActions.isEmpty()) {
            try {
                RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
                retryingCaller.withRetries(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        AliHBaseAPIProxyThriftImpl.this.client.putMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, putActions);
                        return null;
                    }
                });
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!delActions.isEmpty()) {
            try {
                RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
                retryingCaller.withRetries(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        AliHBaseAPIProxyThriftImpl.this.client.deleteMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, delActions);
                        return null;
                    }
                });
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!appendActions.isEmpty()) {
            try {
                for (i = 0; i < appendActions.size(); ++i) {
                    final TAppend append2 = (TAppend)appendActions.get(i);
                    RetryingCaller<TResult> retryingCaller = new RetryingCaller<TResult>();
                    TResult tResult = retryingCaller.withRetries(new Callable<TResult>(){

                        @Override
                        public TResult call() throws Exception {
                            return AliHBaseAPIProxyThriftImpl.this.client.append(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, append2);
                        }
                    });
                    Result result = ThriftUtilities.resultFromThrift(tResult);
                    results[((Integer)appendActionsIndex.get((int)i)).intValue()] = result;
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        return results;
    }

    public static int calculateResultSize(Result result) {
        if (result == null || result.rawCells() == null) {
            return 0;
        }
        int size = 0;
        for (Cell cell : result.rawCells()) {
            if (cell == null) continue;
            size += CellUtil.estimatedSerializedSizeOf((Cell)cell);
        }
        return size;
    }

    public int convertToCU(int size, int cUPaiedInadvance) {
        int cu = size / this.cUInBytes - cUPaiedInadvance;
        return Math.max(0, cu);
    }

    public int convertToCU(int size) {
        return this.convertToCU(size, 0);
    }

    public static int calculateResultSize(Result[] results) {
        if (results == null) {
            return 0;
        }
        int size = 0;
        for (Result result : results) {
            size += AliHBaseAPIProxyThriftImpl.calculateResultSize(result);
        }
        return size;
    }

    public static int calculatePutsSize(List<Put> puts) {
        if (puts == null) {
            return 0;
        }
        int size = 0;
        for (Put put2 : puts) {
            size += AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)put2);
        }
        return size;
    }

    public static int calculateDeletesSize(List<Delete> deletes) {
        if (deletes == null) {
            return 0;
        }
        int size = 0;
        for (Delete delete : deletes) {
            size += AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)delete);
        }
        return size;
    }

    public static int calculateMutationsSize(List<Mutation> mutations) {
        if (mutations == null) {
            return 0;
        }
        int size = 0;
        for (Mutation mutation : mutations) {
            size += AliHBaseAPIProxyThriftImpl.calculateMutationSize(mutation);
        }
        return size;
    }

    public static int calculateMutationSize(Mutation mutation) {
        if (mutation == null) {
            return 0;
        }
        if (mutation.getFamilyCellMap() == null) {
            return 0;
        }
        int size = 0;
        for (List cells : mutation.getFamilyCellMap().values()) {
            if (cells == null) continue;
            for (Cell cell : cells) {
                if (cell == null) continue;
                size += CellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
        }
        return size;
    }

    @Override
    public Result get(Get get2) throws IOException {
        final TGet tGet = ThriftUtilities.getFromHBase(get2);
        this.factory.acquirePermitInCU(1);
        RetryingCaller<TResult> retryingCaller = new RetryingCaller<TResult>();
        TResult tResult = retryingCaller.withRetries(new Callable<TResult>(){

            @Override
            public TResult call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.get(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tGet);
            }
        });
        Result result = ThriftUtilities.resultFromThrift(tResult);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateResultSize(result), 1));
        return result;
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        final List<TGet> tGets = ThriftUtilities.getsFromHBase(gets);
        this.factory.acquirePermitInCU(1);
        RetryingCaller<List<TResult>> retryingCaller = new RetryingCaller<List<TResult>>();
        List<TResult> results = retryingCaller.withRetries(new Callable<List<TResult>>(){

            @Override
            public List<TResult> call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.getMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tGets);
            }
        });
        Result[] resultArray = ThriftUtilities.resultsFromThrift(results);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateResultSize(resultArray), 1));
        return resultArray;
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    @Override
    public void put(Put put2) throws IOException {
        final TPut tPut = ThriftUtilities.putFromHBase(put2);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)put2)));
        RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
        retryingCaller.withRetries(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AliHBaseAPIProxyThriftImpl.this.client.put(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tPut);
                return null;
            }
        });
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        final List<TPut> tPuts = ThriftUtilities.putsFromHBase(puts);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculatePutsSize(puts)));
        RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
        retryingCaller.withRetries(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AliHBaseAPIProxyThriftImpl.this.client.putMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tPuts);
                return null;
            }
        });
    }

    @Override
    public void delete(Delete delete) throws IOException {
        final TDelete tDelete = ThriftUtilities.deleteFromHBase(delete);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)delete)));
        RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
        retryingCaller.withRetries(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AliHBaseAPIProxyThriftImpl.this.client.deleteSingle(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tDelete);
                return null;
            }
        });
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        final List<TDelete> tDeletes = ThriftUtilities.deletesFromHBase(deletes);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateDeletesSize(deletes)));
        RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
        retryingCaller.withRetries(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AliHBaseAPIProxyThriftImpl.this.client.deleteMultiple(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tDeletes);
                return null;
            }
        });
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Put put2) throws IOException {
        RowMutations mutations = new RowMutations(put2.getRow());
        mutations.add(put2);
        return this.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value, Delete delete) throws IOException {
        RowMutations mutations = new RowMutations(delete.getRow());
        mutations.add(delete);
        return this.checkAndMutate(row, family, qualifier, compareOp, value, mutations);
    }

    @Override
    public boolean checkAndMutate(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp op, byte[] value, final RowMutations rowMutations) throws IOException {
        final ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
        RetryingCaller<Boolean> retryingCaller = new RetryingCaller<Boolean>();
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationsSize(rowMutations.getMutations())));
        return retryingCaller.withRetries(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.checkAndMutate(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), ThriftUtilities.compareOpFromHBase(op), valueBuffer, ThriftUtilities.rowMutationsFromHBase(rowMutations));
            }
        });
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        final TRowMutations tRowMutations = ThriftUtilities.rowMutationsFromHBase(rm);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationsSize(rm.getMutations())));
        RetryingCaller<Void> retryingCaller = new RetryingCaller<Void>();
        retryingCaller.withRetries(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AliHBaseAPIProxyThriftImpl.this.client.mutateRow(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tRowMutations);
                return null;
            }
        });
    }

    @Override
    public Result append(Append append2) throws IOException {
        final TAppend tAppend = ThriftUtilities.appendFromHBase(append2);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)append2)));
        RetryingCaller<TResult> retryingCaller = new RetryingCaller<TResult>();
        TResult tResult = retryingCaller.withRetries(new Callable<TResult>(){

            @Override
            public TResult call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.append(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tAppend);
            }
        });
        return ThriftUtilities.resultFromThrift(tResult);
    }

    @Override
    public Result increment(Increment increment2) throws IOException {
        final TIncrement tIncrement = ThriftUtilities.incrementFromHBase(increment2);
        this.factory.acquirePermitInCU(this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateMutationSize((Mutation)increment2)));
        RetryingCaller<TResult> retryingCaller = new RetryingCaller<TResult>();
        TResult tResult = retryingCaller.withRetries(new Callable<TResult>(){

            @Override
            public TResult call() throws Exception {
                return AliHBaseAPIProxyThriftImpl.this.client.increment(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, tIncrement);
            }
        });
        return ThriftUtilities.resultFromThrift(tResult);
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        throw new UnsupportedOperationException("addExternalIndex not supported");
    }

    @Override
    public void alterExternalIndex(ExternalIndexConfig config) throws IOException {
        throw new UnsupportedOperationException("alterExternalIndex not supported");
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        throw new UnsupportedOperationException("removeExternalIndex not supported");
    }

    @Override
    public void buildExternalIndex() throws IOException {
        throw new UnsupportedOperationException("buildExternalIndex not supported");
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        throw new UnsupportedOperationException("cancelBuildExternalIndex not supported");
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        throw new UnsupportedOperationException("describeIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor index, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        throw new UnsupportedOperationException("deleteIndex not supported");
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        throw new UnsupportedOperationException("offlineIndex not supported");
    }

    @Override
    public void registerBDSCluster(String hbaseSourceName, String bdsClusterkey, String hbaseConnectionString, String username, String password) {
        throw new UnsupportedOperationException("registerBDSCluster not supported");
    }

    @Override
    public void registerSolrCluster(String solrSourceName, String solrConnectionStr) throws IOException {
        throw new UnsupportedOperationException("registerSolrCluster not supported");
    }

    @Override
    public void registerESCluster(String esSourceName, String esConnectionStr, String userName, String password) throws IOException {
        throw new UnsupportedOperationException("registerESCluster not supported");
    }

    @Override
    public void unregisterSolrCluster(boolean force) throws IOException {
        throw new UnsupportedOperationException("unregisterSolrCluster not supported");
    }

    @Override
    public void unregisterESCluster(boolean force) throws IOException {
        throw new UnsupportedOperationException("unregisterESCluster not supported");
    }

    @Override
    public void unregisterBDSCluster(boolean force) throws IOException {
        throw new UnsupportedOperationException("unregisterBDSCluster not supported");
    }

    @Override
    public void alterExternalIndex(String json) throws IOException {
        throw new UnsupportedOperationException("alterExternalIndex not supported");
    }

    @Override
    public String describeExternalIndex() throws IOException {
        throw new UnsupportedOperationException("describeExternalIndex not supported");
    }

    static /* synthetic */ int access$300(AliHBaseAPIProxyThriftImpl x0) {
        return x0.numRetries;
    }

    static {
        byte[][] startkeys = new byte[1][];
        byte[][] endkeys = new byte[1][];
        startkeys[0] = HConstants.EMPTY_START_ROW;
        endkeys[0] = HConstants.EMPTY_START_ROW;
        fakeKeys = new Pair((Object)startkeys, (Object)endkeys);
    }

    public class Scanner
    implements ResultScanner {
        protected TScan scan;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();
        protected byte[] nextStartRow = null;
        int rpcNum = 0;
        private int returned = 0;

        public int getRpcNum() {
            return this.rpcNum;
        }

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(AliHBaseAPIProxyThriftImpl.this.defaultScannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            scan.setAttribute("EMPTY", Bytes.toBytes((boolean)true));
            this.scan = ThriftUtilities.scanFromHBase(scan);
            this.scan = ThriftUtilities.scanFromHBase(scan);
        }

        public Result[] next(int nbRows) throws IOException {
            Result next;
            ArrayList<Result> resultSets = new ArrayList<Result>(nbRows);
            for (int i = 0; i < nbRows && (next = this.next()) != null; ++i) {
                resultSets.add(next);
            }
            return resultSets.toArray(new Result[resultSets.size()]);
        }

        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                Result next = null;

                @Override
                public boolean hasNext() {
                    if (this.next == null) {
                        try {
                            this.next = Scanner.this.next();
                            return this.next != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    return true;
                }

                @Override
                public Result next() {
                    if (!this.hasNext()) {
                        return null;
                    }
                    Result temp = this.next;
                    this.next = null;
                    return temp;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public Result next() throws IOException {
            while (this.cache.size() == 0) {
                TResult lastTresult;
                long begin = System.currentTimeMillis();
                this.setupNextScanner();
                AliHBaseAPIProxyThriftImpl.this.factory.acquirePermitInCU(1);
                RetryingCaller<List<TResult>> retryingCaller = new RetryingCaller<List<TResult>>();
                List<TResult> tResults = retryingCaller.withRetries(new Callable<List<TResult>>(){

                    @Override
                    public List<TResult> call() throws Exception {
                        return AliHBaseAPIProxyThriftImpl.this.client.getScannerResults(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, Scanner.this.scan, Scanner.this.scan.getCaching());
                    }
                });
                ++this.rpcNum;
                TResult tResult = lastTresult = tResults.size() > 0 ? tResults.get(tResults.size() - 1) : null;
                if (lastTresult != null && lastTresult.isSetRow() && (!lastTresult.isSetColumnValues() || lastTresult.getColumnValues().isEmpty())) {
                    this.nextStartRow = lastTresult.getRow();
                    tResults.remove(tResults.size() - 1);
                    if (tResults.isEmpty()) {
                        long timeUsed = System.currentTimeMillis() - begin;
                        if (AliHBaseAPIProxyThriftImpl.this.operationTimeout <= 0 || timeUsed <= (long)AliHBaseAPIProxyThriftImpl.this.operationTimeout) continue;
                        throw new DoNotRetryIOException("Timeout when request table " + Bytes.toString((byte[])AliHBaseAPIProxyThriftImpl.this.tableNameInBytes.array()) + ", operationTimeout=" + AliHBaseAPIProxyThriftImpl.this.operationTimeout + " ms, time used=" + timeUsed + "ms, with scan=" + this.scan + ", executed rpc=" + this.rpcNum + ", returned result=" + this.returned);
                    }
                }
                Result[] results = ThriftUtilities.resultsFromThrift(tResults);
                AliHBaseAPIProxyThriftImpl.this.factory.acquirePermitInCU(AliHBaseAPIProxyThriftImpl.this.convertToCU(AliHBaseAPIProxyThriftImpl.calculateResultSize(results), 1));
                boolean firstKey = true;
                for (Result result : results) {
                    if (firstKey) {
                        firstKey = false;
                        if (this.scan.isReversed() && this.lastResult != null && Bytes.equals((byte[])this.lastResult.getRow(), (byte[])result.getRow())) continue;
                    }
                    this.cache.add(result);
                    this.lastResult = result;
                }
            }
            if (this.cache.size() > 0) {
                ++this.returned;
                return this.cache.poll();
            }
            return null;
        }

        public void close() {
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            throw new RuntimeException("getScanMetrics() not supported");
        }

        private void setupNextScanner() {
            if (this.nextStartRow != null) {
                this.scan.setStartRow(this.nextStartRow);
                this.nextStartRow = null;
                this.lastResult = null;
            } else if (this.lastResult != null) {
                byte[] lastRow = this.lastResult.getRow();
                if (this.scan.isReversed()) {
                    this.scan.setStartRow(lastRow);
                } else {
                    this.scan.setStartRow(this.createClosestRowAfter(lastRow));
                }
            }
        }

        protected byte[] createClosestRowAfter(byte[] row) {
            if (row == null) {
                throw new RuntimeException("The passed row is null");
            }
            return Arrays.copyOf(row, row.length + 1);
        }
    }

    public class RetryingCaller<T> {
        protected int getRetrySleepTime(int tries) {
            return (int)ConnectionUtils.getPauseTime((long)AliHBaseAPIProxyThriftImpl.this.pause, (int)tries);
        }

        protected int getSleepTime(int remainingTime, int tries) {
            int sleepTime = this.getRetrySleepTime(tries);
            sleepTime = Math.min(sleepTime, remainingTime / 2);
            return sleepTime;
        }

        protected boolean shouldRetry(Throwable t) {
            String msg = t.getMessage();
            return msg.contains("AllIDCFailedException") || msg.contains("OperationTimeoutException") || msg.contains("QuotaExceededException") || msg.contains("RetriesExhaustedException");
        }

        protected long getRemainingTime(int operationTimeout, long now, long startTime) {
            return Math.max(0L, (long)operationTimeout - (now - startTime));
        }

        /*
         * Exception decompiling
         */
        public T withRetries(Callable<T> callable) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP], 4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

