/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualContext;
import com.alibaba.hbase.haclient.dualservice.ExecuteCounter;
import com.alibaba.hbase.haclient.dualservice.ResultCounter;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;

public class KeyCounter
implements ExecuteCounter {
    private static final Log LOG = LogFactory.getLog(KeyCounter.class);
    private ConcurrentHashMap<String, ConcurrentSkipListMap<byte[], HRegionLocation>> keyMap;
    private ConcurrentHashMap<byte[], ResultCounter> keyCounts;
    private ConcurrentHashMap<byte[], Boolean> keySwitchStatus;
    private Configuration conf;
    private int activeFailLimit;
    private int standbySuccessLimit;

    public KeyCounter(Configuration conf) {
        this.conf = conf;
        this.keyCounts = new ConcurrentHashMap();
        this.keyMap = new ConcurrentHashMap();
        this.keySwitchStatus = new ConcurrentHashMap();
        this.activeFailLimit = this.conf.getInt("key.autoswitch.active.fail.limit", 10);
        this.standbySuccessLimit = this.conf.getInt("key.autoswitch.standby.success.limit", 1);
    }

    @Override
    public synchronized <T> void update(DualContext<T> dualContext) {
        boolean isSwitch = this.isSwitchStatus(dualContext);
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.DEFAULT && isSwitch) {
            return;
        }
        if (dualContext.getExecuteStrategy() == AutoSwitch.ExecuteStrategy.SWITCH && !isSwitch) {
            return;
        }
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.keyMap.containsKey(tableNameAsString)) {
            ConcurrentSkipListMap<byte[], HRegionLocation> regionLocations = this.keyMap.get(tableNameAsString);
            byte[] requestKey = dualContext.getKey();
            byte[] existKey = null;
            existKey = requestKey.length == 0 ? regionLocations.firstKey() : regionLocations.floorKey(requestKey);
            if (existKey == null) {
                if (dualContext.getLocation() != null) {
                    regionLocations.put(requestKey, dualContext.getLocation());
                    ResultCounter newCounter = new ResultCounter(ResultCounter.CountStrategy.SUCCESSION);
                    newCounter.increment(dualContext);
                    this.keyCounts.put(requestKey, newCounter);
                    this.keySwitchStatus.put(requestKey, false);
                }
                return;
            }
            HRegionLocation existLocation = regionLocations.get(existKey);
            byte[] locationEndKey = existLocation.getRegionInfo().getEndKey();
            if (Bytes.BYTES_COMPARATOR.compare(requestKey, locationEndKey) < 0 || dualContext.getLocation() == null) {
                this.keyCounts.get(existKey).increment(dualContext);
            } else {
                regionLocations.put(requestKey, dualContext.getLocation());
                ResultCounter newCounter = new ResultCounter(ResultCounter.CountStrategy.SUCCESSION);
                newCounter.increment(dualContext);
                this.keyCounts.put(requestKey, newCounter);
                this.keySwitchStatus.put(requestKey, false);
            }
        } else if (dualContext.getLocation() != null) {
            ConcurrentSkipListMap<byte[], HRegionLocation> regionLocations = new ConcurrentSkipListMap<byte[], HRegionLocation>(Bytes.BYTES_COMPARATOR);
            regionLocations.put(dualContext.getKey(), dualContext.getLocation());
            this.keyMap.put(tableNameAsString, regionLocations);
            ResultCounter newCounter = new ResultCounter(ResultCounter.CountStrategy.SUCCESSION);
            newCounter.increment(dualContext);
            this.keyCounts.put(dualContext.getKey(), newCounter);
            this.keySwitchStatus.put(dualContext.getKey(), false);
        }
    }

    @Override
    public synchronized <T> boolean isSwitchStatus(DualContext<T> dualContext) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.keyMap.containsKey(tableNameAsString)) {
            byte[] requestKey;
            ConcurrentSkipListMap<byte[], HRegionLocation> regionLocations = this.keyMap.get(tableNameAsString);
            byte[] existKey = regionLocations.floorKey(requestKey = dualContext.getKey());
            if (existKey == null) {
                return false;
            }
            return this.keySwitchStatus.get(existKey);
        }
        return false;
    }

    @Override
    public synchronized <T> void setSwitchStatus(DualContext<T> dualContext, boolean switchStatus) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        byte[] existKey = this.keyMap.get(tableNameAsString).floorKey(dualContext.getKey());
        this.keySwitchStatus.put(existKey, switchStatus);
        this.reset(dualContext);
    }

    @Override
    public synchronized <T> boolean reachLimit(DualContext<T> dualContext) {
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.keyMap.containsKey(tableNameAsString)) {
            boolean result;
            byte[] existKey = this.keyMap.get(tableNameAsString).floorKey(dualContext.getKey());
            if (existKey == null) {
                return false;
            }
            ResultCounter resultCounter = null;
            resultCounter = this.keyCounts.get(existKey);
            if (resultCounter == null) {
                return false;
            }
            if (!this.isSwitchStatus(dualContext)) {
                result = resultCounter.getActiveFailCount() > (long)this.activeFailLimit;
            } else {
                boolean bl = result = resultCounter.getStandbySuccessCount() > (long)this.standbySuccessLimit;
            }
            if (result) {
                LOG.debug((Object)("Reach limit active fail count=" + resultCounter.getActiveFailCount() + ", standby success count=" + resultCounter.getStandbySuccessCount()));
            }
            return result;
        }
        return false;
    }

    @Override
    public synchronized <T> void reset(DualContext<T> dualContext) {
        byte[] existKey;
        String tableNameAsString = TableName.valueOf((byte[])dualContext.getTableName()).getNameAsString();
        if (this.keyMap.containsKey(tableNameAsString) && (existKey = this.keyMap.get(tableNameAsString).floorKey(dualContext.getKey())) != null) {
            this.keyCounts.get(existKey).activeCountClear();
            this.keyCounts.get(existKey).standbyCountClear();
        }
    }
}

