/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.ConfigUpdater;
import com.alibaba.lindorm.client.core.ipc.DefaultLDServerLocator;
import com.alibaba.lindorm.client.core.ipc.DynamicConfig;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerList;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.locator.IDCSorter;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OnlySeedServerLDServerLocator
extends LDServerLocator {
    private static final Log LOG = LogFactory.getLog((String)DefaultLDServerLocator.class.getName());
    public static final String IDCNAME = "SeedServerIDC";
    public static final String IDCATTR = "IDC";
    public static final String FAKEIDCPREFIX = "fakeidc";
    private static final List<LDServerAddress> EMPTYSERVERLIST = new ArrayList<LDServerAddress>();
    private long round = 0L;
    private IDCSorter idcSorter;
    private String requestMode;
    private volatile String priorityIDC = null;
    private volatile LDServerList serverList = new LDServerList();
    private LDServerAddress serverAddress;
    private String seedServerStr;
    private List<LDServerAddress> seedServers = null;
    private LindormClientConfig config;

    public OnlySeedServerLDServerLocator(LindormClientConfig config, LConnection lConnection) throws LindormException {
        this.onConfigChange(config);
    }

    @Override
    public LDServerLocator.LocatorType getLocatorType() {
        return LDServerLocator.LocatorType.SEED_SERVER_ONLY;
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.config = config;
        this.seedServerStr = config.getSeedServer();
        this.seedServers = ConfigUpdater.parseSeedServers(this.seedServerStr, false);
        this.priorityIDC = config.get("lindorm.client.priority.idc");
        String tmpRequestMode = this.config.get("lindorm.client.requestmode", "MULTI").toUpperCase();
        if (!LindormClientConstants.AVAILABLEMODE.contains(tmpRequestMode)) {
            throw new LindormException("Request mode " + tmpRequestMode + " is not supported!");
        }
        if ("SINGLE".equals(tmpRequestMode) && this.priorityIDC == null) {
            throw new LindormException("Must specify priority idc when Request mode SINGLE!");
        }
        this.requestMode = tmpRequestMode;
        if (this.idcSorter == null) {
            this.idcSorter = DefaultLDServerLocator.createIDCSorter(config, this);
        } else {
            String sorterType = config.getString("lindorm.client.sorter.type", "PINGSORTER");
            if (!sorterType.equals(this.idcSorter.getSorterType())) {
                IDCSorter newIdcSorter = DefaultLDServerLocator.createIDCSorter(config, this);
                newIdcSorter.sortIDCs(this.serverList, this.priorityIDC);
                IDCSorter oldSorter = this.idcSorter;
                this.idcSorter = newIdcSorter;
                oldSorter.close();
            } else {
                this.idcSorter.onConfigChange(config);
                this.idcSorter.sortIDCs(this.serverList, this.priorityIDC);
            }
        }
    }

    @Override
    public void cacheLocation(LocationCache.Location location) throws IOException {
    }

    @Override
    public List<String> getAllIDC() {
        return this.serverList.getAllIDCNames();
    }

    @Override
    public String getSingleRequestIDC() {
        if (this.requestMode.equals("SINGLE")) {
            return this.priorityIDC;
        }
        return null;
    }

    @Override
    public String getPriorityIDC() {
        return this.priorityIDC;
    }

    @Override
    public List<String> getAvailableIDCs(boolean pickNearby) {
        if (this.requestMode.equals("SINGLE")) {
            ArrayList<String> idcs = new ArrayList<String>();
            idcs.add(this.priorityIDC);
            return idcs;
        }
        List<String> idcs = !pickNearby ? this.idcSorter.getAvailableIDCList() : this.idcSorter.getNearbySortedIDCList();
        if (idcs.isEmpty()) {
            idcs = this.serverList.getAllIDCNames();
        }
        if (this.requestMode.equals("RANDOM")) {
            Collections.shuffle(idcs);
        }
        return idcs;
    }

    @Override
    public List<LDServerAddress> updateServerList(DynamicConfig dynamicConfig, List<LDServerAddress> newServers, LDServerAddress fromServer) throws IOException {
        List<LDServerAddress> parsedSeedServers = ConfigUpdater.parseSeedServers(this.seedServerStr, true);
        Collections.sort(parsedSeedServers);
        for (int i = 0; i < parsedSeedServers.size(); ++i) {
            LDServerAddress address = parsedSeedServers.get(i);
            address.setIDC(FAKEIDCPREFIX + i);
        }
        if (this.isParsedSeedServerChanged(parsedSeedServers)) {
            LOG.info((Object)("Parsed server from " + this.seedServerStr + " changed from " + this.seedServers + " to " + parsedSeedServers));
        }
        this.seedServers = parsedSeedServers;
        ArrayList<LDServerAddress> expiredServers = new ArrayList<LDServerAddress>();
        this.serverList.updateFromSeedServer(parsedSeedServers, expiredServers);
        this.idcSorter.sortIDCs(this.serverList, this.priorityIDC);
        return EMPTYSERVERLIST;
    }

    private boolean isParsedSeedServerChanged(List<LDServerAddress> parsedSeedServers) {
        if (this.seedServers == null) {
            return true;
        }
        if (this.seedServers.size() != parsedSeedServers.size()) {
            return true;
        }
        for (int i = 0; i < this.seedServers.size(); ++i) {
            if (this.seedServers.get(i).compareTo(parsedSeedServers.get(i)) == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<LDServerAddress> getServersOfIDC(String idc) {
        if (idc == null) {
            return null;
        }
        return this.serverList.getLDServerByIDC(idc);
    }

    @Override
    public LDServerList getServerList() {
        return this.serverList;
    }

    @Override
    public LocationCache getLocationCacheOfIDC(String idc) {
        return null;
    }

    @Override
    public LocationCache.Location getCachedLocation(String idc, DmlOperation operation) {
        return null;
    }

    @Override
    public LDServerAddress locateServer(String idc, DmlOperation operation, boolean useCache) throws IOException {
        List<LDServerAddress> servers = this.getServersOfIDC(idc);
        if (servers == null || servers.size() == 0) {
            if (this.seedServers.size() == 1) {
                return this.seedServers.get(0);
            }
            int index = (int)Math.abs(this.round++ % (long)this.seedServers.size());
            return this.seedServers.get(index);
        }
        return servers.get(0);
    }

    @Override
    public void removeLDServer(LDServerAddress address) {
    }

    @Override
    public void markLocationError(LDServerAddress address) {
    }

    @Override
    public void cleanErrorLocation(LDServerAddress address) {
    }

    @Override
    public void cleanExpiredErrorLocations() {
    }

    @Override
    public void deleteCachedLocation(String idc, DmlOperation op) {
    }

    @Override
    public void deleteServerCache(LDServerAddress server) {
    }

    @Override
    public void banServer(LDServerAddress server) {
    }

    @Override
    public void unbanServer(LDServerAddress server) {
    }

    @Override
    public boolean isServerBanned(LDServerAddress server) {
        return false;
    }

    @Override
    public void close() {
    }
}

