/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.meta.CoveredColumnType;
import com.alibaba.lindorm.client.core.meta.SilenceIndex;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableType;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IndexMeta {
    private List<String> indexLogicalNames;
    private Map<String, TableMeta> indexMetas = new HashMap<String, TableMeta>();
    private Map<Byte, String> idNames;
    private Map<String, SilenceIndex> silenceIndexMap;
    private String parentName;
    private String indexName;
    private CoveredColumnType coveredColumnType = CoveredColumnType.NONE;
    private IndexState indexState;
    private Condition indexCondition;
    private boolean storePkNulls;
    private boolean storeFamilyInQualifier;
    private String indexLogicalName;
    private TableType indexType;
    private boolean storePkTS = true;

    protected void initFromTableDescriptor(LindormTableDescriptor tableDescriptor) {
        this.setParentName(null);
        this.setIndexLogicalNames(tableDescriptor.getIndexNames());
        this.setIdNames(tableDescriptor.getIndexIds());
        this.setSilenceIndexMap(tableDescriptor.getSilenceIndexs());
    }

    protected void initFromIndexDescriptor(LindormIndexDescriptor indexDescriptor) {
        this.setIndexName(indexDescriptor.getIndexName());
        this.setParentName(indexDescriptor.getDataTableName());
        this.setIndexState(indexDescriptor.getIndexState() == null ? IndexState.BUILDING : indexDescriptor.getIndexState());
        this.setIndexCondition(indexDescriptor.getIndexCondition());
        this.setStorePkNulls(indexDescriptor.isStorePkNulls());
        this.setStorePkTS(indexDescriptor.isStorePkTS());
        this.setStoreFamilyInQualifier(indexDescriptor.isStoreFamilyNameInQualifier());
    }

    protected void initFromTableMetaBuilder(TableMeta.TableMetaBuilder builder) {
        this.setParentName(builder.parentName);
        this.setIndexLogicalNames(builder.indexLogicalNames);
        this.setIdNames(builder.indexIdNames);
        this.setSilenceIndexMap(builder.silenceIndexMap);
    }

    protected void addIndex(TableMeta indexTableMeta) throws LindormException {
        String indexName = indexTableMeta.getIndexName();
        String indexLogicalName = indexTableMeta.getTableName();
        if (this.indexLogicalNames == null) {
            this.indexLogicalNames = CollectionUtils.newArrayList();
        }
        if (this.indexLogicalNames.contains(indexLogicalName)) {
            throw new IllegalRequestException("Cannot add repeated index:" + indexLogicalName + ", index name list:" + this.indexLogicalNames);
        }
        this.indexLogicalNames.add(indexLogicalName);
        if (this.idNames == null) {
            this.idNames = new HashMap<Byte, String>();
        }
        byte idxID = (byte)this.indexLogicalNames.size();
        this.idNames.put(idxID, indexName);
    }

    protected void removeIndexMeta(String indexName, String indexLogicalName, String tableName) throws LindormException {
        if (!this.hasIndex()) {
            return;
        }
        this.removeIndexId(indexName, tableName);
        this.removeIndexName(indexName, indexLogicalName);
    }

    private void removeIndexId(String indexName, String tableName) {
        if (null == this.idNames) {
            return;
        }
        byte indexId = -1;
        Iterator<Map.Entry<Byte, String>> idIterator = this.idNames.entrySet().iterator();
        while (idIterator.hasNext()) {
            Map.Entry<Byte, String> entry = idIterator.next();
            if (!entry.getValue().equals(indexName)) continue;
            indexId = entry.getKey();
            idIterator.remove();
            break;
        }
        this.addSilenceIndex(indexId, indexName, tableName, System.currentTimeMillis());
    }

    private void addSilenceIndex(byte indexId, String indexName, String tableName, long delTime) {
        TableMeta indexTableMeta = this.indexMetas.get(indexName);
        if (null == indexTableMeta || !indexTableMeta.isLocalIndex()) {
            return;
        }
        if (this.silenceIndexMap == null) {
            this.silenceIndexMap = new HashMap<String, SilenceIndex>();
        }
        SilenceIndex silenceIndex = new SilenceIndex(indexId, indexName, tableName, delTime);
        this.silenceIndexMap.put(indexName, silenceIndex);
    }

    private void removeIndexName(String indexName, String indexLogicalName) {
        Iterator<String> nameIterator = this.indexLogicalNames.iterator();
        while (nameIterator.hasNext()) {
            if (!nameIterator.next().equals(indexLogicalName)) continue;
            nameIterator.remove();
            break;
        }
        this.indexMetas.remove(indexName);
    }

    protected List<String> getIndexLogicalNames() {
        return this.indexLogicalNames;
    }

    protected void setIndexLogicalNames(List<String> indexLogicalNames) {
        this.indexLogicalNames = indexLogicalNames;
    }

    protected Map<String, TableMeta> getIndexMetas() {
        return this.indexMetas;
    }

    protected void setIndexMetas(Map<String, TableMeta> indexMetas) {
        this.indexMetas = indexMetas;
    }

    protected Map<Byte, String> getIdNames() {
        return this.idNames;
    }

    protected void setIdNames(Map<Byte, String> idNames) {
        this.idNames = idNames;
    }

    protected Map<String, SilenceIndex> getSilenceIndexMap() {
        return this.silenceIndexMap;
    }

    protected void setSilenceIndexMap(Map<String, SilenceIndex> silenceIndexMap) {
        this.silenceIndexMap = silenceIndexMap;
    }

    protected boolean hasIndex() {
        return this.indexLogicalNames != null && this.indexLogicalNames.size() > 0;
    }

    protected String getParentName() {
        return this.parentName;
    }

    protected void setParentName(String parentName) {
        this.parentName = parentName;
    }

    protected String getIndexName() {
        return this.indexName;
    }

    protected void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    protected CoveredColumnType getCoveredColumnType() {
        return this.coveredColumnType;
    }

    protected void setCoveredColumnType(CoveredColumnType coveredColumnType) {
        this.coveredColumnType = coveredColumnType;
    }

    protected IndexState getIndexState() {
        return this.indexState;
    }

    protected void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    protected Condition getIndexCondition() {
        return this.indexCondition;
    }

    protected void setIndexCondition(Condition indexCondition) {
        this.indexCondition = indexCondition;
    }

    protected boolean isStorePkNulls() {
        return this.storePkNulls;
    }

    protected void setStorePkNulls(boolean storePkNulls) {
        this.storePkNulls = storePkNulls;
    }

    protected boolean isStoreFamilyInQualifier() {
        return this.storeFamilyInQualifier;
    }

    protected void setStoreFamilyInQualifier(boolean storeFamilyInQualifier) {
        this.storeFamilyInQualifier = storeFamilyInQualifier;
    }

    protected String getIndexLogicalName() {
        return this.indexLogicalName;
    }

    protected void setIndexLogicalName(String indexLogicalName) {
        this.indexLogicalName = indexLogicalName;
    }

    protected TableType getIndexType() {
        return this.indexType;
    }

    protected void setIndexType(TableType indexType) {
        this.indexType = indexType;
    }

    protected boolean isStorePkTS() {
        return this.storePkTS;
    }

    protected void setStorePkTS(boolean storePkTS) {
        this.storePkTS = storePkTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSilenceIndex(String indexName, long currTime, long timeOut) {
        if (null != this.silenceIndexMap) {
            Map<String, SilenceIndex> map = this.silenceIndexMap;
            synchronized (map) {
                SilenceIndex silenceIndex = this.silenceIndexMap.get(indexName);
                if (null != silenceIndex) {
                    if (currTime - silenceIndex.getDelTime() > timeOut) {
                        this.silenceIndexMap.remove(indexName);
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected void setupAttributes(TableMeta tableMeta) throws LindormException {
        try {
            if (this.hasIndex()) {
                tableMeta.setAttribute("INDEX_NAMES", SchemaUtils.indexNamesToBytes(this.indexLogicalNames));
            } else {
                tableMeta.removeAttribute("INDEX_NAMES");
            }
            if (this.indexMetas.isEmpty()) {
                tableMeta.removeAttribute("INDEX_META");
            } else {
                tableMeta.setAttribute("INDEX_META", SchemaUtils.tableMetaMapToBytes(this.indexMetas));
            }
            if (this.coveredColumnType != CoveredColumnType.NONE) {
                tableMeta.setAttribute("INDEX_COVERED_TYPE", this.coveredColumnType.toString());
            } else {
                tableMeta.removeAttribute("INDEX_COVERED_TYPE");
            }
            if (null != this.indexState) {
                tableMeta.setAttribute("INDEX_STATE", this.indexState.toString());
            } else {
                tableMeta.removeAttribute("INDEX_STATE");
            }
            if (null != this.indexName) {
                tableMeta.setAttribute("INDEX_NAME", this.indexName);
            } else {
                tableMeta.removeAttribute("INDEX_NAME");
            }
            if (null != this.indexCondition) {
                tableMeta.setAttribute("INDEX_CREATE_CONDITION", SchemaUtils.conditionToBytes(this.indexCondition));
            } else {
                tableMeta.removeAttribute("INDEX_CREATE_CONDITION");
            }
            if (this.storePkNulls) {
                tableMeta.setAttribute("INDEX_STORE_PK_NULLS", Bytes.toBytes(this.storePkNulls));
            } else {
                tableMeta.removeAttribute("INDEX_STORE_PK_NULLS");
            }
            if (this.storeFamilyInQualifier) {
                tableMeta.setAttribute("INDEX_STORE_FAMILY_IN_QUALIFIER", Bytes.toBytes(this.storeFamilyInQualifier));
            } else {
                tableMeta.removeAttribute("INDEX_STORE_FAMILY_IN_QUALIFIER");
            }
            if (null != this.idNames) {
                tableMeta.setAttribute("INDEX_ID", SchemaUtils.indexIdToBytes(this.idNames));
            } else {
                tableMeta.removeAttribute("INDEX_ID");
            }
            if (this.silenceIndexMap != null) {
                tableMeta.setAttribute("SILENCE_INDEXES", SchemaUtils.silenceIndexToBytes(this.silenceIndexMap));
            } else {
                tableMeta.removeAttribute("SILENCE_INDEXES");
            }
            tableMeta.setAttribute("INDEX_STORE_PK_TS", Bytes.toBytes(this.storePkTS));
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    protected void initFromAttributes(TableMeta tableMeta) throws LindormException {
        try {
            byte[] storePkTSBytes;
            byte[] silenceIndexBytes;
            byte[] idBytes;
            byte[] storeFamilyInQualifierBytes;
            byte[] storePkNullsBytes;
            byte[] conditionAttrBytes;
            byte[] indexNameBytes;
            byte[] indexStateBytes;
            byte[] indexCoveredColumnTypeBytes;
            byte[] indexMetaBytes;
            byte[] indexNamesBytes = tableMeta.getAttribute("INDEX_NAMES");
            if (indexNamesBytes != null) {
                this.indexLogicalNames = SchemaUtils.indexNamesFromBytes(indexNamesBytes);
            }
            if ((indexMetaBytes = tableMeta.getAttribute("INDEX_META")) != null) {
                this.indexMetas = SchemaUtils.tableMetaMapFromBytes(indexMetaBytes);
            }
            if ((indexCoveredColumnTypeBytes = tableMeta.getAttribute("INDEX_COVERED_TYPE")) != null) {
                this.coveredColumnType = CoveredColumnType.valueOf(Bytes.toString(indexCoveredColumnTypeBytes));
            }
            if ((indexStateBytes = tableMeta.getAttribute("INDEX_STATE")) != null) {
                this.indexState = IndexState.valueOf(Bytes.toString(indexStateBytes));
            }
            if ((indexNameBytes = tableMeta.getAttribute("INDEX_NAME")) != null) {
                this.indexName = Bytes.toString(indexNameBytes);
            }
            if ((conditionAttrBytes = tableMeta.getAttribute("INDEX_CREATE_CONDITION")) != null) {
                this.indexCondition = SchemaUtils.bytesToCondition(conditionAttrBytes);
            }
            if ((storePkNullsBytes = tableMeta.getAttribute("INDEX_STORE_PK_NULLS")) != null) {
                this.storePkNulls = Bytes.toBoolean(storePkNullsBytes);
            }
            if ((storeFamilyInQualifierBytes = tableMeta.getAttribute("INDEX_STORE_FAMILY_IN_QUALIFIER")) != null) {
                this.storeFamilyInQualifier = Bytes.toBoolean(storeFamilyInQualifierBytes);
            }
            if ((idBytes = tableMeta.getAttribute("INDEX_ID")) != null) {
                this.idNames = SchemaUtils.indexIdFromBytes(idBytes);
            }
            if ((silenceIndexBytes = tableMeta.getAttribute("SILENCE_INDEXES")) != null) {
                this.silenceIndexMap = SchemaUtils.silenceIndexFromBytes(silenceIndexBytes);
            }
            if ((storePkTSBytes = tableMeta.getAttribute("INDEX_STORE_PK_TS")) != null) {
                this.storePkTS = Bytes.toBoolean(storePkTSBytes);
            }
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }
}

