/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.dml.ColumnKey;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LColumnRange
extends VersionedObjectWithAttributes {
    private ColumnKey start;
    private ColumnKey end;
    private Boolean startInclusive;
    private Boolean endInclusive;
    private LColumn startColumn;
    private LColumn endColumn;

    public LColumnRange() {
    }

    public LColumnRange(ColumnKey start, Boolean startInclusive, ColumnKey end, Boolean endInclusive) {
        this.start = start;
        this.end = end;
        this.startInclusive = startInclusive;
        this.endInclusive = endInclusive;
    }

    public ColumnKey getStart() {
        return this.start;
    }

    public ColumnKey getEnd() {
        return this.end;
    }

    public Boolean getStartInclusive() {
        return this.startInclusive;
    }

    public Boolean getEndInclusive() {
        return this.endInclusive;
    }

    public void setStartColumn(LColumn startColumn) {
        this.startColumn = startColumn;
    }

    public void setEndColumn(LColumn endColumn) {
        this.endColumn = endColumn;
    }

    public LColumn getStartColumn() {
        return this.startColumn;
    }

    public LColumn getEndColumn() {
        return this.endColumn;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.start != null);
        out.writeBoolean(this.end != null);
        if (this.start != null) {
            this.start.writeTo(out);
        }
        if (this.end != null) {
            this.end.writeTo(out);
        }
        out.writeBoolean(this.startInclusive);
        out.writeBoolean(this.endInclusive);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        boolean hasStart = in.readBoolean();
        boolean hasEnd = in.readBoolean();
        if (hasStart) {
            this.start = new ColumnKey();
            this.start.readFrom(in);
        }
        if (hasEnd) {
            this.end = new ColumnKey();
            this.end.readFrom(in);
        }
        this.startInclusive = in.readBoolean();
        this.endInclusive = in.readBoolean();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LColumnRange that = (LColumnRange)o;
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        if (this.startInclusive != null ? !this.startInclusive.equals(that.startInclusive) : that.startInclusive != null) {
            return false;
        }
        return this.endInclusive != null ? this.endInclusive.equals(that.endInclusive) : that.endInclusive == null;
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.startInclusive != null ? this.startInclusive.hashCode() : 0);
        result = 31 * result + (this.endInclusive != null ? this.endInclusive.hashCode() : 0);
        return result;
    }
}

