/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.lindorm.client.core.utils.PoolMap;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class BoundPoolMap<K, V>
extends PoolMap<K, V> {
    private AtomicInteger boundMaxSize;
    private int poolMinSize;
    private int boundThreshold;

    public BoundPoolMap(PoolMap.PoolType poolType, int poolMinSize, int poolMaxSize, int boundThreshold) {
        super(poolType, Math.max(poolMinSize, poolMaxSize));
        this.boundMaxSize = new AtomicInteger(Math.max(poolMinSize, poolMaxSize));
        this.poolMinSize = poolMinSize;
        this.boundThreshold = boundThreshold;
    }

    @Override
    public V put(K key, V value) {
        V result = super.put(key, value);
        this.resetBoundSize();
        return result;
    }

    @Override
    public V remove(Object key) {
        Object result = super.remove(key);
        this.resetBoundSize();
        return result;
    }

    @Override
    public boolean removeValue(K key, V value) {
        boolean result = super.removeValue(key, value);
        this.resetBoundSize();
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.resetBoundSize();
    }

    private void resetBoundSize() {
        int totalSize = 0;
        for (PoolMap.Pool pool : this.pools.values()) {
            totalSize += pool.size();
        }
        if (totalSize >= this.boundThreshold) {
            this.boundMaxSize.set(this.poolMinSize);
        } else {
            this.boundMaxSize.set(this.poolMaxSize);
        }
    }

    @Override
    protected PoolMap.Pool<V> createPool() {
        if (PoolMap.PoolType.BoundRoundRobin.equals((Object)this.poolType)) {
            return new BoundRoundRobinPool(this.poolMaxSize, this.boundMaxSize);
        }
        return super.createPool();
    }

    class BoundRoundRobinPool<R>
    extends CopyOnWriteArrayList<R>
    implements PoolMap.Pool<R> {
        private static final long serialVersionUID = -2314552956607096361L;
        private int limitSize;
        private AtomicInteger boundMaxSize;
        private int nextResource = 0;

        public BoundRoundRobinPool(int limitSize, AtomicInteger boundMaxSize) {
            this.limitSize = limitSize;
            this.boundMaxSize = boundMaxSize;
        }

        @Override
        public R put(R resource) {
            if (this.size() < this.limitSize) {
                this.add(resource);
            }
            return null;
        }

        @Override
        public R get() {
            int seenSize;
            while ((seenSize = this.size()) != 0 && seenSize >= this.boundMaxSize.get()) {
                try {
                    return (R)this.get(Math.abs(this.nextResource++) % seenSize);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        public Collection<R> values() {
            return this;
        }
    }
}

