/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.compile.LikePattern;
import com.alibaba.lindorm.client.core.expression.AndExpression;
import com.alibaba.lindorm.client.core.expression.ComparisonExpression;
import com.alibaba.lindorm.client.core.expression.ExistExpression;
import com.alibaba.lindorm.client.core.expression.InExpression;
import com.alibaba.lindorm.client.core.expression.LikeExpression;
import com.alibaba.lindorm.client.core.expression.NotExistExpression;
import com.alibaba.lindorm.client.core.expression.NotInExpression;
import com.alibaba.lindorm.client.core.expression.NotLikeExpression;
import com.alibaba.lindorm.client.core.expression.OrExpression;
import com.alibaba.lindorm.client.core.expression.RowComparisonExpression;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.dml.ColumnValue;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.dml.ConditionList;
import com.alibaba.lindorm.client.dml.Row;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import java.util.List;

public class ConditionFactory {
    public static ConditionList and() {
        return new AndExpression();
    }

    public static ConditionList and(Condition ... conditions) throws IllegalRequestException {
        return new AndExpression(conditions);
    }

    public static ConditionList or() {
        return new OrExpression();
    }

    public static ConditionList or(Condition ... conditions) throws IllegalRequestException {
        return new OrExpression(conditions);
    }

    public static Condition compare(byte[] columnName, CompareOp op, Object value) throws LindormException {
        return new ComparisonExpression(columnName, op, value);
    }

    public static Condition compare(String columnName, CompareOp op, Object value) throws LindormException {
        return new ComparisonExpression(Bytes.toBytes(columnName), op, value);
    }

    public static Condition compare(byte[] familyName, byte[] columnName, CompareOp op, Object value) throws LindormException {
        return new ComparisonExpression(familyName, columnName, op, value);
    }

    public static Condition compare(String familyName, String columnName, CompareOp op, Object value) throws LindormException {
        return new ComparisonExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), op, value);
    }

    public static Condition compare(ColumnValue columnValue, CompareOp op) throws LindormException {
        return new ComparisonExpression(columnValue, op);
    }

    public static Condition compare(Row row, CompareOp op) {
        return new RowComparisonExpression(row, op);
    }

    public static Condition in(String columnName, Object ... values) throws LindormException {
        return new InExpression(Bytes.toBytes(columnName), values);
    }

    public static Condition in(byte[] columnName, Object ... values) throws LindormException {
        return new InExpression(columnName, values);
    }

    public static Condition in(String familyName, String columnName, Object ... values) throws LindormException {
        return new InExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), values);
    }

    public static Condition in(byte[] familyName, byte[] columnName, Object ... values) throws LindormException {
        return new InExpression(familyName, columnName, values);
    }

    public static Condition in(String columnName, List<Object> values) throws LindormException {
        return new InExpression(Bytes.toBytes(columnName), values);
    }

    public static Condition in(byte[] columnName, List<Object> values) throws LindormException {
        return new InExpression(columnName, values);
    }

    public static Condition in(String familyName, String columnName, List<Object> values) throws LindormException {
        return new InExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), values);
    }

    public static Condition in(byte[] familyName, byte[] columnName, List<Object> values) throws LindormException {
        return new InExpression(familyName, columnName, values);
    }

    public static Condition notIn(String columnName, Object ... values) throws LindormException {
        return new NotInExpression(Bytes.toBytes(columnName), values);
    }

    public static Condition notIn(byte[] columnName, Object ... values) throws LindormException {
        return new NotInExpression(columnName, values);
    }

    public static Condition notIn(String familyName, String columnName, Object ... values) throws LindormException {
        return new NotInExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), values);
    }

    public static Condition notIn(byte[] familyName, byte[] columnName, Object ... values) throws LindormException {
        return new NotInExpression(familyName, columnName, values);
    }

    public static Condition notIn(String columnName, List<Object> values) throws LindormException {
        return new NotInExpression(Bytes.toBytes(columnName), values);
    }

    public static Condition notIn(byte[] columnName, List<Object> values) throws LindormException {
        return new NotInExpression(columnName, values);
    }

    public static Condition notIn(byte[] familyName, byte[] columnName, List<Object> values) throws LindormException {
        return new NotInExpression(familyName, columnName, values);
    }

    public static Condition notIn(String familyName, String columnName, List<Object> values) throws LindormException {
        return new NotInExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), values);
    }

    public static Condition notExist(String columnName) {
        return ConditionFactory.notExist(Bytes.toBytes(columnName));
    }

    public static Condition notExist(byte[] columnName) {
        return new NotExistExpression(columnName);
    }

    public static Condition notExist(String familyName, String columnName) {
        return ConditionFactory.notExist(Bytes.toBytes(familyName), Bytes.toBytes(columnName));
    }

    public static Condition notExist(byte[] familyName, byte[] columnName) {
        return new NotExistExpression(familyName, columnName);
    }

    public static Condition exist(String columnName) {
        return ConditionFactory.exist(Bytes.toBytes(columnName));
    }

    public static Condition exist(byte[] columnName) {
        return new ExistExpression(columnName);
    }

    public static Condition exist(String familyName, String columnName) {
        return ConditionFactory.exist(Bytes.toBytes(familyName), Bytes.toBytes(columnName));
    }

    public static Condition exist(byte[] familyName, byte[] columnName) {
        return new ExistExpression(familyName, columnName);
    }

    public static Condition like(String columnName, String pattern) throws LindormException {
        return new LikeExpression(Bytes.toBytes(columnName), pattern);
    }

    public static Condition like(byte[] columnName, String pattern) throws LindormException {
        return new LikeExpression(columnName, pattern);
    }

    public static Condition like(String columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new LikeExpression(Bytes.toBytes(columnName), pattern, escapeCharacter);
    }

    public static Condition like(byte[] columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new LikeExpression(columnName, pattern, escapeCharacter);
    }

    public static Condition like(String familyName, String columnName, String pattern) throws LindormException {
        return new LikeExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), pattern);
    }

    public static Condition like(byte[] familyName, byte[] columnName, String pattern) throws LindormException {
        return new LikeExpression(familyName, columnName, pattern);
    }

    public static Condition like(String familyName, String columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new LikeExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), pattern, escapeCharacter);
    }

    public static Condition like(byte[] familyName, byte[] columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new LikeExpression(familyName, columnName, pattern, escapeCharacter);
    }

    public static Condition notLike(String columnName, String pattern) throws LindormException {
        return new NotLikeExpression(Bytes.toBytes(columnName), pattern);
    }

    public static Condition notLike(byte[] columnName, String pattern) throws LindormException {
        return new NotLikeExpression(columnName, pattern);
    }

    public static Condition notLike(String columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new NotLikeExpression(Bytes.toBytes(columnName), pattern, escapeCharacter);
    }

    public static Condition notLike(byte[] columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new NotLikeExpression(columnName, pattern, escapeCharacter);
    }

    public static Condition notLike(String familyName, String columnName, String pattern) throws LindormException {
        return new NotLikeExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), pattern);
    }

    public static Condition notLike(byte[] familyName, byte[] columnName, String pattern) throws LindormException {
        return new NotLikeExpression(familyName, columnName, pattern);
    }

    public static Condition notLike(String familyName, String columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new NotLikeExpression(Bytes.toBytes(familyName), Bytes.toBytes(columnName), pattern, escapeCharacter);
    }

    public static Condition notLike(byte[] familyName, byte[] columnName, String pattern, Character escapeCharacter) throws LindormException {
        LikePattern.check(pattern, escapeCharacter);
        return new NotLikeExpression(familyName, columnName, pattern, escapeCharacter);
    }

    public static enum RowExistenceCondition {
        IGNORE,
        EXPECT_EXIST,
        EXPECT_NOT_EXIST;

    }

    public static enum CompareOp {
        LESS,
        LESS_OR_EQUAL,
        EQUAL,
        NOT_EQUAL,
        GREATER_OR_EQUAL,
        GREATER,
        IS,
        IS_NOT;


        public static CompareOp valueOf(int ordinal) {
            try {
                return CompareOp.values()[ordinal];
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public static boolean isNullValueOp(CompareOp op) {
            return op.equals((Object)IS) || op.equals((Object)IS_NOT);
        }
    }
}

