/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.schema;

import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.schema.IndexState;
import java.util.ArrayList;
import java.util.List;

public class LindormSearchIndexDescriptor {
    private String indexName;
    private String dataTableName;
    private List<ColumnKey> indexedColumns = new ArrayList<ColumnKey>();
    private IndexState indexState;

    public LindormSearchIndexDescriptor(String indexName, String dataTableName) {
        this.indexName = indexName;
        this.dataTableName = dataTableName;
        this.indexState = IndexState.BUILDING;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public void setIndexedColumns(List<ColumnKey> indexedColumns) {
        this.indexedColumns = indexedColumns;
    }

    public List<ColumnKey> getIndexedColumns() {
        return this.indexedColumns;
    }

    public void setIndexState(IndexState indexState) {
        this.indexState = indexState;
    }

    public IndexState getIndexState() {
        return this.indexState;
    }

    public LindormSearchIndexDescriptor addIndexedColumn(ColumnKey indexedColumn) {
        this.indexedColumns.add(indexedColumn);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Search Index [").append(this.indexName).append("] on ").append(this.dataTableName).append("\n");
        builder.append("\tIndexed columns: [");
        for (int i = 0; i < this.indexedColumns.size(); ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            ColumnKey indexedColumn = this.indexedColumns.get(i);
            builder.append(indexedColumn);
        }
        builder.append("], ");
        if (null != this.indexState) {
            builder.append(" index state (");
            builder.append((Object)this.indexState);
            builder.append(")");
        }
        return builder.toString();
    }
}

