/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;

public class AliHBaseMultiBufferedMutator
extends BufferedMutatorImpl
implements BufferedMutator {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiBufferedMutator.class);
    private volatile BufferedMutator currentBufferedMutator = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;
    private BufferedMutatorParams params;
    private AliHBaseConstants.ClusterType currentType;

    public AliHBaseMultiBufferedMutator(AliHBaseMultiClusterConnection connection, BufferedMutator bufferedMutator, BufferedMutatorParams params) {
        super((ClusterConnection)connection, null, null, params);
        this.currentBufferedMutator = bufferedMutator;
        this.connection = connection;
        this.params = params;
        this.currentType = AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get("hbase.cluster.type"));
        this.switchCount = connection.getSwitchCount();
    }

    private BufferedMutator getCurrentBufferedMutator() throws IOException {
        if (this.switchCount < this.connection.getSwitchCount()) {
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
            if (this.currentType != AliHBaseConstants.ClusterType.HBASE || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                BufferedMutator newBufferedMutator = this.connection.getBufferedMutatorByType(this.params);
                BufferedMutator lastBufferedMutator = this.currentBufferedMutator;
                this.currentBufferedMutator = newBufferedMutator;
                if (lastBufferedMutator != null) {
                    try {
                        lastBufferedMutator.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last buffered mutator close failed" + e));
                    }
                }
            }
            this.currentType = clusterType;
            this.switchCount = this.connection.getSwitchCount();
        }
        return this.currentBufferedMutator;
    }

    public TableName getName() {
        return this.params.getTableName();
    }

    public Configuration getConfiguration() {
        return this.currentBufferedMutator.getConfiguration();
    }

    public synchronized void mutate(Mutation mutation) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        try {
            this.getCurrentBufferedMutator().mutate(mutation);
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (RetriesExhaustedWithDetailsException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)(" mutate failed : " + e));
        }
    }

    public synchronized void mutate(List<? extends Mutation> list) throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        try {
            this.getCurrentBufferedMutator().mutate(list);
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (RetriesExhaustedWithDetailsException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)(" mutate list failed : " + e));
        }
    }

    public synchronized void close() throws IOException {
        this.getCurrentBufferedMutator().close();
    }

    public synchronized void flush() throws InterruptedIOException, RetriesExhaustedWithDetailsException {
        try {
            this.getCurrentBufferedMutator().flush();
        }
        catch (InterruptedIOException e) {
            throw e;
        }
        catch (RetriesExhaustedWithDetailsException e) {
            throw e;
        }
        catch (IOException e) {
            LOG.error((Object)(" flush failed : " + e));
        }
    }

    public long getWriteBufferSize() {
        return this.params.getWriteBufferSize();
    }
}

