/*
 * Copyright Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.hbase.jdbc;

import org.apache.calcite.avatica.DriverVersion;
import org.apache.calcite.avatica.remote.Driver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

public class HBaseDriver extends Driver {
  public static final Log LOG = LogFactory.getLog(HBaseDriver.class);
  public static final String CONNECT_STRING_PREFIX = "jdbc:hbase:";

  private static final String DEFAULT_SERIALIZATION = "PROTOBUF";

  static {
    LOG.info("register lindorm thin driver");
    new HBaseDriver().register();
  }

  public HBaseDriver() {
    super();
  }

  protected static Properties getProperties(String user, String password) {
    Properties properties = new Properties();
    properties.put("user", user);
    properties.put("password", password);
    return properties;
  }

  public static String getConnectionUrl(String hostname, int port) {
    return getConnectionUrl("http", hostname, port);
  }

  private static String getConnectionUrl(String protocol, String hostname, int port) {
    return getConnectionUrl(protocol, hostname, port, DEFAULT_SERIALIZATION);
  }

  private static String getConnectionUrl(String protocol, String hostname, int port, String serialization) {
    String urlFmt = CONNECT_STRING_PREFIX + "url=%s://%s:%s;serialization=%s";
    return String.format(urlFmt, protocol, hostname, port, serialization);
  }

  @Override
  protected DriverVersion createDriverVersion() {
    return DriverVersion.load(Driver.class, "com-alibaba-hbase-remote-jdbc.properties", "HBase Remote JDBC Driver", "unknown version", "Alibaba Lindorm", "unknown version");
  }

  @Override
  protected String getConnectStringPrefix() {
    return CONNECT_STRING_PREFIX;
  }

  @Override
  public Connection connect(String url, Properties info) throws SQLException {
    if (!acceptsURL(url)) {
      return null;
    }

    try {
      return super.connect(url, info);
    } catch (Exception e) {
      throw new RuntimeException(e);
    }
  }
}
