package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;

import com.alibaba.hbase.client.AliHBaseConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;

public class AliHBaseMultiBufferedMutator implements BufferedMutator{
  private static final Log LOG = LogFactory.getLog(AliHBaseMultiBufferedMutator.class);

  private volatile BufferedMutator currentBufferedMutator = null;
  //switch count decide switch or not
  private long switchCount = 0;
  private AliHBaseMultiClusterConnection connection;
  private BufferedMutatorParams params;
  private AliHBaseConstants.ClusterType currentType;

  public AliHBaseMultiBufferedMutator(AliHBaseMultiClusterConnection connection,
                                      BufferedMutator bufferedMutator, BufferedMutatorParams params){
    this.currentBufferedMutator = bufferedMutator;
    this.connection = connection;
    this.params = params;
    this.currentType =
      AliHBaseConstants.ClusterType.valueOf(connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
    this.switchCount = connection.getSwitchCount();
  }

  private BufferedMutator getCurrentBufferedMutator() throws IOException{
    if(this.switchCount < connection.getSwitchCount()){
      AliHBaseConstants.ClusterType clusterType =
        AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get(AliHBaseConstants.ALIHBASE_CLUSTER_TYPE));
      //only HBase to HBase no need update BufferedMutator
      if(!(this.currentType == AliHBaseConstants.ClusterType.HBASE && clusterType == AliHBaseConstants.ClusterType.HBASE)) {
        BufferedMutator newBufferedMutator = connection.getBufferedMutatorByType(params);
        BufferedMutator lastBufferedMutator = this.currentBufferedMutator;
        this.currentBufferedMutator = newBufferedMutator;
        if (lastBufferedMutator != null) {
          try {
            lastBufferedMutator.close();
          } catch (IOException e) {
            LOG.warn("last buffered mutator close failed" + e);
          }
        }
      }
      this.currentType = clusterType;
      this.switchCount = connection.getSwitchCount();
    }
    return this.currentBufferedMutator;
  }

  @Override
  public TableName getName(){
    return this.params.getTableName();
  };

  public Configuration getConfiguration(){
    return this.currentBufferedMutator.getConfiguration();
  };

  public void mutate(Mutation mutation) throws IOException{
    this.getCurrentBufferedMutator().mutate(mutation);
  }

  public void mutate(List<? extends Mutation> list) throws IOException{
    this.getCurrentBufferedMutator().mutate(list);
  }

  public void close() throws IOException{
    this.getCurrentBufferedMutator().close();
  }

  public void flush() throws IOException{
    this.getCurrentBufferedMutator().flush();
  }

  public long getWriteBufferSize(){
    return this.params.getWriteBufferSize();
  }

  public void setRpcTimeout(int timeout){
    try {
      this.getCurrentBufferedMutator().setRpcTimeout(timeout);
    }catch (IOException e){
      LOG.warn("set rpc timeout failed : " + e);
    }
  }

  public void setOperationTimeout(int timeout){
    try {
      this.getCurrentBufferedMutator().setOperationTimeout(timeout);
    }catch (IOException e){
      LOG.warn("set operation timeout failed : " + e);
    }
  }
}


