/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseDirectImplFactory;
import com.alibaba.hbase.client.AliHBaseUEAggregateService;
import com.alibaba.hbase.client.ElementConvertor;
import com.alibaba.hbase.exception.BatchExceptions;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.WScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.protobuf.generated.AggregateProtos;
import org.apache.hadoop.hbase.util.Bytes;

public class AliHBaseAPIProxyDirectImpl
implements AliHBaseAPIProxy {
    private AliHBaseDirectImplFactory factory;
    private TableName myTableName;
    private int defaultScannerCaching;
    private WideColumnService wideColumnService;
    private String tableNameWithoutNamespace;

    public AliHBaseAPIProxyDirectImpl(AliHBaseDirectImplFactory factory, TableName tableName) throws IOException {
        this.factory = factory;
        this.myTableName = tableName;
        this.defaultScannerCaching = factory.getConf().getInt("hbase.client.scanner.caching", 1000);
        if (this.defaultScannerCaching > 1000) {
            this.defaultScannerCaching = 1000;
        }
        if (this.myTableName != null) {
            this.wideColumnService = factory.getWideColumnService(this.myTableName.getNamespaceAsString());
            this.tableNameWithoutNamespace = this.myTableName.getQualifierAsString();
        }
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        return this.factory.getWideColumnService(tableName.getNamespaceAsString()).listTables().contains(tableName.getQualifierAsString());
    }

    @Override
    public List<TableDescriptor> listTableDescriptors() throws IOException {
        TableName[] tableNames = this.listTableNames();
        ArrayList<TableDescriptor> tableDescriptors = new ArrayList<TableDescriptor>();
        for (TableName tableName : tableNames) {
            HTableDescriptor tableDescriptor = this.getDescriptor(tableName);
            tableDescriptors.add((TableDescriptor)tableDescriptor);
        }
        return tableDescriptors;
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        List<String> tables = this.factory.getAdminService().listTableNamesByPrefix("");
        TableName[] tableNames = new TableName[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            tableNames[i] = ElementConvertor.toHBaseTableName(tables.get(i));
        }
        return tableNames;
    }

    @Override
    public HTableDescriptor getDescriptor(TableName tableName) throws IOException {
        LindormTableDescriptor lindormTableDescriptor = this.factory.getWideColumnService(tableName.getNamespaceAsString()).describeTable(tableName.getQualifierAsString());
        return ElementConvertor.toHbaseTableDescriptor(tableName.getNamespaceAsString(), lindormTableDescriptor);
    }

    @Override
    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        List<String> tables = this.factory.getWideColumnService(name).listTables();
        TableName[] tableNames = new TableName[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            tableNames[i] = TableName.valueOf((String)name, (String)tables.get(i));
        }
        return tableNames;
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        TableName[] tableNames = this.listTableNamesByNamespace(Bytes.toString((byte[])name));
        ArrayList<TableDescriptor> descriptors = new ArrayList<TableDescriptor>();
        for (TableName tableName : tableNames) {
            descriptors.add((TableDescriptor)this.getDescriptor(tableName));
        }
        return descriptors;
    }

    @Override
    public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(desc, false);
        TableName tableName = desc.getTableName();
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).createTable(lindormTableDescriptor, splitKeys);
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).deleteTable(tableName.getQualifierAsString());
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).truncateTable(tableName.getQualifierAsString());
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).onlineTable(tableName.getQualifierAsString());
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).offlineTable(tableName.getQualifierAsString());
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.factory.getWideColumnService(tableName.getNamespaceAsString()).isTableOnline(tableName.getQualifierAsString());
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.factory.getWideColumnService(tableName.getNamespaceAsString()).isTableOffline(tableName.getQualifierAsString());
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.isTableEnabled(tableName);
    }

    @Override
    public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).addFamily(tableName.getQualifierAsString(), ElementConvertor.toLindormcolumnFamilyDescriptor(columnFamily, false));
    }

    @Override
    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).deleteFamily(tableName.getQualifierAsString(), Bytes.toString((byte[])columnFamily));
    }

    @Override
    public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        List<LindormFamilyAttributes> lindormFamilyAttributes = ElementConvertor.toLindormFamilyAttributes(columnFamily, false);
        this.factory.getWideColumnService(tableName.getNamespaceAsString()).modifyFamilyAttributes(tableName.getQualifierAsString(), lindormFamilyAttributes);
    }

    @Override
    public void modifyTable(TableDescriptor td) throws IOException {
        LindormTableDescriptor lindormTableDescriptor = ElementConvertor.toLindormTableDescripter(td, false);
        this.factory.getWideColumnService(td.getTableName().getNamespaceAsString()).modifyTableAttributes(lindormTableDescriptor);
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        this.factory.getAdminService().removeNamespace(name);
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        if (this.factory.getAdminService().listNamespaces().contains(name)) {
            return NamespaceDescriptor.create((String)name).build();
        }
        throw new NamespaceNotFoundException(name + " is not found");
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        List<String> namespaces = this.factory.getAdminService().listNamespaces();
        NamespaceDescriptor[] namespaceDescriptors = new NamespaceDescriptor[namespaces.size()];
        for (int i = 0; i < namespaces.size(); ++i) {
            namespaceDescriptors[i] = NamespaceDescriptor.create((String)namespaces.get(i)).build();
        }
        return namespaceDescriptors;
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.factory.getAdminService().createNamespace(descriptor.getName());
    }

    @Override
    public void flushRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().flush(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void compactRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().compact(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void majorCompactRegion(String regionName) {
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().majorCompact(regionName, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void flushTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().flush(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void compactTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().compact(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    @Override
    public void majorCompactTable(TableName tableName) {
        String table = ElementConvertor.toLindormTableFullName(tableName);
        try {
            for (String idc : this.factory.getSystemService().getLConnection().getAllIDC()) {
                this.factory.getSystemService().majorCompact(table, idc);
            }
        }
        catch (Throwable t) {
            throw new IllegalArgumentException(t);
        }
    }

    private HRegionLocation createFakeRegionLocation(byte[] startKey, byte[] endKey) {
        HRegionInfo regionInfo = new HRegionInfo(this.myTableName, startKey, endKey);
        return new HRegionLocation((RegionInfo)regionInfo, ServerName.valueOf((String)"localhost", (int)0, (long)0L));
    }

    private org.apache.hadoop.hbase.util.Pair<byte[], byte[]> getStartEndKey(byte[] row) throws IOException {
        byte[][] endKeys = (byte[][])this.getStartEndKeys().getSecond();
        if (endKeys.length == 1) {
            return new org.apache.hadoop.hbase.util.Pair((Object)HConstants.EMPTY_START_ROW, (Object)HConstants.EMPTY_START_ROW);
        }
        byte[] preStartKey = HConstants.EMPTY_START_ROW;
        for (byte[] endKey : endKeys) {
            if (Bytes.compareTo((byte[])row, (byte[])endKey) < 0) {
                return new org.apache.hadoop.hbase.util.Pair((Object)preStartKey, (Object)endKey);
            }
            preStartKey = endKey;
        }
        return new org.apache.hadoop.hbase.util.Pair((Object)endKeys[endKeys.length - 2], (Object)HConstants.EMPTY_START_ROW);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        org.apache.hadoop.hbase.util.Pair<byte[], byte[]> startEndKey = this.getStartEndKey(row);
        return this.createFakeRegionLocation((byte[])startEndKey.getFirst(), (byte[])startEndKey.getSecond());
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        ArrayList<HRegionLocation> fakeRegionLocations = new ArrayList<HRegionLocation>();
        byte[] preStartKey = HConstants.EMPTY_START_ROW;
        byte[][] endKeys = (byte[][])this.getStartEndKeys().getSecond();
        for (int i = 0; i < endKeys.length; ++i) {
            byte[] endKey = endKeys[i];
            fakeRegionLocations.add(this.createFakeRegionLocation(preStartKey, endKey));
            preStartKey = endKey;
        }
        return fakeRegionLocations;
    }

    @Override
    public org.apache.hadoop.hbase.util.Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        Pair<byte[][], byte[][]> pair = this.wideColumnService.getStartEndKeys(this.tableNameWithoutNamespace);
        return new org.apache.hadoop.hbase.util.Pair((Object)pair.getFirst(), (Object)pair.getSecond());
    }

    @Override
    public boolean exists(Get get2) throws IOException {
        WGet wGet = ElementConvertor.toLindormGet(get2);
        return this.wideColumnService.exists(this.tableNameWithoutNamespace, wGet);
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        Result[] results = this.get(gets);
        boolean[] existResult = new boolean[results.length];
        for (int i = 0; i < results.length; ++i) {
            existResult[i] = results[i].getRow() != null;
        }
        return existResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        ArrayList<Object> tactions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                tactions.add(ElementConvertor.toLindormGet((Get)row));
                continue;
            }
            if (row instanceof Put) {
                tactions.add(ElementConvertor.toLindormPut((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                tactions.add(ElementConvertor.toLindormDelete((Delete)row));
                continue;
            }
            if (row instanceof Append) {
                tactions.add(ElementConvertor.toLindormAppend((Append)row));
                continue;
            }
            if (row instanceof Increment) {
                tactions.add(ElementConvertor.toLindormIncrement((Increment)row));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type " + row.getClass().getName() + " in batch operation.");
        }
        Object[] hbaseResults = null;
        BatchExceptions batchExceptions = new BatchExceptions();
        try {
            hbaseResults = this.batch(tactions);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < hbaseResults.length; ++i) {
                if (results != null) {
                    if (hbaseResults[i] == null) {
                        results[i] = null;
                        continue;
                    }
                    if (hbaseResults[i] instanceof WResult) {
                        results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                        continue;
                    }
                    if (hbaseResults[i] instanceof Result) {
                        results[i] = hbaseResults[i];
                        continue;
                    }
                    if (hbaseResults[i] instanceof Throwable) {
                        results[i] = hbaseResults[i];
                        batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                        continue;
                    }
                    throw new IOException("Not unsupported result type " + hbaseResults[i]);
                }
                if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
                batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
            }
            if (batchExceptions.hasErrors()) {
                throw batchExceptions.makeException();
            }
            throw throwable;
        }
        for (int i = 0; i < hbaseResults.length; ++i) {
            if (results != null) {
                if (hbaseResults[i] == null) {
                    results[i] = null;
                    continue;
                }
                if (hbaseResults[i] instanceof WResult) {
                    results[i] = ElementConvertor.toHBaseResult((WResult)hbaseResults[i]);
                    continue;
                }
                if (hbaseResults[i] instanceof Result) {
                    results[i] = hbaseResults[i];
                    continue;
                }
                if (hbaseResults[i] instanceof Throwable) {
                    results[i] = hbaseResults[i];
                    batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                    continue;
                }
                throw new IOException("Not unsupported result type " + hbaseResults[i]);
            }
            if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
            batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
        }
        if (batchExceptions.hasErrors()) {
            throw batchExceptions.makeException();
        }
    }

    private Object[] batch(List<Object> actions) throws IOException {
        Object[] finalResults = new Object[actions.size()];
        ArrayList<WGet> getActions = new ArrayList<WGet>();
        ArrayList<Integer> getActionsIndex = new ArrayList<Integer>();
        ArrayList<WPut> putActions = new ArrayList<WPut>();
        ArrayList<Integer> putActionsIndex = new ArrayList<Integer>();
        ArrayList<WDelete> delActions = new ArrayList<WDelete>();
        ArrayList<Integer> delActionsIndex = new ArrayList<Integer>();
        ArrayList<WAppend> appendActions = new ArrayList<WAppend>();
        ArrayList<Integer> appendActionsIndex = new ArrayList<Integer>();
        ArrayList<WIncrement> incActions = new ArrayList<WIncrement>();
        ArrayList<Integer> incActionsIndex = new ArrayList<Integer>();
        for (int i = 0; i < actions.size(); ++i) {
            Object a = actions.get(i);
            if (a instanceof WGet) {
                getActions.add((WGet)a);
                getActionsIndex.add(i);
                continue;
            }
            if (a instanceof WPut) {
                putActions.add((WPut)a);
                putActionsIndex.add(i);
                continue;
            }
            if (a instanceof WDelete) {
                delActions.add((WDelete)a);
                delActionsIndex.add(i);
                continue;
            }
            if (a instanceof WAppend) {
                appendActions.add((WAppend)a);
                appendActionsIndex.add(i);
                continue;
            }
            if (a instanceof WIncrement) {
                incActions.add((WIncrement)a);
                incActionsIndex.add(i);
                continue;
            }
            throw new UnsupportedOperationException("Not supported action " + a.getClass().getName());
        }
        if (!getActions.isEmpty()) {
            try {
                WResult[] getResult = this.wideColumnService.batchGet(this.tableNameWithoutNamespace, getActions);
                for (int i = 0; i < getActions.size(); ++i) {
                    int index = (Integer)getActionsIndex.get(i);
                    finalResults[index] = getResult[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : getActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!putActions.isEmpty()) {
            try {
                this.wideColumnService.batchPut(this.tableNameWithoutNamespace, putActions);
                for (Integer index : putActionsIndex) {
                    finalResults[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : putActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!delActions.isEmpty()) {
            try {
                this.wideColumnService.batchDelete(this.tableNameWithoutNamespace, delActions);
                for (Integer index : delActionsIndex) {
                    finalResults[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : delActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!appendActions.isEmpty()) {
            try {
                WResult[] appendResults = this.wideColumnService.batchAppend(this.tableNameWithoutNamespace, appendActions);
                for (int i = 0; i < appendActions.size(); ++i) {
                    int index = (Integer)appendActionsIndex.get(i);
                    finalResults[index] = appendResults[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        if (!incActions.isEmpty()) {
            try {
                WResult[] incResults = this.wideColumnService.batchIncrement(this.tableNameWithoutNamespace, incActions);
                for (int i = 0; i < incActions.size(); ++i) {
                    int index = (Integer)incActionsIndex.get(i);
                    finalResults[index] = incResults[i];
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    finalResults[index.intValue()] = e;
                }
            }
        }
        return finalResults;
    }

    @Override
    public Result get(Get get2) throws IOException {
        WResult result = this.wideColumnService.get(this.tableNameWithoutNamespace, ElementConvertor.toLindormGet(get2));
        return ElementConvertor.toHBaseResult(result);
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        WResult[] results = this.wideColumnService.batchGet(this.tableNameWithoutNamespace, ElementConvertor.toLindormGets(gets));
        return ElementConvertor.toHBaseResults(results);
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    @Override
    public void put(Put put2) throws IOException {
        WPut wPut = ElementConvertor.toLindormPut(put2);
        this.wideColumnService.put(this.tableNameWithoutNamespace, wPut);
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        List<WPut> wPuts = ElementConvertor.toLindormPuts(puts);
        this.wideColumnService.batchPut(this.tableNameWithoutNamespace, wPuts);
    }

    @Override
    public void delete(Delete delete) throws IOException {
        WDelete wDelete = ElementConvertor.toLindormDelete(delete);
        this.wideColumnService.delete(this.tableNameWithoutNamespace, wDelete);
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        List<WDelete> wDeletes = ElementConvertor.toLindormDeleteList(deletes);
        this.wideColumnService.batchDelete(this.tableNameWithoutNamespace, wDeletes);
    }

    @Override
    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put2) throws IOException {
        WPut wPut = ElementConvertor.toLindormPut(put2);
        WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(op);
        return this.wideColumnService.checkAndPut(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wPut);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        WDelete wDelete = ElementConvertor.toLindormDelete(delete);
        WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(op);
        return this.wideColumnService.checkAndDelete(this.tableNameWithoutNamespace, row, family, qualifier, wOp, value, wDelete);
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        ArrayList<Put> puts = new ArrayList<Put>();
        ArrayList<Delete> deletes = new ArrayList<Delete>();
        for (Mutation mutation : rm.getMutations()) {
            if (mutation instanceof Put) {
                puts.add((Put)mutation);
                continue;
            }
            if (mutation instanceof Delete) {
                deletes.add((Delete)mutation);
                continue;
            }
            throw new IOException("mutateRow not supported, use put(List<Put> puts), get(List<Get> gets) or delete(List<Delete> deletes) respectively");
        }
        if (!deletes.isEmpty()) {
            this.delete(deletes);
        }
        if (!puts.isEmpty()) {
            this.put(puts);
        }
    }

    @Override
    public Result append(Append append2) throws IOException {
        WAppend wAppend = ElementConvertor.toLindormAppend(append2);
        WResult wResult = this.wideColumnService.append(this.tableNameWithoutNamespace, wAppend);
        return ElementConvertor.toHBaseResult(wResult);
    }

    @Override
    public Result increment(Increment increment2) throws IOException {
        WIncrement wIncrement = ElementConvertor.toLindormIncrement(increment2);
        WResult wResult = this.wideColumnService.increment(this.tableNameWithoutNamespace, wIncrement);
        return ElementConvertor.toHBaseResult(wResult);
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        if (service != AggregateProtos.AggregateService.class) {
            throw new UnsupportedOperationException("coprocessorService " + service + " not supported");
        }
        AliHBaseUEAggregateService instance = new AliHBaseUEAggregateService(this.factory.getTableServiceService(this.myTableName.getNamespaceAsString()), this.tableNameWithoutNamespace);
        Object result = callable.call(instance);
        if (callback != null) {
            callback.update(null, null, result);
        }
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        this.wideColumnService.addExternalIndex(this.tableNameWithoutNamespace, config, fields);
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        this.wideColumnService.removeExternalIndex(this.tableNameWithoutNamespace, fields);
    }

    @Override
    public void buildExternalIndex() throws IOException {
        this.wideColumnService.buildExternalIndex(this.tableNameWithoutNamespace);
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        this.wideColumnService.cancelBuildExternalIndex(this.tableNameWithoutNamespace);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        LindormTableDescriptor desc = this.factory.getWideColumnService(dataTableName.getNamespaceAsString()).describeTable(dataTableName.getQualifierAsString());
        List<LindormIndexDescriptor> indexDescriptors = desc.getIndexes();
        List<AliHBaseIndexDescriptor> ret = Collections.emptyList();
        if (indexDescriptors != null && !indexDescriptors.isEmpty()) {
            ret = new ArrayList<AliHBaseIndexDescriptor>(indexDescriptors.size());
            for (LindormIndexDescriptor lid : indexDescriptors) {
                ret.add(ElementConvertor.toAliHBaseIndexDescriptor(dataTableName.getNamespaceAsString(), lid));
            }
        }
        return ret;
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
        TableName tableName = indexDescriptor.getDataTable();
        this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid);
        this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
        TableName tableName = indexDescriptor.getDataTable();
        this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid, splitKeys);
        this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        LindormIndexDescriptor lid = ElementConvertor.toLindormIndexDescriptor(indexDescriptor);
        TableName tableName = indexDescriptor.getDataTable();
        this.factory.getTableServiceService(tableName.getNamespaceAsString()).createIndex(lid, startKey, endKey, numRegions);
        this.buildIndexSync(indexDescriptor.getIndexName(), indexDescriptor.getDataTable());
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        this.factory.getTableServiceService(dataTable.getNamespaceAsString()).deleteIndex(indexName, dataTable.getQualifierAsString());
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        this.factory.getTableServiceService(dataTable.getNamespaceAsString()).alterIndexState(indexName, dataTable.getQualifierAsString(), IndexState.DISABLED);
    }

    private void buildIndexSync(String indexName, TableName dataTable) throws IOException {
        this.factory.getTableServiceService(dataTable.getNamespaceAsString()).buildIndex(dataTable.getNamespaceAsString(), dataTable.getQualifierAsString(), indexName);
        this.blockingAndWaitIndexState(indexName, dataTable, IndexState.ACTIVE, Integer.MAX_VALUE);
    }

    private void blockingAndWaitIndexState(String indexName, TableName dataTable, IndexState indexState, int blockTimeInSecond) throws IOException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = Integer.MAX_VALUE;
        if (blockTimeInMs != Integer.MAX_VALUE) {
            blockTimeInMs = -1000L;
        }
        long deadline = startTime + blockTimeInMs;
        long remaining = deadline - System.currentTimeMillis();
        long pauseTime = 1000L;
        int loop = 0;
        IndexState currIndexState = null;
        while (remaining >= 0L) {
            currIndexState = this.factory.getTableServiceService(dataTable.getNamespaceAsString()).getIndexState(indexName, dataTable.getQualifierAsString());
            if (currIndexState == indexState) {
                return;
            }
            long sleepTime = pauseTime;
            if (++loop > 60) {
                sleepTime = pauseTime * 10L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                throw new IOException("Failed to wait index state of " + indexName + " to:" + (Object)((Object)indexState) + ", current index state is:" + (Object)((Object)currIndexState), e);
            }
        }
    }

    private class CheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareOperator op;
        private byte[] value;

        CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = row;
            this.family = family;
        }

        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            throw new UnsupportedOperationException("timeRange not supported");
        }

        public Table.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = compareOp;
            this.value = value;
            return this;
        }

        private void preCheck() {
            if (this.op == null) {
                throw new RuntimeException("condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
            }
        }

        public boolean thenPut(Put put2) throws IOException {
            this.preCheck();
            WPut wPut = ElementConvertor.toLindormPut(put2);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(this.op);
            return AliHBaseAPIProxyDirectImpl.this.wideColumnService.checkAndPut(AliHBaseAPIProxyDirectImpl.this.tableNameWithoutNamespace, this.row, this.family, this.qualifier, wOp, this.value, wPut);
        }

        public boolean thenDelete(Delete delete) throws IOException {
            this.preCheck();
            WDelete wDelete = ElementConvertor.toLindormDelete(delete);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(this.op);
            return AliHBaseAPIProxyDirectImpl.this.wideColumnService.checkAndDelete(AliHBaseAPIProxyDirectImpl.this.tableNameWithoutNamespace, this.row, this.family, this.qualifier, wOp, this.value, wDelete);
        }

        public boolean thenMutate(RowMutations rowMutations) throws IOException {
            this.preCheck();
            WRowMutations wRowMutations = ElementConvertor.toLindormWRowMutation(rowMutations);
            WCompareFilter.CompareOp wOp = ElementConvertor.toLindormCompareOp(this.op);
            return AliHBaseAPIProxyDirectImpl.this.wideColumnService.checkAndMutate(AliHBaseAPIProxyDirectImpl.this.tableNameWithoutNamespace, this.row, this.family, this.qualifier, wOp, this.value, wRowMutations);
        }
    }

    private class Scanner
    implements ResultScanner {
        private final WScanner wScanner;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();
        private int limit = -1;
        private int returned = 0;

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(AliHBaseAPIProxyDirectImpl.this.defaultScannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            WScan wScan = ElementConvertor.toLindormScan(scan);
            this.limit = scan.getLimit();
            this.wScanner = AliHBaseAPIProxyDirectImpl.this.wideColumnService.getScanner(AliHBaseAPIProxyDirectImpl.this.tableNameWithoutNamespace, wScan);
        }

        public Iterator<Result> iterator() {
            return new Iterator<Result>(){
                private Iterator<WResult> it;
                {
                    this.it = Scanner.this.wScanner.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (Scanner.this.isLimitReached()) {
                        return false;
                    }
                    return this.it.hasNext();
                }

                @Override
                public Result next() {
                    if (Scanner.this.isLimitReached()) {
                        return null;
                    }
                    WResult wResult = this.it.next();
                    if (wResult == null) {
                        return null;
                    }
                    Scanner.this.returned++;
                    return ElementConvertor.toHBaseResult(wResult);
                }
            };
        }

        private boolean isLimitReached() {
            return this.limit > 0 && this.returned >= this.limit;
        }

        public Result next() throws IOException {
            if (this.isLimitReached()) {
                return null;
            }
            WResult r = this.wScanner.next();
            if (r == null) {
                return null;
            }
            ++this.returned;
            return ElementConvertor.toHBaseResult(r);
        }

        public void close() {
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            return new ScanMetrics();
        }
    }
}

