/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.ThriftUtilities;
import com.alibaba.hbase.exception.BatchExceptions;
import com.alibaba.hbase.thrift2.generated.TAppend;
import com.alibaba.hbase.thrift2.generated.TColumnFamilyDescriptor;
import com.alibaba.hbase.thrift2.generated.TDelete;
import com.alibaba.hbase.thrift2.generated.TGet;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import com.alibaba.hbase.thrift2.generated.TIncrement;
import com.alibaba.hbase.thrift2.generated.TNamespaceDescriptor;
import com.alibaba.hbase.thrift2.generated.TPut;
import com.alibaba.hbase.thrift2.generated.TResult;
import com.alibaba.hbase.thrift2.generated.TRowMutations;
import com.alibaba.hbase.thrift2.generated.TScan;
import com.alibaba.hbase.thrift2.generated.TTableDescriptor;
import com.alibaba.hbase.thrift2.generated.TTableName;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.thrift.TException;
import org.apache.thrift.transport.TTransport;

public class AliHBaseAPIProxyThriftImpl
implements AliHBaseAPIProxy {
    private THBaseService.Client client;
    private TTransport transport;
    private ByteBuffer tableNameInBytes;
    private int defaultScannerCaching;

    public AliHBaseAPIProxyThriftImpl(Configuration conf, THBaseService.Client client, TTransport transport, TableName tableName) {
        this.client = client;
        this.transport = transport;
        if (tableName != null) {
            this.tableNameInBytes = ByteBuffer.wrap(tableName.toBytes());
        }
        this.defaultScannerCaching = conf.getInt("hbase.client.scanner.caching", 100);
        if (this.defaultScannerCaching > 100) {
            this.defaultScannerCaching = 100;
        }
    }

    @Override
    public boolean tableExists(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.tableExists(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<TableDescriptor> listTableDescriptors() throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByPattern(null, false);
            return ThriftUtilities.tableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByPattern(null, false);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HTableDescriptor getDescriptor(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            TTableDescriptor tTableDescriptor = this.client.getTableDescriptor(tTableName);
            return ThriftUtilities.hTableDescriptorFromThrift(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        try {
            List<TTableName> tTableNames = this.client.getTableNamesByNamespace(name);
            return ThriftUtilities.tableNamesArrayFromThrift(tTableNames);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        try {
            List<TTableDescriptor> tTableDescriptors = this.client.getTableDescriptorsByNamespace(Bytes.toString((byte[])name));
            return ThriftUtilities.tableDescriptorsFromThrift(tTableDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(desc);
        List<ByteBuffer> splitKeyInBuffer = ThriftUtilities.splitKeyFromHBase(splitKeys);
        try {
            this.client.createTable(tTableDescriptor, splitKeyInBuffer);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.truncateTable(tTableName, preserveSplits);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void enableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.enableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void disableTable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.disableTable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableEnabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableEnabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableDisabled(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            return this.client.isTableAvailable(tTableName);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.addColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        try {
            this.client.deleteColumnFamily(tTableName, ByteBuffer.wrap(columnFamily));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        TTableName tTableName = ThriftUtilities.tableNameFromHBase(tableName);
        TColumnFamilyDescriptor tColumnFamilyDescriptor = ThriftUtilities.columnFamilyDescriptorFromHBase(columnFamily);
        try {
            this.client.modifyColumnFamily(tTableName, tColumnFamilyDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void modifyTable(TableDescriptor td) throws IOException {
        TTableDescriptor tTableDescriptor = ThriftUtilities.tableDescriptorFromHBase(td);
        try {
            this.client.modifyTable(tTableDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteNamespace(String name) throws IOException {
        try {
            this.client.deleteNamespace(name);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        try {
            TNamespaceDescriptor tNamespaceDescriptor = this.client.getNamespaceDescriptor(name);
            return ThriftUtilities.namespaceDescriptorFromThrift(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        try {
            List<TNamespaceDescriptor> tNamespaceDescriptors = this.client.listNamespaceDescriptors();
            return ThriftUtilities.namespaceDescriptorsFromThrift(tNamespaceDescriptors);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        TNamespaceDescriptor tNamespaceDescriptor = ThriftUtilities.namespaceDescriptorFromHBase(descriptor);
        try {
            this.client.createNamespace(tNamespaceDescriptor);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void flushRegion(String regionName) {
        throw new UnsupportedOperationException("flush is not supported");
    }

    @Override
    public void compactRegion(String regionName) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    @Override
    public void majorCompactRegion(String regionName) {
        throw new UnsupportedOperationException("majorCompact is not supported");
    }

    @Override
    public void flushTable(TableName tableName) {
        throw new UnsupportedOperationException("flush is not supported");
    }

    @Override
    public void compactTable(TableName tableName) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    @Override
    public void majorCompactTable(TableName tableName) {
        throw new UnsupportedOperationException("majorCompact is not supported");
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        throw new UnsupportedOperationException("getRegionLocation is not supported");
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        throw new UnsupportedOperationException("getAllRegionLocations is not supported");
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        throw new UnsupportedOperationException("getStartEndKeys is not supported");
    }

    @Override
    public boolean exists(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            return this.client.exists(this.tableNameInBytes, tGet);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean[] exists(List<Get> gets) throws IOException {
        ArrayList<TGet> tGets = new ArrayList<TGet>();
        for (Get get2 : gets) {
            tGets.add(ThriftUtilities.getFromHBase(get2));
        }
        try {
            List<Boolean> results = this.client.existsAll(this.tableNameInBytes, tGets);
            boolean[] booleans = new boolean[results.size()];
            for (int i = 0; i < results.size(); ++i) {
                booleans[i] = results.get(i);
            }
            return booleans;
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws IOException {
        ArrayList<Object> tactions = new ArrayList<Object>(actions.size());
        for (Row row : actions) {
            if (row instanceof Get) {
                tactions.add(ThriftUtilities.getFromHBase((Get)row));
                continue;
            }
            if (row instanceof Put) {
                tactions.add(ThriftUtilities.putFromHBase((Put)row));
                continue;
            }
            if (row instanceof Delete) {
                tactions.add(ThriftUtilities.deleteFromHBase((Delete)row));
                continue;
            }
            if (row instanceof Append) {
                tactions.add(ThriftUtilities.appendFromHBase((Append)row));
                continue;
            }
            throw new UnsupportedOperationException("Unsupported type " + row.getClass().getName() + " in batch operation.");
        }
        Object[] hbaseResults = null;
        BatchExceptions batchExceptions = new BatchExceptions();
        try {
            hbaseResults = this.batch(tactions);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < hbaseResults.length; ++i) {
                if (results != null) {
                    if (hbaseResults[i] == null) {
                        results[i] = null;
                        continue;
                    }
                    if (hbaseResults[i] instanceof TResult) {
                        results[i] = ThriftUtilities.resultFromThrift((TResult)hbaseResults[i]);
                        continue;
                    }
                    if (hbaseResults[i] instanceof Result) {
                        results[i] = hbaseResults[i];
                        continue;
                    }
                    if (hbaseResults[i] instanceof Throwable) {
                        results[i] = hbaseResults[i];
                        batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                        continue;
                    }
                    throw new IOException("Not unsupported result type " + hbaseResults[i]);
                }
                if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
                batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
            }
            if (batchExceptions.hasErrors()) {
                throw batchExceptions.makeException();
            }
            throw throwable;
        }
        for (int i = 0; i < hbaseResults.length; ++i) {
            if (results != null) {
                if (hbaseResults[i] == null) {
                    results[i] = null;
                    continue;
                }
                if (hbaseResults[i] instanceof TResult) {
                    results[i] = ThriftUtilities.resultFromThrift((TResult)hbaseResults[i]);
                    continue;
                }
                if (hbaseResults[i] instanceof Result) {
                    results[i] = hbaseResults[i];
                    continue;
                }
                if (hbaseResults[i] instanceof Throwable) {
                    results[i] = hbaseResults[i];
                    batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
                    continue;
                }
                throw new IOException("Not unsupported result type " + hbaseResults[i]);
            }
            if (hbaseResults[i] == null || !(hbaseResults[i] instanceof Throwable)) continue;
            batchExceptions.add((Throwable)hbaseResults[i], actions.get(i), null);
        }
        if (batchExceptions.hasErrors()) {
            throw batchExceptions.makeException();
        }
    }

    private Object[] batch(List<Object> actions) throws IOException {
        Object[] results = new Object[actions.size()];
        ArrayList<TGet> getActions = new ArrayList<TGet>();
        ArrayList<Integer> getActionsIndex = new ArrayList<Integer>();
        ArrayList<TPut> putActions = new ArrayList<TPut>();
        ArrayList<Integer> putActionsIndex = new ArrayList<Integer>();
        ArrayList<TDelete> delActions = new ArrayList<TDelete>();
        ArrayList<Integer> delActionsIndex = new ArrayList<Integer>();
        ArrayList<TAppend> appendActions = new ArrayList<TAppend>();
        ArrayList<Integer> appendActionsIndex = new ArrayList<Integer>();
        for (int i = 0; i < actions.size(); ++i) {
            if (actions.get(i) instanceof TGet) {
                getActions.add((TGet)actions.get(i));
                getActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TPut) {
                putActions.add((TPut)actions.get(i));
                putActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TDelete) {
                delActions.add((TDelete)actions.get(i));
                delActionsIndex.add(i);
                continue;
            }
            if (actions.get(i) instanceof TAppend) {
                appendActions.add((TAppend)actions.get(i));
                appendActionsIndex.add(i);
                continue;
            }
            throw new UnsupportedOperationException("Not supported action " + actions.get(i).getClass().getName());
        }
        if (!getActions.isEmpty()) {
            try {
                List<TResult> getResult = this.client.getMultiple(this.tableNameInBytes, getActions);
                for (int i = 0; i < getActions.size(); ++i) {
                    int index = (Integer)getActionsIndex.get(i);
                    results[index] = getResult.get(i);
                }
            }
            catch (Throwable e) {
                for (Integer index : getActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!putActions.isEmpty()) {
            try {
                this.client.putMultiple(this.tableNameInBytes, putActions);
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : putActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!delActions.isEmpty()) {
            try {
                this.client.deleteMultiple(this.tableNameInBytes, delActions);
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : delActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        if (!appendActions.isEmpty()) {
            try {
                for (TAppend append2 : appendActions) {
                    this.client.append(this.tableNameInBytes, append2);
                }
                for (Integer index : appendActionsIndex) {
                    results[index.intValue()] = new Result();
                }
            }
            catch (Throwable e) {
                for (Integer index : appendActionsIndex) {
                    results[index.intValue()] = e;
                }
            }
        }
        return results;
    }

    @Override
    public Result get(Get get2) throws IOException {
        TGet tGet = ThriftUtilities.getFromHBase(get2);
        try {
            TResult tResult = this.client.get(this.tableNameInBytes, tGet);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        List<TGet> tGets = ThriftUtilities.getsFromHBase(gets);
        try {
            List<TResult> results = this.client.getMultiple(this.tableNameInBytes, tGets);
            return ThriftUtilities.resultsFromThrift(results);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        return new Scanner(scan);
    }

    @Override
    public void put(Put put2) throws IOException {
        TPut tPut = ThriftUtilities.putFromHBase(put2);
        try {
            this.client.put(this.tableNameInBytes, tPut);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        List<TPut> tPuts = ThriftUtilities.putsFromHBase(puts);
        try {
            this.client.putMultiple(this.tableNameInBytes, tPuts);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(Delete delete) throws IOException {
        TDelete tDelete = ThriftUtilities.deleteFromHBase(delete);
        try {
            this.client.deleteSingle(this.tableNameInBytes, tDelete);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        List<TDelete> tDeletes = ThriftUtilities.deletesFromHBase(deletes);
        try {
            this.client.deleteMultiple(this.tableNameInBytes, tDeletes);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    private boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, RowMutations mutation) throws IOException {
        try {
            ByteBuffer valueBuffer = value == null ? null : ByteBuffer.wrap(value);
            return this.client.checkAndMutate(this.tableNameInBytes, ByteBuffer.wrap(row), ByteBuffer.wrap(family), ByteBuffer.wrap(qualifier), ThriftUtilities.compareOpFromHBase(op), valueBuffer, ThriftUtilities.rowMutationsFromHBase(mutation));
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Table.CheckAndMutateBuilder checkAndMutate(byte[] row, byte[] family) {
        return new CheckAndMutateBuilderImpl(row, family);
    }

    @Override
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Put put2) throws IOException {
        RowMutations mutations = new RowMutations(put2.getRow(), 1);
        mutations.add(put2);
        return this.checkAndMutate(row, family, qualifier, op, value, mutations);
    }

    @Override
    public boolean checkAndDelete(byte[] row, byte[] family, byte[] qualifier, CompareOperator op, byte[] value, Delete delete) throws IOException {
        RowMutations mutations = new RowMutations(delete.getRow(), 1);
        mutations.add(delete);
        return this.checkAndMutate(row, family, qualifier, op, value, mutations);
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        TRowMutations tRowMutations = ThriftUtilities.rowMutationsFromHBase(rm);
        try {
            this.client.mutateRow(this.tableNameInBytes, tRowMutations);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Result append(Append append2) throws IOException {
        TAppend tAppend = ThriftUtilities.appendFromHBase(append2);
        try {
            TResult tResult = this.client.append(this.tableNameInBytes, tAppend);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Result increment(Increment increment2) throws IOException {
        TIncrement tIncrement = ThriftUtilities.incrementFromHBase(increment2);
        try {
            TResult tResult = this.client.increment(this.tableNameInBytes, tIncrement);
            return ThriftUtilities.resultFromThrift(tResult);
        }
        catch (TException e) {
            throw new IOException(e);
        }
    }

    @Override
    public <T extends Service, R> void coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable, Batch.Callback<R> callback) throws ServiceException, Throwable {
        throw new UnsupportedOperationException("coprocessorService not supported");
    }

    @Override
    public void addExternalIndex(ExternalIndexConfig config, List<ExternalIndexField> fields) throws IOException {
        throw new UnsupportedOperationException("addExternalIndex not supported");
    }

    @Override
    public void removeExternalIndex(List<String> fields) throws IOException {
        throw new UnsupportedOperationException("removeExternalIndex not supported");
    }

    @Override
    public void buildExternalIndex() throws IOException {
        throw new UnsupportedOperationException("buildExternalIndex not supported");
    }

    @Override
    public void cancelBuildExternalIndex() throws IOException {
        throw new UnsupportedOperationException("cancelBuildExternalIndex not supported");
    }

    @Override
    public void close() throws IOException {
        this.transport.close();
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        throw new UnsupportedOperationException("describeIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor index, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        throw new UnsupportedOperationException("createIndex not supported");
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        throw new UnsupportedOperationException("deleteIndex not supported");
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        throw new UnsupportedOperationException("offlineIndex not supported");
    }

    private class CheckAndMutateBuilderImpl
    implements Table.CheckAndMutateBuilder {
        private final byte[] row;
        private final byte[] family;
        private byte[] qualifier;
        private CompareOperator op;
        private byte[] value;

        CheckAndMutateBuilderImpl(byte[] row, byte[] family) {
            this.row = row;
            this.family = family;
        }

        public Table.CheckAndMutateBuilder qualifier(byte[] qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Table.CheckAndMutateBuilder timeRange(TimeRange timeRange) {
            throw new UnsupportedOperationException("timeRange not supported");
        }

        public Table.CheckAndMutateBuilder ifNotExists() {
            this.op = CompareOperator.EQUAL;
            this.value = null;
            return this;
        }

        public Table.CheckAndMutateBuilder ifMatches(CompareOperator compareOp, byte[] value) {
            this.op = compareOp;
            this.value = value;
            return this;
        }

        private void preCheck() {
            if (this.op == null) {
                throw new RuntimeException("condition is null. You need to specify the condition by calling ifNotExists/ifEquals/ifMatches before executing the request");
            }
        }

        public boolean thenPut(Put put2) throws IOException {
            this.preCheck();
            RowMutations rowMutations = new RowMutations(put2.getRow());
            rowMutations.add(put2);
            return AliHBaseAPIProxyThriftImpl.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, rowMutations);
        }

        public boolean thenDelete(Delete delete) throws IOException {
            this.preCheck();
            RowMutations rowMutations = new RowMutations(delete.getRow());
            rowMutations.add(delete);
            return AliHBaseAPIProxyThriftImpl.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, rowMutations);
        }

        public boolean thenMutate(RowMutations mutation) throws IOException {
            this.preCheck();
            return AliHBaseAPIProxyThriftImpl.this.checkAndMutate(this.row, this.family, this.qualifier, this.op, this.value, mutation);
        }
    }

    private class Scanner
    implements ResultScanner {
        protected TScan scan;
        protected Result lastResult = null;
        protected final Queue<Result> cache = new ArrayDeque<Result>();
        private int limit = -1;
        private int returned = 0;

        public Scanner(Scan scan) throws IOException {
            if (scan.getCaching() <= 0) {
                scan.setCaching(AliHBaseAPIProxyThriftImpl.this.defaultScannerCaching);
            } else if (scan.getCaching() == 1 && scan.isReversed()) {
                scan.setCaching(scan.getCaching() + 1);
            }
            this.limit = scan.getLimit();
            this.scan = ThriftUtilities.scanFromHBase(scan);
        }

        private boolean isLimitReached() {
            return this.limit > 0 && this.returned >= this.limit;
        }

        public Result next() throws IOException {
            if (this.isLimitReached()) {
                return null;
            }
            if (this.cache.size() == 0) {
                this.setupNextScanner();
                try {
                    List<TResult> tResults = AliHBaseAPIProxyThriftImpl.this.client.getScannerResults(AliHBaseAPIProxyThriftImpl.this.tableNameInBytes, this.scan, this.scan.getCaching());
                    Result[] results = ThriftUtilities.resultsFromThrift(tResults);
                    boolean firstKey = true;
                    for (Result result : results) {
                        if (firstKey) {
                            firstKey = false;
                            if (this.scan.isReversed() && this.lastResult != null && Bytes.equals((byte[])this.lastResult.getRow(), (byte[])result.getRow())) continue;
                        }
                        this.cache.add(result);
                        this.lastResult = result;
                    }
                }
                catch (TException e) {
                    throw new IOException(e);
                }
            }
            if (this.cache.size() > 0) {
                ++this.returned;
                return this.cache.poll();
            }
            return null;
        }

        public void close() {
        }

        public boolean renewLease() {
            throw new RuntimeException("renewLease() not supported");
        }

        public ScanMetrics getScanMetrics() {
            throw new RuntimeException("getScanMetrics() not supported");
        }

        private void setupNextScanner() {
            if (this.lastResult != null) {
                byte[] lastRow = this.lastResult.getRow();
                if (this.scan.isReversed()) {
                    this.scan.setStartRow(lastRow);
                } else {
                    this.scan.setStartRow(this.createClosestRowAfter(lastRow));
                }
            }
        }

        protected byte[] createClosestRowAfter(byte[] row) {
            if (row == null) {
                throw new RuntimeException("The passed row is null");
            }
            return Arrays.copyOf(row, row.length + 1);
        }
    }
}

