/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;

public class AliHBaseConstants {
    public static final String USERNAME = "hbase.client.username";
    public static final String PASSWORD = "hbase.client.password";
    public static final String INSTANCEID = "hbase.client.instanceid";
    public static final String ALIHBASE_CLIENT_SCANNER_CACHING = "alihbase.client.scanner.caching";
    public static final int ALIHBASE_CLIENT_SCANNER_CACHING_DEFAULT = 100;
    public static final int ALIHBASE_CLIENT_SCANNER_CACHING_MAX = 1000;
    public static final String ALIHBASE_SERVER_NAME = "hbase.client.endpoint";
    public static final int DEFAULT_THRIFT_PORT = 9190;
    public static final int DEFAULT_ALIHBASEUE_PORT = 30020;
    public static final String ALIHBASE_ACCESS_FROM_INTERNET = "hbase.access.from.internet";
    public static final boolean ALIHBASE_ACCESS_FROM_INTERNET_DEFAULT = false;
    public static final String ALIHBASE_USE_THRIFT = "hbase.client.use.thrift";
    public static final boolean ALIHBASE_USE_THRIFT_DEFAULT = false;
    public static final String SERVERLESS_IDENTIFIER = "hbase.serverless.identifier";
    public static final String DEFAULT_SERVERLESS_IDENTIFIER = "-hbase-serverless";
    public static final String HBASEUE_IDENTIFIER = "hbase.hbaseue.identifier";
    public static final String DEFAULT_HBASEUE_IDENTIFIER = "-proxy-hbaseue";
    public static final String SOCKET_TIMEOUT_CONNECT = "hbase.ipc.client.socket.timeout.connect";
    public static final int DEFAULT_SOCKET_TIMEOUT_CONNECT = 10000;
    public static final String PUBLIC_HOSTNAME_IDENTIFIER = "hbase.public.hostname.identifier";
    public static final String DEFAULT_PUBLIC_HOSTNAME_IDENTIFIER = "-proxy-hbaseue-pub";
    public static final String HBASE_MULTI_IDENTIFIER = "hbase.hbase.multi.identifier";
    public static final String DEFAULT_HBASE_MULTI_IDENTIFIER = "-proxy.bds.rds.aliyuncs.com";
    public static final String ENCODING_SETTING = "DATA_BLOCK_ENCODING";
    public static final String INDEX_ENCODING = "INDEX";
    public static final String COMPRESSION__SETTING = "COMPRESSION";
    public static final String ZSTD_COMPRESSION = "ZSTD";
    public static final String ALIHBASE_CLUSTER_TYPE = "hbase.cluster.type";
    public static final String HACLIENT_BASE_NODE = "haclient.base.node";
    public static final String HACLIENT_BASE_NODE_DEFAULT = "/haclient";
    public static final String HACLIENT_CLUSTER_ID = "haclient.cluster.id";
    public static final String HACLIENT_CLUSTER_ID_DEFAULT = "";
    public static final String STOP_FAKE_HBASE_CLIENT = "hbase.stopfake.hbaseclient";
    public static final String COLD_BOUNDARY = "CHS";
    public static final String CHS_L = "CHS_L";
    public static final int CHS_MAX_LAYER = 5;
    public static final String CHS_PROMOTE_ON_MAJOR = "CHS_PROMOTE_ON_MAJOR";
    public static final String HOT_ONLY = "HOT_ONLY";
    public static final String COLD_HOT_MERGE = "COLD_HOT_MERGE";
    public static final String HOT_FIRST = "COLD_HOT_MERGE";
    public static final String STORAGE_POLICY = "STORAGE_POLICY";
    public static final String STORAGETYPE_COLD = "COLD";
    public static final String STORAGETYPE_DEFAULT = "DEFAULT";
    public static final String DUALSERVICE_ENABLE = "hbase.dualservice.enable";
    public static final boolean DUALSERVICE_ENABLE_DEFAULT = false;
    public static final String DUALSERVICE_TABLE_ENABLE = "hbase.dualservice.table.enable";
    public static final boolean DEFAULT_DUALSERVICE_TABLE_ENABLE = false;
    public static final String DUALSERVICE_GLITCHTIMEOUT = "hbase.dualservice.glitchtimeout";
    public static final int DEFAULT_DUALSERVICE_GLITCHTIMEOUT = 30;
    public static final String DUALSERVICE_ACTIVE_EXECUTOR_THREAD = "hbase.dualservice.active.executor.thread";
    public static final int DEFAULT_DUALSERVICE_ACTIVE_EXECUTOR_THREAD = 100;
    public static final String DUALSERVICE_STANDBY_EXECUTOR_THREAD = "hbase.dualservice.standby.executor.thread";
    public static final int DEFAULT_DUALSERVICE_STANDBY_EXECUTOR_THREAD = 10;
    public static final String DUALSERVICE_ACTIVE_EXECUTOR_QUEUE = "hbase.dualservice.active.executor.queue";
    public static final int DEFAULT_DUALSERVICE_ACTIVE_EXECUTOR_QUEUE = 256;
    public static final String DUALSERVICE_STANDBY_EXECUTOR_QUEUE = "hbase.dualservice.standby.executor.queue";
    public static final int DEFAULT_DUALSERVICE_STANDBY_EXECUTOR_QUEUE = 256;
    public static final String DUALSERVICE_TRACE_ENABLE = "hbase.dualservice.trace.enable";
    public static final boolean DEFAULT_DUALSERVICE_TRACE_ENABLE = true;
    public static final String DUALSERVICE_TRACE_PERIOD = "hbase.dualservice.trace.period";
    public static final long DEFAULT_DUALSERVICE_TRACE_PERIOD = 300000L;

    public static boolean isHBaseUEConnectionString(Configuration conf, String hostStr) {
        String hbaseueIdentifier = conf.get(HBASEUE_IDENTIFIER, DEFAULT_HBASEUE_IDENTIFIER);
        String serverlessIdentifier = conf.get(SERVERLESS_IDENTIFIER, DEFAULT_SERVERLESS_IDENTIFIER);
        if (Strings.isNullOrEmpty((String)hostStr)) {
            return false;
        }
        if (hostStr.contains(hbaseueIdentifier) || hostStr.contains(serverlessIdentifier)) {
            return true;
        }
        if (hostStr.contains(":")) {
            try {
                int port;
                String[] parts = hostStr.split(":");
                if (parts.length > 0 && ((port = Integer.valueOf(parts[parts.length - 1]).intValue()) == 30020 || port == 9190)) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isHBaseMultiConnectionString(Configuration conf, String hostStr) {
        String hbaseMultiIdentifier = conf.get(HBASE_MULTI_IDENTIFIER, DEFAULT_HBASE_MULTI_IDENTIFIER);
        if (Strings.isNullOrEmpty((String)hostStr)) {
            return false;
        }
        return hostStr.contains(hbaseMultiIdentifier);
    }

    public static enum ClusterType {
        HBASE("HBASE"),
        HBASEUE("HBASEUE");

        private final String value;

        private ClusterType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

