/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseImplFactory;
import com.alibaba.hbase.client.AliHBaseUEBufferedMutator;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AliHBaseUEAdmin;
import org.apache.hadoop.hbase.client.AliHBaseUETable;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseUEConnection
implements Connection {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseUEConnection.class);
    private Configuration conf;
    private boolean isClosed = false;
    private boolean isAborted = false;
    private int operationTimeout;
    private AliHBaseImplFactory factory;

    public AliHBaseUEConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.conf.setBoolean("hbase.regionsizecalculator.enable", false);
        this.conf.setBoolean("hbase.stopfake.hbaseclient", true);
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.factory = AliHBaseImplFactory.create(conf);
    }

    public AliHBaseAPIProxy getAPIProxy(TableName tableName) throws IOException {
        return this.factory.getHBaseAPIProxyImpl(tableName);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return new AliHBaseUEBufferedMutator(this, tableName);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        if (params.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        return new AliHBaseUEBufferedMutator(this, params.getTableName());
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return new AliHBaseUETable(tableName, this);
    }

    public Admin getAdmin() throws IOException {
        return new AliHBaseUEAdmin(this);
    }

    public synchronized void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.factory.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public TableBuilder getTableBuilder(final TableName tableName, ExecutorService executorService) {
        return new TableBuilder(){

            public TableBuilder setOperationTimeout(int timeout) {
                return this;
            }

            public TableBuilder setRpcTimeout(int timeout) {
                return this;
            }

            public TableBuilder setReadRpcTimeout(int timeout) {
                return this;
            }

            public TableBuilder setWriteRpcTimeout(int timeout) {
                return this;
            }

            public Table build() {
                try {
                    return new AliHBaseUETable(tableName, AliHBaseUEConnection.this);
                }
                catch (IOException ioE) {
                    throw new RuntimeException(ioE);
                }
            }
        };
    }

    public void abort(String s, Throwable throwable) {
        this.isAborted = true;
        try {
            this.close();
        }
        catch (IOException ioE) {
            LOG.error("Error happened when aborting", (Throwable)ioE);
        }
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public AliHBaseImplFactory getFactory() {
        return this.factory;
    }
}

