/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient;

import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.StrUtil;
import com.alibaba.hbase.protobuf.generated.ClusterSwitchProto;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;

public class AdminUtil {
    public static final String NODE_PREFIX = "2x";

    public static Pair<TableDescriptor, byte[][]> toCreateInfo(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        Pair result = new Pair();
        try {
            Pair<String, List<String>> createInfoStringPair = AdminUtil.toCreateInfoStringPair(data);
            String tableDescriptorString = (String)createInfoStringPair.getFirst();
            List splitKeyList = (List)createInfoStringPair.getSecond();
            TableDescriptor tableDescriptor = AdminUtil.getTableDescriptorFromString(tableDescriptorString);
            byte[][] splitKeys = AdminUtil.getSplitKeysFromStringList(splitKeyList);
            result.setFirst((Object)tableDescriptor);
            result.setSecond((Object)splitKeys);
            return result;
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static byte[] toCreateInfoBytes(Pair<TableDescriptor, byte[][]> createInfo) {
        ClusterSwitchProto.CreateInfo.Builder builder = ClusterSwitchProto.CreateInfo.newBuilder();
        byte[] tableDescriptorBytes = TableDescriptorBuilder.toByteArray((TableDescriptor)((TableDescriptor)createInfo.getFirst()));
        builder.setTableDescriptor(Bytes.toStringBinary((byte[])tableDescriptorBytes));
        byte[][] splitKeys = (byte[][])createInfo.getSecond();
        if (splitKeys != null) {
            for (int i = 0; i < splitKeys.length; ++i) {
                builder.addSplitKeys(Bytes.toStringBinary((byte[])splitKeys[i]));
            }
        }
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    public static TableDescriptor toModifyInfo(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try {
            String tableDescriptorString = AdminUtil.toModifyInfoString(data);
            TableDescriptor tableDescriptor = AdminUtil.getTableDescriptorFromString(tableDescriptorString);
            return tableDescriptor;
        }
        catch (DeserializationException e) {
            throw new IOException(e);
        }
    }

    public static byte[] toModifyInfoBytes(TableDescriptor tableDescriptor) {
        ClusterSwitchProto.ModifyInfo.Builder builder = ClusterSwitchProto.ModifyInfo.newBuilder();
        byte[] tableDescriptorBytes = TableDescriptorBuilder.toByteArray((TableDescriptor)tableDescriptor);
        builder.setTableDescriptor(Bytes.toStringBinary((byte[])tableDescriptorBytes));
        return ProtobufUtil.prependPBMagic((byte[])builder.build().toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<TableDescriptor, byte[][]> getCreateInfoFromZk(String zkCluster, Configuration conf, String node) throws IOException, KeeperException {
        Configuration createConf = ClusterSwitchUtil.createConfWithConnectKey(zkCluster, conf);
        try (ZKWatcher zk = new ZKWatcher(createConf, "GetCreateInfo", null, false);){
            Pair<TableDescriptor, byte[][]> createInfo;
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)node) == -1) {
                Pair<TableDescriptor, byte[][]> pair = null;
                return pair;
            }
            byte[] data = ZKUtil.getDataNoWatch((ZKWatcher)zk, (String)node, null);
            Pair<TableDescriptor, byte[][]> pair = createInfo = AdminUtil.toCreateInfo(data);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableDescriptor getModifyInfoFromZk(String zkCluster, Configuration conf, String node) throws IOException, KeeperException {
        Configuration modifyConf = ClusterSwitchUtil.createConfWithConnectKey(zkCluster, conf);
        try (ZKWatcher zk = new ZKWatcher(modifyConf, "GetModifyInfo", null, false);){
            TableDescriptor modifyInfo;
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)node) == -1) {
                TableDescriptor tableDescriptor = null;
                return tableDescriptor;
            }
            byte[] data = ZKUtil.getDataNoWatch((ZKWatcher)zk, (String)node, null);
            TableDescriptor tableDescriptor = modifyInfo = AdminUtil.toModifyInfo(data);
            return tableDescriptor;
        }
    }

    public static void setCreateInfoNode(Configuration clientConf, TableDescriptor tableDescriptor, byte[][] splitKey) throws IOException, KeeperException {
        byte[] data = AdminUtil.toCreateInfoBytes((Pair<TableDescriptor, byte[][]>)new Pair((Object)tableDescriptor, (Object)splitKey));
        String parentNode = clientConf.get(ClusterSwitchUtil.ZOOKEEPER_CREATE_NODE, ClusterSwitchUtil.ZOOKEEPER_CREATE_NODE_DEFAULT);
        String node = NODE_PREFIX + StrUtil.generateRandomString(5);
        AdminUtil.setDataToZK(clientConf, parentNode, node, data);
    }

    public static void setModifyInfoNode(Configuration clientConf, TableDescriptor tableDescriptor) throws IOException, KeeperException {
        byte[] data = AdminUtil.toModifyInfoBytes(tableDescriptor);
        String parentNode = clientConf.get(ClusterSwitchUtil.ZOOKEEPER_MODIFY_NODE, ClusterSwitchUtil.ZOOKEEPER_MODIFY_NODE_DEFAULT);
        String node = NODE_PREFIX + StrUtil.generateRandomString(5);
        AdminUtil.setDataToZK(clientConf, parentNode, node, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDataToZK(Configuration clientConf, String parentNode, String node, byte[] data) throws IOException, KeeperException {
        try (ZKWatcher zk = AdminUtil.getZkWatcher(clientConf);){
            String baseNode = ClusterSwitchUtil.getBaseNode(clientConf.get("haclient.base.node", "/haclient"), clientConf.get("haclient.cluster.id"));
            String createNode = ZNodePaths.joinZNode((String)baseNode, (String)parentNode);
            ZKUtil.createNodeIfNotExistsNoWatch((ZKWatcher)zk, (String)baseNode, null, (CreateMode)CreateMode.PERSISTENT);
            ZKUtil.createNodeIfNotExistsNoWatch((ZKWatcher)zk, (String)createNode, null, (CreateMode)CreateMode.PERSISTENT);
            String dataNode = ZNodePaths.joinZNode((String)createNode, (String)node);
            if (ZKUtil.checkExists((ZKWatcher)zk, (String)dataNode) == -1) {
                ZKUtil.createNodeIfNotExistsNoWatch((ZKWatcher)zk, (String)dataNode, (byte[])data, (CreateMode)CreateMode.PERSISTENT);
            } else {
                ZKUtil.setData((ZKWatcher)zk, (String)dataNode, (byte[])data);
            }
        }
    }

    public static ZKWatcher getZkWatcher(Configuration clientConf) throws IOException {
        String endpoint = clientConf.get("hbase.client.endpoint");
        Configuration conf = new Configuration();
        if (!ClusterSwitchUtil.isValidEndpoint(endpoint)) {
            throw new IOException("Endpoint " + endpoint + " has invalid format, vaild format is hostname:port");
        }
        conf.set("hbase.zookeeper.quorum", endpoint.split(":")[0]);
        conf.set("hbase.zookeeper.property.clientPort", endpoint.split(":")[1]);
        ZKWatcher zk = new ZKWatcher(conf, "GetData", null, false);
        return zk;
    }

    public static TableDescriptor getTableDescriptorFromString(String tableDescriptorString) throws DeserializationException, IOException {
        TableDescriptor tableDescriptor = TableDescriptorBuilder.parseFrom((byte[])Bytes.toBytesBinary((String)tableDescriptorString));
        return tableDescriptor;
    }

    public static byte[][] getSplitKeysFromStringList(List<String> splitKeyList) {
        Object splitKeys = null;
        if (!splitKeyList.isEmpty()) {
            splitKeys = new byte[splitKeyList.size()][];
            for (int i = 0; i < splitKeyList.size(); ++i) {
                splitKeys[i] = Bytes.toBytesBinary((String)splitKeyList.get(i));
            }
        }
        return splitKeys;
    }

    public static Pair<String, List<String>> toCreateInfoStringPair(byte[] data) throws DeserializationException, IOException {
        ProtobufUtil.expectPBMagicPrefix((byte[])data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        ClusterSwitchProto.CreateInfo.Builder builder = ClusterSwitchProto.CreateInfo.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
        ClusterSwitchProto.CreateInfo createInfo = builder.build();
        String tableDescriptorString = createInfo.getTableDescriptor();
        List<String> splitKeyList = createInfo.getSplitKeysList();
        return new Pair((Object)tableDescriptorString, splitKeyList);
    }

    public static String toModifyInfoString(byte[] data) throws DeserializationException, IOException {
        ProtobufUtil.expectPBMagicPrefix((byte[])data);
        int prefixLen = ProtobufUtil.lengthOfPBMagic();
        ClusterSwitchProto.ModifyInfo.Builder builder = ClusterSwitchProto.ModifyInfo.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)prefixLen, (int)(data.length - prefixLen));
        ClusterSwitchProto.ModifyInfo modifyInfo = builder.build();
        String tableDescriptorString = modifyInfo.getTableDescriptor();
        return tableDescriptorString;
    }
}

