/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.fastjson.JSONObject;
import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import java.util.concurrent.atomic.AtomicLong;

public class DualHistogram {
    public static final String NUM_OPS_METRIC_NAME = "_num_ops";
    public static final String MIN_METRIC_NAME = "_min";
    public static final String MAX_METRIC_NAME = "_max";
    public static final String SUM_METRIC_NAME = "_sum";
    public static final String MEAN_METRIC_NAME = "_mean";
    public static final String MEDIAN_METRIC_NAME = "_median";
    public static final String SEVENTY_FIFTH_PERCENTILE_METRIC_NAME = "_75th_percentile";
    public static final String NINETY_FIFTH_PERCENTILE_METRIC_NAME = "_95th_percentile";
    public static final String NINETY_NINETH_PERCENTILE_METRIC_NAME = "_99th_percentile";
    public static final String NINETY_NINETH_NINETH_PERCENTILE_METRIC_NAME = "_999th_percentile";
    private static final int DEFAULT_SAMPLE_SIZE = 2046;
    private static final double DEFAULT_ALPHA = 0.015;
    protected long lastUpdate = System.currentTimeMillis();
    protected final String name;
    protected final String desc;
    protected final Sample sample;
    private final AtomicLong min;
    private final AtomicLong max;
    private final AtomicLong sum;
    private final AtomicLong count;

    public DualHistogram(String name, String description) {
        this.name = name;
        this.desc = description;
        this.sample = new ExponentiallyDecayingSample(2046, 0.015);
        this.count = new AtomicLong();
        this.min = new AtomicLong(Long.MAX_VALUE);
        this.max = new AtomicLong(Long.MIN_VALUE);
        this.sum = new AtomicLong();
    }

    public void clear() {
        this.sample.clear();
        this.count.set(0L);
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        this.sum.set(0L);
    }

    public void clearWithOutSample() {
        this.count.set(0L);
        this.max.set(Long.MIN_VALUE);
        this.min.set(Long.MAX_VALUE);
        this.sum.set(0L);
    }

    public void add(long val) {
        this.count.incrementAndGet();
        this.sample.update(val);
        this.setMax(val);
        this.setMin(val);
        this.sum.getAndAdd(val);
    }

    public void addCountAndSum(int val) {
        this.count.incrementAndGet();
        this.sum.getAndAdd(val);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    public long getCount() {
        return this.count.get();
    }

    public long getSum() {
        if (this.getCount() > 0L) {
            return this.sum.get();
        }
        return 0L;
    }

    public long getMax() {
        if (this.count.get() > 0L) {
            return this.max.get();
        }
        return 0L;
    }

    public long getMin() {
        if (this.count.get() > 0L) {
            return this.min.get();
        }
        return 0L;
    }

    public double getMean() {
        long cCount = this.count.get();
        if (cCount > 0L) {
            return (double)this.sum.get() / (double)cCount;
        }
        return 0.0;
    }

    public JSONObject snapshot() {
        JSONObject result = new JSONObject();
        Snapshot s = this.sample.getSnapshot();
        long now = System.currentTimeMillis();
        long diff = (now - this.lastUpdate) / 1000L;
        if (diff == 0L) {
            diff = 1L;
        }
        result.put(this.name + NUM_OPS_METRIC_NAME, (Object)((double)this.getCount() * 1.0 / (double)diff));
        result.put(this.name + MIN_METRIC_NAME, (Object)this.getMin());
        result.put(this.name + MAX_METRIC_NAME, (Object)this.getMax());
        result.put(this.name + SUM_METRIC_NAME, (Object)this.getCount());
        result.put(this.name + MEAN_METRIC_NAME, (Object)this.getMean());
        result.put(this.name + MEDIAN_METRIC_NAME, (Object)s.getMedian());
        result.put(this.name + SEVENTY_FIFTH_PERCENTILE_METRIC_NAME, (Object)s.get75thPercentile());
        result.put(this.name + NINETY_FIFTH_PERCENTILE_METRIC_NAME, (Object)s.get95thPercentile());
        result.put(this.name + NINETY_NINETH_PERCENTILE_METRIC_NAME, (Object)s.get99thPercentile());
        result.put(this.name + NINETY_NINETH_NINETH_PERCENTILE_METRIC_NAME, (Object)s.get999thPercentile());
        this.clear();
        return result;
    }

    public JSONObject snapshotWithCountAndOps() {
        JSONObject result = new JSONObject();
        long now = System.currentTimeMillis();
        long diff = (now - this.lastUpdate) / 1000L;
        if (diff == 0L) {
            diff = 1L;
        }
        result.put(this.name + NUM_OPS_METRIC_NAME, (Object)((double)this.getCount() * 1.0 / (double)diff));
        result.put(this.name + SUM_METRIC_NAME, (Object)this.getCount());
        this.clearWithOutSample();
        return result;
    }
}

