/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.haclient.dualservice;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.hbase.haclient.StrUtil;
import com.alibaba.hbase.haclient.dualservice.DualMetrics;
import com.alibaba.hbase.haclient.dualservice.DualUtil;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;

public class DualTrace {
    private static Log LOG = LogFactory.getLog(DualTrace.class);
    public static String GET = "getMetrics";
    public static String PUT = "putMetrics";
    public static String DELETE = "deleteMetrics";
    public static String BATCHGET = "batchGetMetrics";
    public static String BATCHPUT = "batchPutMetrics";
    public static String BATCHDELETE = "batchDeleteMetrics";
    public static String SCAN = "scanMetrics";
    private ZKWatcher zooKeeperWatcher = null;
    private String name;
    private ConcurrentHashMap<String, DualMetrics> metricsMap = new ConcurrentHashMap();
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);

    private DualTrace(final String endpoint, final Configuration clientConf) {
        this.name = "dt-" + StrUtil.generateRandomString(7);
        this.metricsMap.put(GET, new DualMetrics("get"));
        this.metricsMap.put(PUT, new DualMetrics("put"));
        this.metricsMap.put(DELETE, new DualMetrics("delete"));
        this.metricsMap.put(BATCHGET, new DualMetrics("batchGet"));
        this.metricsMap.put(BATCHPUT, new DualMetrics("batchPut"));
        this.metricsMap.put(BATCHDELETE, new DualMetrics("batchDelete"));
        this.metricsMap.put(SCAN, new DualMetrics("scan"));
        long period = clientConf.getLong("hbase.dualservice.trace.period", 300000L);
        try {
            this.zooKeeperWatcher = DualUtil.getZookeeperWatcher(endpoint);
        }
        catch (Exception e) {
            LOG.warn((Object)("get dual trace zk failed " + e));
        }
        this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                JSONObject snapshot = DualTrace.this.snapshot();
                try {
                    if (DualTrace.this.zooKeeperWatcher != null) {
                        DualUtil.setDualTraceToZK(DualTrace.this.zooKeeperWatcher, endpoint, clientConf, DualTrace.this.name, snapshot.toString());
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("set dual trace to zk failed " + e));
                }
            }
        }, period, period, TimeUnit.MILLISECONDS);
    }

    public static DualTrace getInstance() {
        return Singleton.INSTANCE.getInstance();
    }

    public static void init(String endpoint, Configuration clientConf) {
        Singleton.INSTANCE.init(endpoint, clientConf);
    }

    public DualMetrics getMetrics(String name) {
        return this.metricsMap.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JSONObject snapshot() {
        JSONObject result = new JSONObject();
        for (String metrics : this.metricsMap.keySet()) {
            DualMetrics dm = this.metricsMap.get(metrics);
            result.put(dm.getName(), (Object)dm.shapshot());
        }
        return result;
    }

    public void close() {
        this.scheduledExecutorService.shutdown();
    }

    private static enum Singleton {
        INSTANCE;

        private DualTrace singleton;

        synchronized void init(String endpoint, Configuration clientConf) {
            if (this.singleton == null) {
                this.singleton = new DualTrace(endpoint, clientConf);
            }
        }

        public DualTrace getInstance() {
            return this.singleton;
        }
    }
}

