/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.TableAttributes;
import com.alibaba.lindorm.client.core.meta.TableCategory;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableState;
import com.alibaba.lindorm.client.core.tableservice.LIndexDescriptor;
import com.alibaba.lindorm.client.core.tableservice.LModifyTableRequest;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CollectionUtils;
import com.alibaba.lindorm.client.core.utils.EagleeyeUtil;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import com.alibaba.lindorm.client.core.utils.ModifySchemaOperation;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.IndexNotFoundException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.IndexState;
import com.alibaba.lindorm.client.schema.IndexedColumnSchema;
import com.alibaba.lindorm.client.schema.LindormAttribute;
import com.alibaba.lindorm.client.schema.LindormFamilyAttributes;
import com.alibaba.lindorm.client.schema.LindormIndexDescriptor;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicDDLService
extends LindormBasicService {
    public static final Log LOG = LogFactory.getLog(BasicDDLService.class);
    private static final int millisInSeconds = 1000;

    public BasicDDLService() {
    }

    public BasicDDLService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    public void useNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() throws LindormException {
        if (this.namespace == null) {
            throw new LindormException("Namespace is not specified!");
        }
        return this.namespace;
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public void prefetchRouteCache(String table) throws LindormException {
        this.checkOpen();
        try {
            this.lconnection.prefetchRouteCache(this.getNamespace(), table);
        }
        catch (IOException ioe) {
            throw new LindormException("Failed to prefetchRouteCache for table " + table, ioe);
        }
    }

    public List<String> listTables() throws LindormException {
        try {
            LServerCallable<List<String>> listTablesByNamespaceCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesByNamespace(BasicDDLService.this.getNamespace());
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesByNamespaceCallable);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public List<String> listTables(final TableCategory category) throws LindormException {
        try {
            LServerCallable<List<String>> listTablesWithCategoryByNamespaceCallable = new LServerCallable<List<String>>(OperationContext.OperationType.NAMESPACE){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesWithCategoryByNamespace(BasicDDLService.this.getNamespace(), category);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesWithCategoryByNamespaceCallable);
        }
        catch (Exception e) {
            throw new LindormException(e);
        }
    }

    public void createTable(LindormTableDescriptor desc) throws LindormException {
        this.checkOpen();
        this.createTable(desc, (byte[][])null);
    }

    public void createTable(LindormTableDescriptor desc, int numRegions) throws LindormException {
        this.createTable(desc, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, int numRegions, int timeout) throws LindormException {
        this.checkOpen();
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        byte[][] splitKeys = null;
        if (desc.isHashTable()) {
            if ((numRegions & numRegions - 1) != 0) {
                throw new LindormException("Number of initial regions in a hash table must be a power of 2!");
            }
            splitKeys = KeyHashFunction.evenSplit(numRegions);
        } else {
            splitKeys = firstPK.isHashed() ? SchemaUtils.getSplits(DataType.VARBINARY, numRegions) : SchemaUtils.getSplits(firstPK.getDataType(), numRegions);
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws LindormException {
        this.createTable(desc, startKey, endKey, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, Object minValue, Object maxValue, int numRegions) throws LindormException {
        this.createTable(desc, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, Object minValue, Object maxValue, int numRegions, int timeout) throws LindormException {
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        if (desc.isHashTable() || firstPK.isHashed()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(firstPK.getDataType(), minValue, maxValue, numRegions);
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions, int timeout) throws LindormException {
        this.checkOpen();
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        if (desc.isHashTable() || firstPK.isHashed()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new LindormException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(startKey, endKey, numRegions);
        if (splitKeys.length != numRegions - 1) {
            throw new LindormException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, List<Object> partitions) throws LindormException {
        this.createTable(desc, partitions, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, List<Object> partitions, int timeout) throws LindormException {
        int i;
        this.checkOpen();
        PrimaryKeySchema firstPK = this.getFirstPkSchema(desc);
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with user assigned partitions!");
        }
        if (partitions == null || partitions.isEmpty()) {
            throw new LindormException("Partition list should not be null");
        }
        byte[][] splitKeys = new byte[partitions.size()][];
        for (i = 0; i < partitions.size(); ++i) {
            splitKeys[i] = LDataTypeFactory.INSTANCE.getTypeInstance(firstPK.getDataType()).toBytes(partitions.get(i));
        }
        for (i = 1; i < splitKeys.length; ++i) {
            if (Bytes.compareTo(splitKeys[i - 1], splitKeys[i]) < 0) continue;
            throw new LindormException("Assigned partitions are not in order, please check");
        }
        this.createTable(desc, splitKeys, timeout);
    }

    public void createTable(LindormTableDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.createTable(desc, splitKeys, Integer.MAX_VALUE);
    }

    public void createTable(LindormTableDescriptor desc, byte[][] splitKeys, int timeout) throws LindormException {
        this.checkOpen();
        this.createTableAsync(desc, splitKeys);
        this.blockingAndWaitForSuccess(desc.getName(), AsyncDDLType.CREATE, timeout);
    }

    public void createTableAsync(LindormTableDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateTableDescriptor(desc);
            TableMeta meta = new TableMeta(this.getNamespace(), desc);
            this.doCreateTableAsync(meta, splitKeys);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void doCreateTableAsync(final TableMeta meta, final byte[][] splitKeys) throws IOException {
        LServerCallable<Void> createTableCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

            @Override
            public Void call() throws Exception {
                this.server.createTableAsync(meta, splitKeys);
                return null;
            }
        };
        this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(createTableCallable);
    }

    public void createLocalIndex(LindormIndexDescriptor desc) throws LindormException {
        this.createLocalIndex(desc, Integer.MAX_VALUE);
    }

    public void createLocalIndex(LindormIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.createLocalIndexAsync(desc);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createLocalIndexAsync(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            LServerCallable<Void> createLocalIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createLocalIndex(index);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createLocalIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormIndexDescriptor desc) throws LindormException {
        this.createIndex(desc, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, int numRegions, int timeout) throws LindormException {
        DataType indexColumnType = this.getIndexedDataType(desc);
        this.createIndex(desc, indexColumnType, numRegions, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.createIndexAsync(desc);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, int numRegions) throws LindormException {
        this.createIndex(desc, indexColumnType, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, int numRegions, int timeout) throws LindormException {
        byte[][] splitKeys = null;
        if (desc.isHashTable()) {
            if ((numRegions & numRegions - 1) != 0) {
                throw new LindormException("Number of initial regions in a hash table must be a power of 2!");
            }
            splitKeys = KeyHashFunction.evenSplit(numRegions);
        } else {
            splitKeys = desc.getFirstIndexedColumn().isHashed() ? SchemaUtils.getSplits(DataType.VARBINARY, numRegions) : SchemaUtils.getSplits(indexColumnType, numRegions);
        }
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, Object minValue, Object maxValue, int numRegions) throws LindormException {
        DataType columnType = this.getIndexedDataType(desc);
        this.createIndex(desc, columnType, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    private DataType getIndexedDataType(LindormIndexDescriptor desc) throws LindormException {
        IndexedColumnSchema index = desc.getFirstIndexedColumn();
        LindormTableDescriptor ltd = this.describeTable(desc.getDataTableName());
        DataType indexColumnType = null;
        List<PrimaryKeySchema> pkSchemas = ltd.getPkColumns();
        for (PrimaryKeySchema pkSchema : pkSchemas) {
            if (!pkSchema.getNameAsString().equals(index.getColumnKey().getQualifierAsString())) continue;
            indexColumnType = pkSchema.getDataType();
        }
        if (indexColumnType == null) {
            List<ColumnSchema> columnSchemas = ltd.getNonPkColumns();
            for (ColumnSchema colSchema : columnSchemas) {
                if (!colSchema.getColumnNameAsString().equals(index.getColumnKey().getQualifierAsString())) continue;
                indexColumnType = colSchema.getDataType();
            }
        }
        if (indexColumnType == null) {
            throw new LindormException("Find no valid index column for data table\uff0cindex column: " + index.getColumnKey());
        }
        return indexColumnType;
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, Object minValue, Object maxValue, int numRegions) throws LindormException {
        this.createIndex(desc, indexColumnType, minValue, maxValue, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, List<Object> partitions) throws LindormException {
        DataType indexColumnType = this.getIndexedDataType(desc);
        this.createIndex(desc, indexColumnType, partitions);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, List<Object> partitions) throws LindormException {
        this.createIndex(desc, indexColumnType, partitions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumnType, List<Object> partitions, int timeout) throws LindormException {
        int i;
        if (desc.isHashTable()) {
            throw new LindormException("Hash table can not be created with user assigned partitions!");
        }
        if (partitions == null || partitions.isEmpty()) {
            throw new LindormException("Partition list should not be null");
        }
        byte[][] splitKeys = new byte[partitions.size()][];
        for (i = 0; i < partitions.size(); ++i) {
            splitKeys[i] = LDataTypeFactory.INSTANCE.getTypeInstance(indexColumnType).toBytes(partitions.get(i));
        }
        for (i = 1; i < splitKeys.length; ++i) {
            if (Bytes.compareTo(splitKeys[i - 1], splitKeys[i]) < 0) continue;
            throw new LindormException("Assigned partitions are not in order, please check");
        }
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, DataType indexColumntype, Object minValue, Object maxValue, int numRegions, int timeout) throws LindormException {
        if (desc.isHashTable() || desc.getFirstIndexedColumn().isHashed()) {
            throw new LindormException("Hash table can not be created with partial range!");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(indexColumntype, minValue, maxValue, numRegions);
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws LindormException {
        this.createIndex(desc, startKey, endKey, numRegions, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[] startKey, byte[] endKey, int numRegions, int timeout) throws LindormException {
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new LindormException("Start key must be smaller than end key");
        }
        byte[][] splitKeys = SchemaUtils.getSplits(startKey, endKey, numRegions);
        if (splitKeys.length != numRegions - 1) {
            throw new LindormException("Unable to split key range into enough regions");
        }
        this.createIndex(desc, splitKeys, timeout);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[][] splitKeys) throws LindormException {
        this.createIndex(desc, splitKeys, Integer.MAX_VALUE);
    }

    public void createIndex(LindormIndexDescriptor desc, byte[][] splitKeys, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.createIndexAsync(desc, splitKeys);
            this.blockingAndWaitForSuccess(desc.getDataTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void createIndexAsync(LindormIndexDescriptor desc, final byte[][] splitKeys) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            LServerCallable<Void> createIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createIndex(index, splitKeys);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Deprecated
    public void createIndexAsync(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        try {
            SchemaUtils.validateIndexTableDescriptor(desc);
            String namespace = this.getNamespace();
            final LIndexDescriptor index = new LIndexDescriptor(namespace, desc);
            LServerCallable<Void> createIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.createIndex(index);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(createIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteIndex(String indexName, String tableName) throws LindormException {
        this.deleteIndex(indexName, tableName, Integer.MAX_VALUE);
    }

    public void deleteIndex(String indexName, String tableName, int timeout) throws LindormException {
        this.checkOpen();
        try {
            this.deleteIndexAsync(indexName, tableName);
            this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteIndexAsync(final String indexName, final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Index name must not be null or emtpy.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> deleteTableCallable = new LServerCallable<Void>(OperationContext.OperationType.DROP){

                @Override
                public Void call() throws Exception {
                    this.server.deleteIndex(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(deleteTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void deleteTable(final String table) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must not be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> deleteTableCallable = new LServerCallable<Void>(OperationContext.OperationType.DROP){

                @Override
                public Void call() throws Exception {
                    this.server.deleteTable(namespace, Bytes.toBytes(table));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(deleteTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void onlineTable(String table) throws LindormException {
        this.onlineTable(table, Integer.MAX_VALUE);
    }

    public void onlineTable(String table, int timeout) throws LindormException {
        this.checkOpen();
        this.onlineTableAsync(table);
        this.blockingAndWaitForSuccess(table, AsyncDDLType.ONLINE, timeout);
    }

    public void onlineTableAsync(final String table) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> onlineCallable = new LServerCallable<Void>(OperationContext.OperationType.ENABLE){

                @Override
                public Void call() throws Exception {
                    this.server.enableTableAsync(namespace, Bytes.toBytes(table));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(onlineCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void offlineTable(String tableName) throws LindormException {
        this.offlineTable(tableName, Integer.MAX_VALUE);
    }

    public void offlineTable(String tableName, int timeout) throws LindormException {
        this.checkOpen();
        this.offlineTableAsync(tableName);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.OFFLINE, timeout);
    }

    public void offlineTableAsync(String tableName) throws LindormException {
        this.offlineTableAsync(tableName, false);
    }

    public void offlineTableAsync(final String tableName, boolean skipSync) throws LindormException {
        this.checkOpen();
        if (!skipSync) {
            this.disableWritingAndSync(tableName);
        }
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> offlineCallable = new LServerCallable<Void>(OperationContext.OperationType.DISABLE){

                @Override
                public Void call() throws Exception {
                    this.server.disableTableAsync(namespace, Bytes.toBytes(tableName));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(offlineCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void truncateTable(String tableName) throws LindormException {
        this.truncateTable(tableName, Integer.MAX_VALUE);
    }

    public void truncateTable(String tableName, int timeout) throws LindormException {
        this.checkOpen();
        this.truncateTableAsync(tableName);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.TRUNCATE, timeout);
    }

    public void truncateTableAsync(final String table) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> truncateTableCallable = new LServerCallable<Void>(OperationContext.OperationType.TRUNCATE){

                @Override
                public Void call() throws Exception {
                    this.server.truncateTableAsync(namespace, Bytes.toBytes(table));
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(truncateTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void addFamily(String tableName, ColumnFamilyDescriptor col) throws LindormException {
        this.addFamily(tableName, col, Integer.MAX_VALUE);
    }

    public void addFamily(String tableName, ColumnFamilyDescriptor col, int timeout) throws LindormException {
        this.checkOpen();
        this.addFamilyAsync(tableName, col);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addFamilyAsync(String tableName, ColumnFamilyDescriptor col) throws LindormException {
        if (col == null) {
            throw new IllegalRequestException("There must be at least one ColumnFamilyDescriptor to add, but has none.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot add family to index table: " + meta.getIndexName());
            }
            if (SchemaUtils.isDefaultFamily(col.getName())) {
                throw new IllegalRequestException("Cannot add system family name:f");
            }
            meta.getFamilies().add(col);
            this.internalModifyTableAsync(meta, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public void deleteFamily(String tableName, String family) throws LindormException {
        this.deleteFamily(tableName, family, Integer.MAX_VALUE);
    }

    public void deleteFamily(String tableName, String family, int timeout) throws LindormException {
        this.checkOpen();
        this.deleteFamilyAsync(tableName, family);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void deleteFamilyAsync(String tableName, String family) throws LindormException {
        if (tableName == null || family == null) {
            throw new IllegalRequestException("Table name:" + tableName + " or family:" + family + " is illegal.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot delete family to index table: " + meta.getIndexName());
            }
            if (meta.getFamilyDescriptorByName(Bytes.toBytes(family)) == null) {
                throw new IllegalRequestException("Family name is not existent:" + family);
            }
            Iterator<ColumnFamilyDescriptor> iterator = meta.getFamilies().iterator();
            while (iterator.hasNext()) {
                ColumnFamilyDescriptor cf = iterator.next();
                if (!cf.getNameAsString().equals(family)) continue;
                iterator.remove();
            }
            this.internalModifyTableAsync(meta, ModifySchemaOperation.DELETE_FAMILY);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public void addColumn(String tableName, ColumnSchema col) throws LindormException {
        this.addColumn(tableName, col, Integer.MAX_VALUE);
    }

    public void addColumn(String tableName, List<ColumnSchema> columns) throws LindormException {
        this.addColumn(tableName, columns, Integer.MAX_VALUE);
    }

    public void addColumn(String tableName, ColumnSchema col, int timeout) throws LindormException {
        this.checkOpen();
        this.addColumnAsync(tableName, col);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addColumn(String tableName, List<ColumnSchema> columns, int timeout) throws LindormException {
        this.checkOpen();
        this.addColumnAsync(tableName, columns);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void addColumnAsync(String tableName, ColumnSchema col) throws LindormException {
        if (col == null) {
            throw new IllegalRequestException("New column schema must not be null.");
        }
        ArrayList<ColumnSchema> newSchema = CollectionUtils.newArrayList(col);
        this.addColumnAsync(tableName, newSchema);
    }

    public void addColumnAsync(String tableName, List<ColumnSchema> columns) throws LindormException {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalRequestException("There must be at least one ColumnSchema to add, but has none.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot add column to index table: " + meta.getIndexName());
            }
            LindormTableDescriptor desc = TableMeta.buildLindormTableDescriptor(meta);
            boolean noDefaultFamily = !SchemaUtils.hasDefaultFamily(desc.getNonPkColumns());
            for (ColumnSchema col : columns) {
                if (col == null) {
                    throw new IllegalRequestException("New column schema must not be null.");
                }
                byte[] familyName = col.getFamilyName();
                if (noDefaultFamily && (familyName == null || SchemaUtils.isDefaultFamily(familyName))) {
                    throw new IllegalDataException("Cannot add column to non-existed column family : default family.");
                }
                desc.addNonPkcolumn(col);
            }
            SchemaUtils.validateColumnSchema(desc);
            List<LColumn> allColumns = meta.getAllColumns();
            int position = allColumns.size();
            for (ColumnSchema col : columns) {
                allColumns.add(new LColumn(col, position));
                ++position;
            }
            ModifySchemaOperation schemaOperation = ModifySchemaOperation.ADD_COLUMN;
            if (SchemaUtils.needOpenRegion(meta)) {
                schemaOperation = ModifySchemaOperation.ADD_COLUMN_OPEN_REGION;
            }
            this.internalModifyTableAsync(meta, schemaOperation);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    public void modifyTableAttributes(String tableName, List<LindormAttribute> attributes) throws LindormException {
        this.modifyTableAttributes(tableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyTableAttributes(String tableName, List<LindormAttribute> attributes, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableAttributesAsync(tableName, attributes);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyTableAttributesAsync(String tableName, List<LindormAttribute> attributes) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, attributes, null, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES, -1);
    }

    public void modifyIndexAttributes(String indexName, String dataTableName, List<LindormAttribute> attributes) throws LindormException {
        this.modifyIndexAttributes(indexName, dataTableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyIndexAttributes(String indexName, String dataTableName, List<LindormAttribute> attributes, int timeout) throws LindormException {
        int indexMetaVersion;
        String indexLogicalName;
        this.checkOpen();
        try {
            TableMeta dataTableMeta = this.getTableMeta(dataTableName);
            TableMeta oldIndexMeta = dataTableMeta.getIndexMeta(indexName);
            if (null == oldIndexMeta) {
                throw new IndexNotFoundException(indexName + " on " + dataTableName);
            }
            indexLogicalName = oldIndexMeta.getTableName();
            indexMetaVersion = oldIndexMeta.getMetaVersion();
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.internalModifyTableAttributeAsync(indexLogicalName, attributes, null, ModifySchemaOperation.MODIFY_INDEX_ATTRIBUTES, indexMetaVersion);
        this.blockingAndWaitForSuccess(indexLogicalName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyFamilyAttributes(String tableName, List<LindormFamilyAttributes> attributes) throws LindormException {
        this.modifyFamilyAttributes(tableName, attributes, Integer.MAX_VALUE);
    }

    public void modifyFamilyAttributes(String tableName, List<LindormFamilyAttributes> attributes, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyFamilyAttributesAsync(tableName, attributes);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    public void modifyFamilyAttributesAsync(String tableName, List<LindormFamilyAttributes> attributes) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, null, attributes, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES, -1);
    }

    private void internalModifyTableAttributeAsync(final String tableName, List<LindormAttribute> tableAttributes, List<LindormFamilyAttributes> familyAttributes, ModifySchemaOperation operation, int metaVersion) throws LindormException {
        try {
            if (metaVersion < 0) {
                TableMeta meta = this.getTableMeta(tableName);
                metaVersion = meta.getMetaVersion();
            }
            LindormAttribute.checkDuplicateAttributes(tableAttributes);
            LindormFamilyAttributes.checkDuplicateAttributes(familyAttributes);
            final LModifyTableRequest request = new LModifyTableRequest(tableName, tableAttributes, familyAttributes);
            request.setMetaVersion(metaVersion);
            request.setOperation(operation.ordinal());
            request.validate();
            LOG.info((Object)("Start to modify table " + request.toString()));
            LServerCallable<Void> modifyTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.modifyTableAsync(BasicDDLService.this.namespace, tableName, request);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Deprecated
    public void modifyTableAttributes(LindormTableDescriptor desc) throws LindormException {
        this.modifyTableAttributes(desc, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyTableAttributes(LindormTableDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableAttributesAsync(desc);
        this.blockingAndWaitForSuccess(desc.getName(), AsyncDDLType.ALTER, timeout);
    }

    @Deprecated
    public void modifyTableAttributesAsync(LindormTableDescriptor desc) throws LindormException {
        this.checkOpen();
        SchemaUtils.validateTableDescriptor(desc);
        TableMeta meta = new TableMeta(this.getNamespace(), desc);
        TableMeta oldMeta = null;
        try {
            oldMeta = this.getTableMeta(desc.getName());
        }
        catch (IOException ioe) {
            throw new LindormException("Cannot get table meta :" + desc.getName());
        }
        if (oldMeta.getTableAttributes().isHashTable() != meta.getTableAttributes().isHashTable()) {
            throw new IllegalDataException("Hash table and range table property can not be changed!");
        }
        List<LColumn> oldSchema = oldMeta.getAllColumns();
        for (LColumn col : oldSchema) {
            if (col.isPrimaryKey() || !SchemaUtils.isDefaultFamily(col.getFamilyName())) continue;
            col.setFamilyName(null);
        }
        List<LColumn> newSchema = meta.getAllColumns();
        if (oldSchema.size() != newSchema.size()) {
            throw new IllegalDataException("You cannot modify column schema in ModifyTableAttributes interface. current column count=" + oldSchema.size() + ", but new column count is " + newSchema.size());
        }
        for (int i = 0; i < oldSchema.size(); ++i) {
            if (oldSchema.get(i).equals(newSchema.get(i))) continue;
            throw new IllegalDataException("You cannot modify column schema in ModifyTableAttributes interface. column " + oldSchema.get(i).toString() + " has changed to " + newSchema.get(i).toString());
        }
        if (oldMeta.hasIndex()) {
            SchemaUtils.checkTTL(meta);
            for (TableMeta indexTable : oldMeta.getIndexMetas().values()) {
                for (LColumn pkColumn : indexTable.getPkColumns()) {
                    LColumn lColumn = oldMeta.resolveColumn(pkColumn.getDataColumnKey());
                    SchemaUtils.checkMaxVersion(lColumn, meta);
                }
            }
        }
        this.internalModifyTableAsync(meta, ModifySchemaOperation.MODIFY_TABLE_ATTRIBUTES);
    }

    @Deprecated
    public void modifyFamilyAttributes(String tableName, ColumnFamilyDescriptor descriptor) throws LindormException {
        this.modifyFamilyAttributes(tableName, descriptor, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyFamilyAttributes(String tableName, ColumnFamilyDescriptor descriptor, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyFamilyAttributesAsync(tableName, descriptor);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    @Deprecated
    public void modifyFamilyAttributesAsync(String tableName, ColumnFamilyDescriptor descriptor) throws LindormException {
        this.checkOpen();
        LindormTableDescriptor desc = this.describeTable(tableName);
        if (!desc.hasFamily(descriptor.getName())) {
            throw new LindormException("Delete column family failure, Column family " + Bytes.toString(descriptor.getName()) + " not exist in table " + tableName);
        }
        desc.removeFamily(descriptor.getName());
        desc.addFamily(descriptor);
        this.modifyTableAttributesAsync(desc);
    }

    public void modifyTableConsistency(String tableName, TableAttributes.ConsistencyType target) throws LindormException {
        this.checkOpen();
        this.modifyTableConsistency(tableName, target, Integer.MAX_VALUE);
    }

    public void modifyTableConsistency(String tableName, TableAttributes.ConsistencyType target, int timeout) throws LindormException {
        this.checkOpen();
        this.modifyTableConsistencyAsync(tableName, target);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER_CONSISTENCY, timeout);
    }

    public void modifyTableConsistencyAsync(String tableName, TableAttributes.ConsistencyType target) throws LindormException {
        this.checkOpen();
        this.internalModifyTableAttributeAsync(tableName, Collections.singletonList(new LindormAttribute("CONSISTENCY", target.toString())), null, ModifySchemaOperation.MODIFY_TABLE_CONSISTENCY, -1);
    }

    public boolean isCreateSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.CREATE);
        return pair.getFirst() == 0;
    }

    public boolean isCreateIndexSuccess(String indexName, String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isDeleteIndexSuccess(String indexName, String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isTruncateSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.TRUNCATE);
        return pair.getFirst() == 0;
    }

    public boolean isOnlineSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ONLINE);
        return pair.getFirst() == 0;
    }

    public boolean isOfflineSuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.OFFLINE);
        return pair.getFirst() == 0;
    }

    public boolean isModifySuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER);
        return pair.getFirst() == 0;
    }

    public boolean isModifyConsistencySuccess(String tableName) throws LindormException {
        Pair<Integer, Integer> pair = this.getOperationStatus(tableName, AsyncDDLType.ALTER_CONSISTENCY);
        return pair.getFirst() == 0;
    }

    public boolean isTableOffline(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Boolean> callable = new LServerCallable<Boolean>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isTableOffline(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public boolean isTableOnline(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Boolean> callable = new LServerCallable<Boolean>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isTableOnline(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public TableState getTableState(final String tableName) throws LindormException {
        this.checkOpen();
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<TableState> callable = new LServerCallable<TableState>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public TableState call() throws Exception {
                    return this.server.getTableState(namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private Pair<Integer, Integer> getOperationStatus(final String table, final AsyncDDLType type) throws LindormException {
        this.checkOpen();
        try {
            if (table == null || table.isEmpty()) {
                throw new LindormException("Table name must be null or emtpy.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Pair<Integer, Integer>> getOperationStatusCallable = new LServerCallable<Pair<Integer, Integer>>(OperationContext.OperationType.CHECKSTATE){

                @Override
                public Pair<Integer, Integer> call() throws Exception {
                    return this.server.getOperationStatus(namespace, Bytes.toBytes(table), type);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(getOperationStatusCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LindormTableDescriptor describeTable(String table) throws LindormException {
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(table);
            return TableMeta.buildLindormTableDescriptor(meta);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Deprecated
    public void modifyIndexAttributes(LindormIndexDescriptor desc) throws LindormException {
        this.checkOpen();
        this.modifyIndexAttributes(desc, Integer.MAX_VALUE);
    }

    @Deprecated
    public void modifyIndexAttributes(LindormIndexDescriptor desc, int timeout) throws LindormException {
        this.checkOpen();
        SchemaUtils.validateIndexTableDescriptor(desc);
        String dataTable = desc.getDataTableName();
        String indexName = desc.getIndexName();
        try {
            LindormIndexDescriptor lid = null;
            TableMeta dataTableMeta = this.getTableMeta(dataTable);
            TableMeta oldIndexMeta = dataTableMeta.getIndexMeta(indexName);
            if (null == oldIndexMeta) {
                throw new IndexNotFoundException(indexName);
            }
            lid = TableMeta.buildLindormIndexDescriptor(oldIndexMeta);
            lid.setFamilyAttributes(desc.getFamilyAttributes());
            lid.setTableAttributes(desc.getTableAttributes());
            TableMeta indexTableMeta = new TableMeta(this.getNamespace(), oldIndexMeta.getTableName(), lid, dataTableMeta);
            this.internalModifyTableAsync(indexTableMeta, ModifySchemaOperation.MODIFY_INDEX_ATTRIBUTES);
            this.blockingAndWaitForSuccess(oldIndexMeta.getTableName(), AsyncDDLType.ALTER, timeout);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private TableMeta getIndexTableMeta(String index, String table) throws IOException {
        TableMeta dataTableMeta = this.getTableMeta(table);
        TableMeta indexTableMeta = dataTableMeta.getIndexMeta(index);
        if (indexTableMeta == null) {
            throw new IndexNotFoundException(index);
        }
        return indexTableMeta;
    }

    public LindormIndexDescriptor describeIndex(String index, String table) throws LindormException {
        this.checkOpen();
        try {
            TableMeta indexTableMeta = this.getIndexTableMeta(index, table);
            return TableMeta.buildLindormIndexDescriptor(indexTableMeta);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public TableMeta getTableMeta(final String tableName) throws IOException {
        if (tableName == null || tableName.isEmpty()) {
            throw new LindormException("Table name must be null or emtpy.");
        }
        final String namespace = this.getNamespace();
        LServerCallable<TableMeta> getTableDescriptorCallable = new LServerCallable<TableMeta>(OperationContext.OperationType.DESCRIBE){

            @Override
            public TableMeta call() throws Exception {
                return this.server.getTableMeta(namespace, Bytes.toBytes(tableName));
            }
        };
        return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(getTableDescriptorCallable);
    }

    public void alterReadPermission(final String tableName, final boolean enabled) throws LindormException {
        LServerCallable<Void> alterReadOperation = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.alterReadPermission(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName), enabled, true);
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withoutRetries(alterReadOperation);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void alterWritePermission(final String tableName, final boolean enabled) throws LindormException {
        LServerCallable<Void> alterWriteOperation = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.alterWritePermission(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName), enabled, true);
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withoutRetries(alterWriteOperation);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void disableWritingAndSync(final String tableName) throws LindormException {
        this.checkOpen();
        LServerCallable<Void> disableAndSyncCallable = new LServerCallable<Void>(OperationContext.OperationType.PERMISSION){

            @Override
            public Void call() throws Exception {
                this.server.disableWritePermissionAndForceSync(BasicDDLService.this.getNamespace(), Bytes.toBytes(tableName));
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(disableAndSyncCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private void internalModifyTableAsync(final TableMeta tableMeta, final ModifySchemaOperation operation) throws LindormException {
        LOG.info((Object)("Start to modify table, new table meta " + tableMeta));
        LServerCallable<Void> modifyTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

            @Override
            public Void call() throws Exception {
                this.server.modifyTableAsync(tableMeta, operation.ordinal());
                return null;
            }
        };
        try {
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(modifyTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void alterIndexState(String indexName, String tableName, IndexState indexState) throws LindormException {
        this.checkOpen();
        this.alterIndexStateAsync(indexName, tableName, indexState);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, Integer.MAX_VALUE);
    }

    public void alterIndexStateAsync(final String indexName, final String tableName, final IndexState indexState) throws LindormException {
        this.checkOpen();
        try {
            if (indexName == null || indexName.isEmpty()) {
                throw new LindormException("Index name must not be null or empty.");
            }
            if (tableName == null || tableName.isEmpty()) {
                throw new LindormException("Data table name must not be null or empty.");
            }
            final String namespace = this.getNamespace();
            LServerCallable<Void> alterIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.MODIFY){

                @Override
                public Void call() throws Exception {
                    this.server.alterIndexState(namespace, Bytes.toBytes(indexName), Bytes.toBytes(tableName), indexState);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(alterIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public IndexState getIndexState(String indexName, String tableName) throws LindormException {
        this.checkOpen();
        try {
            TableMeta indexTableMeta = this.getIndexTableMeta(indexName, tableName);
            return indexTableMeta.getIndexState();
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    protected void blockingAndWaitForSuccess(String tableName, AsyncDDLType type, int blockTimeInSecond) throws LindormException {
        long startTime = System.currentTimeMillis();
        long blockTimeInMs = blockTimeInSecond;
        if (blockTimeInSecond != Integer.MAX_VALUE) {
            blockTimeInMs = blockTimeInSecond * 1000;
        }
        long deadline = startTime + blockTimeInMs;
        for (int i = 0; i < this.maxRetryDDL; ++i) {
            long remaining = deadline - System.currentTimeMillis();
            if (remaining <= 0L) {
                throw new LindormException("Timed out when waiting for table: " + tableName + " to finish operation: " + type);
            }
            try {
                long sleepTime = this.ddlPause;
                if (i > 60) {
                    sleepTime = this.ddlPause * 10;
                }
                sleepTime = sleepTime < remaining ? sleepTime : remaining;
                Thread.sleep(sleepTime);
                Pair<Integer, Integer> status = this.getOperationStatus(tableName, type);
                if (status.getFirst() == 0) {
                    return;
                }
                LOG.info((Object)("Progess of operation for : " + type + " " + tableName + ", undone idcs : " + status.getFirst() + " total idcs : " + status.getSecond()));
                continue;
            }
            catch (LindormException e) {
                LOG.warn((Object)("failed to get table status for " + tableName + ", operation type: " + type + ", Retry count : " + i), (Throwable)e);
                continue;
            }
            catch (InterruptedException e) {
                throw new LindormException("Interrupt while waiting for " + tableName + " ddl operation to finish ", e);
            }
        }
        throw new LindormException("Retry exhausted for table operation " + tableName + " Max wait time : " + (System.currentTimeMillis() - startTime));
    }

    public void startEagleeyeTrace(String tableName, OperationContext.OperationType operationType) {
        if (this.eagleeyeEnabled) {
            EagleeyeUtil.startTrace(tableName, operationType);
        }
    }

    public void endEagleeyeTrace() {
        if (this.eagleeyeEnabled) {
            EagleeyeUtil.endTrace("00");
        }
    }

    public Object startEagleeyeTraceAsync(String tableName, OperationContext.OperationType operationType) {
        if (this.eagleeyeEnabled) {
            return EagleeyeUtil.startTraceAsync(tableName, operationType);
        }
        return null;
    }

    public void endEagleeyeTraceAsync(Object eagleeyeContext) {
        if (this.eagleeyeEnabled && eagleeyeContext != null) {
            EagleeyeUtil.endTraceAsync("00", eagleeyeContext);
        }
    }

    public void buildIndex(final String namespace, final String dataTableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> buildIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.buildIndex(namespace, dataTableName, indexName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(buildIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void cancelBuildIndex(final String namespace, final String dataTableName, final String indexName) throws LindormException {
        this.checkOpen();
        try {
            LServerCallable<Void> cancelBuildIndexCallable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.cancelBuildIndex(namespace, dataTableName, indexName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(cancelBuildIndexCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    protected PrimaryKeySchema getFirstPkSchema(LindormTableDescriptor descriptor) {
        return descriptor.getPkColumns().get(0);
    }
}

