/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.command.Command;
import com.alibaba.lindorm.client.core.command.CommandExecuteInfo;
import com.alibaba.lindorm.client.core.command.CommandExecutor;
import com.alibaba.lindorm.client.core.command.CommandResult;
import com.alibaba.lindorm.client.core.ipc.ConfigObserver;
import com.alibaba.lindorm.client.core.ipc.DynamicConfig;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LindormClientProtocol;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.metrics.PassiveMetrics;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ExceptionUtils;
import com.alibaba.lindorm.client.core.utils.LindormObjectUtils;
import com.alibaba.lindorm.client.core.utils.NetUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.Version;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigUpdater
implements ConfigObserver {
    private static final Log LOG = LogFactory.getLog((String)ConfigUpdater.class.getName());
    private static final AtomicLong CONFIG_UPDATER_ID = new AtomicLong();
    public static final String COMMANDID = "COMMANDID";
    public static final String COMMAND = "COMMAND";
    public static final String COMMANDTYPE = "COMMANDTYPE";
    public static final String VERSION = "VERSION";
    public static final String HASH = "HASH";
    public static final String CONFIGHASH = "CONFIGHASH";
    public static final String COMMANDRESULT = "CMDRESULT";
    public static final String PASSIVEMETRICS = "PASSIVEMETRICS";
    private static String DELIMITER = ",";
    private static final byte[] VERSIONINFO = Bytes.toBytes(Version.getVersion());
    private static final byte[] SQL_VERSIONINFO = Bytes.toBytes("SQL-CORE-" + Version.getVersion());
    private final LConnection lConnection;
    private boolean isStopped = false;
    private Object updateLock = new Object();
    private ConfigUpdaterBackgroundThread backgroundThread;
    private CommandExecutor commandExecutor;
    private LinkedBlockingQueue<CommandExecuteInfo> commandQueue;
    private volatile CommandResult commandResult;
    private long currentCommandID = 0L;
    private final byte[] hashcode;
    private byte[] configHashCode = null;
    private LindormClientConfig originConfig;
    private LindormClientConfig activeConfig;
    private String seedServersStr;
    private long updateWaitTime;
    private int pause;
    private int updateConfigRetry;
    private long useSeedServerUntil;
    private int commandResultSizeThreshold;
    private boolean onlyUseSeedServer;
    private boolean seedServerPrinted = false;
    private int updateConfigOpTimeout;

    public ConfigUpdater(LindormClientConfig config, LConnection connection) throws LindormException {
        this.originConfig = config;
        this.activeConfig = config;
        this.lConnection = connection;
        this.hashcode = Bytes.toBytes(this.lConnection.hashCode());
        this.commandQueue = new LinkedBlockingQueue(config.getInt("lindorm.rpc.configupdater.commandqueue.limit", 10));
        this.onConfigChange(config);
        try {
            this.updateConfigWithRetries(this.updateConfigRetry);
        }
        catch (IOException ioe) {
            LOG.error((Object)("fail construct " + ConfigUpdater.class.getSimpleName()), (Throwable)ioe);
            throw new LindormException(ioe);
        }
        this.backgroundThread = new ConfigUpdaterBackgroundThread();
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
        this.commandExecutor = new CommandExecutor(this.lConnection, this.commandQueue);
        this.commandExecutor.setDaemon(true);
        this.commandExecutor.start();
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.seedServersStr = config.get("lindorm.client.seedserver");
        if (StringUtils.isNullOrEmpty(this.seedServersStr)) {
            throw new LindormException("No seed server provided!");
        }
        this.updateWaitTime = config.getInt("lindorm.client.serverlist.refresh.sleep", 30000);
        this.pause = config.getInt("lindorm.rpc.pause.time", 100);
        this.updateConfigRetry = config.getInt("lindorm.rpc.update.config.retry", 3);
        this.useSeedServerUntil = config.getLong("lindorm.rpc.use.seedserver.until", 0L);
        if (this.useSeedServerUntil > System.currentTimeMillis()) {
            this.updateNow();
        }
        this.commandResultSizeThreshold = config.getInt("lindorm.rpc.command.result.threshold", 0x100000);
        this.onlyUseSeedServer = config.getBoolean("lindorm.rpc.only.use.seedserver", false);
        this.updateConfigOpTimeout = config.getInt("lindorm.client.updateconfig.timeout", 3000);
        if (this.updateConfigOpTimeout <= 0) {
            this.updateConfigOpTimeout = config.getInt("lindorm.rpc.timeout", 60000);
        }
    }

    public void close() {
        this.isStopped = true;
        if (this.backgroundThread != null) {
            this.backgroundThread.interrupt();
            try {
                this.backgroundThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.commandExecutor.close();
    }

    public CommandResult getCommandResult() {
        return this.commandResult;
    }

    public void setCommandResult(CommandResult commandResult) {
        this.commandResult = commandResult;
    }

    public static List<LDServerAddress> parseSeedServers(String seedServersStr, boolean doDNSReverseLookUp) throws LindormException {
        try {
            ArrayList<LDServerAddress> seedServers = new ArrayList<LDServerAddress>();
            for (String hostAndPort : seedServersStr.split(DELIMITER)) {
                String[] pair = hostAndPort.split(":");
                String host = pair[0];
                int port = Integer.parseInt(pair[1]);
                if (doDNSReverseLookUp) {
                    InetAddress[] addresses = null;
                    try {
                        addresses = NetUtils.getAllAddressByName(host);
                    }
                    catch (Throwable t) {
                        LOG.debug((Object)("Error happened when get address from dns for host " + host), t);
                    }
                    if (addresses == null) {
                        LOG.debug((Object)("Failed to parse address from host: " + host));
                        LDServerAddress serverAddress = LDServerAddress.valueOf(host, port);
                        if (seedServers.contains(serverAddress)) continue;
                        seedServers.add(serverAddress);
                        continue;
                    }
                    for (InetAddress address : addresses) {
                        LDServerAddress serverAddress = LDServerAddress.valueOf(address.getHostAddress(), port);
                        if (seedServers.contains(serverAddress)) continue;
                        seedServers.add(serverAddress);
                    }
                    continue;
                }
                LDServerAddress serverAddress = LDServerAddress.valueOf(host, port);
                if (seedServers.contains(serverAddress)) continue;
                seedServers.add(serverAddress);
            }
            return seedServers;
        }
        catch (Throwable t) {
            throw new LindormException("Failed to parse seed Server from " + seedServersStr, t);
        }
    }

    private DynamicConfig updateConfigUsingSeedServer(int retryLimit) throws IOException {
        List<LDServerAddress> seedServers = ConfigUpdater.parseSeedServers(this.seedServersStr, true);
        if (seedServers == null || seedServers.size() == 0) {
            throw new LindormException("No seed server found in config:" + this.seedServersStr);
        }
        if (!this.onlyUseSeedServer || !this.seedServerPrinted) {
            LOG.info((Object)("Parsed Seed servers from seedServerStr= " + this.seedServersStr + ", servers= " + seedServers));
            if (!this.seedServerPrinted) {
                this.seedServerPrinted = true;
            }
        }
        Throwable lastError = null;
        Collections.shuffle(seedServers);
        for (int retries = 0; retries < retryLimit; ++retries) {
            for (LDServerAddress address : seedServers) {
                try {
                    return this.updateConfigFromServer(address);
                }
                catch (Throwable t) {
                    lastError = t;
                    try {
                        Thread.sleep(this.pause);
                    }
                    catch (InterruptedException ie) {
                        throw new InterruptedIOException("Interrupted when update config from server");
                    }
                }
            }
        }
        throw new IOException("Retry exhausted when update config from seedserver:" + this.seedServersStr + " , " + seedServers, lastError);
    }

    protected void triggerPassiveMetricsSnapshot() {
        PassiveMetrics passiveMetrics = this.lConnection.getPassiveMetrics();
        if (passiveMetrics != null) {
            passiveMetrics.createSnapshot();
        }
    }

    public DynamicConfig updateConfigWithRetries(int retryLimit) throws IOException {
        long now = System.currentTimeMillis();
        if (now < this.useSeedServerUntil) {
            return this.updateConfigUsingSeedServer(retryLimit);
        }
        int failedRetries = 0;
        HashMap<String, List<Throwable>> errors = new HashMap<String, List<Throwable>>();
        for (String idc : this.lConnection.getAvailableIDCs()) {
            List<LDServerAddress> serverAddresses = this.lConnection.getLdServerLocator().getServersOfIDC(idc);
            Collections.shuffle(serverAddresses);
            int retry = Math.min(serverAddresses.size(), retryLimit);
            for (int i = 0; i < retry; ++i) {
                LDServerAddress serverAddress = serverAddresses.get(i);
                try {
                    return this.updateConfigFromServer(serverAddress);
                }
                catch (Throwable t) {
                    ++failedRetries;
                    String location = serverAddress.getHostAndPort();
                    LinkedList<Throwable> locationExceptions = (LinkedList<Throwable>)errors.get(location);
                    if (locationExceptions == null) {
                        locationExceptions = new LinkedList<Throwable>();
                        errors.put(location, locationExceptions);
                    }
                    locationExceptions.add(t);
                    continue;
                }
            }
        }
        if (failedRetries > 0) {
            String msg = ExceptionUtils.getDesc(ExceptionUtils.classifyExs(errors), true);
            LOG.debug((Object)("Failed update config from LDServers " + failedRetries + " times, with errors= " + msg));
        }
        return this.updateConfigUsingSeedServer(retryLimit);
    }

    private VersionedObjectWithAttributes buildAttributes() {
        PassiveMetrics.PassiveMetricsSnapshot snapshot;
        PassiveMetrics passiveMetrics;
        VersionedObjectWithAttributes attributes = new VersionedObjectWithAttributes();
        attributes.setAttribute(COMMANDID, Bytes.toBytes(this.currentCommandID));
        boolean isSql = Boolean.valueOf(System.getProperty("lindorm.is.sql", "false"));
        if (isSql) {
            attributes.setAttribute(VERSION, SQL_VERSIONINFO);
        } else {
            attributes.setAttribute(VERSION, VERSIONINFO);
        }
        attributes.setAttribute(HASH, this.hashcode);
        if (this.configHashCode != null) {
            attributes.setAttribute(CONFIGHASH, this.configHashCode);
        }
        if ((passiveMetrics = this.lConnection.getPassiveMetrics()) != null && (snapshot = passiveMetrics.getSnapshot()) != null) {
            try {
                attributes.setAttribute(PASSIVEMETRICS, LindormObjectUtils.getBytes(snapshot));
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        try {
            if (this.commandResult != null) {
                if (this.commandResult.getResult() != null && this.commandResult.getResult().length() > this.commandResultSizeThreshold) {
                    LOG.debug((Object)("Failed to send command result since too big, threshold=" + this.commandResultSizeThreshold + ", commandResult=" + this.commandResult));
                } else {
                    attributes.setAttribute(COMMANDRESULT, WritableUtils.getBytes(this.commandResult));
                }
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)"Error set COMMANDRESULT attribute.", t);
        }
        return attributes;
    }

    private void cleanSuccessAttributes() {
        this.commandResult = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DynamicConfig updateConfigFromServer(LDServerAddress address) throws IOException {
        LindormClientProtocol server = this.lConnection.getLdServerConnection(address);
        OperationContext context = new OperationContext(OperationContext.OperationType.UPDATECONFIG, this.updateConfigOpTimeout, null);
        OperationContext.curOperationContext.set(context);
        try {
            DynamicConfig dynamicConfig = server.updateConfigFromServer(this.buildAttributes());
            this.cleanSuccessAttributes();
            if (dynamicConfig != null) {
                this.applyOrRestoreConfig(dynamicConfig);
                List<LDServerAddress> expireServers = this.lConnection.getLdServerLocator().updateServerList(dynamicConfig.getServerList());
                for (LDServerAddress expireServer : expireServers) {
                    this.lConnection.closeConnection(expireServer);
                }
                this.executeCommand(dynamicConfig);
            }
            DynamicConfig dynamicConfig2 = dynamicConfig;
            return dynamicConfig2;
        }
        finally {
            OperationContext.curOperationContext.set(null);
        }
    }

    private void sendMessageBack(String msg, Command.Type type, long commandID) {
        CommandResult result = new CommandResult(msg, type, commandID);
        if (this.commandResult == null) {
            this.commandResult = result;
        }
    }

    private void executeCommand(DynamicConfig dynamicConfig) {
        long commandID = 0L;
        try {
            if (dynamicConfig != null && dynamicConfig.hasAttribute(COMMAND) && dynamicConfig.hasAttribute(COMMANDTYPE) && dynamicConfig.hasAttribute(COMMANDID)) {
                this.currentCommandID = commandID = Bytes.toLong(dynamicConfig.getAttribute(COMMANDID));
                int type = Bytes.toInt(dynamicConfig.getAttribute(COMMANDTYPE));
                CommandExecuteInfo executeInfo = new CommandExecuteInfo(commandID, type, dynamicConfig.getAttribute(COMMAND));
                LOG.info((Object)("Receive command: " + executeInfo.toString()));
                boolean success = this.commandQueue.offer(executeInfo);
                if (!success) {
                    String msg = "Fail to execute " + executeInfo.toString() + " since command queue is full";
                    LOG.info((Object)msg);
                    this.sendMessageBack(msg, Command.Type.ERROR, commandID);
                }
            }
        }
        catch (Throwable t) {
            LOG.debug((Object)"Failed to parse command info form dynamicConfig.", t);
            this.sendMessageBack(StringUtils.stringifyException(t), Command.Type.ERROR, commandID);
        }
    }

    private void applyOrRestoreConfig(DynamicConfig dynamicConfig) {
        try {
            if (dynamicConfig != null) {
                LindormClientConfig newConfig = dynamicConfig.mergeConfig(this.originConfig, this.activeConfig);
                if (newConfig != null) {
                    this.lConnection.onConfigChange(newConfig);
                    this.activeConfig = newConfig;
                    LOG.info((Object)("Applied config: " + dynamicConfig.toString(false)));
                    this.sendMessageBack(dynamicConfig.toString(false), Command.Type.MESSAGE, 0L);
                }
                if (dynamicConfig.hasAttribute(CONFIGHASH)) {
                    this.configHashCode = dynamicConfig.getAttribute(CONFIGHASH);
                }
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed to update config: " + dynamicConfig.toString(false)), t);
            this.sendMessageBack(StringUtils.stringifyException(t), Command.Type.ERROR, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNow() {
        Object object = this.updateLock;
        synchronized (object) {
            this.updateLock.notify();
        }
    }

    private class ConfigUpdaterBackgroundThread
    extends Thread {
        public ConfigUpdaterBackgroundThread() {
            this.setName("ConfigUpdaterBackgroundThread:" + CONFIG_UPDATER_ID.incrementAndGet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ConfigUpdater.this.isStopped) {
                try {
                    Object object = ConfigUpdater.this.updateLock;
                    synchronized (object) {
                        ConfigUpdater.this.updateLock.wait(ConfigUpdater.this.updateWaitTime);
                    }
                    if (ConfigUpdater.this.isStopped) {
                        return;
                    }
                    ConfigUpdater.this.triggerPassiveMetricsSnapshot();
                    ConfigUpdater.this.updateConfigWithRetries(ConfigUpdater.this.updateConfigRetry);
                    if (ConfigUpdater.this.lConnection == null || ConfigUpdater.this.lConnection.getLdServerLocator() == null) continue;
                    ConfigUpdater.this.lConnection.getLdServerLocator().cleanExpiredErrorLocations();
                }
                catch (Throwable t) {
                    if (!(t instanceof InterruptedException) && !(t instanceof InterruptedIOException)) continue;
                    LOG.warn((Object)"ServerListRefreshBackgroundThread is interrupted");
                    return;
                }
            }
        }
    }
}

