/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.ConfigUpdater;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerList;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OnlySeedServerLDServerLocator
implements LDServerLocator {
    public static final String IDCNAME = "SeedServerIDC";
    private static final List<String> IDCLIST;
    private static final List<LDServerAddress> EMPTYSERVERLIST;
    private long round = 0L;
    private LDServerAddress serverAddress;
    private List<LDServerAddress> seedServers;
    private LindormClientConfig config;

    public OnlySeedServerLDServerLocator(LindormClientConfig config, LConnection lConnection) throws LindormException {
        this.onConfigChange(config);
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        this.config = config;
        String seedServerStr = config.getSeedServer();
        this.seedServers = ConfigUpdater.parseSeedServers(seedServerStr, false);
    }

    @Override
    public void cacheLocation(LocationCache.Location location) throws IOException {
    }

    @Override
    public List<String> getAllIDC() {
        return IDCLIST;
    }

    @Override
    public String getSingleRequestIDC() {
        return null;
    }

    @Override
    public String getPriorityIDC() {
        return null;
    }

    @Override
    public List<String> getAvailableIDCs(boolean pickNearby) {
        return IDCLIST;
    }

    @Override
    public List<LDServerAddress> updateServerList(List<LDServerAddress> newServers) throws IOException {
        return EMPTYSERVERLIST;
    }

    @Override
    public List<LDServerAddress> getServersOfIDC(String idc) {
        return EMPTYSERVERLIST;
    }

    @Override
    public LDServerList getServerList() {
        return null;
    }

    @Override
    public LocationCache getLocationCacheOfIDC(String idc) {
        return null;
    }

    @Override
    public LocationCache.Location getCachedLocation(String idc, DmlOperation operation) {
        return null;
    }

    @Override
    public LDServerAddress locateServer(String idc, DmlOperation operation, boolean useCache) throws IOException {
        if (this.seedServers.size() == 1) {
            return this.seedServers.get(0);
        }
        int index = (int)Math.abs(this.round++ % (long)this.seedServers.size());
        return this.seedServers.get(index);
    }

    @Override
    public void removeLDServer(LDServerAddress address) {
    }

    @Override
    public void markLocationError(LDServerAddress address) {
    }

    @Override
    public void cleanErrorLocation(LDServerAddress address) {
    }

    @Override
    public void cleanExpiredErrorLocations() {
    }

    @Override
    public void deleteCachedLocation(String idc, DmlOperation op) {
    }

    @Override
    public void deleteServerCache(LDServerAddress server) {
    }

    @Override
    public void banServer(LDServerAddress server) {
    }

    @Override
    public void unbanServer(LDServerAddress server) {
    }

    @Override
    public boolean isServerBanned(LDServerAddress server) {
        return false;
    }

    @Override
    public void close() {
    }

    static {
        EMPTYSERVERLIST = new ArrayList<LDServerAddress>();
        IDCLIST = new ArrayList<String>();
        IDCLIST.add(IDCNAME);
    }
}

