/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class WScan
extends VersionedObjectWithAttributes
implements OpTimeout {
    private static final String RESUME_ROW = "_resume_";
    private boolean isRawScan = false;
    private IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
    private byte[] startRowKey = LindormClientConstants.EMPTY_START_ROW;
    private byte[] stopRowKey = LindormClientConstants.EMPTY_END_ROW;
    private int maxVersions = 1;
    private int caching = -1;
    private int limit = -1;
    public static final long DEFAULT_MAX_RESULT_SIZE = 0x1000000L;
    private long maxResultSize = 0x1000000L;
    private boolean cacheBlocks = true;
    private int offset = 0;
    private boolean reversed = false;
    private WFilter filter = null;
    private WTimeRange tr = new WTimeRange();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    int operationTimeout = -1;
    int glitchTimeout = -1;
    private LQueryResults.SelectContext selectContext;

    public WScan() {
    }

    public WScan(byte[] startRow, WFilter filter) {
        this(startRow);
        this.filter = filter;
    }

    public WScan(byte[] startRowKey) {
        this.startRowKey = startRowKey;
    }

    public WScan(byte[] startRowKey, byte[] stopRowKey) {
        this.startRowKey = startRowKey;
        this.stopRowKey = stopRowKey;
    }

    public WScan(WScan scan) throws IOException {
        this.isRawScan = scan.isRaw();
        this.isolationLevel = scan.getIsolationLevel();
        this.startRowKey = scan.getStartRowKey();
        this.stopRowKey = scan.getStopRowKey();
        this.maxVersions = scan.getMaxVersions();
        this.caching = scan.getCaching();
        this.limit = scan.getLimit();
        this.maxResultSize = scan.getMaxResultSize();
        this.cacheBlocks = scan.getCacheBlocks();
        this.offset = scan.getOffset();
        this.reversed = scan.getReversed();
        this.filter = scan.getFilter();
        WTimeRange ctr = scan.getTimeRange();
        this.tr = new WTimeRange(ctr.getMin(), ctr.getMax());
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : scan.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        this.operationTimeout = scan.getOperationTimeout();
        this.glitchTimeout = scan.getGlitchTimeout();
    }

    public WScan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public WScan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        }
        set.add(qualifier);
        this.familyMap.put(family, set);
        return this;
    }

    public WScan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new WTimeRange(minStamp, maxStamp);
        return this;
    }

    public WScan setTimeStamp(long timestamp) {
        try {
            this.tr = new WTimeRange(timestamp, timestamp + 1L);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = Math.max(0, offset);
    }

    public byte[] getStartRowKey() {
        return this.startRowKey;
    }

    public WScan setStartRowKey(byte[] startKey) {
        this.startRowKey = startKey;
        return this;
    }

    public byte[] getResumeRow() {
        return this.getAttribute(RESUME_ROW);
    }

    public WScan setResumeRow(byte[] resumeRow) {
        if (resumeRow != null) {
            this.setAttribute(RESUME_ROW, resumeRow);
        }
        return this;
    }

    public byte[] getStopRowKey() {
        return this.stopRowKey;
    }

    public WScan setStopRowKey(byte[] stopRowKey) {
        this.stopRowKey = stopRowKey;
        return this;
    }

    public WScan setMaxVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public WScan setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
        return this;
    }

    public WScan setCaching(int caching) {
        this.caching = caching;
        return this;
    }

    public WScan setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public WScan setMaxResultSize(long maxResultSize) {
        this.maxResultSize = maxResultSize;
        return this;
    }

    public WScan setFilter(WFilter filter) {
        this.filter = filter;
        return this;
    }

    public WScan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getCaching() {
        return this.caching;
    }

    public int getLimit() {
        return this.limit;
    }

    public WTimeRange getTimeRange() {
        return this.tr;
    }

    public WFilter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public WScan setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public WScan setIsolationLevel(IsolationLevel level) {
        this.isolationLevel = level;
        return this;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public WScan setRaw(boolean raw) {
        this.isRawScan = raw;
        return this;
    }

    public boolean isRaw() {
        return this.isRawScan;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        Bytes.writeByteArray(out, this.startRowKey);
        Bytes.writeByteArray(out, this.stopRowKey);
        WritableUtils.writeVInt(out, this.maxVersions);
        WritableUtils.writeVInt(out, this.caching);
        out.writeBoolean(this.cacheBlocks);
        WritableUtils.writeVLong(out, this.maxResultSize);
        out.writeBoolean(this.reversed);
        out.writeBoolean(this.isRawScan);
        out.writeByte(this.isolationLevel.toByte());
        WritableUtils.writeVInt(out, this.offset);
        WFilter.write(out, this.filter);
        this.tr.writeTo(out);
        WritableUtils.writeVInt(out, this.familyMap.size());
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            NavigableSet<byte[]> columnSet = entry.getValue();
            if (columnSet != null) {
                WritableUtils.writeVInt(out, columnSet.size());
                for (byte[] qualifier : columnSet) {
                    Bytes.writeByteArray(out, qualifier);
                }
                continue;
            }
            WritableUtils.writeVInt(out, 0);
        }
    }

    private void setupAttributes() throws IOException {
        if (this.selectContext != null) {
            this.setupSelectContextAttribute(this.selectContext);
        } else {
            this.removeAttribute("SELECT_CONTEXT");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSelectContextAttribute(LQueryResults.SelectContext context) throws IOException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytesStream);
        try {
            this.selectContext.writeTo(out);
        }
        finally {
            out.close();
        }
        this.setAttribute("SELECT_CONTEXT", bytesStream.toByteArray());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.startRowKey = Bytes.readByteArray(in);
        this.stopRowKey = Bytes.readByteArray(in);
        this.maxVersions = WritableUtils.readVInt(in);
        this.caching = WritableUtils.readVInt(in);
        this.cacheBlocks = in.readBoolean();
        this.maxResultSize = WritableUtils.readVLong(in);
        this.reversed = in.readBoolean();
        this.isRawScan = in.readBoolean();
        this.isolationLevel = IsolationLevel.fromByte(in.readByte());
        this.offset = WritableUtils.readVInt(in);
        this.filter = WFilter.read(in);
        this.tr = new WTimeRange();
        this.tr.readFrom(in);
        int numFamilies = WritableUtils.readVInt(in);
        this.familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
        for (int i = 0; i < numFamilies; ++i) {
            byte[] family = Bytes.readByteArray(in);
            int numColumns = WritableUtils.readVInt(in);
            TreeSet<byte[]> set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            for (int j = 0; j < numColumns; ++j) {
                byte[] qualifier = Bytes.readByteArray(in);
                set.add(qualifier);
            }
            this.familyMap.put(family, set);
        }
        this.initFromAttributes();
    }

    private void initFromAttributes() throws IOException {
        byte[] selectContextBytes = this.getAttribute("SELECT_CONTEXT");
        if (selectContextBytes != null) {
            this.readSelectContextFrom(selectContextBytes);
        }
    }

    private void readSelectContextFrom(byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        this.selectContext = new LQueryResults.SelectContext();
        this.selectContext.readFrom(in);
    }

    @Override
    public String toString() {
        int maxCols = 5;
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary(entry.getKey()));
        }
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("startRowKey", Bytes.toStringBinary(this.startRowKey));
        map.put("stopRowKey", Bytes.toStringBinary(this.stopRowKey));
        if (this.maxVersions > 1) {
            map.put("maxVersions", this.maxVersions);
        }
        if (!this.cacheBlocks) {
            map.put("cacheBlocks", this.cacheBlocks);
        }
        if (this.caching != -1) {
            map.put("caching", this.caching);
        }
        if (this.maxResultSize != 0x1000000L) {
            map.put("maxResultSize", this.maxResultSize);
        }
        if (this.reversed) {
            map.put("reversed", this.reversed);
        }
        if (this.isRawScan) {
            map.put("isRawScan", this.isRawScan);
        }
        if (this.isolationLevel != IsolationLevel.READ_COMMITTED) {
            map.put("isolationLevel", (Object)this.isolationLevel);
        }
        if (!this.tr.containsAllTime()) {
            ArrayList<Long> timeRange = new ArrayList<Long>();
            timeRange.add(this.tr.getMin());
            timeRange.add(this.tr.getMax());
            map.put("timeRange", timeRange);
        }
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary(entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary(column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        return ((Object)map).toString();
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout;
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    public WScan setQueryHotOnly(Boolean hotOnly) {
        if (hotOnly == null) {
            this.removeAttribute("HOT_ONLY");
        } else {
            this.setAttribute("HOT_ONLY", Bytes.toBytes(hotOnly));
            this.removeAttribute("COLD_HOT_MERGE");
        }
        return this;
    }

    public boolean isQueryHotOnly() {
        byte[] value = this.getAttribute("HOT_ONLY");
        return value != null && Bytes.toBoolean(value);
    }

    public WScan setHotColdAutoMerge(Boolean autoMerge) {
        if (autoMerge == null) {
            this.removeAttribute("COLD_HOT_MERGE");
        } else {
            this.setAttribute("COLD_HOT_MERGE", Bytes.toBytes(autoMerge));
            this.removeAttribute("HOT_ONLY");
        }
        return this;
    }

    public boolean isHotColdAutoMerge() {
        byte[] value = this.getAttribute("COLD_HOT_MERGE");
        return value != null && Bytes.toBoolean(value);
    }

    public void setSelectContext(LQueryResults.SelectContext context) {
        this.selectContext = context;
    }

    public LQueryResults.SelectContext getSelectContext() {
        return this.selectContext;
    }

    public WScan setAllowFiltering(boolean allowFiltering) {
        this.setAttribute("ALLOW_FILTERING", Bytes.toBytes(allowFiltering));
        return this;
    }

    public boolean isAllowFiltering() {
        byte[] value = this.getAttribute("ALLOW_FILTERING");
        return value != null && Bytes.toBoolean(value);
    }

    public WScan explain() {
        return this.explain(true);
    }

    public WScan explain(boolean isExplain) {
        this.setAttribute("EXPLAIN", Bytes.toBytes(isExplain));
        return this;
    }

    public boolean isExplain() {
        byte[] value = this.getAttribute("EXPLAIN");
        return value != null && Bytes.toBoolean(value);
    }

    public static enum IsolationLevel {
        READ_COMMITTED(1),
        READ_UNCOMMITTED(2);


        private IsolationLevel(int value) {
        }

        public byte[] toBytes() {
            return new byte[]{this.toByte()};
        }

        public byte toByte() {
            return (byte)this.ordinal();
        }

        public static IsolationLevel fromBytes(byte[] bytes) {
            return IsolationLevel.fromByte(bytes[0]);
        }

        public static IsolationLevel fromByte(byte vbyte) {
            return IsolationLevel.values()[vbyte];
        }
    }
}

