/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WMultipleColumnPrefixFilter
extends WFilter {
    private static final int MAX_LOG_PREFIXES = 5;
    private byte[][] prefixes;

    public WMultipleColumnPrefixFilter() {
    }

    public WMultipleColumnPrefixFilter(byte[][] prefixes) {
        this.prefixes = prefixes;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeVInt(out, this.prefixes.length);
        for (byte[] element : this.prefixes) {
            Bytes.writeByteArray(out, element);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        int length = WritableUtils.readVInt(in);
        this.prefixes = new byte[length][];
        for (int i = 0; i < length; ++i) {
            this.prefixes[i] = Bytes.readByteArray(in);
        }
    }

    public byte[][] getPrefixes() {
        return this.prefixes;
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WMultipleColumnPrefixFilter;
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxPrefixes) {
        StringBuilder prefixes = new StringBuilder();
        int count = 0;
        for (byte[] ba : this.prefixes) {
            if (count >= maxPrefixes) break;
            prefixes.append(Bytes.toStringBinary(ba));
            if (++count >= this.prefixes.length || count >= maxPrefixes) continue;
            prefixes.append(", ");
        }
        return String.format("%s (%d/%d): [%s]", this.getClass().getSimpleName(), count, this.prefixes.length, prefixes.toString());
    }
}

