/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic;

import com.alibaba.lindorm.thirdparty.netty.jctools.queues.QueueProgressIndicators;
import com.alibaba.lindorm.thirdparty.netty.jctools.queues.atomic.AtomicReferenceArrayQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpmcAtomicArrayQueue<E>
extends AtomicReferenceArrayQueue<E>
implements QueueProgressIndicators {
    private final AtomicLong consumerIndex = new AtomicLong();
    private final AtomicLong producerIndex = new AtomicLong();
    private final AtomicLong producerIndexCache = new AtomicLong();

    public SpmcAtomicArrayQueue(int capacity) {
        super(capacity);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long currProducerIndex = this.lvProducerIndex();
        int offset = this.calcElementOffset(currProducerIndex, mask);
        if (null != this.lvElement(buffer, offset)) {
            long size = currProducerIndex - this.lvConsumerIndex();
            if (size > (long)mask) {
                return false;
            }
            while (null != this.lvElement(buffer, offset)) {
            }
        }
        this.spElement(buffer, offset, e);
        this.soTail(currProducerIndex + 1L);
        return true;
    }

    @Override
    public E poll() {
        long currentConsumerIndex;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (!this.casHead(currentConsumerIndex, currentConsumerIndex + 1L));
        int offset = this.calcElementOffset(currentConsumerIndex);
        AtomicReferenceArray lb = this.buffer;
        Object e = this.lpElement(lb, offset);
        this.soElement(lb, offset, null);
        return e;
    }

    @Override
    public E peek() {
        long currentConsumerIndex;
        Object e;
        int mask = this.mask;
        long currProducerIndexCache = this.lvProducerIndexCache();
        do {
            if ((currentConsumerIndex = this.lvConsumerIndex()) < currProducerIndexCache) continue;
            long currProducerIndex = this.lvProducerIndex();
            if (currentConsumerIndex >= currProducerIndex) {
                return null;
            }
            this.svProducerIndexCache(currProducerIndex);
        } while (null == (e = this.lvElement(this.calcElementOffset(currentConsumerIndex, mask))));
        return e;
    }

    @Override
    public int size() {
        long currentProducerIndex;
        long before;
        long after = this.lvConsumerIndex();
        do {
            before = after;
            currentProducerIndex = this.lvProducerIndex();
        } while (before != (after = this.lvConsumerIndex()));
        return (int)(currentProducerIndex - after);
    }

    @Override
    public boolean isEmpty() {
        return this.lvConsumerIndex() == this.lvProducerIndex();
    }

    @Override
    public long currentProducerIndex() {
        return this.lvProducerIndex();
    }

    @Override
    public long currentConsumerIndex() {
        return this.lvConsumerIndex();
    }

    protected final long lvProducerIndexCache() {
        return this.producerIndexCache.get();
    }

    protected final void svProducerIndexCache(long v) {
        this.producerIndexCache.set(v);
    }

    protected final long lvConsumerIndex() {
        return this.consumerIndex.get();
    }

    protected final boolean casHead(long expect, long newValue) {
        return this.consumerIndex.compareAndSet(expect, newValue);
    }

    protected final long lvProducerIndex() {
        return this.producerIndex.get();
    }

    protected final void soTail(long v) {
        this.producerIndex.lazySet(v);
    }
}

