/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.AdminUtil;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.AliHBaseAdminInterface;
import org.apache.hadoop.hbase.client.AliHBaseMultiClusterConnection;
import org.apache.hadoop.hbase.client.AliHBaseUEAdmin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.CompactType;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.index.AliHBaseIndexDescriptor;
import org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class AliHBaseMultiAdmin
extends HBaseAdmin
implements AliHBaseAdminInterface {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiAdmin.class);
    private volatile HBaseAdmin currentHBaseAdmin = null;
    private long switchCount = 0L;
    private AliHBaseMultiClusterConnection connection;

    public AliHBaseMultiAdmin(AliHBaseMultiClusterConnection connection, HBaseAdmin hbaseAdmin) throws IOException {
        super((ClusterConnection)connection);
        this.currentHBaseAdmin = hbaseAdmin;
        this.connection = connection;
        this.switchCount = connection.getSwitchCount();
    }

    private HBaseAdmin getCurrentHBaseAdmin() throws IOException {
        if (this.switchCount < this.connection.getSwitchCount()) {
            AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
            if (!(this.currentHBaseAdmin instanceof HBaseAdmin) || clusterType != AliHBaseConstants.ClusterType.HBASE) {
                HBaseAdmin newHBaseAdmin = this.connection.getHBaseAdmin();
                HBaseAdmin lastHBaseAdmin = this.currentHBaseAdmin;
                this.currentHBaseAdmin = newHBaseAdmin;
                if (lastHBaseAdmin != null) {
                    try {
                        lastHBaseAdmin.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("last hbaseAdmin close failed" + e));
                    }
                }
            }
            this.switchCount = this.connection.getSwitchCount();
        }
        return this.currentHBaseAdmin;
    }

    public int getOperationTimeout() {
        return this.currentHBaseAdmin.getOperationTimeout();
    }

    public void abort(String why, Throwable e) {
        this.currentHBaseAdmin.abort(why, e);
    }

    public boolean isAborted() {
        return this.currentHBaseAdmin.isAborted();
    }

    public void close() throws IOException {
        this.currentHBaseAdmin.close();
    }

    public Configuration getConfiguration() {
        return this.currentHBaseAdmin.getConfiguration();
    }

    public boolean tableExists(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().tableExists(tableName);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HTableDescriptor[] listTables() throws IOException {
        return this.getCurrentHBaseAdmin().listTables();
    }

    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return this.getCurrentHBaseAdmin().listTableDescriptors();
    }

    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables();
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern) throws IOException {
        return this.listTableDescriptors();
    }

    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables();
    }

    public HTableDescriptor[] listTables(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public List<TableDescriptor> listTableDescriptors(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableDescriptors();
    }

    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables();
    }

    public TableName[] listTableNames() throws IOException {
        return this.getCurrentHBaseAdmin().listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(Pattern pattern, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames();
    }

    public HTableDescriptor getTableDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        TableDescriptor tableDescriptor = this.getDescriptor(tableName);
        return new HTableDescriptor(tableDescriptor);
    }

    public TableDescriptor getDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return this.getCurrentHBaseAdmin().getDescriptor(tableName);
    }

    public HTableDescriptor[] listTableDescriptorsByNamespace(String name) throws IOException {
        return this.getCurrentHBaseAdmin().listTableDescriptorsByNamespace(name);
    }

    public List<TableDescriptor> listTableDescriptorsByNamespace(byte[] name) throws IOException {
        return this.getCurrentHBaseAdmin().listTableDescriptorsByNamespace(name);
    }

    public TableName[] listTableNamesByNamespace(String name) throws IOException {
        return this.getCurrentHBaseAdmin().listTableNamesByNamespace(name);
    }

    public HTableDescriptor[] getTableDescriptorsByTableName(List<TableName> tableNames) throws IOException {
        return this.getCurrentHBaseAdmin().getTableDescriptorsByTableName(tableNames);
    }

    public List<TableDescriptor> listTableDescriptors(List<TableName> tableNames) throws IOException {
        return this.getCurrentHBaseAdmin().listTableDescriptors(tableNames);
    }

    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        List<TableName> tableNames = names.stream().map(name -> TableName.valueOf((String)name)).collect(Collectors.toList());
        return this.getTableDescriptorsByTableName(tableNames);
    }

    public void createTable(TableDescriptor desc) throws IOException {
        this.createTable(desc, null);
    }

    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split((byte[])startKey, (byte[])endKey, (int)(numRegions - 3));
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    public void createTable(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        this.getCurrentHBaseAdmin().createTable(desc, splitKeys);
        try {
            AdminUtil.setCreateInfoNode(this.connection.getOriginalConf(), desc, splitKeys);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void deleteTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().deleteTable(tableName);
    }

    public void truncateTable(TableName tableName, boolean preserveSplits) throws IOException {
        this.getCurrentHBaseAdmin().truncateTable(tableName, preserveSplits);
    }

    public void enableTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().enableTable(tableName);
    }

    public void disableTable(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().disableTable(tableName);
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().isTableDisabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.isTableEnabled(tableName);
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.getCurrentHBaseAdmin().isTableAvailable(tableName, splitKeys);
    }

    public void addColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().addColumnFamily(tableName, columnFamily);
    }

    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.deleteColumnFamily(tableName, columnFamily);
    }

    public void deleteColumnFamily(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().deleteColumnFamily(tableName, columnFamily);
    }

    public void modifyColumnFamily(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().modifyColumnFamily(tableName, columnFamily);
    }

    public void modifyTable(TableName tableName, TableDescriptor td) throws IOException {
        this.modifyTable(td);
    }

    public void modifyTable(TableDescriptor td) throws IOException {
        this.getCurrentHBaseAdmin().modifyTable(td);
        try {
            AdminUtil.setModifyInfoNode(this.connection.getOriginalConf(), td);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void modifyNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.getCurrentHBaseAdmin().modifyNamespace(descriptor);
    }

    public void deleteNamespace(String name) throws IOException {
        this.getCurrentHBaseAdmin().deleteNamespace(name);
    }

    public NamespaceDescriptor getNamespaceDescriptor(String name) throws NamespaceNotFoundException, IOException {
        return this.getCurrentHBaseAdmin().getNamespaceDescriptor(name);
    }

    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return this.getCurrentHBaseAdmin().listNamespaceDescriptors();
    }

    public void createNamespace(NamespaceDescriptor descriptor) throws IOException {
        this.getCurrentHBaseAdmin().createNamespace(descriptor);
    }

    public void flush(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().flush(tableName);
    }

    public void flushRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().flushRegion(regionName);
    }

    public void compact(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableName);
    }

    public void compactRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().compactRegion(regionName);
    }

    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compact(tableName, columnFamily);
    }

    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().compactRegion(regionName, columnFamily);
    }

    public void compact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().compact(tableName, compactType);
    }

    public void compact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().compact(tableName, columnFamily, compactType);
    }

    public void majorCompact(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableName);
    }

    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompactRegion(regionName);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompact(tableName, columnFamily);
    }

    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.getCurrentHBaseAdmin().majorCompactRegion(regionName, columnFamily);
    }

    public void majorCompact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().majorCompact(tableName, compactType);
    }

    public void majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().majorCompact(tableName, columnFamily, compactType);
    }

    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().disableTables(regex);
    }

    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().disableTables(pattern);
    }

    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().enableTables(regex);
    }

    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().enableTables(pattern);
    }

    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().deleteTables(regex);
    }

    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().deleteTables(pattern);
    }

    public void closeRegion(String regionname, String serverName) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
    }

    public void closeRegion(byte[] regionname, String serverName) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(regionname, serverName);
    }

    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String serverName) throws IOException {
        return this.getCurrentHBaseAdmin().closeRegionWithEncodedRegionName(encodedRegionName, serverName);
    }

    public void closeRegion(ServerName sn, HRegionInfo hri) throws IOException {
        this.getCurrentHBaseAdmin().closeRegion(sn, hri);
    }

    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        return this.getCurrentHBaseAdmin().getOnlineRegions(sn);
    }

    public List<RegionInfo> getRegions(ServerName serverName) throws IOException {
        return this.getCurrentHBaseAdmin().getRegions(serverName);
    }

    public void flushRegionServer(ServerName serverName) throws IOException {
        this.getCurrentHBaseAdmin().flushRegionServer(serverName);
    }

    public void compactRegionServer(ServerName serverName) throws IOException {
        this.getCurrentHBaseAdmin().compactRegionServer(serverName);
    }

    public void majorCompactRegionServer(ServerName serverName) throws IOException {
        this.getCurrentHBaseAdmin().majorCompactRegionServer(serverName);
    }

    public void assign(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().assign(regionName);
    }

    public void unassign(byte[] regionName, boolean force) throws IOException {
        this.getCurrentHBaseAdmin().unassign(regionName, force);
    }

    public void offline(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().offline(regionName);
    }

    public boolean balancerSwitch(boolean onOrOff, boolean synchronous) throws IOException {
        return this.getCurrentHBaseAdmin().balancerSwitch(onOrOff, synchronous);
    }

    public boolean balance() throws IOException {
        return this.getCurrentHBaseAdmin().balance();
    }

    public boolean balance(boolean force) throws IOException {
        return this.getCurrentHBaseAdmin().balance(force);
    }

    public boolean isBalancerEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isBalancerEnabled();
    }

    public CacheEvictionStats clearBlockCache(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().clearBlockCache(tableName);
    }

    public boolean normalize() throws IOException {
        return this.getCurrentHBaseAdmin().normalize();
    }

    public boolean isNormalizerEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isNormalizerEnabled();
    }

    public boolean normalizerSwitch(boolean on) throws IOException {
        return this.getCurrentHBaseAdmin().normalizerSwitch(on);
    }

    public boolean catalogJanitorSwitch(boolean onOrOff) throws IOException {
        return this.getCurrentHBaseAdmin().catalogJanitorSwitch(onOrOff);
    }

    public int runCatalogJanitor() throws IOException {
        return this.getCurrentHBaseAdmin().runCatalogJanitor();
    }

    public boolean isCatalogJanitorEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isCatalogJanitorEnabled();
    }

    public boolean cleanerChoreSwitch(boolean onOrOff) throws IOException {
        return this.getCurrentHBaseAdmin().cleanerChoreSwitch(onOrOff);
    }

    public boolean runCleanerChore() throws IOException {
        return this.getCurrentHBaseAdmin().runCleanerChore();
    }

    public boolean isCleanerChoreEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isCleanerChoreEnabled();
    }

    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        this.getCurrentHBaseAdmin().mergeRegions(nameOfRegionA, nameOfRegionB, forcible);
    }

    public Future<Void> mergeRegionsAsync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        return this.getCurrentHBaseAdmin().mergeRegionsAsync(nameOfRegionA, nameOfRegionB, forcible);
    }

    public Future<Void> mergeRegionsAsync(byte[][] nameofRegionsToMerge, boolean forcible) throws IOException {
        return this.getCurrentHBaseAdmin().mergeRegionsAsync(nameofRegionsToMerge, forcible);
    }

    public void split(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().split(tableName);
    }

    public void splitRegion(byte[] regionName) throws IOException {
        this.getCurrentHBaseAdmin().splitRegion(regionName);
    }

    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().split(tableName, splitPoint);
    }

    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().splitRegion(regionName, splitPoint);
    }

    public Future<Void> splitRegionAsync(byte[] regionName, byte[] splitPoint) throws IOException {
        return this.getCurrentHBaseAdmin().splitRegionAsync(regionName, splitPoint);
    }

    public Future<Void> modifyTableAsync(TableName tableName, TableDescriptor td) throws IOException {
        return this.getCurrentHBaseAdmin().modifyTableAsync(tableName, td);
    }

    public Future<Void> modifyTableAsync(TableDescriptor td) throws IOException {
        return this.getCurrentHBaseAdmin().modifyTableAsync(td);
    }

    public void shutdown() throws IOException {
        this.getCurrentHBaseAdmin().shutdown();
    }

    public void stopMaster() throws IOException {
        this.getCurrentHBaseAdmin().stopMaster();
    }

    public boolean isMasterInMaintenanceMode() throws IOException {
        return this.getCurrentHBaseAdmin().isMasterInMaintenanceMode();
    }

    public void stopRegionServer(String hostnamePort) throws IOException {
        this.getCurrentHBaseAdmin().stopRegionServer(hostnamePort);
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> options) throws IOException {
        return this.getCurrentHBaseAdmin().getClusterMetrics(options);
    }

    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getRegionMetrics(serverName, tableName);
    }

    public Future<Void> createNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.getCurrentHBaseAdmin().createNamespaceAsync(descriptor);
    }

    public Future<Void> modifyNamespaceAsync(NamespaceDescriptor descriptor) throws IOException {
        return this.getCurrentHBaseAdmin().modifyNamespaceAsync(descriptor);
    }

    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getTableRegions(tableName);
    }

    public List<RegionInfo> getRegions(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getRegions(tableName);
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.getCurrentHBaseAdmin().abortProcedure(procId, mayInterruptIfRunning);
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        return this.getCurrentHBaseAdmin().abortProcedureAsync(procId, mayInterruptIfRunning);
    }

    public String getProcedures() throws IOException {
        return this.getCurrentHBaseAdmin().getProcedures();
    }

    public String getLocks() throws IOException {
        return this.getCurrentHBaseAdmin().getLocks();
    }

    public void rollWALWriter(ServerName serverName) throws IOException {
        this.getCurrentHBaseAdmin().rollWALWriter(serverName);
    }

    public CompactionState getCompactionState(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getCompactionState(tableName);
    }

    public CompactionState getCompactionState(TableName tableName, CompactType compactType) throws IOException {
        return this.getCurrentHBaseAdmin().getCompactionState(tableName, compactType);
    }

    public CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        return this.getCurrentHBaseAdmin().getCompactionStateForRegion(regionName);
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestamp(tableName);
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.getCurrentHBaseAdmin().getLastMajorCompactionTimestampForRegion(regionName);
    }

    public void snapshot(String snapshotName, TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(byte[] snapshotName, TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName);
    }

    public void snapshot(String snapshotName, TableName tableName, SnapshotType type) throws IOException {
        this.getCurrentHBaseAdmin().snapshot(snapshotName, tableName, type);
    }

    public void snapshot(SnapshotDescription snapshot) throws IOException {
        this.getCurrentHBaseAdmin().snapshot(snapshot);
    }

    public void snapshotAsync(SnapshotDescription snapshot) throws IOException {
        this.getCurrentHBaseAdmin().snapshotAsync(snapshot);
    }

    public boolean isSnapshotFinished(SnapshotDescription snapshot) throws IOException {
        return this.getCurrentHBaseAdmin().isSnapshotFinished(snapshot);
    }

    public void restoreSnapshot(byte[] snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
    }

    public void restoreSnapshot(String snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName);
    }

    public Future<Void> restoreSnapshotAsync(String snapshotName) throws IOException {
        return this.getCurrentHBaseAdmin().restoreSnapshotAsync(snapshotName);
    }

    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) throws IOException {
        this.getCurrentHBaseAdmin().restoreSnapshot(snapshotName, takeFailSafeSnapshot, restoreAcl);
    }

    public void cloneSnapshot(byte[] snapshotName, TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public void cloneSnapshot(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName, restoreAcl);
    }

    public void cloneSnapshot(String snapshotName, TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().cloneSnapshot(snapshotName, tableName);
    }

    public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().cloneSnapshotAsync(snapshotName, tableName);
    }

    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        this.getCurrentHBaseAdmin().execProcedure(signature, instance, props);
    }

    public byte[] execProcedureWithReturn(String signature, String instance, Map<String, String> props) throws IOException {
        return this.getCurrentHBaseAdmin().execProcedureWithReturn(signature, instance, props);
    }

    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        return this.getCurrentHBaseAdmin().isProcedureFinished(signature, instance, props);
    }

    public List<SnapshotDescription> listSnapshots() throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots();
    }

    public List<SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots(regex);
    }

    public List<SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().listSnapshots(pattern);
    }

    public List<SnapshotDescription> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        return this.getCurrentHBaseAdmin().listTableSnapshots(tableNameRegex, snapshotNameRegex);
    }

    public List<SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        return this.getCurrentHBaseAdmin().listTableSnapshots(tableNamePattern, snapshotNamePattern);
    }

    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
    }

    public void deleteSnapshot(String snapshotName) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshot(snapshotName);
    }

    public void deleteSnapshots(String regex) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshots(regex);
    }

    public void deleteSnapshots(Pattern pattern) throws IOException {
        this.getCurrentHBaseAdmin().deleteSnapshots(pattern);
    }

    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        this.getCurrentHBaseAdmin().deleteTableSnapshots(tableNameRegex, snapshotNameRegex);
    }

    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        this.getCurrentHBaseAdmin().deleteTableSnapshots(tableNamePattern, snapshotNamePattern);
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        this.getCurrentHBaseAdmin().setQuota(quota);
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        return this.getCurrentHBaseAdmin().getQuotaRetriever(filter);
    }

    public List<QuotaSettings> getQuota(QuotaFilter filter) throws IOException {
        return this.getCurrentHBaseAdmin().getQuota(filter);
    }

    public CoprocessorRpcChannel coprocessorService() {
        try {
            return this.getCurrentHBaseAdmin().coprocessorService();
        }
        catch (IOException e) {
            LOG.error((Object)("coprocessorService failed : " + e));
            return null;
        }
    }

    public CoprocessorRpcChannel coprocessorService(ServerName serverName) {
        try {
            return this.getCurrentHBaseAdmin().coprocessorService(serverName);
        }
        catch (IOException e) {
            LOG.error((Object)("coprocessorService failed : " + e));
            return null;
        }
    }

    public void updateConfiguration(ServerName server) throws IOException {
        this.getCurrentHBaseAdmin().updateConfiguration(server);
    }

    public void updateConfiguration() throws IOException {
        this.getCurrentHBaseAdmin().updateConfiguration();
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        return this.getCurrentHBaseAdmin().getSecurityCapabilities();
    }

    public boolean splitSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.getCurrentHBaseAdmin().splitSwitch(enabled, synchronous);
    }

    public boolean mergeSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.getCurrentHBaseAdmin().mergeSwitch(enabled, synchronous);
    }

    public boolean isSplitEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isSplitEnabled();
    }

    public boolean isMergeEnabled() throws IOException {
        return this.getCurrentHBaseAdmin().isMergeEnabled();
    }

    public void addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws IOException {
        this.getCurrentHBaseAdmin().addReplicationPeer(peerId, peerConfig, enabled);
    }

    public void removeReplicationPeer(String peerId) throws IOException {
        this.getCurrentHBaseAdmin().removeReplicationPeer(peerId);
    }

    public void enableReplicationPeer(String peerId) throws IOException {
        this.getCurrentHBaseAdmin().enableReplicationPeer(peerId);
    }

    public void disableReplicationPeer(String peerId) throws IOException {
        this.getCurrentHBaseAdmin().disableReplicationPeer(peerId);
    }

    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws IOException {
        return this.getCurrentHBaseAdmin().getReplicationPeerConfig(peerId);
    }

    public void updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws IOException {
        this.getCurrentHBaseAdmin().updateReplicationPeerConfig(peerId, peerConfig);
    }

    public void appendReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        this.getCurrentHBaseAdmin().appendReplicationPeerTableCFs(id, tableCfs);
    }

    public void removeReplicationPeerTableCFs(String id, Map<TableName, List<String>> tableCfs) throws ReplicationException, IOException {
        this.getCurrentHBaseAdmin().removeReplicationPeerTableCFs(id, tableCfs);
    }

    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return this.getCurrentHBaseAdmin().listReplicationPeers();
    }

    public List<ReplicationPeerDescription> listReplicationPeers(Pattern pattern) throws IOException {
        return this.getCurrentHBaseAdmin().listReplicationPeers(pattern);
    }

    public void decommissionRegionServers(List<ServerName> servers, boolean offload) throws IOException {
        this.getCurrentHBaseAdmin().decommissionRegionServers(servers, offload);
    }

    public List<ServerName> listDecommissionedRegionServers() throws IOException {
        return this.getCurrentHBaseAdmin().listDecommissionedRegionServers();
    }

    public void recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) throws IOException {
        this.getCurrentHBaseAdmin().recommissionRegionServer(server, encodedRegionNames);
    }

    public List<TableCFs> listReplicatedTableCFs() throws IOException {
        return this.getCurrentHBaseAdmin().listReplicatedTableCFs();
    }

    public void enableTableReplication(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().enableTableReplication(tableName);
    }

    public void disableTableReplication(TableName tableName) throws IOException {
        this.getCurrentHBaseAdmin().disableTableReplication(tableName);
    }

    public void clearCompactionQueues(ServerName serverName, Set<String> queues) throws IOException, InterruptedException {
        this.getCurrentHBaseAdmin().clearCompactionQueues(serverName, queues);
    }

    public List<ServerName> clearDeadServers(List<ServerName> servers) throws IOException {
        return this.getCurrentHBaseAdmin().clearDeadServers(servers);
    }

    public Future<Void> createTableAsync(TableDescriptor desc, byte[][] splitKeys) throws IOException {
        return this.getCurrentHBaseAdmin().createTableAsync(desc, splitKeys);
    }

    public Future<Void> deleteTableAsync(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().deleteTableAsync(tableName);
    }

    public Future<Void> truncateTableAsync(TableName tableName, boolean preserveSplits) throws IOException {
        return this.getCurrentHBaseAdmin().truncateTableAsync(tableName, preserveSplits);
    }

    public Future<Void> enableTableAsync(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().enableTableAsync(tableName);
    }

    public Future<Void> disableTableAsync(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().disableTableAsync(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(TableName tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
    }

    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getCurrentHBaseAdmin().getAlterStatus(tableName);
    }

    public Future<Void> deleteColumnFamilyAsync(TableName tableName, byte[] columnFamily) throws IOException {
        return this.getCurrentHBaseAdmin().deleteColumnFamilyAsync(tableName, columnFamily);
    }

    public Future<Void> addColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.getCurrentHBaseAdmin().addColumnFamilyAsync(tableName, columnFamily);
    }

    public Future<Void> modifyColumnFamilyAsync(TableName tableName, ColumnFamilyDescriptor columnFamily) throws IOException {
        return this.getCurrentHBaseAdmin().modifyColumnFamilyAsync(tableName, columnFamily);
    }

    public Future<Void> deleteNamespaceAsync(String name) throws IOException {
        return this.getCurrentHBaseAdmin().deleteNamespaceAsync(name);
    }

    public void move(byte[] bytes, byte[] bytes1) throws IOException {
        this.getCurrentHBaseAdmin().move(bytes, bytes1);
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint) throws IOException {
        this.getCurrentHBaseAdmin().splitRegionSync(regionName, splitPoint);
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint, long timeout, TimeUnit units) throws IOException {
        this.getCurrentHBaseAdmin().splitRegionSync(regionName, splitPoint, timeout, units);
    }

    public byte[][] rollHLogWriter(String serverName) throws IOException {
        return this.getCurrentHBaseAdmin().rollHLogWriter(serverName);
    }

    public void mergeRegionsSync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        this.getCurrentHBaseAdmin().mergeRegionsSync(nameOfRegionA, nameOfRegionB, forcible);
    }

    Future<Void> splitRegionAsync(RegionInfo hri, byte[] splitPoint) throws IOException {
        return this.getCurrentHBaseAdmin().splitRegionAsync(hri, splitPoint);
    }

    Pair<RegionInfo, ServerName> getRegion(byte[] regionName) throws IOException {
        return this.getCurrentHBaseAdmin().getRegion(regionName);
    }

    @Override
    public List<AliHBaseIndexDescriptor> describeIndex(TableName dataTableName) throws IOException {
        if (this.isHBaseUE()) {
            return ((AliHBaseUEAdmin)this.currentHBaseAdmin).describeIndex(dataTableName);
        }
        throw new UnsupportedOperationException("describeIndex not supported by HBase, please use HBaseUE instead.");
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[][] splitKeys) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor, splitKeys);
    }

    @Override
    public void createIndex(AliHBaseIndexDescriptor indexDescriptor, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("createIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).createIndex(indexDescriptor, startKey, endKey, numRegions);
    }

    @Override
    public void deleteIndex(String indexName, TableName dataTable) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("deleteIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).deleteIndex(indexName, dataTable);
        throw new UnsupportedOperationException("deleteIndex not supported");
    }

    @Override
    public void offlineIndex(String indexName, TableName dataTable) throws IOException {
        if (!this.isHBaseUE()) {
            throw new UnsupportedOperationException("offlineIndex not supported by HBase, please use HBaseUE instead.");
        }
        ((AliHBaseUEAdmin)this.currentHBaseAdmin).offlineIndex(indexName, dataTable);
    }

    private boolean isHBaseUE() {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.connection.getConfiguration().get("hbase.cluster.type"));
        return this.currentHBaseAdmin instanceof AliHBaseUEAdmin && clusterType == AliHBaseConstants.ClusterType.HBASEUE;
    }
}

