/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseAPIProxyThriftImpl;
import com.alibaba.hbase.client.AliHBaseImplFactory;
import com.alibaba.hbase.client.AliHBaseThriftClientBuilder;
import com.alibaba.hbase.client.ThriftClientBuilder;
import com.alibaba.hbase.thrift2.generated.THBaseService;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.RateLimiter;
import org.apache.http.HttpRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class AliHBaseThriftImplFactory
extends AliHBaseImplFactory {
    public static final String ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS = "alihbase.thrift.client.builder.class";
    private Configuration conf;
    private ThriftClientBuilder clientBuilder;
    private String host;
    private int operationTimeout;
    private int connectTimeout;
    private RateLimiter rateLimiter;
    private int cuLimit = -1;

    public AliHBaseThriftImplFactory(Configuration conf) throws IOException {
        this.conf = conf;
        this.host = conf.get("hbase.client.endpoint");
        if (this.host == null) {
            throw new RuntimeException("hbase.client.endpoint is not set");
        }
        this.host = this.host.trim();
        if (!this.host.startsWith("http://") && !this.host.startsWith("https://")) {
            throw new RuntimeException("hbase.client.endpoint should start with http:// or https://");
        }
        String hostOnly = this.host.split("//")[1];
        int port = -1;
        if (!hostOnly.contains(":")) {
            this.host = this.host + ":" + 9190;
            port = 9190;
        } else {
            port = Integer.valueOf(hostOnly.split(":")[1]);
        }
        if (conf.get("hbase.client.instanceid") == null || conf.get("hbase.client.instanceid").length() == 0) {
            String[] parts = hostOnly.split("-");
            String instanceid = parts[0].trim() + "-" + parts[1].trim();
            conf.set("hbase.client.instanceid", instanceid);
        }
        if (port == 9190 && conf.get(ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS) == null) {
            conf.set(ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS, HTTPThriftClientBuilder.class.getName());
        }
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.connectTimeout = conf.getInt("hbase.ipc.client.socket.timeout.connect", 10000);
        String className = conf.get(ALIHBASE_THRIFT_CLIENT_BUIDLER_CLASS, AliHBaseThriftClientBuilder.class.getName());
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> constructor = clazz.getDeclaredConstructor(AliHBaseThriftImplFactory.class);
            constructor.setAccessible(true);
            this.clientBuilder = (ThriftClientBuilder)constructor.newInstance(this);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.cuLimit = conf.getInt("hbase.client.cu.limit", -1);
        this.setCULimit(this.cuLimit);
    }

    @Override
    public synchronized void setCULimit(int cuLimit) {
        this.cuLimit = cuLimit;
        if (cuLimit > 0) {
            if (this.rateLimiter == null) {
                this.rateLimiter = RateLimiter.create((double)cuLimit);
            } else {
                this.rateLimiter.setRate((double)cuLimit);
            }
        }
    }

    public void acquirePermitInCU(int cu) {
        if (this.rateLimiter == null || this.cuLimit < 0 || cu <= 0) {
            return;
        }
        this.rateLimiter.acquire(cu);
    }

    public ThriftClientBuilder getClientBuilder() {
        return this.clientBuilder;
    }

    public String getHost() {
        return this.host;
    }

    public synchronized HttpClient getHttpClient() {
        int retry = this.conf.getInt("hbase.client.retries.number", 15);
        long pause = this.conf.getLong("hbase.client.pause", 5L);
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        requestBuilder = requestBuilder.setConnectTimeout(this.connectTimeout);
        requestBuilder = requestBuilder.setSocketTimeout(this.operationTimeout);
        builder.setRetryHandler((HttpRequestRetryHandler)new DelayRetryHandler(retry, pause));
        builder.setDefaultRequestConfig(requestBuilder.build());
        return builder.build();
    }

    @Override
    public AliHBaseAPIProxy getHBaseAPIProxyImpl(TableName tableName) throws IOException {
        Pair<THBaseService.Client, TTransport> client = this.clientBuilder.getClient();
        return new AliHBaseAPIProxyThriftImpl(this.conf, (THBaseService.Client)client.getFirst(), (TTransport)client.getSecond(), tableName, this);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    public static class DelayRetryHandler
    extends DefaultHttpRequestRetryHandler {
        private long pause;

        public DelayRetryHandler(int retryCount, long pause) {
            super(retryCount, true, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, SSLException.class));
            this.pause = pause;
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (executionCount > 1 && this.pause > 0L) {
                try {
                    long sleepTime = ConnectionUtils.getPauseTime((long)this.pause, (int)(executionCount - 1));
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            return super.retryRequest(exception, executionCount, context);
        }

        protected boolean handleAsIdempotent(HttpRequest request) {
            return true;
        }
    }

    public static class HTTPThriftClientBuilder
    extends ThriftClientBuilder {
        Map<String, String> customHeader = new HashMap<String, String>();

        public HTTPThriftClientBuilder(AliHBaseThriftImplFactory factory) {
            super(factory);
        }

        public void addCostumHeader(String key, String value) {
            this.customHeader.put(key, value);
        }

        @Override
        public Pair<THBaseService.Client, TTransport> getClient() throws IOException {
            String url = this.factory.getHost();
            try {
                THttpClient httpClient = new THttpClient(url, this.factory.getHttpClient());
                for (Map.Entry<String, String> header : this.customHeader.entrySet()) {
                    httpClient.setCustomHeader(header.getKey(), header.getValue());
                }
                if (this.factory.getConf().get("hbase.client.username") != null && this.factory.getConf().get("hbase.client.password") != null) {
                    String name = this.factory.getConf().get("hbase.client.username");
                    String password = this.factory.getConf().get("hbase.client.password");
                    httpClient.setCustomHeader("ACCESSKEYID", name);
                    httpClient.setCustomHeader("ACCESSSIGNATURE", password);
                }
                httpClient.open();
                TBinaryProtocol prot = new TBinaryProtocol((TTransport)httpClient);
                THBaseService.Client client = new THBaseService.Client((TProtocol)prot);
                return new Pair((Object)client, (Object)httpClient);
            }
            catch (TTransportException e) {
                throw new IOException(e);
            }
        }
    }
}

