/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.com.taobao.middleware.logger;

import com.alibaba.hbase.com.taobao.middleware.logger.Logger;
import com.alibaba.hbase.com.taobao.middleware.logger.log4j.Log4jLoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.log4j2.Log4j2LoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.nop.NopLoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.slf4j.Slf4jLoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.support.ILoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.support.LogLog;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoggerFactory {
    private static volatile ILoggerFactory LOGGER_FACTORY;
    private static Map<String, Logger> loggerCache;

    private LoggerFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Logger logger = loggerCache.get(name);
        if (logger == null) {
            ILoggerFactory iLoggerFactory = LOGGER_FACTORY;
            synchronized (iLoggerFactory) {
                logger = loggerCache.get(name);
                if (logger == null) {
                    logger = LOGGER_FACTORY.getLogger(name);
                    loggerCache.put(name, logger);
                }
            }
        }
        return logger;
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    private static void setLoggerFactory(ILoggerFactory loggerFactory) {
        if (loggerFactory != null) {
            LOGGER_FACTORY = loggerFactory;
        }
    }

    static {
        try {
            LoggerFactory.setLoggerFactory(new Slf4jLoggerFactory());
            LogLog.info("Init JM logger with Slf4jLoggerFactory success, " + LoggerFactory.class.getClassLoader());
        }
        catch (Throwable e1) {
            try {
                LoggerFactory.setLoggerFactory(new Log4jLoggerFactory());
                LogLog.info("Init JM logger with Log4jLoggerFactory, " + LoggerFactory.class.getClassLoader());
            }
            catch (Throwable e2) {
                try {
                    LoggerFactory.setLoggerFactory(new Log4j2LoggerFactory());
                    LogLog.info("Init JM logger with Log4j2LoggerFactory, " + LoggerFactory.class.getClassLoader());
                }
                catch (Throwable e3) {
                    LoggerFactory.setLoggerFactory(new NopLoggerFactory());
                    LogLog.warn("Init JM logger with NopLoggerFactory, pay attention. " + LoggerFactory.class.getClassLoader(), e2);
                }
            }
        }
        loggerCache = new ConcurrentHashMap<String, Logger>();
    }
}

