/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.AsyncDDLType;
import com.alibaba.lindorm.client.core.BasicDDLService;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.meta.ExternalIndexConfig;
import com.alibaba.lindorm.client.core.meta.ExternalIndexField;
import com.alibaba.lindorm.client.core.meta.ExternalIndexRowFormatterType;
import com.alibaba.lindorm.client.core.meta.ExternalIndexType;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.LDRegionLocation;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.metrics.PassiveMetrics;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ConfigUtil;
import com.alibaba.lindorm.client.core.utils.FeedStreamUtils;
import com.alibaba.lindorm.client.core.utils.ModifySchemaOperation;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WideColumnUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.HotColdMergeScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.SilenceRequestLimiter;
import com.alibaba.lindorm.client.core.widecolumnservice.WAppend;
import com.alibaba.lindorm.client.core.widecolumnservice.WDelete;
import com.alibaba.lindorm.client.core.widecolumnservice.WGet;
import com.alibaba.lindorm.client.core.widecolumnservice.WIncrement;
import com.alibaba.lindorm.client.core.widecolumnservice.WMutationResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WOperation;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WPut;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRow;
import com.alibaba.lindorm.client.core.widecolumnservice.WRowMutations;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.WScanner;
import com.alibaba.lindorm.client.core.widecolumnservice.WSilenceResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WTimeRange;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.ColumnFamilyDescriptor;
import com.alibaba.lindorm.client.schema.ColumnSchema;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import com.alibaba.lindorm.client.schema.PrimaryKeySchema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LindormWideColumnService
extends BasicDDLService
implements WideColumnService {
    public static final Log LOG = LogFactory.getLog(LindormWideColumnService.class);
    public static final Log WGET_LOG = LogFactory.getLog((String)(LindormWideColumnService.class + "#wget"));
    public static final String UNIFIED_PK_COLUMN_NAME = "ROW";
    public static final String UNIFIED_NON_PK_COLUMN_NAME = "COL";
    private static AtomicInteger wideColumnServiceCount = new AtomicInteger(0);
    private ConcurrentMap<String, AutoFlushContext> autoFlushContexts = new ConcurrentSkipListMap<String, AutoFlushContext>();
    private volatile SilenceRequestLimiter silenceRequestLimiter = null;
    private static final List<WPut> EMPTY_WPUT_LIST = new ArrayList<WPut>(0);

    public LindormWideColumnService() {
    }

    public LindormWideColumnService(LindormClientConfig config) throws LindormException {
        this(config, "WideColumnService" + wideColumnServiceCount.incrementAndGet());
    }

    public LindormWideColumnService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
        if (config.getBoolean("lindorm.client.prefetch.routecache", false)) {
            this.prefetchRouteCache(null);
        }
        this.loadSilenceRequestLimiter(config);
    }

    @Override
    public void close() {
        super.close();
    }

    private boolean parseBooleanResult(WMutationResult wMutationResult) {
        if (wMutationResult == null || wMutationResult.getResults() == null || wMutationResult.getResults().length == 0) {
            return false;
        }
        return wMutationResult.getResults()[0] != null;
    }

    private WResult parseSingleRResult(WMutationResult wMutationResult) {
        if (wMutationResult == null || wMutationResult.getResults() == null || wMutationResult.getResults().length == 0) {
            return null;
        }
        return (WResult)wMutationResult.getResults()[0];
    }

    private WResult[] parseRResultArray(WMutationResult wMutationResult) {
        if (wMutationResult == null) {
            return null;
        }
        WResult[] wResults = new WResult[wMutationResult.getResults().length];
        for (int i = 0; i < wMutationResult.getResults().length; ++i) {
            wResults[i] = (WResult)wMutationResult.getResults()[i];
        }
        return wResults;
    }

    @Override
    public boolean exists(String tableName, final WGet get2) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, get2.getRowKey(), get2.getOperationTimeout(), get2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WEXIST;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildExistsCallable(this.operationType, get2, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        return (Boolean)requestSender.execute();
    }

    @Override
    public void existsAsync(String tableName, final WGet get2, AsyncCallback<Boolean> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, get2.getRowKey(), get2.getOperationTimeout(), get2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WEXIST;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildExistsCallable(this.operationType, get2, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Boolean> existsAsync(String tableName, WGet get2) throws LindormException {
        final ClientCompletableFuture<Boolean> future = new ClientCompletableFuture<Boolean>();
        this.existsAsync(tableName, get2, new AsyncCallback<Boolean>(){

            @Override
            public void onComplete(Boolean result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildExistsCallable(OperationContext.OperationType operationType, final WGet rGet, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.exists(rGet, wOperation);
            }
        };
    }

    private WResult hotColdMergeGet(String tableName, WGet oldGet) throws LindormException {
        try {
            WGet newGet = new WGet(oldGet);
            newGet.setHotColdAutoMerge(false);
            Long boundary = this.getColdHotBoundary(tableName, oldGet.getFamilyMap().keySet());
            if (boundary == null) {
                return this.get(tableName, newGet);
            }
            long boundaryTs = System.currentTimeMillis() - boundary;
            if (newGet.getTimeRange().withinTimeRange(boundaryTs)) {
                WTimeRange oldTr = newGet.getTimeRange();
                newGet.setTimeRange(boundaryTs, oldTr.getMax());
                WResult result = this.get(tableName, newGet);
                if (result == null || result.isEmpty()) {
                    newGet.setTimeRange(oldTr.getMin(), oldTr.getMax());
                    result = this.get(tableName, newGet);
                }
                return result;
            }
            return this.get(tableName, newGet);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    @Override
    public WResult get(String tableName, final WGet get2) throws LindormException {
        if (get2.isHotColdAutoMerge()) {
            return this.hotColdMergeGet(tableName, get2);
        }
        WOperation op = new WOperation(this, this.getNamespace(), tableName, get2.getRowKey(), get2.getOperationTimeout(), get2.getGlitchTimeout());
        SilenceRequestLimiter limiter = this.silenceRequestLimiter;
        PassiveMetrics metrics = this.getLConnection().getPassiveMetrics();
        boolean hasError = false;
        boolean silenced = false;
        try {
            OperationContext.OperationType operationType = OperationContext.OperationType.WGET;
            RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, op, operationType){

                @Override
                protected LServerCallable<WMutationResult> buildCall() {
                    return LindormWideColumnService.this.buildGetCallable(this.operationType, get2, this.wOperation);
                }

                @Override
                protected WResult parseResult(WMutationResult response) {
                    return LindormWideColumnService.this.parseSingleRResult(response);
                }
            };
            WResult wResult = (WResult)requestSender.execute();
            return wResult;
        }
        catch (LindormException e) {
            hasError = true;
            if (limiter != null && limiter.shouldSilence()) {
                silenced = true;
                WGET_LOG.warn((Object)("Silence error for " + get2 + " , error=" + e.getMessage()));
                WResult wResult = this.constructSilenceRequest(get2);
                return wResult;
            }
            throw e;
        }
        finally {
            if (limiter != null) {
                limiter.onRequest();
            }
            if (metrics != null) {
                metrics.onSilenceRequest(hasError, silenced);
            }
        }
    }

    private WResult constructSilenceRequest(WGet get2) {
        return new WSilenceResult(new WRow(get2.getRowKey()));
    }

    @Override
    public void getAsync(String tableName, final WGet get2, AsyncCallback<WResult> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, get2.getRowKey(), get2.getOperationTimeout(), get2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WGET;
        RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildGetCallable(this.operationType, get2, this.wOperation);
            }

            @Override
            protected WResult parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseSingleRResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult> getAsync(String tableName, WGet get2) throws LindormException {
        final ClientCompletableFuture<WResult> future = new ClientCompletableFuture<WResult>();
        this.getAsync(tableName, get2, new AsyncCallback<WResult>(){

            @Override
            public void onComplete(WResult result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildGetCallable(OperationContext.OperationType operationType, final WGet rGet, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.get(rGet, wOperation);
            }
        };
    }

    @Override
    public WResult[] batchGet(String tableName, final List<WGet> gets) throws LindormException {
        if (gets == null || gets.size() == 0) {
            return null;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, gets.get(0).getRowKey(), gets.get(0).getOperationTimeout(), gets.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WGET;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchGetCallable(this.operationType, gets, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return gets.size();
            }
        };
        return (WResult[])requestSender.execute();
    }

    @Override
    public void batchGetAsync(String tableName, final List<WGet> gets, AsyncCallback<WResult[]> callback) throws LindormException {
        if (gets == null || gets.size() == 0) {
            callback.onComplete(null);
            return;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, gets.get(0).getRowKey(), gets.get(0).getOperationTimeout(), gets.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WGET;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchGetCallable(this.operationType, gets, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return gets.size();
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult[]> batchGetAsync(String tableName, List<WGet> gets) throws LindormException {
        final ClientCompletableFuture<WResult[]> future = new ClientCompletableFuture<WResult[]>();
        this.batchGetAsync(tableName, gets, new AsyncCallback<WResult[]>(){

            @Override
            public void onComplete(WResult[] result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildBatchGetCallable(OperationContext.OperationType operationType, final List<WGet> rGets, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.batchGet(rGets, wOperation);
            }
        };
    }

    private Long getColdHotBoundary(String tableName, Set<byte[]> cfNames) throws LindormException {
        try {
            TableMeta meta = this.getLConnection().getTableMetaCache().getTable(this.getNamespace(), tableName);
            if (meta == null) {
                meta = this.getTableMeta(tableName);
            }
            return meta.getColdHotBoundary(cfNames);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    private WScanner getHotColdMergeScanner(String tableName, WScan scan) throws LindormException {
        Long boundary = this.getColdHotBoundary(tableName, scan.getFamilyMap().keySet());
        if (boundary == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(HotColdMergeScanner.class.getSimpleName() + " for table:" + tableName + " scan:" + scan + " not take effect"));
            }
            return new WScanner(this, scan, tableName);
        }
        long boundaryTs = System.currentTimeMillis() - boundary;
        if (scan.getTimeRange().withinTimeRange(boundaryTs)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("use :" + HotColdMergeScanner.class.getSimpleName() + " for table:" + tableName + " scan:" + scan));
            }
            return new HotColdMergeScanner(this, scan, tableName, boundaryTs);
        }
        return new WScanner(this, scan, tableName);
    }

    @Override
    public WScanner getScanner(String tableName, WScan scan) throws LindormException {
        if (scan.isHotColdAutoMerge()) {
            return this.getHotColdMergeScanner(tableName, scan);
        }
        WScanner scanner = new WScanner(this, scan, tableName);
        return scanner;
    }

    @Override
    public void put(String tableName, WPut put2) throws LindormException {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context == null || context.autoFlush) {
            this.doPut(tableName, put2);
        } else {
            this.writeToBufferOrCommit(tableName, context, Arrays.asList(put2), false);
        }
    }

    private void doPut(String tableName, final WPut put2) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, put2.getRowKey(), put2.getOperationTimeout(), put2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WPUT;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildPutCallable(this.operationType, put2, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }
        };
        requestSender.execute();
    }

    @Override
    public void putAsync(String tableName, final WPut put2, AsyncCallback<Void> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, put2.getRowKey(), put2.getOperationTimeout(), put2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WPUT;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildPutCallable(this.operationType, put2, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Void> putAsync(String tableName, WPut put2) throws LindormException {
        final ClientCompletableFuture<Void> future = new ClientCompletableFuture<Void>();
        this.putAsync(tableName, put2, new AsyncCallback<Void>(){

            @Override
            public void onComplete(Void result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildPutCallable(OperationContext.OperationType operationType, final WPut put2, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.put(put2, wOperation);
            }
        };
    }

    @Override
    public void batchPut(String tableName, List<WPut> puts) throws LindormException {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context == null || context.autoFlush) {
            this.doBatchPut(tableName, puts);
        } else {
            this.writeToBufferOrCommit(tableName, context, puts, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToBufferOrCommit(String tableName, AutoFlushContext context, List<WPut> puts, boolean forceCommit) throws LindormException {
        assert (context != null);
        long heapSize = 0L;
        for (WPut put2 : puts) {
            heapSize += put2.getEstimateSize();
        }
        ArrayList<WPut> goingToCommits = null;
        int newSize = -1;
        AutoFlushContext autoFlushContext = context;
        synchronized (autoFlushContext) {
            newSize = context.currentBufferSize.addAndGet((int)heapSize);
            context.writeBuffer.addAll(puts);
            if (forceCommit || context.autoFlush || newSize > context.bufferSize) {
                goingToCommits = context.writeBuffer;
                context.writeBuffer = new ArrayList();
                context.currentBufferSize.set(0);
            }
        }
        if (goingToCommits != null && !goingToCommits.isEmpty()) {
            boolean success = false;
            try {
                this.doBatchPut(tableName, goingToCommits);
                success = true;
            }
            finally {
                if (!success && !context.clearBufferOnFailure) {
                    AutoFlushContext autoFlushContext2 = context;
                    synchronized (autoFlushContext2) {
                        context.currentBufferSize.addAndGet(newSize);
                        context.writeBuffer.addAll(goingToCommits);
                    }
                }
            }
        }
    }

    private void doBatchPut(String tableName, final List<WPut> puts) throws LindormException {
        if (puts == null || puts.size() == 0) {
            return;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, puts.get(0).getRowKey(), puts.get(0).getOperationTimeout(), puts.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WPUT;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchPutCallable(this.operationType, puts, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return puts.size();
            }
        };
        requestSender.execute();
    }

    @Override
    public void batchPutAsync(String tableName, final List<WPut> puts, AsyncCallback<Void> callback) throws LindormException {
        if (puts == null || puts.size() == 0) {
            callback.onComplete(null);
            return;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, puts.get(0).getRowKey(), puts.get(0).getOperationTimeout(), puts.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WPUT;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchPutCallable(this.operationType, puts, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return puts.size();
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Void> batchPutAsync(String tableName, List<WPut> puts) throws LindormException {
        final ClientCompletableFuture<Void> future = new ClientCompletableFuture<Void>();
        this.batchPutAsync(tableName, puts, new AsyncCallback<Void>(){

            @Override
            public void onComplete(Void result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildBatchPutCallable(OperationContext.OperationType operationType, final List<WPut> puts, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.batchPut(puts, wOperation);
            }
        };
    }

    @Override
    public boolean checkAndPut(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WPut put2) throws LindormException {
        return this.checkAndPut(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, put2);
    }

    @Override
    public boolean checkAndPut(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WPut put2) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, put2.getRowKey(), put2.getOperationTimeout(), put2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDPUT;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndPutCallable(this.operationType, row, family, qualifier, compareOp, value, put2, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        return (Boolean)requestSender.execute();
    }

    @Override
    public void checkAndPutAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WPut put2, AsyncCallback<Boolean> callback) throws LindormException {
        this.checkAndPutAsync(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, put2, callback);
    }

    @Override
    public void checkAndPutAsync(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WPut put2, AsyncCallback<Boolean> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, put2.getRowKey(), put2.getOperationTimeout(), put2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDPUT;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndPutCallable(this.operationType, row, family, qualifier, compareOp, value, put2, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Boolean> checkAndPutAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WPut put2) throws LindormException {
        return this.checkAndPutAsync(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, put2);
    }

    @Override
    public Future<Boolean> checkAndPutAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, byte[] value, WPut put2) throws LindormException {
        final ClientCompletableFuture<Boolean> future = new ClientCompletableFuture<Boolean>();
        this.checkAndPutAsync(tableName, row, family, qualifier, compareOp, value, put2, new AsyncCallback<Boolean>(){

            @Override
            public void onComplete(Boolean result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildCheckAndPutCallable(OperationContext.OperationType operationType, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WPut put2, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.checkAndPut(row, family, qualifier, compareOp, value, put2, wOperation);
            }
        };
    }

    @Override
    public void delete(String tableName, final WDelete delete) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, delete.getRowKey(), delete.getOperationTimeout(), delete.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WDELETE;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildDeleteCallable(this.operationType, delete, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }
        };
        requestSender.execute();
    }

    @Override
    public void deleteAsync(String tableName, final WDelete delete, AsyncCallback<Void> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, delete.getRowKey(), delete.getOperationTimeout(), delete.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WDELETE;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildDeleteCallable(this.operationType, delete, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Void> deleteAsync(String tableName, WDelete delete) throws LindormException {
        final ClientCompletableFuture<Void> future = new ClientCompletableFuture<Void>();
        this.deleteAsync(tableName, delete, new AsyncCallback<Void>(){

            @Override
            public void onComplete(Void result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildDeleteCallable(OperationContext.OperationType operationType, final WDelete delete, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.delete(delete, wOperation);
            }
        };
    }

    @Override
    public void batchDelete(String tableName, final List<WDelete> deletes) throws LindormException {
        if (deletes == null || deletes.size() == 0) {
            return;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, deletes.get(0).getRowKey(), deletes.get(0).getOperationTimeout(), deletes.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WDELETE;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchDeleteCallable(this.operationType, deletes, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return deletes.size();
            }
        };
        requestSender.execute();
    }

    @Override
    public void batchDeleteAsync(String tableName, final List<WDelete> deletes, AsyncCallback<Void> callback) throws LindormException {
        if (deletes == null || deletes.size() == 0) {
            return;
        }
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, deletes.get(0).getRowKey(), deletes.get(0).getOperationTimeout(), deletes.get(0).getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WDELETE;
        RequestSender<Void, WMutationResult> requestSender = new RequestSender<Void, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchDeleteCallable(this.operationType, deletes, this.wOperation);
            }

            @Override
            protected Void parseResult(WMutationResult response) {
                return null;
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult response) {
                return deletes.size();
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Void> batchDeleteAsync(String tableName, List<WDelete> deletes) throws LindormException {
        final ClientCompletableFuture<Void> future = new ClientCompletableFuture<Void>();
        this.batchDeleteAsync(tableName, deletes, new AsyncCallback<Void>(){

            @Override
            public void onComplete(Void result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildBatchDeleteCallable(OperationContext.OperationType operationType, final List<WDelete> deletes, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.batchDelete(deletes, wOperation);
            }
        };
    }

    @Override
    public boolean checkAndDelete(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WDelete delete) throws LindormException {
        return this.checkAndDelete(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, delete);
    }

    @Override
    public boolean checkAndDelete(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WDelete delete) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, delete.getRowKey(), delete.getOperationTimeout(), delete.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDDELETE;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndDeleteCallable(this.operationType, row, family, qualifier, compareOp, value, delete, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        return (Boolean)requestSender.execute();
    }

    @Override
    public void checkAndDeleteAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WDelete delete, AsyncCallback<Boolean> callback) throws LindormException {
        this.checkAndDeleteAsync(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, delete, callback);
    }

    @Override
    public void checkAndDeleteAsync(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WDelete delete, AsyncCallback<Boolean> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, delete.getRowKey(), delete.getOperationTimeout(), delete.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDDELETE;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndDeleteCallable(this.operationType, row, family, qualifier, compareOp, value, delete, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Boolean> checkAndDeleteAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, byte[] value, WDelete delete) throws LindormException {
        return this.checkAndDeleteAsync(tableName, row, family, qualifier, WCompareFilter.CompareOp.EQUAL, value, delete);
    }

    @Override
    public Future<Boolean> checkAndDeleteAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, byte[] value, WDelete delete) throws LindormException {
        final ClientCompletableFuture<Boolean> future = new ClientCompletableFuture<Boolean>();
        this.checkAndDeleteAsync(tableName, row, family, qualifier, compareOp, value, delete, new AsyncCallback<Boolean>(){

            @Override
            public void onComplete(Boolean result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildCheckAndDeleteCallable(OperationContext.OperationType operationType, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WDelete delete, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.checkAndDelete(row, family, qualifier, compareOp, value, delete, wOperation);
            }
        };
    }

    @Override
    public boolean checkAndMutate(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WRowMutations rowMutations) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, row, rowMutations.getOperationTimeout(), rowMutations.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDMUTATE;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndMutationCallable(this.operationType, row, family, qualifier, compareOp, value, rowMutations, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        return (Boolean)requestSender.execute();
    }

    @Override
    public void checkAndMutateAsync(String tableName, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WRowMutations rowMutations, AsyncCallback<Boolean> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, row, rowMutations.getOperationTimeout(), rowMutations.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.CHECKANDMUTATE;
        RequestSender<Boolean, WMutationResult> requestSender = new RequestSender<Boolean, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildCheckAndMutationCallable(this.operationType, row, family, qualifier, compareOp, value, rowMutations, this.wOperation);
            }

            @Override
            protected Boolean parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseBooleanResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<Boolean> checkAndMutateAsync(String tableName, byte[] row, byte[] family, byte[] qualifier, WCompareFilter.CompareOp compareOp, byte[] value, WRowMutations rowMutations) throws LindormException {
        final ClientCompletableFuture<Boolean> future = new ClientCompletableFuture<Boolean>();
        this.checkAndMutateAsync(tableName, row, family, qualifier, compareOp, value, rowMutations, new AsyncCallback<Boolean>(){

            @Override
            public void onComplete(Boolean result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildCheckAndMutationCallable(OperationContext.OperationType operationType, final byte[] row, final byte[] family, final byte[] qualifier, final WCompareFilter.CompareOp compareOp, final byte[] value, final WRowMutations rowMutations, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.checkAndMutate(row, family, qualifier, compareOp, value, rowMutations, wOperation);
            }
        };
    }

    @Override
    public WResult append(String tableName, final WAppend append2) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, append2.getRowKey(), append2.getOperationTimeout(), append2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WAPPEND;
        RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildAppendCallable(this.operationType, append2, this.wOperation);
            }

            @Override
            protected WResult parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseSingleRResult(response);
            }
        };
        return (WResult)requestSender.execute();
    }

    @Override
    public void appendAsync(String tableName, final WAppend append2, AsyncCallback<WResult> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, append2.getRowKey(), append2.getOperationTimeout(), append2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WAPPEND;
        RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildAppendCallable(this.operationType, append2, this.wOperation);
            }

            @Override
            protected WResult parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseSingleRResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult> appendAsync(String tableName, WAppend append2) throws LindormException {
        final ClientCompletableFuture<WResult> future = new ClientCompletableFuture<WResult>();
        this.appendAsync(tableName, append2, new AsyncCallback<WResult>(){

            @Override
            public void onComplete(WResult result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public WResult[] batchAppend(String tableName, final List<WAppend> appends) throws LindormException {
        if (appends == null || appends.isEmpty()) {
            return null;
        }
        WAppend a = appends.get(0);
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, a.getRowKey(), a.getOperationTimeout(), a.getGlitchTimeout());
        OperationContext.OperationType type = OperationContext.OperationType.APPEND;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, type){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchAppendCallable(this.operationType, appends, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return appends.size();
            }
        };
        return (WResult[])requestSender.execute();
    }

    @Override
    public void batchAppendAsync(String tableName, final List<WAppend> appends, AsyncCallback<WResult[]> callback) throws LindormException {
        if (appends == null || appends.isEmpty()) {
            callback.onComplete(null);
            return;
        }
        WAppend a = appends.get(0);
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, a.getRowKey(), a.getOperationTimeout(), a.getGlitchTimeout());
        OperationContext.OperationType type = OperationContext.OperationType.WAPPEND;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, type){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchAppendCallable(this.operationType, appends, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return appends.size();
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult[]> batchAppendAsync(String tableName, List<WAppend> appends) throws LindormException {
        final ClientCompletableFuture<WResult[]> future = new ClientCompletableFuture<WResult[]>();
        this.batchAppendAsync(tableName, appends, new AsyncCallback<WResult[]>(){

            @Override
            public void onComplete(WResult[] result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildAppendCallable(OperationContext.OperationType operationType, final WAppend append2, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.append(append2, wOperation);
            }
        };
    }

    private LServerCallable<WMutationResult> buildBatchAppendCallable(OperationContext.OperationType operationType, final List<WAppend> appends, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.batchAppend(appends, wOperation);
            }
        };
    }

    @Override
    public WResult increment(String tableName, final WIncrement increment2) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, increment2.getRowKey(), increment2.getOperationTimeout(), increment2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WINCREMENT;
        RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildIncrementCallable(this.operationType, increment2, this.wOperation);
            }

            @Override
            protected WResult parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseSingleRResult(response);
            }
        };
        return (WResult)requestSender.execute();
    }

    @Override
    public void incrementAsync(String tableName, final WIncrement increment2, AsyncCallback<WResult> callback) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, increment2.getRowKey(), increment2.getOperationTimeout(), increment2.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WINCREMENT;
        RequestSender<WResult, WMutationResult> requestSender = new RequestSender<WResult, WMutationResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildIncrementCallable(this.operationType, increment2, this.wOperation);
            }

            @Override
            protected WResult parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseSingleRResult(response);
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult> incrementAsync(String tableName, WIncrement increment2) throws LindormException {
        final ClientCompletableFuture<WResult> future = new ClientCompletableFuture<WResult>();
        this.incrementAsync(tableName, increment2, new AsyncCallback<WResult>(){

            @Override
            public void onComplete(WResult result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    @Override
    public WResult[] batchIncrement(String tableName, final List<WIncrement> increments) throws LindormException {
        if (increments == null || increments.isEmpty()) {
            return null;
        }
        WIncrement i = increments.get(0);
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, i.getRowKey(), i.getOperationTimeout(), i.getGlitchTimeout());
        OperationContext.OperationType type = OperationContext.OperationType.WINCREMENT;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, type){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchIncrementCallable(this.operationType, increments, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return increments.size();
            }
        };
        return (WResult[])requestSender.execute();
    }

    @Override
    public void batchIncrementAsync(String tableName, final List<WIncrement> increments, AsyncCallback<WResult[]> callback) throws LindormException {
        if (increments == null || increments.isEmpty()) {
            callback.onComplete(null);
            return;
        }
        WIncrement i = increments.get(0);
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, i.getRowKey(), i.getOperationTimeout(), i.getGlitchTimeout());
        OperationContext.OperationType type = OperationContext.OperationType.WINCREMENT;
        RequestSender<WResult[], WMutationResult> requestSender = new RequestSender<WResult[], WMutationResult>(tableName, wOperation, type){

            @Override
            protected LServerCallable<WMutationResult> buildCall() {
                return LindormWideColumnService.this.buildBatchIncrementCallable(this.operationType, increments, this.wOperation);
            }

            @Override
            protected WResult[] parseResult(WMutationResult response) {
                return LindormWideColumnService.this.parseRResultArray(response);
            }

            @Override
            protected int getNumberOfRowsAffected(WMutationResult wMutationResult) {
                return increments.size();
            }
        };
        requestSender.executeAsync(callback);
    }

    @Override
    public Future<WResult[]> batchIncrementAsync(String tableName, List<WIncrement> increments) throws LindormException {
        final ClientCompletableFuture<WResult[]> future = new ClientCompletableFuture<WResult[]>();
        this.batchIncrementAsync(tableName, increments, new AsyncCallback<WResult[]>(){

            @Override
            public void onComplete(WResult[] result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private LServerCallable<WMutationResult> buildIncrementCallable(OperationContext.OperationType operationType, final WIncrement increment2, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.increment(increment2, wOperation);
            }
        };
    }

    private LServerCallable<WMutationResult> buildBatchIncrementCallable(OperationContext.OperationType operationType, final List<WIncrement> increments, final WOperation wOperation) {
        return new LServerCallable<WMutationResult>((DmlOperation)wOperation, operationType){

            @Override
            public WMutationResult call() throws Exception {
                return this.server.batchIncrement(increments, wOperation);
            }
        };
    }

    public WPartialResult scan(String tableName, final WScan wScan) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, wScan.getStartRowKey(), wScan.getOperationTimeout(), wScan.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WSCAN;
        RequestSender<WPartialResult, WPartialResult> requestSender = new RequestSender<WPartialResult, WPartialResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WPartialResult> buildCall() {
                return LindormWideColumnService.this.buildScanCallable(this.operationType, wScan, this.wOperation);
            }

            @Override
            protected WPartialResult parseResult(WPartialResult response) {
                return response;
            }
        };
        return (WPartialResult)requestSender.execute();
    }

    @Override
    public void scanAsync(String tableName, WScan wScan, AsyncCallback<List<WResult>> callback) throws LindormException {
        AsyncScanner asyncScanner = new AsyncScanner(callback, wScan, tableName);
        this.scanAsyncInternal(tableName, wScan, asyncScanner, wScan.getOperationTimeout());
    }

    @Override
    public Future<List<WResult>> scanAsync(String tableName, WScan wScan) throws LindormException {
        final ClientCompletableFuture<List<WResult>> future = new ClientCompletableFuture<List<WResult>>();
        this.scanAsync(tableName, wScan, new AsyncCallback<List<WResult>>(){

            @Override
            public void onComplete(List<WResult> result) {
                future.complete(result);
            }

            @Override
            public void onError(Throwable exception) {
                future.completeExceptionally(exception);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return false;
            }
        });
        return future;
    }

    private void scanAsyncInternal(String tableName, final WScan wScan, AsyncCallback<WPartialResult> callback, final int remainingTime) throws LindormException {
        WOperation wOperation = new WOperation(this, this.getNamespace(), tableName, wScan.getStartRowKey(), wScan.getOperationTimeout(), wScan.getGlitchTimeout());
        OperationContext.OperationType operationType = OperationContext.OperationType.WSCAN;
        RequestSender<WPartialResult, WPartialResult> requestSender = new RequestSender<WPartialResult, WPartialResult>(tableName, wOperation, operationType){

            @Override
            protected LServerCallable<WPartialResult> buildCall() {
                return LindormWideColumnService.this.buildScanCallable(this.operationType, wScan, this.wOperation);
            }

            @Override
            protected WPartialResult parseResult(WPartialResult response) {
                return response;
            }

            @Override
            protected int getRemainingTime() {
                return remainingTime;
            }
        };
        requestSender.executeAsync(callback);
    }

    private LServerCallable<WPartialResult> buildScanCallable(OperationContext.OperationType operationType, final WScan wScan, final WOperation wOperation) {
        return new LServerCallable<WPartialResult>((DmlOperation)wOperation, operationType){

            @Override
            public WPartialResult call() throws Exception {
                if (wScan.getCaching() >= 0 && wScan.getLimit() >= 0) {
                    wScan.setCaching(Math.min(wScan.getCaching(), wScan.getLimit()));
                }
                return this.server.scan(wScan, wOperation);
            }
        };
    }

    @Override
    protected PrimaryKeySchema getFirstPkSchema(LindormTableDescriptor descriptor) {
        return new PrimaryKeySchema(UNIFIED_PK_COLUMN_NAME, DataType.VARBINARY);
    }

    public static void validateWideColumnTableDescriptorForCreateTable(LindormTableDescriptor desc) throws IllegalArgumentException {
        if (desc.getPkColumns() != null && !desc.getPkColumns().isEmpty()) {
            throw new IllegalArgumentException("Shouldn't specified pk columns for RowColumn model table");
        }
        if (desc.getNonPkColumns() != null && !desc.getNonPkColumns().isEmpty()) {
            throw new IllegalArgumentException("Shouldn't specified non-pk columns for RowColumn model table");
        }
        List<ColumnFamilyDescriptor> families = desc.getFamilies();
        if (families.isEmpty()) {
            throw new IllegalArgumentException("At least create one column family for RowColumn model table");
        }
        desc.addPkColumn(new PrimaryKeySchema(UNIFIED_PK_COLUMN_NAME, DataType.VARBINARY));
        byte[] firstFamilyName = desc.getFamilies().get(0).getName();
        if (SchemaUtils.isDefaultFamily(firstFamilyName)) {
            desc.addNonPkcolumn(new ColumnSchema(UNIFIED_NON_PK_COLUMN_NAME, DataType.VARBINARY));
        } else {
            desc.addNonPkcolumn(new ColumnSchema(families.get(0).getNameAsString(), UNIFIED_NON_PK_COLUMN_NAME, DataType.VARBINARY));
        }
        desc.setDynamicColumnsEnabled(true);
        FeedStreamUtils.validateSystemFamilyProperty(desc);
    }

    public static void validateWideColumnTableDescriptorForModifyTable(LindormTableDescriptor desc) throws IllegalArgumentException {
        List<ColumnFamilyDescriptor> families = desc.getFamilies();
        if (families.isEmpty()) {
            throw new IllegalArgumentException("At least create one column family for RowColumn model table");
        }
        List<PrimaryKeySchema> pks = desc.getPkColumns();
        if (pks != null && !pks.isEmpty()) {
            if (pks.size() != 1) {
                throw new IllegalArgumentException("WideColumn table should have only one PK column, but has " + pks);
            }
            PrimaryKeySchema pk = pks.get(0);
            if (!pk.getNameAsString().equals(UNIFIED_PK_COLUMN_NAME)) {
                throw new IllegalArgumentException("Should not modify PK column name for WideColumn table, should be [ROW], but has [" + pk.getNameAsString() + "]");
            }
            if (pk.getDataType() != DataType.VARBINARY) {
                throw new IllegalArgumentException("Should not modify PK column data type for WideColumn table, should be " + (Object)((Object)DataType.VARBINARY) + ", but has " + (Object)((Object)pk.getDataType()));
            }
        } else {
            desc.addPkColumn(new PrimaryKeySchema(UNIFIED_PK_COLUMN_NAME, DataType.VARBINARY));
        }
        List<ColumnSchema> nonPks = desc.getNonPkColumns();
        if (nonPks != null && !nonPks.isEmpty()) {
            if (nonPks.size() != 1) {
                throw new IllegalArgumentException("WideColumn table should have only one non-PK column, but has " + nonPks);
            }
            ColumnSchema col = nonPks.get(0);
            if (!col.getColumnNameAsString().equals(UNIFIED_NON_PK_COLUMN_NAME)) {
                throw new IllegalArgumentException("Should not modify non-PK column name for WideColumn table, should be [COL], but has [" + col.getColumnNameAsString() + "]");
            }
            if (col.getDataType() != DataType.VARBINARY) {
                throw new IllegalArgumentException("Should not modify non-PK column data type for WideColumn table, should be " + (Object)((Object)DataType.VARBINARY) + ", but has " + (Object)((Object)col.getDataType()));
            }
        } else {
            desc.addNonPkcolumn(new ColumnSchema(families.get(0).getNameAsString(), UNIFIED_NON_PK_COLUMN_NAME, DataType.VARBINARY));
        }
        if (!desc.isDynamicColumnsEnabled()) {
            throw new IllegalArgumentException("Should always enabled dynamic columns for WideColumn tables.");
        }
        FeedStreamUtils.validateSystemFamilyProperty(desc);
    }

    @Override
    public void createTableAsync(LindormTableDescriptor desc, byte[][] splitKeys) throws LindormException {
        LindormWideColumnService.validateWideColumnTableDescriptorForCreateTable(desc);
        super.createTableAsync(desc, splitKeys);
    }

    @Override
    public void deleteFamily(String tableName, String family) throws LindormException {
        this.deleteFamily(tableName, family, Integer.MAX_VALUE);
    }

    @Override
    public void deleteFamily(String tableName, String family, int timeout) throws LindormException {
        this.checkOpen();
        this.deleteFamilyAsync(tableName, family);
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, timeout);
    }

    @Override
    public void deleteFamilyAsync(String tableName, String family) throws LindormException {
        if (tableName == null || family == null) {
            throw new IllegalRequestException("Table name:" + tableName + " or family:" + family + " is illegal.");
        }
        this.checkOpen();
        try {
            TableMeta meta = this.getTableMeta(tableName);
            if (meta.isIndex()) {
                throw new IllegalRequestException("Cannot delete family to index table: " + meta.getIndexName());
            }
            byte[] familyToDelete = Bytes.toBytes(family);
            if (meta.getFamilyDescriptorByName(familyToDelete) == null) {
                throw new IllegalRequestException("Family " + family + " not found for table " + tableName);
            }
            if (meta.getFamilies().size() == 1) {
                throw new IllegalRequestException("There's only one family, should add a new family before deleting this one");
            }
            Iterator<ColumnFamilyDescriptor> iterator = meta.getFamilies().iterator();
            while (iterator.hasNext()) {
                ColumnFamilyDescriptor cf = iterator.next();
                if (!cf.getNameAsString().equals(family)) continue;
                iterator.remove();
            }
            LColumn nonPK = meta.getNonPkColumns().get(0);
            if (Bytes.equals(familyToDelete, nonPK.getFamilyName())) {
                byte[] firstFamilyAfterDelete = meta.getFamilies().get(0).getName();
                nonPK.setFamilyName(firstFamilyAfterDelete);
            }
            this.internalModifyTableAsync(meta, ModifySchemaOperation.DELETE_FAMILY);
        }
        catch (IOException e) {
            throw new LindormException(e);
        }
    }

    @Override
    public void modifyTableAttributes(LindormTableDescriptor desc) throws LindormException {
        this.modifyTableAttributes(desc, Integer.MAX_VALUE);
    }

    @Override
    public void modifyTableAttributesAsync(LindormTableDescriptor desc) throws LindormException {
        LindormWideColumnService.validateWideColumnTableDescriptorForModifyTable(desc);
        super.modifyTableAttributesAsync(desc);
    }

    @Override
    public void addColumn(String tableName, ColumnSchema col) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String tableName, List<ColumnSchema> columns) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String tableName, ColumnSchema col, int timeout) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumn(String tableName, List<ColumnSchema> columns, int timeout) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumnAsync(String tableName, ColumnSchema col) throws LindormException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addColumnAsync(String tableName, List<ColumnSchema> columns) throws LindormException {
        throw new UnsupportedOperationException();
    }

    private AutoFlushContext getAutoFlushContext(String tableName, boolean createIfAbsent) {
        AutoFlushContext context = (AutoFlushContext)this.autoFlushContexts.get(tableName);
        if (context == null && createIfAbsent) {
            AutoFlushContext newContext = this.autoFlushContexts.putIfAbsent(tableName, new AutoFlushContext());
            context = this.autoFlushContexts.putIfAbsent(tableName, new AutoFlushContext());
            context = context == null ? newContext : context;
        }
        return context;
    }

    @Override
    public void setWriteBufferSize(String tableName, int writeBufferSize) {
        AutoFlushContext context = this.getAutoFlushContext(tableName, true);
        context.bufferSize = writeBufferSize;
    }

    @Override
    public boolean getClearBufferOnFailure(String tableName) {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context == null) {
            return true;
        }
        return context.clearBufferOnFailure;
    }

    @Override
    public int getWriteBufferSize(String tableName) {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context == null) {
            return 0;
        }
        return context.bufferSize;
    }

    @Override
    public void setAutoFlush(String tableName, boolean autoFlush, boolean clearBufferOnFailure) {
        AutoFlushContext context = this.getAutoFlushContext(tableName, true);
        context.autoFlush = autoFlush;
        context.clearBufferOnFailure = clearBufferOnFailure;
    }

    @Override
    public void setAutoFlush(String tableName, boolean autoFlush) {
        this.setAutoFlush(tableName, autoFlush, autoFlush);
    }

    @Override
    public boolean getAutoFlush(String tableName) {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context == null) {
            return true;
        }
        return context.autoFlush;
    }

    @Override
    public void flushCommits(String tableName) throws LindormException {
        AutoFlushContext context = this.getAutoFlushContext(tableName, false);
        if (context != null) {
            this.writeToBufferOrCommit(tableName, context, EMPTY_WPUT_LIST, true);
        }
    }

    @Override
    public byte[][] getStartKeys(String tableName) throws IOException {
        return this.getStartEndKeys(tableName).getFirst();
    }

    @Override
    public byte[][] getEndKeys(String tableName) throws IOException {
        return this.getStartEndKeys(tableName).getSecond();
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys(final String tableName) throws LindormException {
        List<String> idcNames = this.lconnection.getAllIDC();
        final String idcName = idcNames.get(0);
        try {
            LServerCallable<List<LDRegionLocation>> callable = new LServerCallable<List<LDRegionLocation>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDRegionLocation> call() throws Exception {
                    return this.server.getZoneTableRegionLocations(idcName, LindormWideColumnService.this.namespace, tableName);
                }
            };
            List<LDRegionLocation> regions = this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
            ArrayList<byte[]> startKeyList = new ArrayList<byte[]>(regions.size());
            ArrayList<byte[]> endKeyList = new ArrayList<byte[]>(regions.size());
            for (LDRegionLocation region : regions) {
                startKeyList.add(region.getRegionInfo().getStartKey());
                endKeyList.add(region.getRegionInfo().getEndKey());
            }
            return new Pair<T[], T[]>(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void onConfigChange(LindormClientConfig config) throws LindormException {
        super.onConfigChange(config);
        this.loadSilenceRequestLimiter(config);
    }

    private void loadSilenceRequestLimiter(LindormClientConfig config) {
        String ratioKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.widecolumn.error.silence.ratio");
        String bufferKey = ConfigUtil.createServiceConfKey(this.serviceName, "lindorm.client.widecolumn.error.silence.buffer");
        double ratio = config.getDouble(ratioKey, config.getDouble("lindorm.client.widecolumn.error.silence.ratio", -1.0));
        int buffer = config.getInt(bufferKey, config.getInt("lindorm.client.widecolumn.error.silence.buffer", 100));
        SilenceRequestLimiter newOne = null;
        newOne = ratio <= 0.0 || buffer <= 0 ? null : (this.silenceRequestLimiter == null ? new SilenceRequestLimiter(ratio, buffer) : (ratio != this.silenceRequestLimiter.getRatio() || buffer != this.silenceRequestLimiter.getMaxBuffered() ? new SilenceRequestLimiter(ratio, buffer) : this.silenceRequestLimiter));
        if (newOne != this.silenceRequestLimiter) {
            LOG.info((Object)("Service " + this.serviceName + "Configuration changed , silence request ratio: " + ratio + ", silence request buffered: " + buffer));
        }
        this.silenceRequestLimiter = newOne;
    }

    @Override
    public void addExternalIndex(String tableName, String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType, List<ExternalIndexField> fields) throws IOException {
        this.checkOpen();
        ExternalIndexConfig config = new ExternalIndexConfig(targetIndexName, indexType, rowFormatterType);
        this.addExternalIndex(tableName, config, fields);
    }

    @Override
    public void addExternalIndex(String tableName, String targetIndexName, ExternalIndexType indexType, ExternalIndexRowFormatterType rowFormatterType, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(tableName, targetIndexName, indexType, rowFormatterType, list);
    }

    @Override
    public void addExternalIndex(String tableName, List<ExternalIndexField> fields) throws IOException {
        this.addExternalIndex(tableName, null, fields);
    }

    @Override
    public void addExternalIndex(String tableName, ExternalIndexField ... fields) throws IOException {
        this.addExternalIndex(tableName, (ExternalIndexConfig)null, fields);
    }

    @Override
    public void addExternalIndex(final String tableName, final ExternalIndexConfig config, final List<ExternalIndexField> fields) throws IOException {
        this.checkOpen();
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.addExternalIndex(LindormWideColumnService.this.namespace, tableName, config, fields);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, this.ddlOperationTimeout);
    }

    @Override
    public void addExternalIndex(String tableName, ExternalIndexConfig config, ExternalIndexField ... fields) throws IOException {
        ArrayList<ExternalIndexField> list = new ArrayList<ExternalIndexField>();
        for (ExternalIndexField field : fields) {
            list.add(field);
        }
        this.addExternalIndex(tableName, config, list);
    }

    @Override
    public void alterExternalIndex(String tableName, ExternalIndexConfig config) throws IOException {
        this.addExternalIndex(tableName, config, (List<ExternalIndexField>)null);
    }

    @Override
    public void removeExternalIndex(String tableName, String ... fields) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        for (String field : fields) {
            list.add(field);
        }
        this.removeExternalIndex(tableName, list);
    }

    @Override
    public void removeExternalIndex(final String tableName, final List<String> fields) throws IOException {
        this.checkOpen();
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.removeExternalIndex(LindormWideColumnService.this.namespace, tableName, fields);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, this.ddlOperationTimeout);
    }

    @Override
    public void buildExternalIndex(final String tableName) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.buildExternalIndex(LindormWideColumnService.this.namespace, tableName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void cancelBuildExternalIndex(final String tableName) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.cancelBuildExternalIndex(LindormWideColumnService.this.namespace, tableName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    @Override
    public void alterExternalIndex(final String tableName, final String json) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.CREATE){

                @Override
                public Void call() throws Exception {
                    this.server.alterExternalIndex(LindormWideColumnService.this.namespace, tableName, json);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
        this.blockingAndWaitForSuccess(tableName, AsyncDDLType.ALTER, this.ddlOperationTimeout);
    }

    @Override
    public String describeExternalIndex(final String tableName) throws IOException {
        try {
            LServerCallable<String> callable = new LServerCallable<String>(OperationContext.OperationType.CREATE){

                @Override
                public String call() throws Exception {
                    return this.server.describeExternalIndex(LindormWideColumnService.this.namespace, tableName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.ddlOperationTimeout, this.doAsUser).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    private class AsyncScanner
    extends AsyncCallback<WPartialResult> {
        private List<WResult> wResults = new ArrayList<WResult>();
        private WScan wScan;
        private String tableName;
        protected long startTime = System.currentTimeMillis();
        private AsyncCallback<List<WResult>> callback;

        public AsyncScanner(AsyncCallback<List<WResult>> callback, WScan wScan, String tableName) throws LindormException {
            this.callback = callback;
            this.tableName = tableName;
            try {
                this.wScan = new WScan(wScan);
            }
            catch (IOException e) {
                throw new LindormException("failed to deep copy WScan while init AsyncScanner", e);
            }
        }

        @Override
        public void onComplete(WPartialResult result) {
            boolean reachLimit = WideColumnUtils.loadLimitResultsAndUpdateLimitOfWScan(this.wResults, this.wScan, result);
            if (result != null && result.getSelectContext() != null) {
                LQueryResults.SelectContext selectContext = result.getSelectContext();
                this.wScan.setSelectContext(selectContext);
                if (!LQueryResults.hasMore(selectContext) || reachLimit) {
                    this.callback.onComplete(this.wResults);
                    return;
                }
            } else {
                if (result == null || result.getNextStartKey() == null || reachLimit) {
                    this.callback.onComplete(this.wResults);
                    return;
                }
                this.wScan.setStartRowKey(result.getNextStartKey());
                this.wScan.setResumeRow(result.getResumeRow());
                this.wScan.setOffset(this.wScan.getOffset() - result.getSkipped());
            }
            try {
                LindormWideColumnService.this.scanAsyncInternal(this.tableName, this.wScan, this, this.getRemainingTime());
            }
            catch (Throwable t) {
                this.onError(t);
            }
        }

        @Override
        public void onError(Throwable exception) {
            this.callback.onError(exception);
        }

        @Override
        public boolean shouldProcessResultInPool() {
            return this.callback.shouldProcessResultInPool();
        }

        public int getRemainingTime() {
            return (int)Math.max(0L, (long)this.wScan.getOperationTimeout() - (System.currentTimeMillis() - this.startTime));
        }
    }

    protected abstract class RequestSender<Result, Response extends Attributes> {
        protected String tableName;
        protected WOperation wOperation;
        protected OperationContext.OperationType operationType;

        public RequestSender(String tableName, WOperation wOperation, OperationContext.OperationType operationType) {
            this.tableName = tableName;
            this.wOperation = wOperation;
            this.operationType = operationType;
        }

        protected abstract LServerCallable<Response> buildCall();

        protected abstract Result parseResult(Response var1);

        protected int getNumberOfRowsAffected(Response response) {
            return 1;
        }

        protected int getRemainingTime() {
            return this.wOperation.getOperationTimeout();
        }

        public Result execute() throws LindormException {
            long start = System.currentTimeMillis();
            LindormWideColumnService.this.startOperation(this.tableName, this.operationType);
            RetryingCaller<Response> retryingCaller = LindormWideColumnService.this.getLConnection().getDMLRetryingCaller(this.wOperation.getOperationTimeout(), this.wOperation.getGlitchTimeout(), LindormWideColumnService.this.doAsUser);
            try {
                LServerCallable<Response> callable = this.buildCall();
                Attributes response = (Attributes)retryingCaller.withRetries(callable);
                this.wOperation.handleResultAttributes(this.wOperation, response);
                Result result = this.parseResult(response);
                int rows = Math.max(1, this.getNumberOfRowsAffected(response));
                LindormWideColumnService.this.getLConnection().getTableMetricsManager().onOperationSuccess(LindormWideColumnService.this.namespace, this.tableName, this.operationType, System.currentTimeMillis() - start, rows);
                LindormWideColumnService.this.endOperationSuccessfully(this.tableName, retryingCaller);
                return result;
            }
            catch (Throwable t) {
                String msg = this.wOperation.buildErrorMsg(this.operationType, t, System.currentTimeMillis() - start);
                LindormException error = new LindormException(msg);
                LindormWideColumnService.this.getLConnection().getTableMetricsManager().onOperationError(LindormWideColumnService.this.namespace, this.tableName, this.operationType, error);
                LindormWideColumnService.this.endOperationExceptionally(this.tableName, retryingCaller, t);
                throw error;
            }
        }

        public void executeAsync(AsyncCallback<Result> callback) throws LindormException {
            RetryingCaller<Response> retryingCaller = LindormWideColumnService.this.getLConnection().getDMLRetryingCaller(this.wOperation.getOperationTimeout(), this.wOperation.getGlitchTimeout(), LindormWideColumnService.this.doAsUser);
            LServerCallable<Response> callable = this.buildCall();
            Object context = LindormWideColumnService.this.startOperationAsync(this.tableName, this.operationType);
            AsyncHandler asyncHandler = new AsyncHandler(callback, context, System.currentTimeMillis(), retryingCaller);
            retryingCaller.withRetriesAsync(callable, asyncHandler);
        }

        private class AsyncHandler
        extends AsyncCallback<Response> {
            private AsyncCallback<Result> userCallback;
            protected Object traceContext;
            protected long startTime;
            private final RetryingCaller<Response> caller;

            public AsyncHandler(AsyncCallback<Result> userCallback, Object context, long startTime, RetryingCaller<Response> caller) {
                this.userCallback = userCallback;
                this.traceContext = context;
                this.startTime = startTime;
                this.caller = caller;
            }

            @Override
            public void onComplete(Response response) {
                LindormWideColumnService.this.endOperationAsyncSuccessfully(this.traceContext, RequestSender.this.tableName, this.caller);
                RequestSender.this.wOperation.handleResultAttributes(RequestSender.this.wOperation, (Attributes)response);
                Object result = RequestSender.this.parseResult(response);
                int rows = Math.max(1, RequestSender.this.getNumberOfRowsAffected(response));
                LindormWideColumnService.this.getLConnection().getTableMetricsManager().onOperationSuccess(LindormWideColumnService.this.namespace, RequestSender.this.tableName, RequestSender.this.operationType, System.currentTimeMillis() - this.startTime, rows);
                this.userCallback.onComplete(result);
            }

            @Override
            public void onError(Throwable exception) {
                LindormWideColumnService.this.endOperationAsyncExceptionally(this.traceContext, RequestSender.this.tableName, this.caller, exception);
                String msg = RequestSender.this.wOperation.buildErrorMsg(RequestSender.this.operationType, exception, System.currentTimeMillis() - this.startTime);
                LindormException error = new LindormException(msg);
                LindormWideColumnService.this.getLConnection().getTableMetricsManager().onOperationError(LindormWideColumnService.this.namespace, RequestSender.this.tableName, RequestSender.this.operationType, error);
                this.userCallback.onError(error);
            }

            @Override
            public boolean shouldProcessResultInPool() {
                return this.userCallback.shouldProcessResultInPool();
            }
        }
    }

    private static class AutoFlushContext {
        int bufferSize = 0x200000;
        AtomicInteger currentBufferSize = new AtomicInteger(0);
        boolean clearBufferOnFailure = true;
        boolean autoFlush = true;
        ArrayList<WPut> writeBuffer = new ArrayList();
        static final boolean AUTO_FLUSH_DEFAULT = true;
        static final boolean CLEAR_BUFFER_ON_FAILURE_DEFAULT = true;
        static final int WRITE_BUFFER_SIZE_DEFAULT = 0x200000;

        private AutoFlushContext() {
        }
    }
}

