/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.ipc.IDCRequestSequence;
import com.alibaba.lindorm.client.core.ipc.LConnection;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LDServerLocator;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.SingleIDCRequestSequence;
import com.alibaba.lindorm.client.core.ipc.TracePoint;
import com.alibaba.lindorm.client.core.tableservice.DmlOperation;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.ConnectionUtils;
import com.alibaba.lindorm.client.core.utils.ExceptionUtils;
import com.alibaba.lindorm.client.exception.AllIDCFailedException;
import com.alibaba.lindorm.client.exception.ConnectionResetException;
import com.alibaba.lindorm.client.exception.DeadServerException;
import com.alibaba.lindorm.client.exception.DoNotRetryIOException;
import com.alibaba.lindorm.client.exception.LDRemoteException;
import com.alibaba.lindorm.client.exception.OperationTimeoutException;
import com.alibaba.lindorm.client.exception.QuotaExceededException;
import com.alibaba.lindorm.client.exception.RetriesExhaustedException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class RetryingCaller<T> {
    protected int callTimeout;
    protected final LConnection connection;
    protected final int pause;
    protected final int numRetries;
    Map<String, List<Throwable>> exceptions;
    List<TracePoint> traces;
    protected int glitchTimeout = -1;
    protected final int maxVMPauseDelay;
    protected String idcSpecifiedByRequest;
    protected String doAsUser = null;
    protected boolean skipConsistencyCheck = false;
    protected boolean retryIfQuotaExceeded = true;
    protected long createTs;

    public RetryingCaller(LConnection connection, int pause, int numRetries, int callTimeout, boolean retryIfQuotaExceeded) {
        this(connection, pause, numRetries, callTimeout, -1, retryIfQuotaExceeded);
    }

    public RetryingCaller(LConnection connection, int pause, int numRetries, int callTimeout, int glitchTimeout, boolean retryIfQuotaExceeded) {
        this(connection, pause, numRetries, callTimeout, glitchTimeout, retryIfQuotaExceeded, 0, null, false);
    }

    public RetryingCaller(LConnection connection, int pause, int numRetries, int callTimeout, int glitchTimeout, boolean retryIfQuotaExceeded, int maxVMPauseDelay, String doAsUser, boolean skipConsistencyCheck) {
        this.connection = connection;
        this.callTimeout = callTimeout;
        this.pause = pause;
        this.numRetries = numRetries;
        this.glitchTimeout = glitchTimeout;
        this.retryIfQuotaExceeded = retryIfQuotaExceeded;
        this.maxVMPauseDelay = maxVMPauseDelay;
        this.doAsUser = doAsUser;
        this.skipConsistencyCheck = skipConsistencyCheck;
        this.traces = new LinkedList<TracePoint>();
        this.createTs = System.currentTimeMillis();
    }

    public void setIdcToRequest(String idcSpecifiedByRequest) {
        this.idcSpecifiedByRequest = idcSpecifiedByRequest;
    }

    public boolean isRetryIfQuotaExceeded() {
        return this.retryIfQuotaExceeded;
    }

    private void advanceIDC(IDCRequestSequence sequence) {
        sequence.nextIDC();
    }

    protected int getRetrySleepTime(int tries) {
        return (int)ConnectionUtils.getPauseTime(this.pause, tries);
    }

    private T call(LServerCallable<T> callable, String idc, boolean useCache) throws Exception {
        callable.connect(this.connection, idc, useCache);
        return (T)callable.call();
    }

    protected boolean switchIDCIfNeeded(IDCRequestSequence sequence, Throwable t) {
        this.advanceIDC(sequence);
        return true;
    }

    protected int getSleepTime(int remainingTime, int tries) {
        int sleepTime = this.getRetrySleepTime(tries);
        sleepTime = Math.min(sleepTime, remainingTime / 2);
        return sleepTime;
    }

    protected OperationTimeoutException getTimeoutException(OperationContext context, Throwable t) {
        String exceptionMsg = "";
        if (this.exceptions != null) {
            exceptionMsg = ExceptionUtils.getDesc(ExceptionUtils.classifyExs(this.exceptions), true);
        }
        return context.getOperationTimeoutException(System.currentTimeMillis(), exceptionMsg, t);
    }

    private void setAttributesBeforeCall(DmlOperation operation) {
        if (operation == null) {
            return;
        }
        String singleIDC = this.connection.getSingleRequestIDC();
        if (singleIDC != null) {
            operation.setAttribute(Attributes.SINGLEIDC, singleIDC);
        }
        if (this.glitchTimeout > -1) {
            operation.setAttribute(Attributes.GLITCHTIME, Bytes.toBytes(this.glitchTimeout));
        }
    }

    protected boolean isQuotaExceededException(Throwable t) {
        if (t instanceof QuotaExceededException) {
            return true;
        }
        return (t instanceof AllIDCFailedException || t instanceof LDRemoteException) && t.getMessage().contains("QuotaExceededException");
    }

    protected boolean shouldRetry(Throwable t, boolean isRemote) {
        if (!isRemote && t instanceof RuntimeException) {
            return false;
        }
        if (t instanceof DoNotRetryIOException) {
            return false;
        }
        return this.retryIfQuotaExceeded || !this.isQuotaExceededException(t);
    }

    public void withRetriesAsync(LServerCallable<T> callable, AsyncCallback<T> callback) {
        IDCRequestSequence idcRequestSequence = this.getIDCRequestSequence(callable);
        this.setAttributesBeforeCall(callable.getDmlOperation());
        OperationContext context = new OperationContext(callable.getOperationType(), this.callTimeout, this.maxVMPauseDelay, this.doAsUser, this.skipConsistencyCheck);
        AsyncRetryHandler asyncRetryHandler = new AsyncRetryHandler(callable, callback, idcRequestSequence, context);
        context.setCallBack(asyncRetryHandler);
        asyncRetryHandler.callOnce();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T withRetries(LServerCallable<T> callable) throws IOException, RuntimeException {
        int tries;
        IDCRequestSequence idcRequestSequence = this.getIDCRequestSequence(callable);
        this.setAttributesBeforeCall(callable.getDmlOperation());
        OperationContext context = new OperationContext(callable.getOperationType(), this.callTimeout, this.maxVMPauseDelay, this.doAsUser, this.skipConsistencyCheck);
        OperationContext.curOperationContext.set(context);
        LDServerLocator locator = this.connection.getLdServerLocator();
        String currentIDC = null;
        try {
            for (tries = 0; tries < this.numRetries; ++tries) {
                long startTs = System.currentTimeMillis();
                try {
                    currentIDC = idcRequestSequence.peek();
                    T result = this.call(callable, currentIDC, true);
                    this.connection.handleAttributes(callable.getLocation(), result);
                    this.traces.add(new TracePoint(callable.getLocation(), startTs, System.currentTimeMillis(), null));
                    T t = result;
                    return t;
                }
                catch (Throwable t) {
                    int sleepTime;
                    this.traces.add(new TracePoint(callable.getLocation(), startTs, System.currentTimeMillis(), t));
                    locator.deleteCachedLocation(currentIDC, callable.getDmlOperation());
                    t = this.translateException(t);
                    boolean isRemote = false;
                    if (t instanceof LDRemoteException) {
                        isRemote = true;
                        t = ((LDRemoteException)t).unwrapRemoteException();
                    }
                    if (t instanceof ConnectionResetException || t instanceof DeadServerException) {
                        this.connection.getLdServerLocator().removeLDServer(callable.getLocation());
                    } else if (!isRemote) {
                        this.connection.getLdServerLocator().markLocationError(callable.getLocation());
                    }
                    if (!this.shouldRetry(t, isRemote)) {
                        if (!(t instanceof IOException)) throw new DoNotRetryIOException(t);
                        throw (IOException)t;
                    }
                    if (tries == this.numRetries - 1) {
                        throw new RetriesExhaustedException(ExceptionUtils.getDesc(ExceptionUtils.classifyExs(this.exceptions), true), t);
                    }
                    int remainingTime = (int)context.getRemainingTime(System.currentTimeMillis());
                    if (remainingTime <= 0) {
                        throw this.getTimeoutException(context, t);
                    }
                    this.addException(idcRequestSequence.peek(), callable.getLocation(), t);
                    if (this.switchIDCIfNeeded(idcRequestSequence, t) && tries < idcRequestSequence.size() || (sleepTime = this.getSleepTime(remainingTime, tries)) <= 0) continue;
                    Thread.sleep(sleepTime);
                    continue;
                }
            }
            T t = null;
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException("Giving up after tries=" + tries, e);
        }
        finally {
            OperationContext.curOperationContext.set(null);
        }
    }

    private void addException(String idc, LDServerAddress server, Throwable t) {
        String location;
        List<Throwable> locationExceptions;
        if (this.exceptions == null) {
            this.exceptions = new HashMap<String, List<Throwable>>();
        }
        if ((locationExceptions = this.exceptions.get(location = server == null ? idc : server.getHostAndPort())) == null) {
            locationExceptions = new ArrayList<Throwable>();
            this.exceptions.put(location, locationExceptions);
        }
        locationExceptions.add(t);
    }

    public T withoutRetries(LServerCallable<T> callable) throws IOException, RuntimeException {
        this.setAttributesBeforeCall(callable.getDmlOperation());
        OperationContext context = new OperationContext(callable.getOperationType(), this.callTimeout, this.maxVMPauseDelay, this.doAsUser, this.skipConsistencyCheck);
        OperationContext.curOperationContext.set(context);
        String idc = null;
        IDCRequestSequence idcRequestSequence = this.getIDCRequestSequence(callable);
        long startTs = System.currentTimeMillis();
        try {
            idc = idcRequestSequence.nextIDC();
            T result = this.call(callable, idc, true);
            this.connection.handleAttributes(callable.getLocation(), result);
            this.traces.add(new TracePoint(callable.getLocation(), startTs, System.currentTimeMillis(), null));
            T t = result;
            return t;
        }
        catch (Throwable t) {
            this.traces.add(new TracePoint(callable.getLocation(), startTs, System.currentTimeMillis(), t));
            this.connection.getLdServerLocator().deleteCachedLocation(idc, callable.getDmlOperation());
            t = this.translateException(t);
            boolean isRemote = false;
            if (t instanceof LDRemoteException) {
                isRemote = true;
                t = ((LDRemoteException)t).unwrapRemoteException();
            }
            if (t instanceof ConnectionResetException || t instanceof DeadServerException) {
                this.connection.getLdServerLocator().removeLDServer(callable.getLocation());
            } else if (!isRemote) {
                this.connection.getLdServerLocator().markLocationError(callable.getLocation());
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new DoNotRetryIOException(t);
        }
        finally {
            OperationContext.curOperationContext.set(null);
        }
    }

    protected int getRemainingTime(int operationTimeout, long startTime) {
        int remainingTime = operationTimeout - (int)(System.currentTimeMillis() - startTime);
        if (remainingTime < 0) {
            remainingTime = 1;
        }
        return remainingTime;
    }

    private Throwable translateException(Throwable t) {
        Throwable cause;
        if (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        if (t instanceof UndeclaredThrowableException) {
            t = t.getCause();
        }
        if (t instanceof ConnectionResetException && (cause = t.getCause()) != null && cause instanceof DoNotRetryIOException) {
            t = cause;
        }
        return t;
    }

    private IDCRequestSequence getIDCRequestSequence(LServerCallable<T> callable) {
        if (this.idcSpecifiedByRequest != null) {
            return new SingleIDCRequestSequence(this.idcSpecifiedByRequest);
        }
        return this.connection.getIDCRequestSequence(callable.getDmlOperation());
    }

    public List<TracePoint> getTraces() {
        return this.traces;
    }

    public String getTraceMessage() {
        return this.traces.toString();
    }

    public long getCreateTs() {
        return this.createTs;
    }

    public String getRemoteIP() {
        String host = "";
        long maxTime = -1L;
        for (TracePoint trace : this.traces) {
            if (trace.getTookTime() <= maxTime) continue;
            maxTime = trace.getTookTime();
            host = trace.getRemoteHost();
        }
        return host;
    }

    private class AsyncRetryHandler
    extends AsyncCallback<T> {
        private int tries = 0;
        private boolean isRetrying = false;
        private LServerCallable<T> callable;
        private AsyncCallback<T> userCallback;
        private IDCRequestSequence idcRequestSequence;
        private OperationContext context;
        private String currentIDC;
        private volatile long startTs;

        public AsyncRetryHandler(LServerCallable<T> callable, AsyncCallback<T> userCallback, IDCRequestSequence sequence, OperationContext context) {
            this.callable = callable;
            this.userCallback = userCallback;
            this.idcRequestSequence = sequence;
            this.context = context;
        }

        public OperationContext getContext() {
            return this.context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callOnce() {
            this.startTs = System.currentTimeMillis();
            OperationContext.curOperationContext.set(this.context);
            try {
                this.currentIDC = this.idcRequestSequence.peek();
                RetryingCaller.this.call(this.callable, this.currentIDC, true);
            }
            catch (Throwable t) {
                this.onError(t);
            }
            finally {
                OperationContext.curOperationContext.remove();
            }
        }

        @Override
        public void onComplete(T result) {
            RetryingCaller.this.traces.add(new TracePoint(this.callable.getLocation(), this.startTs, System.currentTimeMillis(), null));
            RetryingCaller.this.connection.handleAttributes(this.callable.getLocation(), result);
            this.userCallback.onComplete(result);
        }

        @Override
        public void onError(Throwable t) {
            long sleepTime;
            RetryingCaller.this.traces.add(new TracePoint(this.callable.getLocation(), this.startTs, System.currentTimeMillis(), t));
            RetryingCaller.this.connection.getLdServerLocator().deleteCachedLocation(this.currentIDC, this.callable.getDmlOperation());
            this.isRetrying = true;
            t = RetryingCaller.this.translateException(t);
            boolean isRemote = false;
            if (t instanceof LDRemoteException) {
                isRemote = true;
                t = ((LDRemoteException)t).unwrapRemoteException();
            }
            if (t instanceof ConnectionResetException || t instanceof DeadServerException) {
                RetryingCaller.this.connection.getLdServerLocator().removeLDServer(this.callable.getLocation());
            } else if (!isRemote) {
                RetryingCaller.this.connection.getLdServerLocator().markLocationError(this.callable.getLocation());
            }
            if (!RetryingCaller.this.shouldRetry(t, isRemote)) {
                if (t instanceof IOException) {
                    this.userCallback.onError(t);
                } else {
                    this.userCallback.onError(new DoNotRetryIOException(t));
                }
                return;
            }
            if (this.tries == RetryingCaller.this.numRetries - 1) {
                this.userCallback.onError(new RetriesExhaustedException(ExceptionUtils.getDesc(ExceptionUtils.classifyExs(RetryingCaller.this.exceptions), true), t));
                return;
            }
            int remainingTime = (int)this.context.getRemainingTime(System.currentTimeMillis());
            if (remainingTime <= 0) {
                OperationTimeoutException exception = RetryingCaller.this.getTimeoutException(this.context, t);
                this.userCallback.onError(exception);
                return;
            }
            ++this.tries;
            RetryingCaller.this.addException(this.currentIDC, this.callable.getLocation(), t);
            boolean isIdcSwitched = RetryingCaller.this.switchIDCIfNeeded(this.idcRequestSequence, t);
            long l = sleepTime = !isIdcSwitched || this.tries >= this.idcRequestSequence.size() ? (long)RetryingCaller.this.getSleepTime(remainingTime, this.tries) : 0L;
            if (sleepTime > 0L) {
                RetryingCaller.this.connection.getDelayRetryPool().schedule(new Runnable(){

                    @Override
                    public void run() {
                        AsyncRetryHandler.this.callOnce();
                    }
                }, sleepTime, TimeUnit.MILLISECONDS);
            } else {
                this.callOnce();
            }
        }

        @Override
        public boolean shouldProcessResultInPool() {
            return this.userCallback.shouldProcessResultInPool();
        }

        @Override
        public boolean isRetrying() {
            return this.isRetrying || this.userCallback.isRetrying();
        }

        @Override
        public boolean isBlockable() {
            return false;
        }
    }
}

