/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.ipc;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormClientConstants;
import com.alibaba.lindorm.client.core.ipc.Address;
import com.alibaba.lindorm.client.core.ipc.ClientCompletableFuture;
import com.alibaba.lindorm.client.core.ipc.Connection;
import com.alibaba.lindorm.client.core.ipc.EventLoopGroupShutdownThread;
import com.alibaba.lindorm.client.core.ipc.Invocation;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.Request;
import com.alibaba.lindorm.client.core.ipc.Serializer;
import com.alibaba.lindorm.client.core.utils.BoundPoolMap;
import com.alibaba.lindorm.client.core.utils.PoolMap;
import com.alibaba.lindorm.client.core.utils.ReflectionUtils;
import com.alibaba.lindorm.client.core.utils.Threads;
import com.alibaba.lindorm.client.exception.ConnectionBlockedException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.thirdparty.netty.bootstrap.Bootstrap;
import com.alibaba.lindorm.thirdparty.netty.channel.ChannelFuture;
import com.alibaba.lindorm.thirdparty.netty.channel.ChannelHandler;
import com.alibaba.lindorm.thirdparty.netty.channel.ChannelInitializer;
import com.alibaba.lindorm.thirdparty.netty.channel.ChannelOption;
import com.alibaba.lindorm.thirdparty.netty.channel.EventLoopGroup;
import com.alibaba.lindorm.thirdparty.netty.channel.WriteBufferWaterMark;
import com.alibaba.lindorm.thirdparty.netty.channel.nio.NioEventLoopGroup;
import com.alibaba.lindorm.thirdparty.netty.channel.socket.SocketChannel;
import com.alibaba.lindorm.thirdparty.netty.channel.socket.nio.NioSocketChannel;
import com.alibaba.lindorm.thirdparty.netty.util.HashedWheelTimer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RpcClient {
    private static final Log LOG = LogFactory.getLog((String)RpcClient.class.getName());
    public static final String CLIENT_STOP_MESSAGE = "The client is stopped";
    protected final AtomicBoolean running = new AtomicBoolean(true);
    private LindormClientConfig conf;
    private long throttlePause;
    private long throttleTimeout;
    final int maxChunkSize;
    public int requestInFlightLimit;
    public int connectionBlockTime;
    public int requestPendingLimit;
    private boolean useSharedEventLoopGroup = false;
    private EventLoopGroup sharedEventLoopGroup = null;
    private boolean blockingWhenBusy = true;
    private Serializer serializer;
    private ThreadPoolExecutor callbackPool;
    private int maxCallbackPoolQueueSize;
    private final HashedWheelTimer rpcTimeoutTimer;
    private int refCount = 1;
    private final BoundPoolMap<ConnectionId, Connection> connectionsMap;

    public HashedWheelTimer getRpcTimeoutTimer() {
        return this.rpcTimeoutTimer;
    }

    public RpcClient(LindormClientConfig config) throws LindormException {
        try {
            this.conf = config;
            this.rpcTimeoutTimer = this.newTimer(this.conf, "RPC Timeout Timer");
            this.useSharedEventLoopGroup = this.conf.getBoolean("lindorm.rpc.sharedthreadpool.enabled", true);
            if (this.useSharedEventLoopGroup) {
                this.sharedEventLoopGroup = new NioEventLoopGroup(this.conf.getInt("lindorm.rpc.sharedthreadpool.num", 0), Threads.newDaemonThreadFactory("NioEventLoopGroup"));
            }
            this.throttlePause = this.conf.getLong("lindorm.rpc.throttle.pause.time", 10L);
            this.throttleTimeout = this.conf.getLong("lindorm.rpc.throttle.timeout", 200L);
            this.maxChunkSize = this.conf.getInt("lindorm.rpc.maxChunkSize", 524288);
            this.blockingWhenBusy = this.conf.getBoolean("lindorm.rpc.blocking.when.channelbusy", true);
            this.requestInFlightLimit = this.conf.getInt("lindorm.rpc.request.inflight.limit", 0);
            this.connectionBlockTime = this.conf.getInt("lindorm.rpc.connection.block.time", 5000);
            this.requestPendingLimit = this.conf.getInt("lindorm.rpc.request.pending.limit", 16);
            this.connectionsMap = new BoundPoolMap(PoolMap.PoolType.BoundRoundRobin, this.conf.getInt("lindorm.rpc.connection.pool.min.size", 1), this.conf.getInt("lindorm.rpc.connection.pool.max.size", 3), this.conf.getInt("lindorm.rpc.connection.pool.bound.threshold", 10));
            Class<?> serializerClass = this.conf.getClass("lindorm.rpc.serializer.class", "com.alibaba.lindorm.server.client.WritableSerializer", LindormClientConstants.RPC_SERIALIZER_CLASS_DEFAULT);
            this.serializer = (Serializer)ReflectionUtils.newInstance(serializerClass);
            int maxThreads = this.conf.getInt("lindorm.rpc.callback.threads", 50);
            this.maxCallbackPoolQueueSize = this.conf.getInt("lindorm.rpc.callback.maxqueuesize", 500);
            this.callbackPool = new ThreadPoolExecutor(maxThreads, maxThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), Threads.newDaemonThreadFactory("Client-Callback"));
            this.callbackPool.allowCoreThreadTimeOut(false);
        }
        catch (Throwable t) {
            LOG.error((Object)"Error constructing RpcClient", t);
            throw new LindormException(t);
        }
    }

    public LindormClientConfig getConf() {
        return this.conf;
    }

    synchronized void incCount() {
        ++this.refCount;
    }

    synchronized void decCount() {
        --this.refCount;
    }

    synchronized boolean isZeroReference() {
        return this.refCount == 0;
    }

    public ThreadPoolExecutor getCallbackThreadPool() {
        return this.callbackPool;
    }

    boolean callbackQueueTooBig() {
        return this.getCallbackThreadPool().getQueue().size() > this.maxCallbackPoolQueueSize;
    }

    public Serializer getSerializer() {
        return this.serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(Address addr, Class<?> protocol, String userName, String password) throws LindormException {
        if (!this.running.get()) {
            throw new LindormException(CLIENT_STOP_MESSAGE);
        }
        ConnectionId remoteId = new ConnectionId(addr, protocol, userName, password);
        Connection connection = (Connection)this.connectionsMap.get(remoteId);
        if (connection == null) {
            BoundPoolMap<ConnectionId, Connection> boundPoolMap = this.connectionsMap;
            synchronized (boundPoolMap) {
                connection = (Connection)this.connectionsMap.get(remoteId);
                if (connection == null) {
                    connection = this.newConnection(remoteId);
                    this.connectionsMap.put(remoteId, connection);
                }
            }
        }
        return connection;
    }

    public Object call(Class<?> protocol, Invocation invocation, Address addr, String userName, String password, int rpcTimeout) throws InterruptedException, IOException {
        long remainTime;
        OperationContext operationContext = OperationContext.curOperationContext.get();
        AsyncCallback callback = null;
        if (operationContext != null) {
            callback = operationContext.getCallBack();
        }
        long sendCallStartTime = System.currentTimeMillis();
        int timeout = rpcTimeout;
        if (operationContext != null && (remainTime = operationContext.getRemainingTime(sendCallStartTime)) < (long)timeout) {
            timeout = (int)remainTime;
        }
        Request request = new Request(this, invocation, callback, timeout);
        if (operationContext != null) {
            request.setDoAsUser(operationContext.getDoAsUser());
            request.setSkipConsistencyCheck(operationContext.isSkipConsistencyCheck());
        }
        request.setOperationContext(operationContext);
        ClientCompletableFuture future = this.sendRequest(request, protocol, addr, userName, password);
        if (callback == null) {
            Object v;
            block11: {
                try {
                    Object value;
                    v = value = future.get();
                    if (operationContext == null || callback != null) break block11;
                }
                catch (ExecutionException e) {
                    try {
                        Throwable t = e.getCause();
                        if (t instanceof IOException) {
                            throw (IOException)t;
                        }
                        if (t instanceof RuntimeException) {
                            throw (RuntimeException)t;
                        }
                        throw new IOException(t);
                    }
                    catch (Throwable throwable) {
                        if (operationContext != null && callback == null) {
                            operationContext.markOperationPoint(System.currentTimeMillis() - sendCallStartTime, OperationContext.OperationPointType.WAIT_RESPONSE, addr, request);
                        }
                        throw throwable;
                    }
                }
                operationContext.markOperationPoint(System.currentTimeMillis() - sendCallStartTime, OperationContext.OperationPointType.WAIT_RESPONSE, addr, request);
            }
            return v;
        }
        return null;
    }

    private ClientCompletableFuture sendRequest(Request request, Class<?> protocol, Address addr, String userName, String password) throws InterruptedException, LindormException {
        if (!this.running.get()) {
            request.callback(new LindormException(CLIENT_STOP_MESSAGE));
            return request.getFuture();
        }
        OperationContext clientOperationContext = OperationContext.curOperationContext.get();
        long connectStartTime = clientOperationContext == null ? -1L : System.currentTimeMillis();
        Connection connection = this.getConnection(addr, protocol, userName, password);
        if (connection.isBlocked()) {
            request.callback(new ConnectionBlockedException("Too many in flight request for connection " + connection.toSimpleString() + ", in flight limit request: " + this.requestInFlightLimit));
            return request.getFuture();
        }
        if (this.blockingWhenBusy && !request.isAsyncRetry()) {
            while (!connection.isWritable()) {
                long timeout;
                if (connection.isWriteDisabled() || !request.isBlockable()) {
                    request.callback(new ConnectionBlockedException("Connection " + connection.toSimpleString() + " is not writable for request " + request + ", pending request: " + this.requestInFlightLimit));
                    return request.getFuture();
                }
                connection.waitOnThrottle(this.throttlePause);
                long waitTime = System.currentTimeMillis() - request.getStartTime();
                if (waitTime <= (timeout = Math.min(this.throttleTimeout, (long)(request.getTimeout() / 8)))) continue;
                request.callback(new IOException("Waited " + (System.currentTimeMillis() - request.getStartTime()) + "ms before connection " + connection.toSimpleString() + " is available for request " + request));
                return request.getFuture();
            }
        }
        long sendCallStartTime = System.currentTimeMillis();
        if (clientOperationContext != null) {
            clientOperationContext.markOperationPoint(sendCallStartTime - connectStartTime, OperationContext.OperationPointType.GET_CONNECTION, connection.getHostAndPort());
        }
        request.setWaitTime();
        request.enqueueTimeout(connection, this.rpcTimeoutTimer);
        try {
            connection.sendRequest(request);
        }
        catch (Throwable t) {
            request.callback(t);
            connection.removeRpc(request);
        }
        if (clientOperationContext != null) {
            clientOperationContext.markOperationPoint(System.currentTimeMillis() - sendCallStartTime, OperationContext.OperationPointType.SEND_CALL, connection.getHostAndPort());
        }
        return request.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionFromCache(Connection connection) {
        BoundPoolMap<ConnectionId, Connection> boundPoolMap = this.connectionsMap;
        synchronized (boundPoolMap) {
            boolean removed = this.connectionsMap.removeValue(connection.getMyConnectionId(), connection);
            if (removed) {
                LOG.debug((Object)("remove connection from cache:" + connection));
            }
        }
    }

    private HashedWheelTimer newTimer(LindormClientConfig config, String name) {
        if (config == null) {
            return new HashedWheelTimer(100L, TimeUnit.MICROSECONDS);
        }
        return new HashedWheelTimer(Threads.newDaemonThreadFactory(name), config.getInt("lindorm.rpc.timer.tick", 1000), TimeUnit.MICROSECONDS, config.getInt("lindorm.rpc.timer.tickperwheel", 512));
    }

    protected Connection newConnection(ConnectionId connectionId) {
        NioEventLoopGroup singleThreadGroup = null;
        if (!this.useSharedEventLoopGroup) {
            singleThreadGroup = new NioEventLoopGroup(1);
        }
        final Connection connection = new Connection(this, connectionId, singleThreadGroup);
        Bootstrap b = new Bootstrap();
        if (this.useSharedEventLoopGroup) {
            b.group(this.sharedEventLoopGroup);
        } else {
            b.group(singleThreadGroup);
        }
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("client", (ChannelHandler)connection);
            }
        })).option(ChannelOption.TCP_NODELAY, this.conf.getBoolean("lindorm.rpc.tcpnodelay", true))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.conf.getInt("lindorm.rpc.connect.timeout", 3000))).option(ChannelOption.SO_KEEPALIVE, this.conf.getBoolean("lindorm.rpc.tcpkeepalive", true))).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(this.conf.getInt("lindorm.rpc.writebuffer.watermark.low", 0x200000), this.conf.getInt("lindorm.rpc.writebuffer.watermark.high", 0x400000)));
        ChannelFuture res = b.connect(connectionId.getHostname(), connectionId.getPort());
        connection.setConnectFuture(res);
        LOG.debug((Object)("Connection created :" + connection));
        return connection;
    }

    public void shutdown() {
        LOG.warn((Object)("Shutdown client: " + this));
        if (!this.running.compareAndSet(true, false)) {
            LOG.warn((Object)("Already shutdown, + " + this));
            return;
        }
        this.disconnectEverything();
        this.rpcTimeoutTimer.stop();
        if (this.sharedEventLoopGroup != null) {
            try {
                EventLoopGroupShutdownThread sharedEventLoopGroupThread = new EventLoopGroupShutdownThread(this.sharedEventLoopGroup);
                sharedEventLoopGroupThread.start();
                sharedEventLoopGroupThread.join(1000L);
            }
            catch (Throwable t) {
                LOG.error((Object)("Error happened when closing " + this), t);
            }
        }
        this.callbackPool.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectEverything() {
        ArrayList toClean = new ArrayList();
        BoundPoolMap<ConnectionId, Connection> boundPoolMap = this.connectionsMap;
        synchronized (boundPoolMap) {
            toClean.addAll(this.connectionsMap.values());
            this.connectionsMap.clear();
        }
        for (Connection connection : toClean) {
            connection.close("rpc Client is shut down ");
        }
    }

    public void disconnect(ConnectionId connectionId) {
        Collection connectionsToDisconnect = this.connectionsMap.values(connectionId);
        if (connectionsToDisconnect.size() > 0) {
            for (Connection connection : connectionsToDisconnect) {
                connection.close("server is no longer alive ");
            }
        }
    }

    public void updateConfiguration(LindormClientConfig config) {
        this.conf = config;
        this.throttlePause = config.getLong("lindorm.rpc.throttle.pause.time", 10L);
        this.throttleTimeout = config.getLong("lindorm.rpc.throttle.timeout", 200L);
        this.requestInFlightLimit = config.getInt("lindorm.rpc.request.inflight.limit", 0);
        this.requestPendingLimit = config.getInt("lindorm.rpc.request.pending.limit", 16);
        this.connectionBlockTime = this.conf.getInt("lindorm.rpc.connection.block.time", 5000);
    }

    protected static class ConnectionId {
        final Address address;
        final String userName;
        final String password;
        final Class<?> protocol;
        private static final int PRIME = 16777619;

        ConnectionId(Address address, Class<?> protocol, String userName, String password) {
            this.protocol = protocol;
            this.address = address;
            this.userName = userName;
            this.password = password;
        }

        Address getAddress() {
            return this.address;
        }

        String getHostname() {
            return this.address.getHostname();
        }

        int getPort() {
            return this.address.getPort();
        }

        Class<?> getProtocol() {
            return this.protocol;
        }

        String getUserName() {
            return this.userName;
        }

        String getPassword() {
            return this.password;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ConnectionId)) {
                return false;
            }
            ConnectionId id = (ConnectionId)obj;
            return this.address.equals(id.address) && this.protocol == id.protocol && (this.userName == null ? id.userName == null : this.userName.equals(id.userName)) && (this.password == null ? id.password == null : this.password.equals(id.password));
        }

        public int hashCode() {
            return this.address.hashCode() + 16777619 * (16777619 * System.identityHashCode(this.protocol) ^ (this.userName == null ? 0 : this.userName.hashCode()) + 16777619 * (this.password == null ? 0 : this.password.hashCode()));
        }
    }
}

