/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.meta;

import com.alibaba.lindorm.client.core.meta.TableKey;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.meta.TableMetaChangeEventHandler;
import com.alibaba.lindorm.client.exception.IllegalRequestException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.LindormTableDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableMetaCache
implements Iterable<TableMeta> {
    private static final Log LOG = LogFactory.getLog(TableMetaCache.class);
    private Map<TableKey, TableMeta> cache = new ConcurrentHashMap<TableKey, TableMeta>();
    private volatile List<TableMetaChangeEventHandler> metaChangeHandlers = new ArrayList<TableMetaChangeEventHandler>(1);
    private ThreadPoolExecutor notifyThreadPool = new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("TableMetaChangeNotifier"));

    public TableMetaCache() {
        this.notifyThreadPool.allowCoreThreadTimeOut(true);
    }

    public TableMeta getTable(String namespace, String tableName) {
        TableKey key = new TableKey(namespace, tableName);
        return this.cache.get(key);
    }

    public void addTable(TableMeta table) throws LindormException {
        TableKey key = new TableKey(table.getNamespace(), table.getTableName());
        this.cache.put(key, table);
        this.notifyMetaChanged(table);
    }

    public void removeTable(String namespace, String tableName) throws LindormException {
        TableKey key = new TableKey(namespace, tableName);
        this.cache.remove(key);
        this.notifyMetaRemoved(namespace, tableName);
    }

    @Override
    public Iterator<TableMeta> iterator() {
        return new Iterator<TableMeta>(){
            private Iterator<Map.Entry<TableKey, TableMeta>> iter;
            {
                this.iter = TableMetaCache.this.cache.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public TableMeta next() {
                return this.iter.next().getValue();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator#remove()");
            }
        };
    }

    public synchronized void registerMetaChangeHandler(TableMetaChangeEventHandler handler) throws IllegalRequestException {
        if (handler == null) {
            throw new IllegalRequestException("Table meta change event handler must not be null.");
        }
        String name = handler.getName();
        for (TableMetaChangeEventHandler h : this.metaChangeHandlers) {
            if (!h.getName().equals(name)) continue;
            throw new IllegalRequestException("Detect duplicate table meta change event handler [" + name + "].");
        }
        ArrayList<TableMetaChangeEventHandler> copy = new ArrayList<TableMetaChangeEventHandler>(this.metaChangeHandlers);
        copy.add(handler);
        this.metaChangeHandlers = copy;
    }

    private void notifyMetaChanged(final TableMeta newMeta) {
        try {
            if (this.metaChangeHandlers.size() == 0) {
                return;
            }
            final LindormTableDescriptor desc = TableMeta.buildLindormTableDescriptor(newMeta);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    for (TableMetaChangeEventHandler handler : TableMetaCache.this.metaChangeHandlers) {
                        try {
                            handler.handleMetaChanged(desc);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Failed notify meta change for handler " + handler.getName() + ", meta=" + newMeta.getNamespace() + "." + newMeta.getTableName()), t);
                        }
                    }
                }
            };
            this.notifyThreadPool.execute(r);
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed notify meta change " + newMeta.getNamespace() + "." + newMeta.getTableName()), t);
        }
    }

    private void notifyMetaRemoved(final String namespace, final String tableName) {
        try {
            if (this.metaChangeHandlers.size() == 0) {
                return;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    for (TableMetaChangeEventHandler handler : TableMetaCache.this.metaChangeHandlers) {
                        try {
                            handler.handleMetaRemoved(namespace, tableName);
                        }
                        catch (Throwable t) {
                            LOG.error((Object)("Failed notify meta remove for handler " + handler.getName() + ", meta=" + namespace + "." + tableName), t);
                        }
                    }
                }
            };
            this.notifyThreadPool.execute(r);
        }
        catch (Throwable t) {
            LOG.error((Object)("Failed notify meta remove for " + namespace + "." + tableName), t);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DaemonThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!t.isDaemon()) {
                t.setDaemon(true);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

