/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.metrics;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.ipc.ConfigObserver;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.meta.TableKey;
import com.alibaba.lindorm.client.core.metrics.TableMetrics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableMetricsManager
implements ConfigObserver {
    private static final Log LOG = LogFactory.getLog((String)TableMetricsManager.class.getName());
    public static final List<OperationContext.OperationType> RWTYPES = Collections.unmodifiableList(new ArrayList<OperationContext.OperationType>(Arrays.asList(OperationContext.OperationType.UPSERT, OperationContext.OperationType.SELECT, OperationContext.OperationType.DELETE, OperationContext.OperationType.WPUT, OperationContext.OperationType.WGET, OperationContext.OperationType.WSCAN, OperationContext.OperationType.WINCREMENT, OperationContext.OperationType.WAPPEND, OperationContext.OperationType.WDELETE, OperationContext.OperationType.WEXIST)));
    private boolean metricsEnabled;
    private LindormClientConfig config;
    private long period;
    private long expireTime;
    private boolean printMetrics;
    private boolean closed = false;
    private MetricsBackgroundThread backgroundThread;
    private ConcurrentHashMap<TableKey, TableMetrics> tableMetricsMap = new ConcurrentHashMap();

    public TableMetricsManager(LindormClientConfig config) {
        this.onConfigChange(config);
        this.backgroundThread = new MetricsBackgroundThread();
        this.backgroundThread.setDaemon(true);
        this.backgroundThread.start();
    }

    public boolean hasTableMetrics(String namespace, String table) {
        if (namespace == null || table == null) {
            return false;
        }
        TableKey tableKey = new TableKey(namespace, table);
        return this.tableMetricsMap.containsKey(tableKey);
    }

    public TableMetrics getTableMetrics(String namespace, String table) {
        TableMetrics oldTableMetrics;
        if (namespace == null || table == null) {
            return null;
        }
        TableKey tableKey = new TableKey(namespace, table);
        TableMetrics tableMetrics = this.tableMetricsMap.get(tableKey);
        if (tableMetrics == null && (oldTableMetrics = this.tableMetricsMap.putIfAbsent(tableKey, tableMetrics = new TableMetrics(namespace, table, RWTYPES))) != null) {
            tableMetrics = oldTableMetrics;
        }
        return tableMetrics;
    }

    public void onOperationSuccess(String namespace, String table, OperationContext.OperationType type, long took, int rowCount) {
        if (!this.metricsEnabled) {
            return;
        }
        TableMetrics tableMetrics = this.getTableMetrics(namespace, table);
        if (tableMetrics == null) {
            return;
        }
        tableMetrics.onSuccess(type, took, rowCount);
    }

    public void onOperationError(String namespace, String table, OperationContext.OperationType type, Throwable t) {
        if (!this.metricsEnabled) {
            return;
        }
        TableMetrics tableMetrics = this.getTableMetrics(namespace, table);
        if (tableMetrics == null) {
            return;
        }
        tableMetrics.onError(type, t);
    }

    @Override
    public void onConfigChange(LindormClientConfig config) {
        this.config = config;
        this.metricsEnabled = config.getBoolean("lindorm.client.metrics.enabled", true);
        this.period = config.getLong("lindorm.client.metrics.period", 15000L);
        this.printMetrics = config.getBoolean("lindorm.client.metrics.print.enabled", false);
        this.expireTime = config.getLong("lindorm.client.metrics.expire.time", 43200000L);
    }

    public void close() {
        this.closed = true;
        if (this.backgroundThread != null) {
            this.backgroundThread.interrupt();
        }
    }

    class MetricsBackgroundThread
    extends Thread {
        public MetricsBackgroundThread() {
            this.setName("MetricsBackgroundThread");
        }

        @Override
        public void run() {
            while (!TableMetricsManager.this.closed) {
                try {
                    Thread.sleep(TableMetricsManager.this.period);
                    long now = System.currentTimeMillis();
                    long timeToExpire = now - TableMetricsManager.this.expireTime;
                    for (Map.Entry entry : TableMetricsManager.this.tableMetricsMap.entrySet()) {
                        TableMetrics tableMetrics = (TableMetrics)entry.getValue();
                        tableMetrics.snapshot(now, timeToExpire, TableMetricsManager.this.printMetrics);
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        LOG.error((Object)"MetricsBackgroundThread exits since InterruptedException");
                        return;
                    }
                    LOG.error((Object)"Error happened when snapshot metrics", t);
                }
            }
            LOG.info((Object)"MetricsBackgroundThread exits");
        }
    }
}

