/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.utils;

import com.alibaba.hbase.com.taobao.middleware.logger.Level;
import com.alibaba.hbase.com.taobao.middleware.logger.Logger;
import com.alibaba.hbase.com.taobao.middleware.logger.LoggerFactory;
import com.alibaba.hbase.com.taobao.middleware.logger.support.LoggerHelper;
import com.alibaba.lindorm.client.LindormClientConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientEnvLogUtil {
    private static final Log LOG = LogFactory.getLog(ClientEnvLogUtil.class);
    public static boolean clientEnvLogEnabled = true;
    public static boolean clientLogAsyncEnabled = true;
    public static int LOG_MAX_BACKUP_INDEX = 4;
    public static String LOG_MAX_FILE_SIZE = "256MB";
    public static String LOG_PREFIX = "com.alibaba.lindorm";

    public static void setEnabled(boolean enabled) {
        clientEnvLogEnabled = enabled;
    }

    static Level getLogLevel(String level) {
        if (level == null) {
            return Level.INFO;
        }
        if ("ERROR".equals(level = level.trim().toUpperCase())) {
            return Level.ERROR;
        }
        if ("WARN".equals(level)) {
            return Level.WARN;
        }
        if ("DEBUG".equals(level)) {
            return Level.DEBUG;
        }
        if ("OFF".equals(level)) {
            return Level.OFF;
        }
        return Level.INFO;
    }

    public static void initClientLog() {
        try {
            if (!clientEnvLogEnabled) {
                LOG.info((Object)"No need to set client env log.");
                return;
            }
            LindormClientConfig config = LindormClientConfig.create();
            if (!config.getBoolean("lindorm.client.redirectlog", true)) {
                return;
            }
            clientLogAsyncEnabled = config.getBoolean("lindorm.client.asynclog", true);
            LoggerHelper.setPattern("lindorm-client", "%d{ISO8601} [%t] %p %c: %m%n");
            Level logLevel = ClientEnvLogUtil.resetLoggerLevel(config);
            ClientEnvLogUtil.resetLogger();
            LOG.info((Object)("Successfully setting lindorm-client log properties. Log Level=" + logLevel.getName() + ", isAsync " + clientLogAsyncEnabled));
        }
        catch (Throwable t) {
            System.out.println("Failed loading client environment log because of " + t.getMessage());
        }
    }

    public static Level resetLoggerLevel(LindormClientConfig config) {
        Level logLevel = ClientEnvLogUtil.getLogLevel(config.get("lindorm.client.log.level"));
        Logger logger = LoggerFactory.getLogger(LOG_PREFIX);
        logger.setLevel(logLevel);
        LOG.info((Object)("Successfully set Log Level to " + logLevel.getName()));
        return logLevel;
    }

    static void resetLogger() {
        Logger logger = LoggerFactory.getLogger(LOG_PREFIX);
        logger.setAdditivity(false);
        logger.activateAppenderWithSizeRolling("lindorm-client", "lindorm-client.log", "GBK", LOG_MAX_FILE_SIZE, LOG_MAX_BACKUP_INDEX);
        if (clientLogAsyncEnabled) {
            logger.activateAsync(1024, 0);
        }
    }
}

