/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseConstants;
import com.alibaba.hbase.haclient.ClusterSwitchUtil;
import com.alibaba.hbase.haclient.dualservice.AutoSwitch;
import com.alibaba.hbase.haclient.dualservice.DualExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AliHBaseMultiAdmin;
import org.apache.hadoop.hbase.client.AliHBaseMultiBufferedMutator;
import org.apache.hadoop.hbase.client.AliHBaseMultiTable;
import org.apache.hadoop.hbase.client.AliHBaseUEAdmin;
import org.apache.hadoop.hbase.client.AliHBaseUEClusterConnection;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorImpl;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HRegionLocator;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableBuilderBase;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Threads;

public class AliHBaseMultiClusterConnection
implements ClusterConnection,
Closeable {
    private static final Log LOG = LogFactory.getLog(AliHBaseMultiClusterConnection.class);
    private volatile ClusterConnection activeConnectionImpl;
    private volatile ClusterConnection standbyConnectionImpl;
    protected volatile long switchCount = 0L;
    protected volatile Configuration conf;
    protected volatile Configuration standbyConf;
    protected User user;
    protected volatile boolean closed = false;
    protected volatile boolean aborted = false;
    protected volatile boolean cleanupPool = false;
    protected volatile boolean cleanupStandbyPool = false;
    private ExecutorService batchPool = null;
    private ExecutorService standbyBatchPool = null;
    private AsyncProcess asyncProcess = null;
    private AliHBaseConstants.ClusterType activeClusterType = null;
    private AliHBaseConstants.ClusterType standbyClusterType = null;
    protected boolean dualServiceEnable;
    protected DualExecutor dualExecutor;
    protected AutoSwitch autoSwitch;

    protected AliHBaseMultiClusterConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.conf = conf;
        this.user = user;
        this.batchPool = pool;
        this.dualServiceEnable = conf.getBoolean("hbase.dualservice.enable", false);
    }

    protected ClusterConnection createConnection(Configuration conf, User user, ExecutorService pool) throws IOException {
        Object newClusterConnection = null;
        AliHBaseConstants.ClusterType clusterType = this.getClusterTypeFromConf(conf);
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            newClusterConnection = new ConnectionImplementation(conf, pool, user);
        } else if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            newClusterConnection = new AliHBaseUEClusterConnection(conf, pool, user);
        } else {
            throw new IOException("Cluster is null, can not create connection");
        }
        return newClusterConnection;
    }

    protected AsyncProcess createAsyncProcess() {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new AsyncProcess((ClusterConnection)this, this.conf, RpcRetryingCallerFactory.instantiate((Configuration)this.conf, (ServerStatisticTracker)this.getStatisticsTracker()), RpcControllerFactory.instantiate((Configuration)this.conf));
        }
        return null;
    }

    protected ExecutorService getThreadPool(int maxThreads, int coreThreads, String nameHint, BlockingQueue<Runnable> passedWorkQueue) {
        if (maxThreads == 0) {
            maxThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        if (coreThreads == 0) {
            coreThreads = Runtime.getRuntime().availableProcessors() * 8;
        }
        long keepAliveTime = this.conf.getLong("hbase.hconnection.threads.keepalivetime", 60L);
        BlockingQueue<Runnable> workQueue = passedWorkQueue;
        if (workQueue == null) {
            workQueue = new LinkedBlockingQueue<Runnable>(maxThreads * this.conf.getInt("hbase.client.max.total.tasks", 100));
        }
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(coreThreads, maxThreads, keepAliveTime, TimeUnit.SECONDS, workQueue, Threads.newDaemonThreadFactory((String)(this.toString() + nameHint)));
        tpe.allowCoreThreadTimeOut(true);
        return tpe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getBatchPool() {
        if (this.batchPool == null) {
            AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
            synchronized (aliHBaseMultiClusterConnection) {
                if (this.batchPool == null) {
                    this.batchPool = this.getThreadPool(this.conf.getInt("hbase.hconnection.threads.max", 256), this.conf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                    this.cleanupPool = true;
                }
            }
        }
        return this.batchPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getStandbyBatchPool() {
        if (this.standbyBatchPool == null) {
            AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
            synchronized (aliHBaseMultiClusterConnection) {
                if (this.standbyBatchPool == null) {
                    this.standbyBatchPool = this.getThreadPool(this.standbyConf.getInt("hbase.hconnection.threads.max", 256), this.standbyConf.getInt("hbase.hconnection.threads.core", 256), "-shared-", null);
                    this.cleanupStandbyPool = true;
                }
            }
        }
        return this.standbyBatchPool;
    }

    protected synchronized void onChangeCluster(Configuration activeConf, Configuration standbyConf) throws IOException {
        this.conf = new Configuration(activeConf);
        String activeConnectKey = ClusterSwitchUtil.getConnectKey(activeConf);
        AliHBaseConstants.ClusterType localActiveType = this.getClusterTypeFromConf(this.conf);
        if (standbyConf == null) {
            AliHBaseConstants.ClusterType lastClusterType = this.activeClusterType;
            if (lastClusterType == null) {
                lastClusterType = localActiveType;
            }
            ClusterConnection lastConnection = this.activeConnectionImpl;
            LOG.info((Object)("Creating new connection to " + activeConnectKey));
            this.activeConnectionImpl = this.createConnection(activeConf, this.user, this.getBatchPool());
            this.activeClusterType = localActiveType;
            if (lastConnection != null && !lastConnection.isClosed() && lastClusterType == AliHBaseConstants.ClusterType.HBASE) {
                LOG.info((Object)("Closing old connection on " + ClusterSwitchUtil.getConnectKey(lastConnection.getConfiguration()) + " since destination cluster is changed"));
                lastConnection.close();
            }
        } else {
            this.standbyConf = new Configuration(standbyConf);
            String standbyConnectKey = ClusterSwitchUtil.getConnectKey(standbyConf);
            AliHBaseConstants.ClusterType localStandbyType = this.getClusterTypeFromConf(standbyConf);
            ClusterConnection tempConnection = this.activeConnectionImpl;
            this.activeConnectionImpl = this.standbyConnectionImpl;
            this.standbyConnectionImpl = tempConnection;
            if (this.activeConnectionImpl == null || this.activeConnectionImpl.isClosed()) {
                LOG.info((Object)("Creating new active connection to " + activeConnectKey));
                try {
                    this.activeConnectionImpl = this.createConnection(activeConf, this.user, this.getBatchPool());
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Create active connection failed with error : " + t));
                    LOG.warn((Object)"Disable dual service, try connect standby cluster");
                    standbyConf.setBoolean("hbase.dualservice.enable", false);
                    this.onChangeCluster(standbyConf, null);
                }
            }
            if (this.standbyConnectionImpl == null || this.standbyConnectionImpl.isClosed()) {
                LOG.info((Object)("Creating new standby connection to " + standbyConnectKey));
                try {
                    this.standbyConnectionImpl = this.createConnection(standbyConf, this.user, this.getStandbyBatchPool());
                }
                catch (Throwable t) {
                    LOG.warn((Object)("Create standby connection failed with error : " + t));
                }
            }
            this.activeClusterType = localActiveType;
            this.standbyClusterType = localStandbyType;
            if (this.autoSwitch != null) {
                this.autoSwitch.reset();
            }
        }
        ++this.switchCount;
    }

    private AliHBaseConstants.ClusterType getClusterTypeFromConf(Configuration conf) {
        return AliHBaseConstants.ClusterType.valueOf(conf.get("hbase.cluster.type"));
    }

    public long getSwitchCount() {
        return this.switchCount;
    }

    @Deprecated
    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return this.activeConnectionImpl.isMasterRunning();
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.activeConnectionImpl.isTableAvailable(tableName, splitKeys);
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.locateRegion(tableName, row);
    }

    public void clearRegionCache() {
        this.activeConnectionImpl.clearRegionCache();
    }

    public void cacheLocation(TableName tableName, RegionLocations regionLocations) {
        this.activeConnectionImpl.cacheLocation(tableName, regionLocations);
    }

    public void clearRegionCache(TableName tableName) {
        this.activeConnectionImpl.clearRegionCache(tableName);
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
        this.activeConnectionImpl.deleteCachedRegionLocation(location);
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.activeConnectionImpl.relocateRegion(tableName, row);
    }

    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        return this.activeConnectionImpl.relocateRegion(tableName, row, replicaId);
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
        this.activeConnectionImpl.updateCachedLocations(tableName, regionName, rowkey, exception, source);
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        return this.activeConnectionImpl.locateRegion(regionName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName);
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        return this.activeConnectionImpl.locateRegions(tableName, useCache, offlined);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry, 0);
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.activeConnectionImpl.locateRegion(tableName, row, useCache, retry, replicaId);
    }

    public MasterKeepAliveConnection getMaster() throws IOException {
        return this.activeConnectionImpl.getMaster();
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return this.activeConnectionImpl.getAdmin(serverName);
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        return this.activeConnectionImpl.getClient(serverName);
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.activeConnectionImpl.getRegionLocation(tableName, row, reload);
    }

    public void clearCaches(ServerName sn) {
        this.activeConnectionImpl.clearCaches(sn);
    }

    public NonceGenerator getNonceGenerator() {
        return this.activeConnectionImpl.getNonceGenerator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncProcess getAsyncProcess() {
        if (this.asyncProcess != null) {
            return this.asyncProcess;
        }
        AliHBaseMultiClusterConnection aliHBaseMultiClusterConnection = this;
        synchronized (aliHBaseMultiClusterConnection) {
            if (this.asyncProcess != null) {
                return this.asyncProcess;
            }
            this.asyncProcess = this.createAsyncProcess();
            return this.asyncProcess;
        }
    }

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return this.activeConnectionImpl.getNewRpcRetryingCallerFactory(conf);
    }

    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return this.activeConnectionImpl.getRpcRetryingCallerFactory();
    }

    public RpcControllerFactory getRpcControllerFactory() {
        return this.activeConnectionImpl.getRpcControllerFactory();
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return this.activeConnectionImpl.getConnectionConfiguration();
    }

    public ServerStatisticTracker getStatisticsTracker() {
        return this.activeConnectionImpl.getStatisticsTracker();
    }

    public ClientBackoffPolicy getBackoffPolicy() {
        return this.activeConnectionImpl.getBackoffPolicy();
    }

    public MetricsConnection getConnectionMetrics() {
        return this.activeConnectionImpl.getConnectionMetrics();
    }

    public boolean hasCellBlockSupport() {
        return this.activeConnectionImpl.hasCellBlockSupport();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTableBuilder(tableName, this.getBatchPool()).build();
    }

    public TableState getTableState(TableName tableName) throws IOException {
        return this.activeConnectionImpl.getTableState(tableName);
    }

    public AdminProtos.AdminService.BlockingInterface getAdminForMaster() throws IOException {
        return this.activeConnectionImpl.getAdminForMaster();
    }

    public HTable getHTable(TableName tableName) {
        return this.getHTable(tableName, this.getBatchPool(), this.activeClusterType, this, false);
    }

    public HTable getHTableWithStandbyConnection(TableName tableName) {
        return this.getHTable(tableName, this.getStandbyBatchPool(), this.standbyClusterType, this.standbyConnectionImpl, true);
    }

    public HTable getHTable(TableName tableName, ExecutorService pool, AliHBaseConstants.ClusterType clusterType, ClusterConnection connection, boolean isStandby) {
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new HTable(connection, new TableBuilderBase(tableName, connection.getConnectionConfiguration()){

                public Table build() {
                    return null;
                }
            }, this.getRpcRetryingCallerFactory(), this.getRpcControllerFactory(), pool);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            if (!isStandby) {
                return (HTable)this.activeConnectionImpl.getTableBuilder(tableName, pool).build();
            }
            if (this.standbyConnectionImpl != null && !this.standbyConnectionImpl.isClosed()) {
                return (HTable)this.standbyConnectionImpl.getTableBuilder(tableName, pool).build();
            }
            return null;
        }
        LOG.error((Object)"getHTable can not get cluster type, return null");
        return null;
    }

    public TableBuilder getTableBuilder(TableName tableName, final ExecutorService pool) {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new TableBuilderBase(tableName, this.getConnectionConfiguration()){

                public Table build() {
                    HTable htable = new HTable((ClusterConnection)AliHBaseMultiClusterConnection.this, (TableBuilderBase)this, AliHBaseMultiClusterConnection.this.getRpcRetryingCallerFactory(), AliHBaseMultiClusterConnection.this.getRpcControllerFactory(), pool);
                    return new AliHBaseMultiTable(this.tableName, AliHBaseMultiClusterConnection.this, htable);
                }
            };
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return new TableBuilderBase(tableName, this.getConnectionConfiguration()){

                public Table build() {
                    HTable htable = (HTable)AliHBaseMultiClusterConnection.this.activeConnectionImpl.getTableBuilder(this.tableName, pool).build();
                    return new AliHBaseMultiTable(this.tableName, AliHBaseMultiClusterConnection.this, htable);
                }
            };
        }
        LOG.error((Object)"getTableBuilder can not get cluster type, return null");
        return null;
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.getTableBuilder(tableName, pool).build();
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new HRegionLocator(tableName, (ClusterConnection)this);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return this.activeConnectionImpl.getRegionLocator(tableName);
        }
        LOG.error((Object)"getRegionLocator ClusterType is null , return null");
        return null;
    }

    public Admin getAdmin() throws IOException {
        HBaseAdmin hbaseAdmin = this.getHBaseAdmin();
        return new AliHBaseMultiAdmin(this, hbaseAdmin);
    }

    public HBaseAdmin getHBaseAdmin() throws IOException {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            return new HBaseAdmin((ClusterConnection)this);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return (AliHBaseUEAdmin)this.activeConnectionImpl.getAdmin();
        }
        LOG.error((Object)"getHBaseAdmin ClusterType is null , return null");
        return null;
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        return this.activeConnectionImpl.isTableEnabled(tableName);
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        return this.activeConnectionImpl.isTableDisabled(tableName);
    }

    public int getCurrentNrHRS() throws IOException {
        return this.activeConnectionImpl.getCurrentNrHRS();
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        BufferedMutator bufferedMutator = this.getBufferedMutatorByType(params);
        return new AliHBaseMultiBufferedMutator(this, bufferedMutator, params);
    }

    public BufferedMutator getBufferedMutatorByType(BufferedMutatorParams params) throws IOException {
        AliHBaseConstants.ClusterType clusterType = AliHBaseConstants.ClusterType.valueOf(this.conf.get("hbase.cluster.type"));
        if (clusterType == AliHBaseConstants.ClusterType.HBASE) {
            if (params.getTableName() == null) {
                throw new IllegalArgumentException("TableName cannot be null.");
            }
            if (params.getPool() == null) {
                params.pool((ExecutorService)HTable.getDefaultExecutor((Configuration)this.getConfiguration()));
            }
            if (params.getWriteBufferSize() == -1L) {
                params.writeBufferSize(this.getConnectionConfiguration().getWriteBufferSize());
            }
            if (params.getMaxKeyValueSize() == -1) {
                params.maxKeyValueSize(this.getConnectionConfiguration().getMaxKeyValueSize());
            }
            return new BufferedMutatorImpl((ClusterConnection)this, this.getRpcRetryingCallerFactory(), this.getRpcControllerFactory(), params);
        }
        if (clusterType == AliHBaseConstants.ClusterType.HBASEUE) {
            return this.activeConnectionImpl.getBufferedMutator(params);
        }
        LOG.error((Object)"getBufferedMutator ClusterType is null , return null");
        return null;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.activeConnectionImpl != null) {
            this.activeConnectionImpl.close();
        }
        if (this.standbyConnectionImpl != null) {
            this.standbyConnectionImpl.close();
        }
        this.shutdownBatchPool(this.batchPool, this.cleanupPool);
        this.shutdownBatchPool(this.standbyBatchPool, this.cleanupStandbyPool);
        if (this.dualExecutor != null) {
            this.dualExecutor.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void abort(String why, Throwable throwable) {
        this.activeConnectionImpl.abort(why, throwable);
        if (this.standbyConnectionImpl != null) {
            this.standbyConnectionImpl.abort(why, throwable);
        }
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.activeConnectionImpl.isAborted();
    }

    private void shutdownBatchPool(ExecutorService pool, boolean cleanupPool) {
        if (!cleanupPool || pool.isShutdown()) {
            return;
        }
        pool.shutdown();
        try {
            if (!pool.awaitTermination(10L, TimeUnit.SECONDS)) {
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            pool.shutdownNow();
        }
    }

    public Configuration getOriginalConf() {
        return this.conf;
    }

    public DualExecutor getDualExecutor() {
        return this.dualExecutor;
    }
}

