/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.alibaba.hbase.client.AliHBaseUEClientService;
import com.alibaba.hbase.client.AliHBaseUEConnection;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.AliHBaseUETable;
import org.apache.hadoop.hbase.client.AsyncProcess;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ConnectionConfiguration;
import org.apache.hadoop.hbase.client.MasterKeepAliveConnection;
import org.apache.hadoop.hbase.client.MetricsConnection;
import org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hadoop.hbase.client.ServerStatisticTracker;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.client.backoff.ClientBackoffPolicy;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;

public class AliHBaseUEClusterConnection
implements ClusterConnection {
    private AliHBaseUEConnection connection;

    public AliHBaseUEClusterConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
        this.connection = new AliHBaseUEConnection(conf, pool, user);
    }

    public AliHBaseUEClusterConnection(AliHBaseUEConnection connection) {
        this.connection = connection;
    }

    public void setCULimit(int cuLimit) {
        this.connection.setCULimit(cuLimit);
    }

    public boolean isMasterRunning() throws MasterNotRunningException, ZooKeeperConnectionException {
        return true;
    }

    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(tableName, splitKeys);
            return bl;
        }
    }

    public boolean isTableEnabled(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableAvailable(tableName);
            return bl;
        }
    }

    public boolean isTableDisabled(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            boolean bl = admin.isTableDisabled(tableName);
            return bl;
        }
    }

    public TableState getTableState(TableName tableName) throws IOException {
        try (Admin admin = this.getAdmin();){
            if (this.isTableEnabled(tableName)) {
                TableState tableState = new TableState(tableName, TableState.State.ENABLED);
                return tableState;
            }
            if (this.isTableDisabled(tableName)) {
                TableState tableState = new TableState(tableName, TableState.State.DISABLED);
                return tableState;
            }
            TableState tableState = new TableState(tableName, TableState.State.DISABLING);
            return tableState;
        }
    }

    public HRegionLocation locateRegion(TableName tableName, byte[] row) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            HRegionLocation hRegionLocation = table.getRegionLocation(row);
            return hRegionLocation;
        }
    }

    public void clearRegionCache() {
    }

    public void cacheLocation(TableName tableName, RegionLocations location) {
    }

    public void clearRegionCache(TableName tableName) {
    }

    public void deleteCachedRegionLocation(HRegionLocation location) {
    }

    public HRegionLocation relocateRegion(TableName tableName, byte[] row) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public RegionLocations relocateRegion(TableName tableName, byte[] row, int replicaId) throws IOException {
        RegionLocations regionLocations = new RegionLocations(new HRegionLocation[]{this.locateRegion(tableName, row)});
        return regionLocations;
    }

    public void updateCachedLocations(TableName tableName, byte[] regionName, byte[] rowkey, Object exception, ServerName source) {
    }

    public HRegionLocation locateRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("locateRegion by region name is not supported");
    }

    public List<HRegionLocation> locateRegions(TableName tableName) throws IOException {
        return this.locateRegions(tableName, false, false);
    }

    public List<HRegionLocation> locateRegions(TableName tableName, boolean useCache, boolean offlined) throws IOException {
        try (AliHBaseUETable table = (AliHBaseUETable)this.getTable(tableName);){
            List<HRegionLocation> list = table.getAllRegionLocations();
            return list;
        }
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry) throws IOException {
        RegionLocations regionLocations = new RegionLocations(new HRegionLocation[]{this.locateRegion(tableName, row)});
        return regionLocations;
    }

    public RegionLocations locateRegion(TableName tableName, byte[] row, boolean useCache, boolean retry, int replicaId) throws IOException {
        return this.locateRegion(tableName, row, useCache, retry);
    }

    public MasterKeepAliveConnection getMaster() throws IOException {
        return null;
    }

    public AdminProtos.AdminService.BlockingInterface getAdminForMaster() throws IOException {
        return null;
    }

    public AdminProtos.AdminService.BlockingInterface getAdmin(ServerName serverName) throws IOException {
        return null;
    }

    public ClientProtos.ClientService.BlockingInterface getClient(ServerName serverName) throws IOException {
        return new AliHBaseUEClientService(this.connection);
    }

    public HRegionLocation getRegionLocation(TableName tableName, byte[] row, boolean reload) throws IOException {
        return this.locateRegion(tableName, row);
    }

    public void clearCaches(ServerName sn) {
    }

    public NonceGenerator getNonceGenerator() {
        return null;
    }

    public AsyncProcess getAsyncProcess() {
        return null;
    }

    public RpcRetryingCallerFactory getNewRpcRetryingCallerFactory(Configuration conf) {
        return null;
    }

    public RpcRetryingCallerFactory getRpcRetryingCallerFactory() {
        return null;
    }

    public RpcControllerFactory getRpcControllerFactory() {
        return null;
    }

    public ConnectionConfiguration getConnectionConfiguration() {
        return new ConnectionConfiguration(this.connection.getConfiguration());
    }

    public ServerStatisticTracker getStatisticsTracker() {
        return null;
    }

    public ClientBackoffPolicy getBackoffPolicy() {
        return null;
    }

    public MetricsConnection getConnectionMetrics() {
        return null;
    }

    public boolean hasCellBlockSupport() {
        return false;
    }

    public int getCurrentNrHRS() throws IOException {
        return 0;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.connection.getTable(tableName);
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return this.connection.getTable(tableName, pool);
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.connection.getBufferedMutator(tableName);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        return this.connection.getBufferedMutator(params);
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        return this.connection.getRegionLocator(tableName);
    }

    public Admin getAdmin() throws IOException {
        return this.connection.getAdmin();
    }

    public void close() throws IOException {
        this.connection.close();
    }

    public boolean isClosed() {
        return this.connection.isClosed();
    }

    public TableBuilder getTableBuilder(TableName tableName, ExecutorService pool) {
        return this.connection.getTableBuilder(tableName, pool);
    }

    public void abort(String why, Throwable e) {
        this.connection.abort(why, e);
    }

    public boolean isAborted() {
        return this.connection.isAborted();
    }
}

