package com.alibaba.hbase.haclient;

public class SwitchCommand implements Comparable<SwitchCommand>{
  public static final SwitchCommand NOCOMMAND = new SwitchCommand(null, Long.MIN_VALUE);


  private String clusterKey;
  private long ts;

  public SwitchCommand(String clusterKey, long ts) {
    this.clusterKey = clusterKey;
    this.ts = ts;
  }

  public long getTs() {
    return ts;
  }

  public String getClusterKey() {
    return clusterKey;
  }


  /**
   * If no cluster is provided, or the TS is negative(which means the redirect node is gone)
   * We need to switch back to back. But the MultiClusterConnectionImpl also will compare the
   * ts, if the current ts is bigger than this one, a switch won't happen
   * @return
   */
  public boolean isSwitchBackToMaster() {
    return ts < 0 || clusterKey == null || clusterKey.isEmpty();
  }

  public String toString() {
    return "{SwitchCommand: clusterkey=" + clusterKey + ", ts=" + ts+"}";
  }

  @Override
  public int compareTo(SwitchCommand o) {
    long compare = ts - o.ts;
    if (compare != 0) {
      return (int) compare;
    }
    if (this.clusterKey == null) {
      return o.clusterKey == null ? 0 : -1;
    } else {
      return this.clusterKey.compareTo(o.clusterKey);
    }
  }

  @Override
  public boolean equals(Object obj) {
    if (obj instanceof SwitchCommand) {
      return compareTo((SwitchCommand)obj) == 0;
    } else {
      return false;
    }
  }
}