/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.hbase.client;

import com.alibaba.hbase.client.AliHBaseAPIProxy;
import com.alibaba.hbase.client.AliHBaseAPIProxyDirectImpl;
import com.alibaba.hbase.client.AliHBaseImplFactory;
import com.alibaba.lindorm.client.AdminService;
import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.LindormServiceProvider;
import com.alibaba.lindorm.client.SystemService;
import com.alibaba.lindorm.client.TableService;
import com.alibaba.lindorm.client.WideColumnService;
import com.alibaba.lindorm.client.core.ipc.ConfigUpdater;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.utils.ClientEnvLogUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliHBaseDirectImplFactory
extends AliHBaseImplFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AliHBaseDirectImplFactory.class);
    private Configuration conf;
    private String seedServer;
    private String userName;
    private String password;
    private int operationTimeout;
    private boolean accessFromInternet;
    private ConcurrentHashMap<String, WideColumnService> wideColumnMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, TableService> tableServiceMap = new ConcurrentHashMap();
    private AdminService adminService;
    private SystemService systemService;
    private LindormClientConfig lindormClientConfig;

    public AliHBaseDirectImplFactory(Configuration conf) {
        this.conf = conf;
        String host = conf.get("hbase.client.endpoint");
        if (host == null || host.trim().isEmpty()) {
            this.seedServer = conf.get("lindorm.client.seedserver");
        } else if (host.contains(":")) {
            this.seedServer = host;
        } else {
            int port = 30020;
            this.seedServer = host + ":" + port;
        }
        this.operationTimeout = conf.getInt("hbase.client.operation.timeout", 1200000);
        this.userName = conf.get("hbase.client.username");
        this.password = conf.get("hbase.client.password");
        String publicIdentifier = conf.get("hbase.public.hostname.identifier", "-proxy-hbaseue-pub");
        String lindormPublicIdentifier = conf.get("lindorm.public.hostname.identifier", "-proxy-lindorm-pub");
        if (this.seedServer.contains(publicIdentifier) || this.seedServer.contains(lindormPublicIdentifier)) {
            this.accessFromInternet = true;
        }
        if (this.isServerlessMode(this.seedServer)) {
            this.accessFromInternet = true;
        }
        if (conf.get("hbase.access.from.internet") != null) {
            this.accessFromInternet = conf.getBoolean("hbase.access.from.internet", false);
        }
    }

    private boolean isServerlessMode(String seedServerStr) {
        if (seedServerStr == null || seedServerStr.isEmpty()) {
            return false;
        }
        try {
            List<LDServerAddress> serverAddresses = ConfigUpdater.parseSeedServers(seedServerStr, false);
            if (serverAddresses == null || serverAddresses.size() == 0) {
                return false;
            }
            for (LDServerAddress address : serverAddresses) {
                if (address.getPort() == 30022) continue;
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to parse seedServer:" + seedServerStr, t);
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AdminService getAdminService() throws IOException {
        if (this.adminService == null) {
            AliHBaseDirectImplFactory aliHBaseDirectImplFactory = this;
            synchronized (aliHBaseDirectImplFactory) {
                if (this.adminService == null) {
                    this.adminService = LindormServiceProvider.AdminServiceProvider.create(this.getLindormConfig());
                }
            }
        }
        return this.adminService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemService getSystemService() throws IOException {
        if (this.systemService == null) {
            AliHBaseDirectImplFactory aliHBaseDirectImplFactory = this;
            synchronized (aliHBaseDirectImplFactory) {
                if (this.systemService == null) {
                    this.systemService = LindormServiceProvider.SystemServiceProvider.create(this.getLindormConfig());
                }
            }
        }
        return this.systemService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WideColumnService getWideColumnService(String namespace) throws IOException {
        if (namespace == null) {
            throw new IOException("namespace can't be null!");
        }
        WideColumnService wideColumnService = this.wideColumnMap.get(namespace);
        if (wideColumnService == null) {
            AliHBaseDirectImplFactory aliHBaseDirectImplFactory = this;
            synchronized (aliHBaseDirectImplFactory) {
                LindormClientConfig config = this.getLindormConfig();
                config.setNamespace(namespace);
                WideColumnService service = LindormServiceProvider.WideColumnServiceProvider.create(config);
                WideColumnService old = this.wideColumnMap.putIfAbsent(namespace, service);
                if (old != null) {
                    service.close();
                    return old;
                }
                return service;
            }
        }
        return wideColumnService;
    }

    LindormClientConfig createLindormConfig() throws IOException {
        LindormClientConfig lindormClientConfig = LindormClientConfig.create();
        for (Map.Entry entry : this.conf) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            lindormClientConfig.set((String)entry.getKey(), (String)entry.getValue());
        }
        if (this.userName != null && !this.userName.isEmpty() && this.password != null && !this.password.isEmpty()) {
            lindormClientConfig.setUser(this.userName, this.password);
        }
        lindormClientConfig.setSeedServer(this.seedServer.trim());
        lindormClientConfig.setTimeout(this.operationTimeout);
        if (this.accessFromInternet) {
            lindormClientConfig.setBoolean("lindorm.rpc.only.use.seedserver", true);
        }
        if (this.conf.get("lindorm.client.sorter.type") != null) {
            lindormClientConfig.set("lindorm.client.sorter.type", this.conf.get("lindorm.client.sorter.type"));
        } else {
            lindormClientConfig.set("lindorm.client.sorter.type", "NAMESORTER");
        }
        return lindormClientConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LindormClientConfig getLindormConfig() throws IOException {
        if (this.lindormClientConfig == null) {
            AliHBaseDirectImplFactory aliHBaseDirectImplFactory = this;
            synchronized (aliHBaseDirectImplFactory) {
                if (this.lindormClientConfig == null) {
                    this.lindormClientConfig = this.createLindormConfig();
                }
            }
        }
        return new LindormClientConfig(this.lindormClientConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TableService getTableServiceService(String namespace) throws IOException {
        if (namespace == null) {
            throw new IOException("namespace can't be null!");
        }
        TableService tableService = this.tableServiceMap.get(namespace);
        if (tableService == null) {
            AliHBaseDirectImplFactory aliHBaseDirectImplFactory = this;
            synchronized (aliHBaseDirectImplFactory) {
                LindormClientConfig config = this.getLindormConfig();
                config.setNamespace(namespace);
                TableService service = LindormServiceProvider.TableServiceProvider.create(config);
                TableService old = this.tableServiceMap.putIfAbsent(namespace, service);
                if (old != null) {
                    service.close();
                    return old;
                }
                return service;
            }
        }
        return tableService;
    }

    @Override
    public AliHBaseAPIProxy getHBaseAPIProxyImpl(TableName tableName) throws IOException {
        return new AliHBaseAPIProxyDirectImpl(this, tableName);
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.adminService != null) {
                this.adminService.close();
            }
        }
        catch (IOException ioE) {
            LOG.error("Error happened when closing adminservice", (Throwable)ioE);
        }
        try {
            if (this.systemService != null) {
                this.systemService.close();
            }
        }
        catch (Throwable e) {
            LOG.error("Error happened when closing systemService", e);
        }
        for (Map.Entry<String, WideColumnService> entry : this.wideColumnMap.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                entry.getValue().close();
            }
            catch (IOException ioE) {
                LOG.error("Error happened when closing WideColumnService for namespace " + entry.getKey(), (Throwable)ioE);
            }
        }
        for (Map.Entry<String, Closeable> entry : this.tableServiceMap.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                ((TableService)entry.getValue()).close();
            }
            catch (Exception e) {
                LOG.error("Error happened when closing TableService for namespace " + entry.getKey(), (Throwable)e);
            }
        }
    }

    static {
        ClientEnvLogUtil.setEnabled(false);
    }
}

