/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client;

import com.alibaba.lindorm.client.LindormClientConfig;
import com.alibaba.lindorm.client.core.LindormBasicService;
import com.alibaba.lindorm.client.core.ipc.LDServerAddress;
import com.alibaba.lindorm.client.core.ipc.LServerCallable;
import com.alibaba.lindorm.client.core.ipc.LindormTableInfo;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.SyncState;
import com.alibaba.lindorm.client.core.meta.LDRegionLocation;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Pair;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class SystemService
extends LindormBasicService {
    private static AtomicInteger systemServiceCount = new AtomicInteger(0);

    public SystemService(LindormClientConfig config) throws LindormException {
        super(config, "SystemService" + systemServiceCount.getAndIncrement());
    }

    public SystemService(LindormClientConfig config, String serviceName) throws LindormException {
        super(config, serviceName);
    }

    public void addGroup(final String groupName) throws LindormException {
        try {
            LServerCallable<Void> addGroupCallable = new LServerCallable<Void>(OperationContext.OperationType.GROUP){

                @Override
                public Void call() throws Exception {
                    this.server.addGroup(groupName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(addGroupCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public void removeGroup(final String groupName) throws LindormException {
        try {
            LServerCallable<Void> removeGroupCallable = new LServerCallable<Void>(OperationContext.OperationType.GROUP){

                @Override
                public Void call() throws Exception {
                    this.server.removeGroup(groupName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(removeGroupCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public void moveTable(final String namespace, final String table, final String targetGroup) throws LindormException {
        try {
            LServerCallable<Void> moveTableCallable = new LServerCallable<Void>(OperationContext.OperationType.GROUP){

                @Override
                public Void call() throws Exception {
                    this.server.moveTable(namespace, table, targetGroup);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(moveTableCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public List<String> listTablesOfGroup(final String groupName) throws LindormException {
        try {
            LServerCallable<List<String>> listTablesOfGroupCallable = new LServerCallable<List<String>>(OperationContext.OperationType.GROUP){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listTablesOfGroup(groupName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listTablesOfGroupCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public List<String> listServersOfGroup(final String groupName, String idc) throws LindormException {
        try {
            LServerCallable<List<String>> listServersOfGroup = new LServerCallable<List<String>>(OperationContext.OperationType.GROUP){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listServersOfGroup(groupName);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withRetries(listServersOfGroup);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public List<String> listGroups() throws LindormException {
        try {
            LServerCallable<List<String>> listGroupsCallable = new LServerCallable<List<String>>(OperationContext.OperationType.GROUP){

                @Override
                public List<String> call() throws Exception {
                    return this.server.listGroups();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(listGroupsCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public boolean isGroupExists(final String groupName) throws LindormException {
        try {
            LServerCallable<Boolean> isGroupExistsCallable = new LServerCallable<Boolean>(OperationContext.OperationType.GROUP){

                @Override
                public Boolean call() throws Exception {
                    return this.server.isGroupExists(groupName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(isGroupExistsCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public String getGroupNameOfTable(final String namespace, final String table) throws LindormException {
        try {
            LServerCallable<String> getGroupNameOfTableCallable = new LServerCallable<String>(OperationContext.OperationType.GROUP){

                @Override
                public String call() throws Exception {
                    return this.server.getGroupNameOfTable(namespace, table);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withRetries(getGroupNameOfTableCallable);
        }
        catch (Throwable t) {
            if (t instanceof LindormException) {
                throw (LindormException)t;
            }
            throw new LindormException(t);
        }
    }

    public void split(final String tableName, final String splitPoint) throws IOException, InterruptedException {
        try {
            LServerCallable<Void> splitCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.split(tableName, splitPoint);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(splitCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void splitTableOrRegion(final String tableNameOrRegionName, final byte[] splitPoint, String idc) throws IOException, InterruptedException {
        try {
            LServerCallable<Void> splitCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.split(tableNameOrRegionName, splitPoint);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(splitCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void mergeTable(final String tableName, final int minRegionNumToMergeInput, final int tableDaysThresholdInput, final int minRegionNumThresholdAfterMergeInput, final int regionSizeLimit, final int regionMergeMaximum) throws IOException {
        try {
            LServerCallable<Void> mergeTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MERGE){

                @Override
                public Void call() throws Exception {
                    this.server.mergeTable(tableName, minRegionNumToMergeInput, tableDaysThresholdInput, minRegionNumThresholdAfterMergeInput, regionSizeLimit, regionMergeMaximum);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(mergeTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void mergeRegions(final String tableName, final String region1EncodedName, final String region2EncodedName, String idc) throws IOException {
        try {
            LServerCallable<Void> splitTableCallable = new LServerCallable<Void>(OperationContext.OperationType.MERGE){

                @Override
                public Void call() throws Exception {
                    this.server.mergeRegions(tableName, region1EncodedName, region2EncodedName);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(splitTableCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void flush(final String tableOrRegionFullName, String idc) throws LindormException {
        try {
            LServerCallable<Void> flushCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.flush(tableOrRegionFullName);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(flushCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void compact(final String tableOrRegionFullName, String idc) throws LindormException {
        try {
            LServerCallable<Void> compactCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.compact(tableOrRegionFullName);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(compactCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void majorCompact(final String tableOrRegionFullName, String idc) throws LindormException {
        try {
            LServerCallable<Void> compactCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.majorCompact(tableOrRegionFullName);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(compactCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public long estimateRowCount(final String tableName, String idc) throws LindormException {
        try {
            LServerCallable<Long> rowCountCallable = new LServerCallable<Long>(OperationContext.OperationType.SYSTEM){

                @Override
                public Long call() throws Exception {
                    return this.server.estimateRowCount(tableName);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(rowCountCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public long estimateRegionRowCount(String idc, final String encodedName) throws LindormException {
        try {
            LServerCallable<Long> rowCountCallable = new LServerCallable<Long>(OperationContext.OperationType.SYSTEM){

                @Override
                public Long call() throws Exception {
                    return this.server.estimateRegionRowCount(encodedName);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idc).withoutRetries(rowCountCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public static long parseUnsignedLong(String str) {
        int pos = 0;
        int radix = 10;
        boolean negate = false;
        if (str.startsWith("-")) {
            negate = true;
            pos = 1;
        }
        if (str.startsWith("0x", pos) || str.startsWith("0X", pos)) {
            radix = 16;
            pos += 2;
        } else if (str.startsWith("#", pos)) {
            radix = 16;
            ++pos;
        } else if (str.startsWith("0", pos) && str.length() > pos + 1) {
            radix = 8;
            ++pos;
        }
        BigInteger value = new BigInteger(str.substring(pos), radix);
        value = negate ? value.negate() : value;
        return value.longValue();
    }

    public void splitHashTable(final String tableName, String splitPoint) throws IOException {
        final long split = SystemService.parseUnsignedLong(splitPoint);
        try {
            LServerCallable<Void> splitCallable = new LServerCallable<Void>(OperationContext.OperationType.SPLIT){

                @Override
                public Void call() throws Exception {
                    this.server.splitHashTable(tableName, split);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(splitCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void disableSplit(final String namespace, final String table) throws LindormException {
        try {
            LServerCallable<Void> disableSplitCallable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.disableSplit(namespace, table);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(disableSplitCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void enableSplit(final String namespace, final String table) throws LindormException {
        try {
            LServerCallable<Void> enableSplitCallable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.enableSplit(namespace, table);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(enableSplitCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void disableMerge(final String namespace, final String table) throws LindormException {
        try {
            LServerCallable<Void> disableMergeCallable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.disableMerge(namespace, table);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(disableMergeCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void enableMerge(final String namespace, final String table) throws LindormException {
        try {
            LServerCallable<Void> enableMergeCallable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.enableMerge(namespace, table);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(enableMergeCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void switchRegionLeader(final String regionName, final String idc, final String destIdc, final boolean skipSync) throws LindormException {
        try {
            LServerCallable<Void> failoverCallable = new LServerCallable<Void>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public Void call() throws Exception {
                    this.server.switchRegionLeader(Bytes.toBytes(regionName), idc, destIdc, skipSync);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(failoverCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public String getRegionLeadingZone(final String tableName, final String idc, final String regionName) throws LindormException {
        try {
            LServerCallable<String> failoverCallable = new LServerCallable<String>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public String call() throws Exception {
                    return this.server.getRegionLeadingZone(tableName, idc, regionName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(failoverCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void switchTableLeader(final String namespace, final String table, final String srcIdc, final String destIdc, final boolean skipSync) throws LindormException {
        try {
            LServerCallable<Void> failoverCallable = new LServerCallable<Void>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public Void call() throws Exception {
                    this.server.switchTableLeader(namespace, table, srcIdc, destIdc, skipSync);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(failoverCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void switchLeadingZone(final String srcIdc, final String destIdc, final boolean skipSync) throws LindormException {
        try {
            LServerCallable<Void> failoverCallable = new LServerCallable<Void>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public Void call() throws Exception {
                    this.server.switchLeadingZone(srcIdc, destIdc, skipSync);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(failoverCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void balanceTable(final String namespace, final String tableName) throws LindormException {
        try {
            LServerCallable<Void> failoverCallable = new LServerCallable<Void>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public Void call() throws Exception {
                    this.server.balanceTable(namespace, tableName);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(failoverCallable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public String getAuthState(final String regionName) throws LindormException {
        try {
            LServerCallable<String> getAuthStateCallbale = new LServerCallable<String>(OperationContext.OperationType.LEADERSWITCH){

                @Override
                public String call() throws Exception {
                    return this.server.getAuthState(Bytes.toBytes(regionName));
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(getAuthStateCallbale);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LDServerAddress getActiveGlobalMaster() throws LindormException {
        try {
            LServerCallable<LDServerAddress> callable = new LServerCallable<LDServerAddress>(OperationContext.OperationType.SYSTEM){

                @Override
                public LDServerAddress call() throws Exception {
                    return this.server.getActiveGlobalMaster();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<LDServerAddress> getBackUpGlobalMaster() throws LindormException {
        try {
            LServerCallable<List<LDServerAddress>> callable = new LServerCallable<List<LDServerAddress>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDServerAddress> call() throws Exception {
                    return this.server.getBackUpGlobalMaster();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<LDServerAddress> getBackUpLocalMaster(final String idc) throws LindormException {
        try {
            LServerCallable<List<LDServerAddress>> callable = new LServerCallable<List<LDServerAddress>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDServerAddress> call() throws Exception {
                    return this.server.getBackUpLocalMaster(idc);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<LDServerAddress> getActiveLocalMasters() throws LindormException {
        try {
            LServerCallable<List<LDServerAddress>> callable = new LServerCallable<List<LDServerAddress>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDServerAddress> call() throws Exception {
                    return this.server.getActiveLocalMasters();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<LDServerAddress> getActiveLDServers(final String idcName) throws LindormException {
        try {
            LServerCallable<List<LDServerAddress>> callable = new LServerCallable<List<LDServerAddress>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDServerAddress> call() throws Exception {
                    return this.server.getActiveLDServers(idcName);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public Map<String, String> getZoneFSConfiguration(String idcName) throws LindormException {
        return this.getZoneFSConfiguration(idcName, false);
    }

    public Map<String, String> getZoneFSConfiguration(final String idcName, final boolean canonicalHostName) throws LindormException {
        try {
            LServerCallable<Map<String, String>> callable = new LServerCallable<Map<String, String>>(OperationContext.OperationType.SYSTEM){

                @Override
                public Map<String, String> call() throws Exception {
                    List<Pair<String, String>> fsConfs = canonicalHostName ? this.server.getZoneFSConfiguration(idcName, true) : this.server.getZoneFSConfiguration(idcName);
                    HashMap<String, String> config = new HashMap<String, String>();
                    for (Pair<String, String> pair : fsConfs) {
                        config.put(pair.getFirst(), pair.getSecond());
                    }
                    return config;
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public Map<String, String> getZoneConfiguration(final String idcName, final boolean canonicalHostName) throws LindormException {
        try {
            LServerCallable<Map<String, String>> callable = new LServerCallable<Map<String, String>>(OperationContext.OperationType.SYSTEM){

                @Override
                public Map<String, String> call() throws Exception {
                    List<Pair<String, String>> fsConf = this.server.getZoneConfiguration(idcName, canonicalHostName);
                    HashMap<String, String> config = new HashMap<String, String>();
                    for (Pair<String, String> pair : fsConf) {
                        config.put(pair.getFirst(), pair.getSecond());
                    }
                    return config;
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<String> listZones() {
        return this.lconnection.getAllIDC();
    }

    public List<LDRegionLocation> getZoneTableRegionLocations(final String idcName, final String namespace, final String tableName) throws IOException {
        try {
            LServerCallable<List<LDRegionLocation>> callable = new LServerCallable<List<LDRegionLocation>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDRegionLocation> call() throws Exception {
                    return this.server.getZoneTableRegionLocations(idcName, namespace, tableName);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public List<LDRegionLocation> getZoneTableRegionLocations(final String idcName, final String namespace, final String tableName, final byte[] startKey, final byte[] endKey) throws IOException {
        try {
            LServerCallable<List<LDRegionLocation>> callable = new LServerCallable<List<LDRegionLocation>>(OperationContext.OperationType.SYSTEM){

                @Override
                public List<LDRegionLocation> call() throws Exception {
                    return this.server.getZoneTableRegionLocations(idcName, namespace, tableName, startKey, endKey);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.operationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public SyncState getReplicaconsensusSyncTime() throws IOException {
        try {
            LServerCallable<SyncState> callable = new LServerCallable<SyncState>(OperationContext.OperationType.SYSTEM){

                @Override
                public SyncState call() throws Exception {
                    return this.server.getReplicaconsensusSyncTime();
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public Long getReplicaconsensusSyncTime(final String srcIdc, final String sinkIdc) throws IOException {
        try {
            LServerCallable<Long> callable = new LServerCallable<Long>(OperationContext.OperationType.SYSTEM){

                @Override
                public Long call() throws Exception {
                    return this.server.getReplicaconsensusSyncTime(srcIdc, sinkIdc);
                }
            };
            return this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void moveRegionLocation(final String idcName, final byte[] encodedName, final LDServerAddress dest) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.moveRegionLocation(idcName, encodedName, dest);
                    return null;
                }
            };
            this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public boolean bulkLoadLdFiles(final String idcName, final String namespace, final String tableName, final byte[] startKey, final List<Pair<byte[], String>> familyPaths) throws IOException {
        try {
            LServerCallable<Boolean> callable = new LServerCallable<Boolean>(OperationContext.OperationType.SYSTEM){

                @Override
                public Boolean call() throws Exception {
                    return this.server.bulkLoadLDFiles(idcName, namespace, tableName, startKey, familyPaths);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public LindormTableInfo getLindormTableInfo(final String idcName, final String namespace, final String tableName) throws IOException {
        try {
            LServerCallable<LindormTableInfo> callable = new LServerCallable<LindormTableInfo>(OperationContext.OperationType.SYSTEM){

                @Override
                public LindormTableInfo call() throws Exception {
                    return this.server.getLindormTableInfo(idcName, namespace, tableName);
                }
            };
            return this.lconnection.getIdcSpecifiedRetryingCaller(this.systemOperationTimeout, idcName).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void registerBDSCluster(final String lindormSourceName, final String bdsClusterkey, final String lindormSeedServer, final String username, final String password) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.registerBDSCluster(lindormSourceName, bdsClusterkey, lindormSeedServer, username, password);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void registerBDSCluster(String bdsClusterkey, String lindormSeedServer, String username, String password) throws IOException {
        this.registerBDSCluster(null, bdsClusterkey, lindormSeedServer, username, password);
    }

    public void registerBDSCluster(String bdsClusterkey, String lindormSeedServer) throws IOException {
        this.registerBDSCluster(null, bdsClusterkey, lindormSeedServer, "", "");
    }

    public void registerSolrCluster(final String solrSourceName, final String solrConnectionStr) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.registerSolrCluster(solrSourceName, solrConnectionStr);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void registerSolrCluster(String solrSourceName) throws IOException {
        this.registerSolrCluster(null, solrSourceName);
    }

    public void registerESCluster(final String esSourceName, final String esConnectionStr, final String userName, final String password) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.registerESCluster(esSourceName, esConnectionStr, userName, password);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void registerESCluster(String esConnectionStr, String userName, String password) throws IOException {
        this.registerESCluster(null, esConnectionStr, userName, password);
    }

    public void unregisterSolrCluster(final boolean force) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.unregisterSolrCluster(force);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void unregisterESCluster(final boolean force) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.unregisterESCluster(force);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }

    public void unregisterBDSCluster(final boolean force) throws IOException {
        try {
            LServerCallable<Void> callable = new LServerCallable<Void>(OperationContext.OperationType.SYSTEM){

                @Override
                public Void call() throws Exception {
                    this.server.unregisterBDSCluster(force);
                    return null;
                }
            };
            this.lconnection.getDDLRetryingCaller(this.systemOperationTimeout, this.doAsUser).withoutRetries(callable);
        }
        catch (Throwable t) {
            throw new LindormException(t);
        }
    }
}

