/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.expression;

import com.alibaba.lindorm.client.core.compile.Interval;
import com.alibaba.lindorm.client.core.compile.LikePattern;
import com.alibaba.lindorm.client.core.meta.LColumn;
import com.alibaba.lindorm.client.core.meta.Tuple;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.CompilerUtils;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.ImmutableBytesPtr;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.dml.Condition;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import com.alibaba.lindorm.client.schema.SortOrder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class SimilarityExpression
extends Condition {
    protected ColumnKey columnKey;
    protected String pattern;
    protected Character escapeCharacter;
    protected LColumn column;
    protected boolean compiled;
    protected LikePattern likePattern;
    private int hashCode;

    SimilarityExpression() {
    }

    protected SimilarityExpression(byte[] columnName, String pattern) {
        this(columnName, pattern, null);
    }

    protected SimilarityExpression(byte[] columnName, String pattern, Character escapeCharacter) {
        this(null, columnName, pattern, escapeCharacter);
    }

    protected SimilarityExpression(byte[] family, byte[] columnName, String pattern) {
        this(family, columnName, pattern, null);
    }

    protected SimilarityExpression(byte[] family, byte[] columnName, String pattern, Character escapeCharacter) {
        this(new ColumnKey(family, columnName), pattern, escapeCharacter);
    }

    protected SimilarityExpression(ColumnKey columnKey, String pattern, Character escapeCharacter) {
        this.columnKey = columnKey;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
    }

    protected SimilarityExpression(LColumn column, String pattern, Character escapeCharacter) {
        this.columnKey = column.getColumnKey();
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
        this.column = column;
    }

    public boolean containsWildcards() throws LindormException {
        int length = this.pattern.length();
        for (int i = 0; i < length; ++i) {
            char c = this.pattern.charAt(i);
            if (this.escapeCharacter != null && this.escapeCharacter.equals(Character.valueOf(c))) {
                if (++i < length) continue;
                throw new LindormException(this.getName() + " pattern must not end with escape character");
            }
            if (!LikePattern.isWildcard(c)) continue;
            return true;
        }
        return false;
    }

    public Interval getPrefix(LColumn meta) throws LindormException {
        Object prefix;
        int i;
        int length = this.pattern.length();
        StringBuilder builder = new StringBuilder();
        for (i = 0; i < length; ++i) {
            char c = this.pattern.charAt(i);
            if (this.escapeCharacter != null && this.escapeCharacter.equals(Character.valueOf(c))) {
                if (++i >= length) {
                    throw new LindormException(this.getName() + " pattern must not end with escape character");
                }
                c = this.pattern.charAt(i);
            } else if (LikePattern.isWildcard(c)) break;
            builder.append(c);
        }
        String rawPrefix = builder.toString();
        DataType dataType = meta.getDataType().getClientType();
        Object object = prefix = dataType.equals((Object)DataType.STRING) ? rawPrefix : (Object)Bytes.toBytes(rawPrefix);
        if (i >= length) {
            byte[] value = LDataType.toBytes(meta, prefix, LDataTypeFactory.INSTANCE.getTypeInstance(dataType));
            return Interval.create(value);
        }
        if (i == 0) {
            return Interval.EVERYTHING_RANGE;
        }
        byte[] value = LDataType.toBytes(meta, prefix, LDataTypeFactory.INSTANCE.getTypeInstance(dataType), false);
        byte[] nextValue = this.getNextValue(value, meta.getSortOrder());
        if (meta.isPrimaryKey() && SchemaUtils.hasSeparatorByte(meta.getDataType())) {
            value = Bytes.add(value, SchemaUtils.getSeparatorBytes(meta.getSortOrder()));
            if (nextValue != Interval.UNBOUND) {
                nextValue = Bytes.add(nextValue, SchemaUtils.getSeparatorBytes(meta.getSortOrder()));
            }
        }
        if (meta.getSortOrder().equals((Object)SortOrder.getDefault())) {
            return Interval.create(value, nextValue);
        }
        return Interval.create(nextValue, value);
    }

    private byte[] getNextValue(byte[] value, SortOrder sortOrder) {
        byte[] nextValue = null;
        if (sortOrder.equals((Object)SortOrder.getDefault())) {
            nextValue = CompilerUtils.nextKey(value);
        } else {
            int i;
            for (i = value.length - 1; i >= 0 && value[i] == 0; --i) {
            }
            if (i >= 0) {
                nextValue = new byte[i + 1];
                System.arraycopy(value, 0, nextValue, 0, i + 1);
                nextValue[i] = (byte)(nextValue[i] - 1);
            }
        }
        return nextValue == null ? Interval.UNBOUND : nextValue;
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public boolean match(byte[] text) throws LindormException {
        if (!this.compiled) {
            this.likePattern = LikePattern.compile(this.pattern, this.escapeCharacter);
            this.compiled = true;
        }
        return this.likePattern.matcher(text).matches() == this.getExpectedResult();
    }

    public boolean match(String text) throws LindormException {
        if (!this.compiled) {
            this.likePattern = LikePattern.compile(this.pattern, this.escapeCharacter);
            this.compiled = true;
        }
        return this.likePattern.matcher(text).matches() == this.getExpectedResult();
    }

    public void resetCompiledStatus() {
        this.likePattern = null;
        this.compiled = false;
    }

    public void setColumn(LColumn column) {
        this.column = column;
    }

    protected abstract String getName();

    protected abstract boolean getExpectedResult();

    @Override
    public boolean evaluate(Tuple tuple, ImmutableBytesPtr result) throws LindormException {
        assert (this.column != null);
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        if (this.column.isPrimaryKey()) {
            tuple.getPrimaryKeys().getPKValue(this.column.getPosition(), ptr);
            int offset = ptr.getOffset();
            int length = ptr.getLength();
            if (SchemaUtils.storePkNulls(this.column)) {
                if (ptr.getLength() == 0 || SchemaUtils.isNullValueByte(ptr.get()[ptr.getOffset()], this.column.getSortOrder())) {
                    result.set(DataTypeUtils.FALSE_BYTES);
                    return true;
                }
                ++offset;
                --length;
            }
            if (SchemaUtils.hasSeparatorByte(this.column.getDataType())) {
                --length;
            }
            ptr.set(ptr.get(), offset, length);
        } else {
            tuple.getKeyValue(this.column.getFamilyName(), this.column.getColumnName(), ptr);
            if (ptr.get() == Bytes.EMPTY_BYTE_ARRAY) {
                return false;
            }
        }
        if (!this.compiled) {
            this.likePattern = LikePattern.compile(this.pattern, this.escapeCharacter, !this.column.getSortOrder().equals((Object)SortOrder.getDefault()));
            this.compiled = true;
        }
        boolean matched = false;
        matched = !this.column.getDataType().getClientType().equals((Object)DataType.ENCODED_VARBINARY) ? this.likePattern.matcher(ptr.get(), ptr.getOffset(), ptr.getLength()).matches() == this.getExpectedResult() : ((LikePattern.BytesLikeMatcher)this.likePattern.matcher(ptr.get(), ptr.getOffset(), ptr.getLength())).matchesEncodedVarbinary() == this.getExpectedResult();
        result.set(matched ? DataTypeUtils.TRUE_BYTES : DataTypeUtils.FALSE_BYTES);
        return true;
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeString(out, this.pattern);
        boolean shouldWriteEscapeCharacter = this.escapeCharacter != null;
        out.writeBoolean(shouldWriteEscapeCharacter);
        if (shouldWriteEscapeCharacter) {
            out.writeChar(this.escapeCharacter.charValue());
        }
        boolean shouldWriteColumn = this.column != null;
        out.writeBoolean(shouldWriteColumn);
        if (shouldWriteColumn) {
            this.column.writeTo(out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        boolean shouldReadColumn;
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        this.pattern = WritableUtils.readString(in);
        boolean shouldReadEscapeCharacter = in.readBoolean();
        if (shouldReadEscapeCharacter) {
            this.escapeCharacter = Character.valueOf(in.readChar());
        }
        if (shouldReadColumn = in.readBoolean()) {
            this.column = new LColumn();
            this.column.readFrom(in);
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int code = this.columnKey.hashCode();
            code = code * 31 + this.pattern.hashCode();
            if (this.escapeCharacter != null) {
                code = code * 31 + this.escapeCharacter.hashCode();
            }
            this.hashCode = code;
        }
        return this.hashCode;
    }
}

