/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.tableservice;

import com.alibaba.lindorm.client.AsyncCallback;
import com.alibaba.lindorm.client.OpTimeout;
import com.alibaba.lindorm.client.core.BasicDDLService;
import com.alibaba.lindorm.client.core.ipc.Attributes;
import com.alibaba.lindorm.client.core.ipc.LocationCache;
import com.alibaba.lindorm.client.core.ipc.OperationContext;
import com.alibaba.lindorm.client.core.ipc.RetryingCaller;
import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.meta.TableMeta;
import com.alibaba.lindorm.client.core.tableservice.LMutationResult;
import com.alibaba.lindorm.client.core.utils.KeyHashFunction;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.StringUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.exception.LindormException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class DmlOperation
extends VersionedObjectWithAttributes
implements OpTimeout {
    protected BasicDDLService service;
    protected String namespace;
    protected String tableName;
    protected byte[] routeKey = null;
    protected int clientMetaVersion = 0;
    private LocationCache.Location location;
    protected int operationTimeout = -1;
    protected int glitchTimeout = -1;

    protected DmlOperation() {
    }

    protected DmlOperation(BasicDDLService service) {
        this.service = service;
    }

    public String buildErrorMsg(OperationContext.OperationType type, Throwable t, long timeTook) {
        return this.buildErrorMsg(type, t, timeTook, 0);
    }

    public String buildErrorMsg(OperationContext.OperationType type, Throwable t, long timeTook, int totalRows) {
        StringBuilder builder = new StringBuilder();
        builder.append("Failed doing ").append(type.toString()).append(" on namespace=").append(this.namespace).append(", table=").append(this.tableName).append(", operationTimeout=").append(this.getOperationTimeout()).append(", time took=").append(timeTook);
        if (totalRows > 0) {
            builder.append(", total rows=").append(totalRows);
        }
        if (t != null) {
            builder.append(", caused by ").append(StringUtils.stringifyException(t));
        }
        return builder.toString();
    }

    public LocationCache.Location getLocation() {
        return this.location;
    }

    public void setLocation(LocationCache.Location location) {
        this.location = location;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTableName() {
        return this.tableName;
    }

    public byte[] getKey() {
        return this.routeKey;
    }

    public void setRouteKey(byte[] rowKey, TableMeta table) {
        this.setRouteKey(rowKey, null, table);
    }

    public void setRouteKey(byte[] rowKey, byte[] hashKey, TableMeta table) {
        this.routeKey = table.getTableAttributes().isHashTable() ? (hashKey != null ? hashKey : (rowKey == null ? null : KeyHashFunction.computeHashKeyFromRow(rowKey, 0, rowKey.length))) : rowKey;
    }

    public int getClientMetaVersion() {
        return this.clientMetaVersion;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        WritableUtils.writeString(out, this.namespace);
        WritableUtils.writeString(out, this.tableName);
        WritableUtils.writeVInt(out, this.clientMetaVersion);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.namespace = WritableUtils.readString(in);
        this.tableName = WritableUtils.readString(in);
        this.clientMetaVersion = WritableUtils.readVInt(in);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DmlOperation)) {
            return false;
        }
        DmlOperation other = (DmlOperation)obj;
        if (!this.namespace.equals(other.namespace)) {
            return false;
        }
        return this.tableName.equals(other.tableName);
    }

    public void setupRouteKey() throws LindormException {
        TableMeta meta = this.tryGetTableMeta();
        if (meta != null) {
            this.setRouteKey(this.computeRowKey(meta), meta);
        }
    }

    protected TableMeta tryGetTableMeta() throws LindormException {
        TableMeta meta = this.service.getTableMetaFromCache(this.tableName);
        if (meta != null) {
            this.clientMetaVersion = meta.getMetaVersion();
        } else {
            SchemaUtils.setRequireTableMetaToAttributes(this);
        }
        return meta;
    }

    protected abstract byte[] computeRowKey(TableMeta var1) throws LindormException;

    public void handleResultAttributes(DmlOperation operation, Attributes attr) {
        try {
            TableMeta meta = SchemaUtils.getTableMetaFromAttributes(attr);
            if (meta != null) {
                this.service.getLConnection().getTableMetaCache().addTable(meta);
                SchemaUtils.removeRequireTableMetaToAttributes(operation);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout > 0 ? this.operationTimeout : this.service.getOperationTimeout();
    }

    @Override
    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    @Override
    public int getGlitchTimeout() {
        return this.glitchTimeout > -1 ? this.glitchTimeout : this.service.getGlitchTimeout();
    }

    @Override
    public void setGlitchTimeout(int glitchTimeout) {
        this.glitchTimeout = glitchTimeout;
    }

    @Override
    public String toString() {
        return "DmlOperation[" + this.namespace + "/" + this.tableName + "/meta=" + this.clientMetaVersion + "/" + "attrs=" + super.toString() + "]";
    }

    protected abstract class AsyncMutationHandler<T, E extends Attributes>
    extends AsyncCallback<E> {
        protected AsyncCallback<T> callback;
        protected OperationContext.OperationType operationType;
        protected Object traceContext;
        protected int rows = 0;
        protected long startTime;
        protected RetryingCaller caller;

        public AsyncMutationHandler(AsyncCallback<T> callback, OperationContext.OperationType operationType, long startTime, Object traceContext) {
            this(callback, operationType, startTime, 0, traceContext, null);
        }

        public AsyncMutationHandler(AsyncCallback<T> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller caller) {
            this(callback, operationType, startTime, 0, traceContext, caller);
        }

        public AsyncMutationHandler(AsyncCallback<T> callback, OperationContext.OperationType operationType, long startTime, int rows, Object traceContext, RetryingCaller caller) {
            this.callback = callback;
            this.operationType = operationType;
            this.startTime = startTime;
            this.rows = rows;
            this.traceContext = traceContext;
            this.caller = caller;
        }

        public void setCaller(RetryingCaller caller) {
            this.caller = caller;
        }

        protected abstract T getReturnValue(E var1);

        protected abstract int getAffectedRows(E var1);

        @Override
        public void onComplete(E result) {
            DmlOperation.this.service.endOperationAsyncSuccessfully(this.traceContext, DmlOperation.this.tableName, this.caller);
            DmlOperation.this.handleResultAttributes(DmlOperation.this, (Attributes)result);
            int affectedRows = this.getAffectedRows(result);
            DmlOperation.this.service.getLConnection().getTableMetricsManager().onOperationSuccess(DmlOperation.this.namespace, DmlOperation.this.tableName, this.operationType, System.currentTimeMillis() - this.startTime, affectedRows);
            T retValue = this.getReturnValue(result);
            this.callback.onComplete(retValue);
        }

        @Override
        public void onError(Throwable exception) {
            DmlOperation.this.service.endOperationAsyncExceptionally(this.traceContext, DmlOperation.this.tableName, this.caller, exception);
            String msg = DmlOperation.this.buildErrorMsg(this.operationType, exception, System.currentTimeMillis() - this.startTime, this.rows);
            LindormException error = new LindormException(msg);
            DmlOperation.this.service.getLConnection().getTableMetricsManager().onOperationError(DmlOperation.this.namespace, DmlOperation.this.tableName, this.operationType, error);
            this.callback.onError(error);
        }

        @Override
        public boolean shouldProcessResultInPool() {
            return this.callback.shouldProcessResultInPool();
        }
    }

    protected abstract class AsyncLMutationResultHandler<T>
    extends AsyncMutationHandler<T, LMutationResult> {
        public AsyncLMutationResultHandler(AsyncCallback<T> callback, OperationContext.OperationType operationType, long startTime, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super(callback, operationType, startTime, traceContext, caller);
        }

        public AsyncLMutationResultHandler(AsyncCallback<T> callback, OperationContext.OperationType operationType, long startTime, int rows, Object traceContext, RetryingCaller<LMutationResult> caller) {
            super(callback, operationType, startTime, rows, traceContext, caller);
        }

        @Override
        protected int getAffectedRows(LMutationResult result) {
            return result.getNumberOfRowsAffected();
        }
    }
}

