/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.quota.ClientQuotaContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WPartialResult
extends VersionedObjectWithAttributes {
    private static final String RESUME_ROW = "_resume_";
    private static final String SELECT_CONTEXT = "_select_context_";
    private static final String QUOTACONTEXT = "_quotacontext_";
    private List<WResult> results;
    private byte[] nextStartKey = null;
    private int skipped = 0;
    private LQueryResults.SelectContext selectContext;

    public WPartialResult() {
    }

    public WPartialResult(List<WResult> results, byte[] nextStartKey) {
        this.results = results;
        this.nextStartKey = nextStartKey;
    }

    public WPartialResult(List<WResult> results, byte[] nextStartKey, byte[] resumeRow) {
        this(results, nextStartKey);
        this.setAttribute(RESUME_ROW, resumeRow);
    }

    public int getSkipped() {
        return this.skipped;
    }

    public void setSkipped(int skipped) {
        this.skipped = skipped;
    }

    public List<WResult> getResults() {
        return this.results;
    }

    public void setResults(List<WResult> results) {
        this.results = results;
    }

    public byte[] getNextStartKey() {
        return this.nextStartKey;
    }

    public void setNextStartKey(byte[] nextStartPrimaryKey) {
        this.nextStartKey = nextStartPrimaryKey;
    }

    public byte[] getResumeRow() {
        return this.getAttribute(RESUME_ROW);
    }

    public void setSelectContext(LQueryResults.SelectContext context) {
        if (context != null && this.selectContext != null) {
            throw new RuntimeException("There is already a Select contex, old one=" + this.selectContext + ", new one= " + context);
        }
        this.selectContext = context;
    }

    public ClientQuotaContext getClientQuotaContext() {
        byte[] bytes = this.getAttribute(QUOTACONTEXT);
        if (bytes != null && bytes.length > 0) {
            ClientQuotaContext clientQuotaContext = new ClientQuotaContext();
            try {
                return (ClientQuotaContext)WritableUtils.getWritable(bytes, clientQuotaContext);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    public void setClientQuotaContext(ClientQuotaContext clientQuotaContext) {
        if (clientQuotaContext != null) {
            try {
                byte[] bytes = WritableUtils.getBytes(clientQuotaContext);
                this.setAttribute(QUOTACONTEXT, bytes);
            }
            catch (Throwable throwable) {}
        } else {
            this.removeAttribute(QUOTACONTEXT);
        }
    }

    public LQueryResults.SelectContext getSelectContext() {
        return this.selectContext;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.setupAttributes();
        super.writeTo(out);
        if (this.results == null || this.results.size() == 0) {
            WritableUtils.writeVInt(out, 0);
        } else {
            WritableUtils.writeVInt(out, this.results.size());
            for (WResult wResult : this.results) {
                wResult.writeTo(out);
            }
        }
        Bytes.writeByteArray(out, this.nextStartKey);
        WritableUtils.writeVInt(out, this.skipped);
    }

    private void setupAttributes() throws IOException {
        if (this.selectContext != null) {
            this.setupSelectContextAttribute(this.selectContext);
        } else {
            this.removeAttribute(SELECT_CONTEXT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSelectContextAttribute(LQueryResults.SelectContext context) throws IOException {
        ByteArrayOutputStream bytesStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bytesStream);
        try {
            this.selectContext.writeTo(out);
        }
        finally {
            out.close();
        }
        this.setAttribute(SELECT_CONTEXT, bytesStream.toByteArray());
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.results = new ArrayList<WResult>();
        int size = WritableUtils.readVInt(in);
        for (int i = 0; i < size; ++i) {
            WResult result = new WResult();
            result.readFrom(in);
            this.results.add(result);
        }
        this.nextStartKey = Bytes.readByteArrayNullable(in);
        this.skipped = WritableUtils.readVInt(in);
        this.initFromAttributes();
    }

    private void initFromAttributes() throws IOException {
        byte[] selectContextBytes = this.getAttribute(SELECT_CONTEXT);
        if (selectContextBytes != null) {
            this.readSelectContextFrom(selectContextBytes);
        }
    }

    private void readSelectContextFrom(byte[] bytes) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        this.selectContext = new LQueryResults.SelectContext();
        this.selectContext.readFrom(in);
    }
}

