/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice;

import com.alibaba.lindorm.client.core.LindormWideColumnService;
import com.alibaba.lindorm.client.core.tableservice.LQueryResults;
import com.alibaba.lindorm.client.core.utils.WideColumnUtils;
import com.alibaba.lindorm.client.core.widecolumnservice.WPartialResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WResult;
import com.alibaba.lindorm.client.core.widecolumnservice.WRow;
import com.alibaba.lindorm.client.core.widecolumnservice.WScan;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilterList;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WPageFilter;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.quota.ClientQuotaContext;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;

public class WScanner
implements Iterable<WResult> {
    private LinkedList<WResult> cache = new LinkedList();
    private WScan wScan;
    protected String tableName;
    private boolean needLoadingCache = true;
    protected LindormWideColumnService wideColumnService;
    private boolean insertEmptyResultIfBackOffNeeded = false;
    private int rpcCount;

    public WScanner(LindormWideColumnService wideColumnService, WScan wScan, String tableName) throws LindormException {
        this.wideColumnService = wideColumnService;
        this.tableName = tableName;
        this.rpcCount = 0;
        try {
            if (wScan != null) {
                int limit;
                this.wScan = new WScan(wScan);
                if (wScan.getFilter() != null && (limit = this.handleFilterLimit(wScan.getFilter())) != -1) {
                    if (wScan.getLimit() <= 0) {
                        this.wScan.setLimit(limit);
                    } else {
                        this.wScan.setLimit(Math.min(limit, wScan.getLimit()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new LindormException("failed to deep copy WScan while init WScanner", e);
        }
    }

    public boolean isInsertEmptyResultIfBackOffNeeded() {
        return this.insertEmptyResultIfBackOffNeeded;
    }

    public void setInsertEmptyResultIfBackOffNeeded(boolean insertEmptyResultIfBackOffNeeded) {
        this.insertEmptyResultIfBackOffNeeded = insertEmptyResultIfBackOffNeeded;
    }

    private int handleFilterLimit(WFilter filter) {
        if (filter instanceof WFilterList) {
            WFilterList list = (WFilterList)filter;
            if (list.getOperator() == WFilterList.Operator.MUST_PASS_ONE) {
                return -1;
            }
            int limit = -1;
            for (WFilter f : list.getFilters()) {
                int filterLimit = this.handleFilterLimit(f);
                if (filterLimit == -1) continue;
                if (limit == -1) {
                    limit = filterLimit;
                    continue;
                }
                limit = Math.min(limit, filterLimit);
            }
            return limit;
        }
        if (filter instanceof WPageFilter) {
            return (int)((WPageFilter)filter).getPageSize();
        }
        return -1;
    }

    @Override
    public Iterator<WResult> iterator() {
        return new Iterator<WResult>(){
            WResult next = null;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    try {
                        this.next = WScanner.this.next();
                        return this.next != null;
                    }
                    catch (LindormException e) {
                        throw new RuntimeException(e);
                    }
                }
                return true;
            }

            @Override
            public WResult next() {
                if (!this.hasNext()) {
                    return null;
                }
                WResult temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void loadCache() throws LindormException {
        WPartialResult result = this.wideColumnService.scan(this.tableName, this.wScan);
        ++this.rpcCount;
        boolean reachLimit = WideColumnUtils.loadLimitResultsAndUpdateLimitOfWScan(this.cache, this.wScan, result);
        if (result != null && result.getSelectContext() != null) {
            LQueryResults.SelectContext selectContext = result.getSelectContext();
            this.wScan.setSelectContext(selectContext);
            if (!LQueryResults.hasMore(selectContext) || reachLimit) {
                this.needLoadingCache = false;
            }
        } else if (result == null || result.getNextStartKey() == null || reachLimit) {
            this.needLoadingCache = false;
        } else {
            this.wScan.setStartRowKey(result.getNextStartKey());
            this.wScan.setResumeRow(result.getResumeRow());
            this.wScan.setOffset(this.wScan.getOffset() - result.getSkipped());
        }
        if (result != null) {
            ClientQuotaContext clientQuotaContext = null;
            clientQuotaContext = result.getSelectContext() != null ? result.getSelectContext().getClientQuotaContext() : result.getClientQuotaContext();
            if (this.isInsertEmptyResultIfBackOffNeeded() && this.needLoadingCache && clientQuotaContext != null && clientQuotaContext.isNeedBackOff()) {
                WResult wResult = new WResult(new WRow(result.getNextStartKey()));
                this.cache.add(wResult);
            }
            if (this.cache.size() > 0 && clientQuotaContext != null) {
                this.cache.get(this.cache.size() - 1).setClientQuotaContext(clientQuotaContext);
            }
        }
    }

    public WResult next() throws LindormException {
        long currentTs = System.currentTimeMillis();
        while (this.needLoadingCache && this.cache.size() == 0) {
            this.loadCache();
            if (this.wScan.operationTimeout == -1 || System.currentTimeMillis() - currentTs <= (long)this.wScan.operationTimeout) continue;
            throw new LindormException("Timeout while execute wscan, check if too many invalid result skippped, timeout " + this.wScan.operationTimeout);
        }
        if (!this.cache.isEmpty()) {
            return this.cache.poll();
        }
        return null;
    }

    public int getRpcCount() {
        return this.rpcCount;
    }
}

