/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.core.widecolumnservice.filter;

import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WByteArrayComparable;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WCompareFilter;
import com.alibaba.lindorm.client.core.widecolumnservice.filter.WFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class WColumnValueFilter
extends WFilter {
    private byte[] family;
    private byte[] qualifier;
    private WCompareFilter.CompareOp op;
    private WByteArrayComparable comparator;

    public WColumnValueFilter() {
    }

    public WColumnValueFilter(byte[] family, byte[] qualifier, WCompareFilter.CompareOp op, WByteArrayComparable comparator) {
        this.family = Preconditions.checkNotNull(family, "family should not be null.");
        this.qualifier = qualifier == null ? new byte[]{} : qualifier;
        this.op = Preconditions.checkNotNull(op, "CompareOperator should not be null");
        this.comparator = Preconditions.checkNotNull(comparator, "Comparator should not be null");
    }

    public WCompareFilter.CompareOp getCompareOperator() {
        return this.op;
    }

    public WByteArrayComparable getComparator() {
        return this.comparator;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public byte[] getQualifier() {
        return this.qualifier;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bytes.writeByteArray(out, this.family);
        Bytes.writeByteArray(out, this.qualifier);
        out.writeUTF(this.op.name());
        WByteArrayComparable.write(out, this.comparator);
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.family = Bytes.readByteArray(in);
        if (this.family.length == 0) {
            this.family = null;
        }
        this.qualifier = Bytes.readByteArray(in);
        if (this.qualifier.length == 0) {
            this.qualifier = null;
        }
        this.op = WCompareFilter.CompareOp.valueOf(in.readUTF());
        this.comparator = WByteArrayComparable.read(in);
    }

    @Override
    public WFilter.Type getType() {
        return WFilter.Type.WColumnValueFilter;
    }
}

