/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.dml;

import com.alibaba.lindorm.client.core.ipc.VersionedObjectWithAttributes;
import com.alibaba.lindorm.client.core.types.LDataType;
import com.alibaba.lindorm.client.core.types.LDataTypeFactory;
import com.alibaba.lindorm.client.core.types.LDecimal;
import com.alibaba.lindorm.client.core.utils.Bytes;
import com.alibaba.lindorm.client.core.utils.DataTypeUtils;
import com.alibaba.lindorm.client.core.utils.Preconditions;
import com.alibaba.lindorm.client.core.utils.SchemaUtils;
import com.alibaba.lindorm.client.core.utils.WritableUtils;
import com.alibaba.lindorm.client.dml.ColumnKey;
import com.alibaba.lindorm.client.exception.IllegalDataException;
import com.alibaba.lindorm.client.exception.LindormException;
import com.alibaba.lindorm.client.schema.DataType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;

public class ColumnValue
extends VersionedObjectWithAttributes
implements Cloneable,
Comparable<ColumnValue> {
    private static LDataTypeFactory TYPE_FACTORY = LDataTypeFactory.INSTANCE;
    private ColumnKey columnKey;
    private DataType type;
    private Object value;
    private long ts = Long.MAX_VALUE;
    private boolean isNotNull;

    public ColumnValue() {
    }

    public ColumnValue(byte[] name, Object value) throws LindormException {
        this(null, name, Long.MAX_VALUE, value);
    }

    public ColumnValue(String name, Object value) throws LindormException {
        this(null, Bytes.toBytes(name), Long.MAX_VALUE, value);
    }

    public ColumnValue(byte[] name, long ts, Object value) throws LindormException {
        this(null, name, ts, value);
    }

    public ColumnValue(String name, long ts, Object value) throws LindormException {
        this(null, Bytes.toBytes(name), ts, value);
    }

    public ColumnValue(byte[] familyName, byte[] columnName, Object value) throws LindormException {
        this(familyName, columnName, Long.MAX_VALUE, value);
    }

    public ColumnValue(String familyName, String columnName, Object value) throws LindormException {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), Long.MAX_VALUE, value);
    }

    public ColumnValue(String familyName, String columnName, long ts, Object value) throws LindormException {
        this(Bytes.toBytes(familyName), Bytes.toBytes(columnName), ts, value);
    }

    public ColumnValue(byte[] familyName, byte[] columnName, long ts, Object value) throws LindormException {
        SchemaUtils.validateTimestamp(ts);
        this.columnKey = new ColumnKey(familyName, columnName);
        this.ts = ts;
        if (value != null) {
            this.type = TYPE_FACTORY.getTypeByClass(value.getClass()).getClientType();
            this.value = value;
            this.isNotNull = true;
            this.validateValue();
        } else {
            this.type = DataType.VARBINARY;
            this.value = null;
            this.isNotNull = false;
        }
    }

    public ColumnValue(byte[] familyName, byte[] columnName, Object value, DataType type, long ts) throws LindormException {
        this(new ColumnKey(familyName, columnName), value, type, ts);
    }

    public ColumnValue(ColumnKey columnKey, Object value, DataType type, long ts) throws IllegalDataException {
        SchemaUtils.validateTimestamp(ts);
        this.columnKey = columnKey;
        this.ts = ts;
        this.setValue(value, type);
    }

    public void setFamilyName(byte[] familyName) {
        this.columnKey.setFamily(familyName);
    }

    public byte[] getFamilyName() {
        return this.columnKey.getFamily();
    }

    public String getFamilyNameAsString() {
        return this.columnKey.getFamilyAsString();
    }

    public void setColumnName(byte[] columnName) {
        this.columnKey.setQualifier(columnName);
    }

    public byte[] getColumnName() {
        return this.columnKey.getQualifier();
    }

    public String getColumnNameAsString() {
        return this.columnKey.getQualifierAsString();
    }

    public byte[] getFullName() {
        return this.columnKey.getFullName();
    }

    public String getFullNameAsString() {
        return this.columnKey.getFullNameAsString();
    }

    public ColumnKey getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(ColumnKey columnKey) {
        this.columnKey = columnKey;
    }

    public void setTimestamp(long ts) {
        this.ts = ts;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public Object getValueObject() {
        return this.value;
    }

    public boolean isNotNull() {
        return this.isNotNull;
    }

    public int getEstimatedSize() {
        int length = this.columnKey.getByteSize() + 1 + 8;
        if (this.isNotNull) {
            length += LDataTypeFactory.INSTANCE.getTypeInstance(this.type).getByteSize(this.value);
        }
        return length;
    }

    public Byte getByte() {
        this.validateDataType(DataType.BYTE);
        return this.isNotNull ? Byte.valueOf(((Number)this.value).byteValue()) : null;
    }

    public Boolean getBoolean() {
        this.validateDataType(DataType.BOOLEAN);
        return (Boolean)this.value;
    }

    public Short getShort() {
        this.validateDataType(DataType.SHORT);
        return this.isNotNull ? Short.valueOf(((Number)this.value).shortValue()) : null;
    }

    public Integer getInt() {
        this.validateDataType(DataType.INT);
        return this.isNotNull ? Integer.valueOf(((Number)this.value).intValue()) : null;
    }

    public Long getLong() {
        this.validateDataType(DataType.LONG);
        return this.isNotNull ? Long.valueOf(((Number)this.value).longValue()) : null;
    }

    public Float getFloat() {
        this.validateDataType(DataType.FLOAT);
        return this.isNotNull ? Float.valueOf(((Number)this.value).floatValue()) : null;
    }

    public Double getDouble() {
        this.validateDataType(DataType.DOUBLE);
        return this.isNotNull ? Double.valueOf(((Number)this.value).doubleValue()) : null;
    }

    public String getString() {
        this.validateDataType(DataType.STRING);
        return (String)this.value;
    }

    public byte[] getBinary() {
        this.validateDataType(DataType.VARBINARY);
        return (byte[])this.value;
    }

    public BigDecimal getDecimal() {
        this.validateDataType(DataType.DECIMAL);
        if (this.type == DataType.DECIMAL) {
            return (BigDecimal)this.value;
        }
        try {
            return (BigDecimal)LDecimal.INSTANCE.toObject(this.value, LDataTypeFactory.INSTANCE.getTypeInstance(this.type));
        }
        catch (Throwable t) {
            throw new IllegalStateException("Failed converting " + DataTypeUtils.valueToString(this.type, this.value) + " to Decimal", t);
        }
    }

    public DataType getType() {
        return this.type;
    }

    public void setValue(Object value, DataType type) throws IllegalDataException {
        if (type == null) {
            throw new IllegalDataException("Data type must not be null.");
        }
        this.value = value;
        this.type = type;
        if (value != null) {
            this.isNotNull = true;
            this.validateValue();
        } else {
            this.isNotNull = false;
        }
    }

    public void setByte(Byte value) throws IllegalDataException {
        this.setValue(value, DataType.BYTE);
    }

    public void setBoolean(Boolean value) throws IllegalDataException {
        this.setValue(value, DataType.BOOLEAN);
    }

    public void setShort(Short value) throws IllegalDataException {
        this.setValue(value, DataType.SHORT);
    }

    public void setInt(Integer value) throws IllegalDataException {
        this.setValue(value, DataType.INT);
    }

    public void setLong(Long value) throws IllegalDataException {
        this.setValue(value, DataType.LONG);
    }

    public void setFloat(Float value) throws IllegalDataException {
        this.setValue(value, DataType.FLOAT);
    }

    public void setDouble(Double value) throws IllegalDataException {
        this.setValue(value, DataType.DOUBLE);
    }

    public void setString(String value) throws IllegalDataException {
        this.setValue(value, DataType.STRING);
    }

    public void setBinary(byte[] value) throws IllegalDataException {
        this.setValue(value, DataType.BINARY);
    }

    public void setDecimal(BigDecimal value) throws IllegalDataException {
        this.setValue(value, DataType.DECIMAL);
    }

    @Override
    public String toString() {
        return "(" + Bytes.toString(this.getFullName()) + "=" + DataTypeUtils.valueToString(this.type, this.value) + (this.ts != Long.MAX_VALUE ? " @" + this.ts + " " + new Date(this.ts) : "") + ")";
    }

    private void validateDataType(DataType targetType) {
        LDataType target;
        LDataType current = TYPE_FACTORY.getTypeInstance(this.type);
        if (!current.isCastableTo(target = TYPE_FACTORY.getTypeInstance(targetType))) {
            throw new IllegalStateException("The type of column [" + Bytes.toString(this.getFullName()) + "] is " + this.type.toString() + " cannot be converted to " + targetType.toString());
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ColumnValue)) {
            return false;
        }
        ColumnValue other = (ColumnValue)obj;
        if (!this.columnKey.equals(other.columnKey)) {
            return false;
        }
        if (this.ts != other.ts) {
            return false;
        }
        if (this.isNotNull != other.isNotNull) {
            return false;
        }
        if (this.isNotNull) {
            if (this.type != other.type) {
                return false;
            }
            if (this.type == DataType.VARBINARY || this.type == DataType.BINARY || this.type == DataType.ENCODED_VARBINARY ? !Arrays.equals((byte[])this.value, (byte[])other.value) : !this.value.equals(other.value)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        this.columnKey.writeTo(out);
        WritableUtils.writeVLong(out, this.ts);
        WritableUtils.writeVInt(out, this.type.ordinal());
        if (this.isNotNull) {
            byte[] valueBytes;
            out.writeBoolean(true);
            switch (this.type) {
                case DECIMAL: {
                    valueBytes = Bytes.toBytes((BigDecimal)this.value);
                    break;
                }
                case ENCODED_VARBINARY: {
                    valueBytes = (byte[])this.value;
                    break;
                }
                default: {
                    valueBytes = LDataTypeFactory.INSTANCE.getTypeInstance(this.type).toBytes(this.value);
                }
            }
            Bytes.writeByteArray(out, valueBytes);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.columnKey = new ColumnKey();
        this.columnKey.readFrom(in);
        this.ts = WritableUtils.readVLong(in);
        int typeOrdinal = WritableUtils.readVInt(in);
        this.type = LDataTypeFactory.INSTANCE.getClientTypeByOrdinal(typeOrdinal);
        this.isNotNull = in.readBoolean();
        if (this.isNotNull) {
            byte[] valueBytes = Bytes.readByteArray(in);
            switch (this.type) {
                case DECIMAL: {
                    this.value = Bytes.toBigDecimal(valueBytes);
                    break;
                }
                case ENCODED_VARBINARY: {
                    this.value = valueBytes;
                    break;
                }
                default: {
                    this.value = LDataTypeFactory.INSTANCE.getTypeInstance(this.type).toObject(valueBytes);
                    break;
                }
            }
        } else {
            this.value = null;
        }
    }

    public ColumnValue clone() throws CloneNotSupportedException {
        ColumnValue copy = (ColumnValue)super.clone();
        copy.columnKey = new ColumnKey(this.columnKey.getFamily(), this.columnKey.getQualifier());
        if (this.value instanceof byte[]) {
            copy.value = Arrays.copyOf((byte[])this.value, ((byte[])this.value).length);
        }
        return copy;
    }

    public static int compare(ColumnValue v1, ColumnValue v2) {
        Preconditions.checkNotNull(v1);
        Preconditions.checkNotNull(v2);
        if (v1.getValueObject() == null || v2.getValueObject() == null) {
            throw new IllegalStateException("Can not compare null values.");
        }
        if (v1.getType() != v2.getType()) {
            throw new IllegalStateException("Can not compare value with different type");
        }
        switch (v1.getType()) {
            case BYTE: 
            case UNSIGNED_BYTE: {
                return v1.getByte() - v2.getByte();
            }
            case BOOLEAN: {
                return v1.getBoolean().booleanValue() == v2.getBoolean().booleanValue() ? 0 : (v1.getBoolean() != false ? 1 : -1);
            }
            case SHORT: 
            case UNSIGNED_SHORT: {
                return v1.getShort() - v2.getShort();
            }
            case INT: 
            case UNSIGNED_INTEGER: {
                return v1.getInt() < v2.getInt() ? -1 : (v1.getInt().intValue() == v2.getInt().intValue() ? 0 : 1);
            }
            case LONG: 
            case UNSIGNED_LONG: 
            case ACC_LONG: {
                return v1.getLong() < v2.getLong() ? -1 : (v1.getLong().longValue() == v2.getLong().longValue() ? 0 : 1);
            }
            case FLOAT: 
            case UNSIGNED_FLOAT: {
                return Float.compare(v1.getFloat().floatValue(), v2.getFloat().floatValue());
            }
            case DOUBLE: 
            case UNSIGNED_DOUBLE: 
            case ACC_DOUBLE: {
                return Double.compare(v1.getDouble(), v2.getDouble());
            }
            case STRING: {
                return v1.getString().compareTo(v2.getString());
            }
            case ENCODED_VARBINARY: 
            case VARBINARY: 
            case BINARY: {
                return Bytes.compareTo(v1.getBinary(), v2.getBinary());
            }
            case DECIMAL: {
                return v1.getDecimal().compareTo(v2.getDecimal());
            }
        }
        throw new IllegalArgumentException("Unknown data type" + (Object)((Object)v1.getType()));
    }

    @Override
    public int compareTo(ColumnValue o) {
        return ColumnValue.compare(this, o);
    }

    private void validateValue() throws IllegalDataException {
        byte[] bytes;
        assert (this.value != null);
        if (this.value instanceof byte[] && (bytes = (byte[])this.value).length == 0) {
            throw new IllegalDataException("Must not use byte[0] for BINARY/VARBINARY, please use null instead. columnName=" + this.columnKey.toString());
        }
    }
}

