/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.lindorm.client.exception;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.LinkedList;

public final class LDRemoteException
extends IOException {
    private final String type;
    private final String msg;
    private String hostAndPort;
    private static final long serialVersionUID = 1279775242L;

    public LDRemoteException(String type, String msg, String hostAndPort) {
        super(msg);
        this.type = type;
        this.msg = msg;
        this.hostAndPort = hostAndPort;
    }

    public LDRemoteException(String type, String msg) {
        this(type, msg, null);
    }

    public String getType() {
        return this.type;
    }

    public IOException unwrapRemoteException() {
        try {
            Class<?> realClass = Class.forName(this.type);
            return this.instantiateException(realClass.asSubclass(IOException.class), this.msg);
        }
        catch (Throwable throwable) {
            return this;
        }
    }

    private IOException instantiateException(Class<? extends IOException> cls, String message) throws Exception {
        Constructor<? extends IOException> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        String[] messages = message.split("\n|\r");
        String msg = messages[0];
        if (msg.substring(0, cls.getName().length()).equals(cls.getName())) {
            msg = messages[0].substring(cls.getName().length() + 2);
        }
        LinkedList<StackTraceElement> traces = new LinkedList<StackTraceElement>();
        for (int i = 1; i < messages.length; ++i) {
            traces.add(LDRemoteException.toStackTrace(messages[i]));
        }
        if (this.hostAndPort != null) {
            StackTraceElement element = new StackTraceElement(this.hostAndPort, "RPC", null, -1);
            traces.addFirst(element);
        }
        IOException ex = cn.newInstance(msg);
        ex.setStackTrace(traces.toArray(new StackTraceElement[0]));
        return ex;
    }

    public static StackTraceElement toStackTrace(String msg) {
        msg = msg.substring(4);
        String[] messageArray = msg.split("\\(");
        int index = messageArray[0].lastIndexOf(".");
        String declaringClass = messageArray[0].substring(0, index);
        String methodName = messageArray[0].substring(index + 1);
        String file = null;
        int lineNumber = -2;
        if (!messageArray[1].contains("Native Method")) {
            String[] fileLine = messageArray[1].split(":");
            if (fileLine.length < 2) {
                file = null;
                lineNumber = 0;
            } else {
                file = fileLine[0];
                String line = fileLine[1].substring(0, fileLine[1].length() - 1);
                lineNumber = Integer.parseInt(line);
            }
        }
        return new StackTraceElement(declaringClass, methodName, file, lineNumber);
    }
}

